/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PredicateFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.ComplexAggregator;
import org.ojalgo.function.constant.ComplexMath;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public final class ComplexFunction
extends FunctionSet<ComplexNumber> {
    private static final ComplexFunction SET = new ComplexFunction();

    public static ComplexFunction getSet() {
        return SET;
    }

    private ComplexFunction() {
    }

    @Override
    public UnaryFunction<ComplexNumber> abs() {
        return ComplexMath.ABS;
    }

    @Override
    public UnaryFunction<ComplexNumber> acos() {
        return ComplexMath.ACOS;
    }

    @Override
    public UnaryFunction<ComplexNumber> acosh() {
        return ComplexMath.ACOSH;
    }

    @Override
    public BinaryFunction<ComplexNumber> add() {
        return ComplexMath.ADD;
    }

    @Override
    public AggregatorSet<ComplexNumber> aggregator() {
        return ComplexAggregator.getSet();
    }

    @Override
    public UnaryFunction<ComplexNumber> asin() {
        return ComplexMath.ASIN;
    }

    @Override
    public UnaryFunction<ComplexNumber> asinh() {
        return ComplexMath.ASINH;
    }

    @Override
    public UnaryFunction<ComplexNumber> atan() {
        return ComplexMath.ATAN;
    }

    @Override
    public BinaryFunction<ComplexNumber> atan2() {
        return ComplexMath.ATAN2;
    }

    @Override
    public UnaryFunction<ComplexNumber> atanh() {
        return ComplexMath.ATANH;
    }

    @Override
    public UnaryFunction<ComplexNumber> cardinality() {
        return ComplexMath.CARDINALITY;
    }

    @Override
    public UnaryFunction<ComplexNumber> cbrt() {
        return ComplexMath.CBRT;
    }

    @Override
    public UnaryFunction<ComplexNumber> ceil() {
        return ComplexMath.CEIL;
    }

    @Override
    public UnaryFunction<ComplexNumber> conjugate() {
        return ComplexMath.CONJUGATE;
    }

    @Override
    public UnaryFunction<ComplexNumber> cos() {
        return ComplexMath.COS;
    }

    @Override
    public UnaryFunction<ComplexNumber> cosh() {
        return ComplexMath.COSH;
    }

    @Override
    public BinaryFunction<ComplexNumber> divide() {
        return ComplexMath.DIVIDE;
    }

    public Unary enforce(NumberContext context) {
        return t -> ComplexNumber.valueOf(context.enforce(t));
    }

    @Override
    public UnaryFunction<ComplexNumber> exp() {
        return ComplexMath.EXP;
    }

    @Override
    public UnaryFunction<ComplexNumber> expm1() {
        return ComplexMath.EXPM1;
    }

    @Override
    public UnaryFunction<ComplexNumber> floor() {
        return ComplexMath.FLOOR;
    }

    @Override
    public BinaryFunction<ComplexNumber> hypot() {
        return ComplexMath.HYPOT;
    }

    @Override
    public UnaryFunction<ComplexNumber> invert() {
        return ComplexMath.INVERT;
    }

    @Override
    public UnaryFunction<ComplexNumber> log() {
        return ComplexMath.LOG;
    }

    @Override
    public UnaryFunction<ComplexNumber> log10() {
        return ComplexMath.LOG10;
    }

    @Override
    public UnaryFunction<ComplexNumber> log1p() {
        return ComplexMath.LOG1P;
    }

    @Override
    public UnaryFunction<ComplexNumber> logistic() {
        return ComplexMath.LOGISTIC;
    }

    @Override
    public UnaryFunction<ComplexNumber> logit() {
        return ComplexMath.LOGIT;
    }

    @Override
    public BinaryFunction<ComplexNumber> max() {
        return ComplexMath.MAX;
    }

    @Override
    public BinaryFunction<ComplexNumber> min() {
        return ComplexMath.MIN;
    }

    @Override
    public BinaryFunction<ComplexNumber> multiply() {
        return ComplexMath.MULTIPLY;
    }

    @Override
    public UnaryFunction<ComplexNumber> negate() {
        return ComplexMath.NEGATE;
    }

    @Override
    public BinaryFunction<ComplexNumber> pow() {
        return ComplexMath.POW;
    }

    @Override
    public ParameterFunction<ComplexNumber> power() {
        return ComplexMath.POWER;
    }

    @Override
    public UnaryFunction<ComplexNumber> rint() {
        return ComplexMath.RINT;
    }

    @Override
    public ParameterFunction<ComplexNumber> root() {
        return ComplexMath.ROOT;
    }

    @Override
    public ParameterFunction<ComplexNumber> scale() {
        return ComplexMath.SCALE;
    }

    @Override
    public UnaryFunction<ComplexNumber> signum() {
        return ComplexMath.SIGNUM;
    }

    @Override
    public UnaryFunction<ComplexNumber> sin() {
        return ComplexMath.SIN;
    }

    @Override
    public UnaryFunction<ComplexNumber> sinh() {
        return ComplexMath.SINH;
    }

    @Override
    public UnaryFunction<ComplexNumber> sqrt() {
        return ComplexMath.SQRT;
    }

    @Override
    public UnaryFunction<ComplexNumber> sqrt1px2() {
        return ComplexMath.SQRT1PX2;
    }

    @Override
    public BinaryFunction<ComplexNumber> subtract() {
        return ComplexMath.SUBTRACT;
    }

    @Override
    public UnaryFunction<ComplexNumber> tan() {
        return ComplexMath.TAN;
    }

    @Override
    public UnaryFunction<ComplexNumber> tanh() {
        return ComplexMath.TANH;
    }

    @Override
    public UnaryFunction<ComplexNumber> value() {
        return ComplexMath.VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<ComplexNumber> {
        @Override
        default public double invoke(double arg) {
            return this.invoke(ComplexNumber.valueOf(arg)).doubleValue();
        }

        @Override
        default public float invoke(float arg) {
            return this.invoke(ComplexNumber.valueOf(arg)).floatValue();
        }
    }

    @FunctionalInterface
    public static interface Predicate
    extends PredicateFunction<ComplexNumber> {
        @Override
        default public boolean invoke(double arg) {
            return this.invoke(ComplexNumber.valueOf(arg));
        }

        @Override
        default public boolean invoke(float arg) {
            return this.invoke(ComplexNumber.valueOf(arg));
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<ComplexNumber> {
        @Override
        default public double invoke(double arg, int param) {
            return this.invoke(ComplexNumber.valueOf(arg), param).doubleValue();
        }

        @Override
        default public float invoke(float arg, int param) {
            return this.invoke(ComplexNumber.valueOf(arg), param).floatValue();
        }
    }

    @FunctionalInterface
    public static interface Consumer
    extends VoidFunction<ComplexNumber> {
        @Override
        default public void invoke(double arg) {
            this.invoke(ComplexNumber.valueOf(arg));
        }

        @Override
        default public void invoke(float arg) {
            this.invoke(ComplexNumber.valueOf(arg));
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<ComplexNumber> {
        @Override
        default public double invoke(double arg1, double arg2) {
            return this.invoke(ComplexNumber.valueOf(arg1), ComplexNumber.valueOf(arg2)).doubleValue();
        }

        @Override
        default public float invoke(float arg1, float arg2) {
            return this.invoke(ComplexNumber.valueOf(arg1), ComplexNumber.valueOf(arg2)).floatValue();
        }
    }
}

