/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PredicateFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.RationalAggregator;
import org.ojalgo.function.constant.RationalMath;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.type.context.NumberContext;

public final class RationalFunction
extends FunctionSet<RationalNumber> {
    private static final RationalFunction SET = new RationalFunction();

    public static RationalFunction getSet() {
        return SET;
    }

    private RationalFunction() {
    }

    @Override
    public UnaryFunction<RationalNumber> abs() {
        return RationalMath.ABS;
    }

    @Override
    public UnaryFunction<RationalNumber> acos() {
        return RationalMath.ACOS;
    }

    @Override
    public UnaryFunction<RationalNumber> acosh() {
        return RationalMath.ACOSH;
    }

    @Override
    public BinaryFunction<RationalNumber> add() {
        return RationalMath.ADD;
    }

    @Override
    public AggregatorSet<RationalNumber> aggregator() {
        return RationalAggregator.getSet();
    }

    @Override
    public UnaryFunction<RationalNumber> asin() {
        return RationalMath.ASIN;
    }

    @Override
    public UnaryFunction<RationalNumber> asinh() {
        return RationalMath.ASINH;
    }

    @Override
    public UnaryFunction<RationalNumber> atan() {
        return RationalMath.ATAN;
    }

    @Override
    public BinaryFunction<RationalNumber> atan2() {
        return RationalMath.ATAN2;
    }

    @Override
    public UnaryFunction<RationalNumber> atanh() {
        return RationalMath.ATANH;
    }

    @Override
    public UnaryFunction<RationalNumber> cardinality() {
        return RationalMath.CARDINALITY;
    }

    @Override
    public UnaryFunction<RationalNumber> cbrt() {
        return RationalMath.CBRT;
    }

    @Override
    public UnaryFunction<RationalNumber> ceil() {
        return RationalMath.CEIL;
    }

    @Override
    public UnaryFunction<RationalNumber> conjugate() {
        return RationalMath.CONJUGATE;
    }

    @Override
    public UnaryFunction<RationalNumber> cos() {
        return RationalMath.COS;
    }

    @Override
    public UnaryFunction<RationalNumber> cosh() {
        return RationalMath.COSH;
    }

    @Override
    public BinaryFunction<RationalNumber> divide() {
        return RationalMath.DIVIDE;
    }

    public Unary enforce(NumberContext context) {
        return t -> RationalNumber.valueOf(context.enforce(t));
    }

    @Override
    public UnaryFunction<RationalNumber> exp() {
        return RationalMath.EXP;
    }

    @Override
    public UnaryFunction<RationalNumber> expm1() {
        return RationalMath.EXPM1;
    }

    @Override
    public UnaryFunction<RationalNumber> floor() {
        return RationalMath.FLOOR;
    }

    @Override
    public BinaryFunction<RationalNumber> hypot() {
        return RationalMath.HYPOT;
    }

    @Override
    public UnaryFunction<RationalNumber> invert() {
        return RationalMath.INVERT;
    }

    @Override
    public UnaryFunction<RationalNumber> log() {
        return RationalMath.LOG;
    }

    @Override
    public UnaryFunction<RationalNumber> log10() {
        return RationalMath.LOG10;
    }

    @Override
    public UnaryFunction<RationalNumber> log1p() {
        return RationalMath.LOG1P;
    }

    @Override
    public UnaryFunction<RationalNumber> logistic() {
        return RationalMath.LOGISTIC;
    }

    @Override
    public UnaryFunction<RationalNumber> logit() {
        return RationalMath.LOGIT;
    }

    @Override
    public BinaryFunction<RationalNumber> max() {
        return RationalMath.MAX;
    }

    @Override
    public BinaryFunction<RationalNumber> min() {
        return RationalMath.MIN;
    }

    @Override
    public BinaryFunction<RationalNumber> multiply() {
        return RationalMath.MULTIPLY;
    }

    @Override
    public UnaryFunction<RationalNumber> negate() {
        return RationalMath.NEGATE;
    }

    @Override
    public BinaryFunction<RationalNumber> pow() {
        return RationalMath.POW;
    }

    @Override
    public ParameterFunction<RationalNumber> power() {
        return RationalMath.POWER;
    }

    @Override
    public UnaryFunction<RationalNumber> rint() {
        return RationalMath.RINT;
    }

    @Override
    public ParameterFunction<RationalNumber> root() {
        return RationalMath.ROOT;
    }

    @Override
    public ParameterFunction<RationalNumber> scale() {
        return RationalMath.SCALE;
    }

    @Override
    public UnaryFunction<RationalNumber> signum() {
        return RationalMath.SIGNUM;
    }

    @Override
    public UnaryFunction<RationalNumber> sin() {
        return RationalMath.SIN;
    }

    @Override
    public UnaryFunction<RationalNumber> sinh() {
        return RationalMath.SINH;
    }

    @Override
    public UnaryFunction<RationalNumber> sqrt() {
        return RationalMath.SQRT;
    }

    @Override
    public UnaryFunction<RationalNumber> sqrt1px2() {
        return RationalMath.SQRT1PX2;
    }

    @Override
    public BinaryFunction<RationalNumber> subtract() {
        return RationalMath.SUBTRACT;
    }

    @Override
    public UnaryFunction<RationalNumber> tan() {
        return RationalMath.TAN;
    }

    @Override
    public UnaryFunction<RationalNumber> tanh() {
        return RationalMath.TANH;
    }

    @Override
    public UnaryFunction<RationalNumber> value() {
        return RationalMath.VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<RationalNumber> {
        @Override
        default public double invoke(double arg) {
            return this.invoke(RationalNumber.valueOf(arg)).doubleValue();
        }

        @Override
        default public float invoke(float arg) {
            return this.invoke(RationalNumber.valueOf(arg)).floatValue();
        }
    }

    @FunctionalInterface
    public static interface Predicate
    extends PredicateFunction<RationalNumber> {
        @Override
        default public boolean invoke(double arg) {
            return this.invoke(RationalNumber.valueOf(arg));
        }

        @Override
        default public boolean invoke(float arg) {
            return this.invoke(RationalNumber.valueOf(arg));
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<RationalNumber> {
        @Override
        default public double invoke(double arg, int param) {
            return this.invoke(RationalNumber.valueOf(arg), param).doubleValue();
        }

        @Override
        default public float invoke(float arg, int param) {
            return this.invoke(RationalNumber.valueOf(arg), param).floatValue();
        }
    }

    @FunctionalInterface
    public static interface Consumer
    extends VoidFunction<RationalNumber> {
        @Override
        default public void invoke(double arg) {
            this.invoke(RationalNumber.valueOf(arg));
        }

        @Override
        default public void invoke(float arg) {
            this.invoke(RationalNumber.valueOf(arg));
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<RationalNumber> {
        @Override
        default public double invoke(double arg1, double arg2) {
            return this.invoke(RationalNumber.valueOf(arg1), RationalNumber.valueOf(arg2)).doubleValue();
        }

        @Override
        default public float invoke(float arg1, float arg2) {
            return this.invoke(RationalNumber.valueOf(arg1), RationalNumber.valueOf(arg2)).floatValue();
        }
    }
}

