/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.GammaFunction;
import org.ojalgo.random.RandomNumber;

public class Weibull
extends RandomNumber {
    private final double myShape;
    private final double myRate;

    public Weibull() {
        this(PrimitiveMath.ONE, PrimitiveMath.ONE);
    }

    public Weibull(double lambda, double beta) {
        this.myRate = lambda;
        this.myShape = beta;
    }

    @Override
    public double getExpected() {
        return GammaFunction.gamma(PrimitiveMath.ONE + PrimitiveMath.ONE / this.myShape) / this.myRate;
    }

    @Override
    public double getVariance() {
        double tmpA = GammaFunction.gamma(PrimitiveMath.ONE + PrimitiveMath.TWO / this.myShape);
        double tmpB = GammaFunction.gamma(PrimitiveMath.ONE + PrimitiveMath.ONE / this.myShape);
        return (tmpA - tmpB * tmpB) / (this.myRate * this.myRate);
    }

    @Override
    protected double generate() {
        return PrimitiveMath.POW.invoke(-PrimitiveMath.LOG.invoke(this.random().nextDouble()), PrimitiveMath.ONE / this.myShape) / this.myRate;
    }
}

