/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.trigger.schedule.CronnableSchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.TimezoneUtils;

public class ScheduleRegistry {
    private final Map<String, Schedule.Parser<? extends Schedule>> parsers = new HashMap<String, Schedule.Parser<? extends Schedule>>();

    public ScheduleRegistry(Set<Schedule.Parser<? extends Schedule>> parsers) {
        parsers.forEach(parser -> this.parsers.put(parser.type(), (Schedule.Parser<? extends Schedule>)parser));
    }

    public Set<String> types() {
        return this.parsers.keySet();
    }

    public Schedule parse(String context, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String type = null;
        Schedule schedule = null;
        ZoneId timeZone = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String fieldName = parser.currentName();
                if (fieldName.equals("timezone")) {
                    timeZone = ScheduleRegistry.parseTimezone(parser);
                    continue;
                }
                type = parser.currentName();
                continue;
            }
            if (type != null) {
                schedule = this.parse(context, type, parser);
                continue;
            }
            throw new ElasticsearchParseException("could not parse schedule. expected a schedule type field, but found [{}] instead", new Object[]{token});
        }
        if (schedule == null) {
            throw new ElasticsearchParseException("could not parse schedule. expected a schedule type field, but no fields were found", new Object[0]);
        }
        if (timeZone != null && schedule instanceof CronnableSchedule) {
            CronnableSchedule cronnableSchedule = (CronnableSchedule)schedule;
            cronnableSchedule.setTimeZone(timeZone);
        } else if (timeZone != null) {
            throw new ElasticsearchParseException("could not parse schedule. Timezone is not supported for schedule type [{}]", new Object[]{schedule.type()});
        }
        return schedule;
    }

    private static ZoneId parseTimezone(XContentParser parser) throws IOException {
        ZoneId timeZone;
        XContentParser.Token token = parser.nextToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            String text = parser.text();
            try {
                timeZone = TimezoneUtils.parse(text);
            }
            catch (DateTimeException e) {
                throw new ElasticsearchParseException("could not parse schedule. invalid timezone [{}]", (Throwable)e, new Object[]{text});
            }
        } else {
            throw new ElasticsearchParseException("could not parse schedule. expected a string value for timezone, but found [{}] instead", new Object[]{token});
        }
        return timeZone;
    }

    public Schedule parse(String context, String type, XContentParser parser) throws IOException {
        Schedule.Parser<? extends Schedule> scheduleParser = this.parsers.get(type);
        if (scheduleParser == null) {
            throw new ElasticsearchParseException("could not parse schedule for [{}]. unknown schedule type [{}]", new Object[]{context, type});
        }
        return scheduleParser.parse(parser);
    }
}

