// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Bonus.h"




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Bonus::Bonus( int x_, int y_, int my_row_, BonusType my_bonus_type_ )
{
    x = x_;
    y = y_;
    width = CELL_WIDTH;
    height = CELL_HEIGHT;
    
    my_row = my_row_;
    my_bonus_type = my_bonus_type_;
    
    my_id = BONUS;
    
    coll_box_x_offset = BONUS_COLL_BOX_X_OFFSET;
    coll_box_y_offset = BONUS_COLL_BOX_Y_OFFSET;
    coll_box.w = BONUS_COLL_BOX_WIDTH; 
    coll_box.h = BONUS_COLL_BOX_HEIGHT;
    
    must_deactivate = false;
    active = true;
    
} // FS::Bonus::Bonus

// ******************
// *** DESTRUCTOR ***
// ******************
FS::Bonus::~Bonus()
{
    // ...
    
} // FS::Bonus::~Bonus




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::Bonus::update( const ScrollingData& sd )
{
    // Need to scroll whether bonus's active or not - it will
    // be reactivated if the level is restarted.
    scroll_x(sd);   // i.e. MapSprite::scroll_x
    
    if ( active )
    {
        if ( calc_virtual_x(sd, my_row) )   // see CollectableSprite::calc_rects
        {
            if ( !must_deactivate )
            {
                gfx_ptr->draw_texture( my_bonus_type + 43, virtual_x, y );
            } 
            else
            {
                must_deactivate = false;
                deactivate();   // see Sprite::deactivate
            } // if ... else
        } // if
    } // if
    
} // FS::Bonus::update

// **************************************************

void FS::Bonus::reset()
{
    active = true;
    must_deactivate = false;
    
} // FS::Bonus::reset

// **************************************************

