// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Bonus_h
#define Bonus_h




#include "Collectable_sprite.h"
#include "constants.h"
#include "enums.h"
#include "FS_gfx.h"
#include <tr1/memory>




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;




namespace FS
{
    
class Bonus : public Collectable_sprite
{
    public:
            
        Bonus( int x_, int y_, int my_row_, BonusType my_bonus_type_ );
        ~Bonus();
        
        // Provide implementation of pure virtual function in MapSprite.
        void update( const ScrollingData& sd );
        
        void reset();
        
        BonusType get_bonus_type() const { return my_bonus_type; }
        
    private:

        BonusType my_bonus_type;
        int points; // this is only used for TREATs
        
}; // class Bonus

} // namespace FS




#endif
    
