// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Useful_gl_h
#define Useful_gl_h

#include <SDL/SDL.h>
#include <SDL/SDL_opengl.h>
#include <iostream>
#include <cstdlib>
#include <SDL/SDL_image.h>
#include <string>




namespace Mafferyew
{
    
class Useful_gl
{
    public:
            
        static int power_of_two(int value);
    
        // This function assumes that 'image_file' has a depth of four bytes:
        // 1 byte for each red, green, blue and alpha component.
        static GLuint create_opengl_texture_rgba(const std::string& image_file,
                                                 int* w,     // texture width
                                                 int* h);    // and height stored here
        
        static Uint32 get_pixel(SDL_Surface* surface, int x, int y);
        
}; // class Useful_gl
    
} // namespace Mafferyew




#endif
    
