/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.jobs;

import java.io.IOException;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.jobs.Job;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.internal.util.Hex;

public class RetrieveStickerPackJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(RetrieveStickerPackJob.class);
    private final StickerPackId packId;
    private final byte[] packKey;

    public RetrieveStickerPackJob(StickerPackId packId, byte[] packKey) {
        this.packId = packId;
        this.packKey = packKey;
    }

    @Override
    public void run(Context context) {
        logger.trace("Downloading sticker pack {}", (Object)this.packId);
        try {
            context.getStickerHelper().retrieveStickerPack(this.packId, this.packKey);
        }
        catch (IOException e) {
            logger.warn("Failed to retrieve sticker pack {}: {}", (Object)Hex.toStringCondensed((byte[])this.packId.serialize()), (Object)e.getMessage());
        }
        catch (InvalidMessageException e) {
            logger.warn("Failed to retrieve sticker pack {}, invalid pack data: {}", (Object)Hex.toStringCondensed((byte[])this.packId.serialize()), (Object)e.getMessage());
        }
    }
}

