/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.groups;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.asamk.signal.manager.api.GroupIdV1;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.api.GroupInviteLinkUrl;
import org.asamk.signal.manager.api.GroupPermission;
import org.asamk.signal.manager.groups.GroupUtils;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.whispersystems.signalservice.api.push.DistributionId;

public final class GroupInfoV1
extends GroupInfo {
    private final GroupIdV1 groupId;
    private GroupIdV2 expectedV2Id;
    public String name;
    public Set<RecipientId> members = new HashSet<RecipientId>();
    public String color;
    public int messageExpirationTime;
    public boolean blocked;
    public boolean archived;
    private byte[] storageRecord;

    public GroupInfoV1(GroupIdV1 groupId) {
        this.groupId = groupId;
    }

    public GroupInfoV1(GroupIdV1 groupId, GroupIdV2 expectedV2Id, String name, Set<RecipientId> members, String color, int messageExpirationTime, boolean blocked, boolean archived, byte[] storageRecord) {
        this.groupId = groupId;
        this.expectedV2Id = expectedV2Id;
        this.name = name;
        this.members = new HashSet<RecipientId>(members);
        this.color = color;
        this.messageExpirationTime = messageExpirationTime;
        this.blocked = blocked;
        this.archived = archived;
        this.storageRecord = storageRecord;
    }

    @Override
    public GroupIdV1 getGroupId() {
        return this.groupId;
    }

    @Override
    public DistributionId getDistributionId() {
        return null;
    }

    public GroupIdV2 getExpectedV2Id() {
        if (this.expectedV2Id == null) {
            this.expectedV2Id = GroupUtils.getGroupIdV2(this.groupId);
        }
        return this.expectedV2Id;
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    @Override
    public GroupInviteLinkUrl getGroupInviteLink() {
        return null;
    }

    @Override
    public Set<RecipientId> getMembers() {
        return new HashSet<RecipientId>(this.members);
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    @Override
    public boolean isProfileSharingEnabled() {
        return true;
    }

    @Override
    public void setProfileSharingEnabled(boolean profileSharingEnabled) {
    }

    @Override
    public int getMessageExpirationTimer() {
        return this.messageExpirationTime;
    }

    @Override
    public boolean isAnnouncementGroup() {
        return false;
    }

    @Override
    public GroupPermission getPermissionAddMember() {
        return GroupPermission.EVERY_MEMBER;
    }

    @Override
    public GroupPermission getPermissionEditDetails() {
        return GroupPermission.EVERY_MEMBER;
    }

    @Override
    public GroupPermission getPermissionSendMessage() {
        return GroupPermission.EVERY_MEMBER;
    }

    public void addMembers(Collection<RecipientId> members) {
        this.members.addAll(members);
    }

    public void removeMember(RecipientId recipientId) {
        this.members.removeIf(member -> member.equals(recipientId));
    }

    public byte[] getStorageRecord() {
        return this.storageRecord;
    }
}

