/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.protocol.InvalidMessageException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/whispersystems/signalservice/api/crypto/DigestValidatingInputStream;", "Ljava/io/FilterInputStream;", "inputStream", "Ljava/io/InputStream;", "digest", "Ljava/security/MessageDigest;", "expectedHash", "", "<init>", "(Ljava/io/InputStream;Ljava/security/MessageDigest;[B)V", "value", "", "validationAttempted", "getValidationAttempted", "()Z", "read", "", "buffer", "offset", "length", "validateDigest", "", "signal-service-java"})
public final class DigestValidatingInputStream
extends FilterInputStream {
    @NotNull
    private final MessageDigest digest;
    @NotNull
    private final byte[] expectedHash;
    private boolean validationAttempted;

    public DigestValidatingInputStream(@NotNull InputStream inputStream, @NotNull MessageDigest digest, @NotNull byte[] expectedHash) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)expectedHash, (String)"expectedHash");
        super(inputStream);
        this.digest = digest;
        this.expectedHash = expectedHash;
    }

    public final boolean getValidationAttempted() {
        return this.validationAttempted;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.digest.update((byte)n);
        } else {
            this.validateDigest();
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] buffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(@NotNull byte[] buffer, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int bytesRead = super.read(buffer, offset, length);
        if (bytesRead > 0) {
            this.digest.update(buffer, offset, bytesRead);
        } else if (bytesRead == -1) {
            this.validateDigest();
        }
        return bytesRead;
    }

    private final void validateDigest() throws InvalidMessageException {
        if (this.validationAttempted) {
            return;
        }
        this.validationAttempted = true;
        byte[] calculatedHash = this.digest.digest();
        if (!MessageDigest.isEqual(calculatedHash, this.expectedHash)) {
            throw new InvalidMessageException("Calculated digest does not match expected hash!");
        }
    }
}

