/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages.multidevice;

import java.io.IOException;
import java.io.OutputStream;
import org.whispersystems.signalservice.api.messages.multidevice.ChunkedOutputStream;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceContact;
import org.whispersystems.signalservice.internal.push.ContactDetails;

public class DeviceContactsOutputStream
extends ChunkedOutputStream {
    public DeviceContactsOutputStream(OutputStream out) {
        super(out);
    }

    public void write(DeviceContact contact) throws IOException {
        this.writeContactDetails(contact);
        this.writeAvatarImage(contact);
    }

    public void close() throws IOException {
        this.out.close();
    }

    private void writeAvatarImage(DeviceContact contact) throws IOException {
        if (contact.getAvatar().isPresent()) {
            this.writeStream(contact.getAvatar().get().getInputStream());
        }
    }

    private void writeContactDetails(DeviceContact contact) throws IOException {
        ContactDetails.Builder contactDetails = new ContactDetails.Builder();
        if (contact.getAci().isPresent()) {
            contactDetails.aci(contact.getAci().get().toString());
        }
        if (contact.getE164().isPresent()) {
            contactDetails.number(contact.getE164().get());
        }
        if (contact.getName().isPresent()) {
            contactDetails.name(contact.getName().get());
        }
        if (contact.getAvatar().isPresent()) {
            ContactDetails.Avatar.Builder avatarBuilder = new ContactDetails.Avatar.Builder();
            avatarBuilder.contentType(contact.getAvatar().get().getContentType());
            avatarBuilder.length((int)contact.getAvatar().get().getLength());
            contactDetails.avatar(avatarBuilder.build());
        }
        if (contact.getExpirationTimer().isPresent()) {
            contactDetails.expireTimer(contact.getExpirationTimer().get());
        }
        if (contact.getInboxPosition().isPresent()) {
            contactDetails.inboxPosition(contact.getInboxPosition().get());
        }
        byte[] serializedContactDetails = contactDetails.build().encode();
        this.writeVarint32(serializedContactDetails.length);
        this.out.write(serializedContactDetails);
    }
}

