/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.subscriptions;

import io.reactivex.rxjava3.annotations.NonNull;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.signal.core.util.Base64;
import org.whispersystems.signalservice.api.util.Preconditions;

public final class SubscriberId {
    private static final int SIZE = 32;
    private final byte[] bytes;

    private SubscriberId(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @NonNull
    public String serialize() {
        return Base64.encodeUrlSafeWithPadding((byte[])this.bytes);
    }

    @NonNull
    public static SubscriberId deserialize(@NonNull String serialized) throws IOException {
        byte[] bytes = Base64.decode((String)serialized);
        return SubscriberId.fromBytes(bytes);
    }

    public static SubscriberId fromBytes(byte[] bytes) {
        Preconditions.checkArgument(bytes.length == 32);
        return new SubscriberId(bytes);
    }

    public static SubscriberId generate() {
        byte[] bytes = new byte[32];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(bytes);
        return new SubscriberId(bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriberId that = (SubscriberId)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

