/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import net.sf.clipsrules.jni.Agenda;
import net.sf.clipsrules.jni.CLIPSException;
import net.sf.clipsrules.jni.CLIPSLineError;
import net.sf.clipsrules.jni.CLIPSLoadException;
import net.sf.clipsrules.jni.CaptureRouter;
import net.sf.clipsrules.jni.ExternalAddressValue;
import net.sf.clipsrules.jni.FactAddressValue;
import net.sf.clipsrules.jni.FactInstance;
import net.sf.clipsrules.jni.Focus;
import net.sf.clipsrules.jni.FocusStack;
import net.sf.clipsrules.jni.InstanceAddressValue;
import net.sf.clipsrules.jni.InstanceNameValue;
import net.sf.clipsrules.jni.Module;
import net.sf.clipsrules.jni.MultifieldValue;
import net.sf.clipsrules.jni.PeriodicCallback;
import net.sf.clipsrules.jni.PrimitiveValue;
import net.sf.clipsrules.jni.Router;
import net.sf.clipsrules.jni.UserFunction;

public class Environment {
    private static final String CLIPSJNI_VERSION = "0.5";
    public static final String FACTS = "facts";
    public static final String RULES = "rules";
    public static final String DEFFUNCTIONS = "deffunctions";
    public static final String COMPILATIONS = "compilations";
    public static final String INSTANCES = "instances";
    public static final String SLOTS = "slots";
    public static final String ACTIVATIONS = "activations";
    public static final String STATISTICS = "statistics";
    public static final String FOCUS = "focus";
    public static final String GENERIC_FUNCTIONS = "generic-functions";
    public static final String METHODS = "methods";
    public static final String GLOBALS = "globals";
    public static final String MESSAGES = "messages";
    public static final String MESSAGE_HANDLERS = "message-handlers";
    public static final String NONE = "none";
    public static final String ALL = "all";
    private HashMap<String, Router> routerMap = new HashMap();
    private List<CLIPSLineError> errorList = new ArrayList<CLIPSLineError>();
    private long theEnvironment = this.createEnvironment();

    public static void main(String[] stringArray) {
        Environment environment = new Environment();
        environment.commandLoop();
    }

    private native long createEnvironment();

    public CaptureRouter captureStart() {
        this.setErrorCallback(true);
        this.errorList.clear();
        return new CaptureRouter(this, new String[]{"stderr"});
    }

    public void captureEnd(CaptureRouter captureRouter) throws CLIPSException {
        String string = captureRouter.getOutput();
        this.setErrorCallback(false);
        this.deleteRouter(captureRouter);
        if (!string.isEmpty()) {
            throw new CLIPSException(string);
        }
    }

    public void captureEndWithoutCheck(CaptureRouter captureRouter) {
        String string = captureRouter.getOutput();
        this.setErrorCallback(false);
        this.deleteRouter(captureRouter);
    }

    private native void clear(long var1);

    public void clear() throws CLIPSException {
        this.voidCommandWrapper(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Environment.this.clear(Environment.this.theEnvironment);
                return null;
            }
        });
    }

    private native void load(long var1, String var3);

    public void load(String string) throws CLIPSLoadException {
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        CaptureRouter captureRouter = this.captureStart();
        this.load(this.theEnvironment, string);
        this.captureEndWithoutCheck(captureRouter);
        this.checkForErrors("Load");
    }

    private native void loadFromString(long var1, String var3);

    public void loadFromString(String string) throws CLIPSLoadException {
        if (string == null) {
            throw new NullPointerException("loadString");
        }
        String string2 = this.getParsingFileName();
        this.setParsingFileName("<String>");
        CaptureRouter captureRouter = this.captureStart();
        this.loadFromString(this.theEnvironment, string);
        this.captureEndWithoutCheck(captureRouter);
        this.setParsingFileName(string2);
        this.checkForErrors("LoadFromString");
    }

    private native void loadFromStringWithOutput(long var1, String var3);

    public void loadFromStringWithOutput(String string) {
        String string2 = this.getParsingFileName();
        this.setParsingFileName("<String>");
        this.loadFromStringWithOutput(this.theEnvironment, string);
        this.setParsingFileName(string2);
    }

    private static String convertStreamToString(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream, "UTF-8").useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    public void loadFromResource(String string) throws CLIPSLoadException, FileNotFoundException {
        if (string == null) {
            throw new NullPointerException("resourceFile");
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string + " (no such file)");
        }
        String string2 = this.getParsingFileName();
        this.setParsingFileName(string);
        CaptureRouter captureRouter = this.captureStart();
        this.loadFromString(this.theEnvironment, Environment.convertStreamToString(inputStream));
        this.captureEndWithoutCheck(captureRouter);
        this.setParsingFileName(string2);
        this.checkForErrors("LoadFromResource");
    }

    private native boolean build(long var1, String var3);

    public void build(String string) throws CLIPSException {
        if (string == null) {
            throw new NullPointerException("buildString");
        }
        CaptureRouter captureRouter = this.captureStart();
        this.build(this.theEnvironment, string);
        this.captureEnd(captureRouter);
    }

    private native void reset(long var1);

    public void reset() throws CLIPSException {
        this.voidCommandWrapper(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Environment.this.reset(Environment.this.theEnvironment);
                return null;
            }
        });
    }

    private native long run(long var1, long var3);

    public long run(final long l) throws CLIPSException {
        return this.longCommandWrapper(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return Environment.this.run(Environment.this.theEnvironment, l);
            }
        });
    }

    public long run() throws CLIPSException {
        return this.run(-1L);
    }

    private native FactAddressValue assertString(long var1, String var3);

    public FactAddressValue assertString(String string) throws CLIPSException {
        if (string == null) {
            throw new NullPointerException("factString");
        }
        CaptureRouter captureRouter = this.captureStart();
        FactAddressValue factAddressValue = this.assertString(this.theEnvironment, string);
        this.captureEnd(captureRouter);
        return factAddressValue;
    }

    private native InstanceAddressValue makeInstance(long var1, String var3);

    public InstanceAddressValue makeInstance(String string) throws CLIPSException {
        if (string == null) {
            throw new NullPointerException("instanceString");
        }
        CaptureRouter captureRouter = this.captureStart();
        InstanceAddressValue instanceAddressValue = this.makeInstance(this.theEnvironment, string);
        this.captureEnd(captureRouter);
        return instanceAddressValue;
    }

    public FactAddressValue findFact(String string) throws CLIPSException {
        return this.findFact("?f", string, "TRUE");
    }

    public FactAddressValue findFact(String string, String string2, String string3) throws CLIPSException {
        if (string == null) {
            throw new NullPointerException("variable");
        }
        if (string2 == null) {
            throw new NullPointerException("deftemplate");
        }
        if (string3 == null) {
            throw new NullPointerException("condition");
        }
        String string4 = "(find-fact ((" + string + " " + string2 + ")) " + string3 + ")";
        PrimitiveValue primitiveValue = this.eval(string4);
        if (!primitiveValue.isMultifield()) {
            return null;
        }
        MultifieldValue multifieldValue = (MultifieldValue)primitiveValue;
        if (multifieldValue.size() == 0) {
            return null;
        }
        return (FactAddressValue)multifieldValue.get(0);
    }

    public List<FactAddressValue> findAllFacts(String string) throws CLIPSException {
        return this.findAllFacts("?f", string, "TRUE");
    }

    public List<FactAddressValue> findAllFacts(String string, String string2, String string3) throws CLIPSException {
        if (string == null) {
            throw new NullPointerException("variable");
        }
        if (string2 == null) {
            throw new NullPointerException("deftemplate");
        }
        if (string3 == null) {
            throw new NullPointerException("condition");
        }
        String string4 = "(find-all-facts ((" + string + " " + string2 + ")) " + string3 + ")";
        PrimitiveValue primitiveValue = this.eval(string4);
        if (!primitiveValue.isMultifield()) {
            return null;
        }
        MultifieldValue multifieldValue = (MultifieldValue)primitiveValue;
        ArrayList<FactAddressValue> arrayList = new ArrayList<FactAddressValue>(multifieldValue.size());
        for (PrimitiveValue primitiveValue2 : multifieldValue) {
            arrayList.add((FactAddressValue)primitiveValue2);
        }
        return arrayList;
    }

    public InstanceAddressValue findInstance(String string) throws CLIPSException {
        return this.findInstance("?i", string, "TRUE");
    }

    public InstanceAddressValue findInstance(String string, String string2, String string3) throws CLIPSException {
        if (string == null) {
            throw new NullPointerException("variable");
        }
        if (string2 == null) {
            throw new NullPointerException("defclass");
        }
        if (string3 == null) {
            throw new NullPointerException("condition");
        }
        String string4 = "(find-instance ((" + string + " " + string2 + ")) " + string3 + ")";
        PrimitiveValue primitiveValue = this.eval(string4);
        if (!primitiveValue.isMultifield()) {
            return null;
        }
        MultifieldValue multifieldValue = (MultifieldValue)primitiveValue;
        if (multifieldValue.size() == 0) {
            return null;
        }
        return ((InstanceNameValue)multifieldValue.get(0)).getInstance(this);
    }

    public List<InstanceAddressValue> findAllInstances(String string) throws CLIPSException {
        return this.findAllInstances("?i", string, "TRUE");
    }

    public List<InstanceAddressValue> findAllInstances(String string, String string2, String string3) throws CLIPSException {
        if (string == null) {
            throw new NullPointerException("variable");
        }
        if (string2 == null) {
            throw new NullPointerException("defclass");
        }
        if (string3 == null) {
            throw new NullPointerException("condition");
        }
        String string4 = "(find-all-instances ((" + string + " " + string2 + ")) " + string3 + ")";
        PrimitiveValue primitiveValue = this.eval(string4);
        if (!primitiveValue.isMultifield()) {
            return null;
        }
        MultifieldValue multifieldValue = (MultifieldValue)primitiveValue;
        ArrayList<InstanceAddressValue> arrayList = new ArrayList<InstanceAddressValue>(multifieldValue.size());
        for (PrimitiveValue primitiveValue2 : multifieldValue) {
            arrayList.add(((InstanceNameValue)primitiveValue2).getInstance(this));
        }
        return arrayList;
    }

    private native PrimitiveValue eval(long var1, String var3);

    public PrimitiveValue eval(String string) throws CLIPSException {
        if (string == null) {
            throw new NullPointerException("evalString");
        }
        CaptureRouter captureRouter = this.captureStart();
        PrimitiveValue primitiveValue = this.eval(this.theEnvironment, string);
        this.captureEnd(captureRouter);
        return primitiveValue;
    }

    private native boolean watch(long var1, String var3);

    public void watch(String string) {
        if (string == null) {
            throw new NullPointerException("watchItem");
        }
        if (!this.validWatchItem(this.theEnvironment, string)) {
            throw new IllegalArgumentException("watchItem '" + string + "' is invalid.");
        }
        this.watch(this.theEnvironment, string);
    }

    private native boolean unwatch(long var1, String var3);

    public void unwatch(String string) {
        if (string == null) {
            throw new NullPointerException("watchItem");
        }
        if (!this.validWatchItem(this.theEnvironment, string)) {
            throw new IllegalArgumentException("watchItem '" + string + "' is invalid.");
        }
        this.unwatch(this.theEnvironment, string);
    }

    private native boolean validWatchItem(long var1, String var3);

    private native boolean getWatchItem(long var1, String var3);

    public boolean getWatchItem(String string) {
        if (string == null) {
            throw new NullPointerException("watchItem");
        }
        if (!this.validWatchItem(this.theEnvironment, string)) {
            throw new IllegalArgumentException("watchItem '" + string + "' is invalid.");
        }
        return this.getWatchItem(this.theEnvironment, string);
    }

    public void setWatchItem(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("watchItem");
        }
        if (!this.validWatchItem(this.theEnvironment, string)) {
            throw new IllegalArgumentException("watchItem '" + string + "' is invalid.");
        }
        if (bl) {
            this.watch(string);
        } else {
            this.unwatch(string);
        }
    }

    private native int addUserFunction(long var1, String var3, String var4, int var5, int var6, String var7, UserFunction var8);

    public void addUserFunction(String string, UserFunction userFunction) {
        this.addUserFunction(string, "*", 0, -1, null, userFunction);
    }

    public void addUserFunction(String string, String string2, int n, int n2, String string3, UserFunction userFunction) {
        if (string == null) {
            throw new NullPointerException("functionName");
        }
        if (userFunction == null) {
            throw new NullPointerException("callback");
        }
        int n3 = this.addUserFunction(this.theEnvironment, string, string2, n, n2, string3, userFunction);
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                throw new IllegalArgumentException("Function '" + string + "' minArgs exceeds maxArgs.");
            }
            case 2: {
                throw new IllegalArgumentException("Function '" + string + "' already exists.");
            }
            case 3: {
                throw new IllegalArgumentException("Function '" + string + "' invalid argument type.");
            }
            case 4: {
                throw new IllegalArgumentException("Function '" + string + "' invalid return type.");
            }
        }
    }

    private native boolean removeUserFunction(long var1, String var3);

    public void removeUserFunction(String string) {
        if (string == null) {
            throw new NullPointerException("functionName");
        }
        boolean bl = this.removeUserFunction(this.theEnvironment, string);
        if (!bl) {
            throw new IllegalArgumentException("Function '" + string + "' does not exist.");
        }
    }

    private native boolean addRouter(long var1, String var3, int var4, Router var5);

    public void addRouter(Router router) {
        if (router == null) {
            throw new NullPointerException("theRouter");
        }
        if (this.routerMap.containsKey(router.getName())) {
            throw new IllegalArgumentException("Router named '" + router.getName() + "' already exists.");
        }
        boolean bl = this.addRouter(this.theEnvironment, router.getName(), router.getPriority(), router);
        if (!bl) {
            throw new IllegalArgumentException("Router named '" + router.getName() + "' already exists.");
        }
        this.routerMap.put(router.getName(), router);
    }

    private native boolean deleteRouter(long var1, String var3);

    public void deleteRouter(Router router) {
        if (router == null) {
            throw new NullPointerException("theRouter");
        }
        if (!this.deleteRouter(this.theEnvironment, router.getName())) {
            throw new IllegalArgumentException("Router named '" + router.getName() + "' does not exist.");
        }
        this.routerMap.remove(router);
    }

    private native boolean activateRouter(long var1, String var3);

    public void activateRouter(Router router) {
        if (router == null) {
            throw new NullPointerException("theRouter");
        }
        if (!this.activateRouter(this.theEnvironment, router.getName())) {
            throw new IllegalArgumentException("Router named '" + router.getName() + "' does not exist.");
        }
    }

    private native boolean deactivateRouter(long var1, String var3);

    public void deactivateRouter(Router router) {
        if (router == null) {
            throw new NullPointerException("theRouter");
        }
        if (!this.deactivateRouter(this.theEnvironment, router.getName())) {
            throw new IllegalArgumentException("Router named '" + router.getName() + "' does not exist.");
        }
    }

    private native void printString(long var1, String var3, String var4);

    private native boolean printRouterExists(long var1, String var3);

    public void print(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("logicalName");
        }
        if (string2 == null) {
            throw new NullPointerException("printString");
        }
        if (!this.printRouterExists(this.theEnvironment, string)) {
            throw new IllegalArgumentException("No print router for logicalName '" + string + "' exists.");
        }
        this.printString(this.theEnvironment, string, string2);
    }

    public void print(String string) {
        if (string == null) {
            throw new NullPointerException("printString");
        }
        this.printString(this.theEnvironment, "stdout", string);
    }

    public void println(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("logicalName");
        }
        if (string2 == null) {
            throw new NullPointerException("printString");
        }
        if (!this.printRouterExists(this.theEnvironment, string)) {
            throw new IllegalArgumentException("No print router for logicalName '" + string + "' exists.");
        }
        this.printString(this.theEnvironment, string, string2 + "\n");
    }

    public void println(String string) {
        if (string == null) {
            throw new NullPointerException("printString");
        }
        this.printString(this.theEnvironment, "stdout", string + "\n");
    }

    private native void commandLoop(long var1);

    public void commandLoop() {
        this.commandLoop(this.theEnvironment);
    }

    private native int changeDirectory(long var1, String var3);

    public int changeDirectory(String string) {
        return this.changeDirectory(this.theEnvironment, string);
    }

    public void checkForErrors(String string) throws CLIPSLoadException {
        if (this.errorList.isEmpty()) {
            return;
        }
        String string2 = this.errorList.size() == 1 ? "\n" + string + " encountered 1 error:\n" : "\n" + string + " encountered " + this.errorList.size() + " errors:\n";
        for (CLIPSLineError cLIPSLineError : this.errorList) {
            string2 = string2.concat("\n" + cLIPSLineError.getFileName() + " (Line " + cLIPSLineError.getLineNumber() + ") : " + cLIPSLineError.getMessage());
        }
        CLIPSLoadException cLIPSLoadException = new CLIPSLoadException(string2, this.errorList);
        this.errorList.clear();
        throw cLIPSLoadException;
    }

    private native String getParsingFileName(long var1);

    public String getParsingFileName() {
        return this.getParsingFileName(this.theEnvironment);
    }

    private native void setParsingFileName(long var1, String var3);

    public void setParsingFileName(String string) {
        this.setParsingFileName(this.theEnvironment, string);
    }

    public void addError(String string, long l, String string2) {
        this.errorList.add(new CLIPSLineError(string, l, string2));
    }

    private native boolean loadFacts(long var1, String var3);

    public boolean loadFacts(String string) {
        return this.loadFacts(this.theEnvironment, string);
    }

    private native void setHaltExecution(long var1, boolean var3);

    public void setHaltExecution(boolean bl) {
        this.setHaltExecution(this.theEnvironment, bl);
    }

    private native void setHaltRules(long var1, boolean var3);

    public void setHaltRules(boolean bl) {
        this.setHaltRules(this.theEnvironment, bl);
    }

    private native List<Module> getModuleList(long var1);

    public List<Module> getModuleList() {
        return this.getModuleList(this.theEnvironment);
    }

    private native FocusStack getFocusStack(long var1);

    public FocusStack getFocusStack() {
        return this.getFocusStack(this.theEnvironment);
    }

    private native HashMap<Long, BitSet> getFactScopes(long var1);

    public HashMap<Long, BitSet> getFactScopes() {
        return this.getFactScopes(this.theEnvironment);
    }

    private native HashMap<Long, BitSet> getInstanceScopes(long var1);

    public HashMap<Long, BitSet> getInstanceScopes() {
        return this.getInstanceScopes(this.theEnvironment);
    }

    private native List<FactInstance> getFactList(long var1);

    public List<FactInstance> getFactList() {
        return this.getFactList(this.theEnvironment);
    }

    private native List<FactInstance> getInstanceList(long var1);

    public List<FactInstance> getInstanceList() {
        return this.getInstanceList(this.theEnvironment);
    }

    private native Agenda getAgenda(long var1, String var3);

    public Agenda getAgenda(String string) {
        return this.getAgenda(this.theEnvironment, string);
    }

    public Agenda getAgenda(Focus focus) {
        return this.getAgenda(this.theEnvironment, focus.getModuleName());
    }

    private native String getDeftemplateText(long var1, long var3);

    public String getDeftemplateText(long l) {
        return this.getDeftemplateText(this.theEnvironment, l);
    }

    private native String getDefclassText(long var1, long var3);

    public String getDefclassText(long l) {
        return this.getDefclassText(this.theEnvironment, l);
    }

    private native String getDefruleText(long var1, String var3);

    public String getDefruleText(String string) {
        return this.getDefruleText(this.theEnvironment, string);
    }

    private static native long factIndex(Environment var0, long var1, long var3);

    public static long factIndex(FactAddressValue factAddressValue) {
        return Environment.factIndex(factAddressValue.getEnvironment(), factAddressValue.getEnvironment().getEnvironmentAddress(), factAddressValue.getFactAddress());
    }

    private static native PrimitiveValue getFactSlot(Environment var0, long var1, long var3, String var5);

    public static PrimitiveValue getFactSlot(FactAddressValue factAddressValue, String string) {
        if (string == null) {
            throw new NullPointerException("slotName");
        }
        PrimitiveValue primitiveValue = Environment.getFactSlot(factAddressValue.getEnvironment(), factAddressValue.getEnvironment().getEnvironmentAddress(), factAddressValue.getFactAddress(), string);
        if (primitiveValue == null) {
            throw new IllegalArgumentException("Slot name '" + string + "' is invalid.");
        }
        return primitiveValue;
    }

    private static native String getInstanceName(Environment var0, long var1, long var3);

    public static String getInstanceName(InstanceAddressValue instanceAddressValue) {
        return Environment.getInstanceName(instanceAddressValue.getEnvironment(), instanceAddressValue.getEnvironment().getEnvironmentAddress(), instanceAddressValue.getInstanceAddress());
    }

    private static native PrimitiveValue directGetSlot(Environment var0, long var1, long var3, String var5);

    public static PrimitiveValue directGetSlot(InstanceAddressValue instanceAddressValue, String string) {
        if (string == null) {
            throw new NullPointerException("slotName");
        }
        PrimitiveValue primitiveValue = Environment.directGetSlot(instanceAddressValue.getEnvironment(), instanceAddressValue.getEnvironment().getEnvironmentAddress(), instanceAddressValue.getInstanceAddress(), string);
        if (primitiveValue == null) {
            throw new IllegalArgumentException("Slot name '" + string + "' is invalid.");
        }
        return primitiveValue;
    }

    private native void destroyEnvironment(long var1);

    private native void flushInputBuffer(long var1);

    public void flushInputBuffer() {
        this.flushInputBuffer(this.theEnvironment);
    }

    private native String getInputBuffer(long var1);

    public String getInputBuffer() {
        return this.getInputBuffer(this.theEnvironment);
    }

    private native void setInputBuffer(long var1, String var3);

    public void setInputBuffer(String string) {
        this.setInputBuffer(this.theEnvironment, string);
    }

    private native long getInputBufferCount(long var1);

    public long getInputBufferCount() {
        return this.getInputBufferCount(this.theEnvironment);
    }

    private native long setInputBufferCount(long var1, long var3);

    public long setInputBufferCount(long l) {
        return this.setInputBufferCount(this.theEnvironment, l);
    }

    private native void expandInputBuffer(long var1, int var3);

    public void expandInputBuffer(int n) {
        this.expandInputBuffer(this.theEnvironment, n);
    }

    private native void appendInputBuffer(long var1, String var3);

    public void appendInputBuffer(String string) {
        this.appendInputBuffer(this.theEnvironment, string);
    }

    private native void appendDribble(long var1, String var3);

    public void appendDribble(String string) {
        this.appendDribble(this.theEnvironment, string);
    }

    private native boolean inputBufferContainsCommand(long var1);

    public boolean inputBufferContainsCommand() {
        return this.inputBufferContainsCommand(this.theEnvironment);
    }

    private native void commandLoopOnceThenBatch(long var1);

    public void commandLoopOnceThenBatch() {
        this.commandLoopOnceThenBatch(this.theEnvironment);
    }

    private native void commandLoopBatchDriver(long var1);

    public void commandLoopBatchDriver() {
        this.commandLoopBatchDriver(this.theEnvironment);
    }

    private native boolean openStringBatch(long var1, String var3, String var4, boolean var5);

    public boolean openStringBatch(String string, String string2, boolean bl) {
        return this.openStringBatch(this.theEnvironment, string, string2, bl);
    }

    private native void setPeriodicCallbackEnabled(long var1, boolean var3);

    public void setPeriodicCallbackEnabled(boolean bl) {
        this.setPeriodicCallbackEnabled(this.theEnvironment, bl);
    }

    private native void addPeriodicCallback(long var1, String var3, int var4, PeriodicCallback var5);

    public void addPeriodicCallback(String string, int n, PeriodicCallback periodicCallback) {
        this.addPeriodicCallback(this.theEnvironment, string, n, periodicCallback);
    }

    private native boolean removePeriodicCallback(long var1, String var3);

    public boolean removePeriodicCallback(String string) {
        return this.removePeriodicCallback(this.theEnvironment, string);
    }

    private native void printBanner(long var1);

    public void printBanner() {
        this.printBanner(this.theEnvironment);
    }

    private native void printPrompt(long var1);

    public void printPrompt() {
        this.printPrompt(this.theEnvironment);
    }

    public void callNextPrintRouter(Router router, String string, String string2) {
        this.deactivateRouter(router);
        this.print(string, string2);
        this.activateRouter(router);
    }

    private native boolean getAgendaChanged(long var1);

    public boolean getAgendaChanged() {
        return this.getAgendaChanged(this.theEnvironment);
    }

    private native void setAgendaChanged(long var1, boolean var3);

    public void setAgendaChanged(boolean bl) {
        this.setAgendaChanged(this.theEnvironment, bl);
    }

    private native boolean getFocusChanged(long var1);

    public boolean getFocusChanged() {
        return this.getFocusChanged(this.theEnvironment);
    }

    private native void setFocusChanged(long var1, boolean var3);

    public void setFocusChanged(boolean bl) {
        this.setFocusChanged(this.theEnvironment, bl);
    }

    private native boolean getFactListChanged(long var1);

    public boolean getFactListChanged() {
        return this.getFactListChanged(this.theEnvironment);
    }

    private native void setFactListChanged(long var1, boolean var3);

    public void setFactListChanged(boolean bl) {
        this.setFactListChanged(this.theEnvironment, bl);
    }

    private native boolean getInstancesChanged(long var1);

    public boolean getInstancesChanged() {
        return this.getInstancesChanged(this.theEnvironment);
    }

    private native void setInstancesChanged(long var1, boolean var3);

    public void setInstancesChanged(boolean bl) {
        this.setInstancesChanged(this.theEnvironment, bl);
    }

    private native void retainFact(Environment var1, long var2, long var4);

    private native void releaseFact(Environment var1, long var2, long var4);

    public void retainFact(FactAddressValue factAddressValue) {
        this.retainFact(factAddressValue.getEnvironment(), factAddressValue.getEnvironment().getEnvironmentAddress(), factAddressValue.getFactAddress());
    }

    public void releaseFact(FactAddressValue factAddressValue) {
        this.releaseFact(factAddressValue.getEnvironment(), factAddressValue.getEnvironment().getEnvironmentAddress(), factAddressValue.getFactAddress());
    }

    private native void retainInstance(Environment var1, long var2, long var4);

    private native void releaseInstance(Environment var1, long var2, long var4);

    public void retainInstance(InstanceAddressValue instanceAddressValue) {
        this.retainInstance(instanceAddressValue.getEnvironment(), instanceAddressValue.getEnvironment().getEnvironmentAddress(), instanceAddressValue.getInstanceAddress());
    }

    public void releaseInstance(InstanceAddressValue instanceAddressValue) {
        this.releaseInstance(instanceAddressValue.getEnvironment(), instanceAddressValue.getEnvironment().getEnvironmentAddress(), instanceAddressValue.getInstanceAddress());
    }

    private native InstanceAddressValue findInstanceByName(long var1, String var3);

    public InstanceAddressValue findInstanceByName(String string) {
        return this.findInstanceByName(this.theEnvironment, string);
    }

    private native void incrementAddressCount(Environment var1, long var2, long var4);

    private native void decrementAddressCount(Environment var1, long var2, long var4);

    public void incrementAddressCount(ExternalAddressValue externalAddressValue) {
        this.incrementAddressCount(externalAddressValue.getEnvironment(), externalAddressValue.getEnvironment().getEnvironmentAddress(), externalAddressValue.getExternalAddress());
    }

    public void decrementAddressCount(ExternalAddressValue externalAddressValue) {
        this.decrementAddressCount(externalAddressValue.getEnvironment(), externalAddressValue.getEnvironment().getEnvironmentAddress(), externalAddressValue.getExternalAddress());
    }

    public ExternalAddressValue createExternalAddressValue(Object object) {
        return new ExternalAddressValue(object, this);
    }

    private native void setErrorCallback(long var1, boolean var3);

    public void setErrorCallback(boolean bl) {
        this.setErrorCallback(this.theEnvironment, bl);
    }

    public void destroy() {
        for (String string : this.routerMap.keySet()) {
            this.deleteRouter(this.routerMap.get(string));
        }
        this.destroyEnvironment(this.theEnvironment);
    }

    public static String getCLIPSJNIVersion() {
        return CLIPSJNI_VERSION;
    }

    public static native String getCLIPSVersion();

    public static String getVersion() {
        return "CLIPSJNI version " + Environment.getCLIPSJNIVersion() + " (CLIPS version " + Environment.getCLIPSVersion() + ")";
    }

    public long getEnvironmentAddress() {
        return this.theEnvironment;
    }

    private void voidCommandWrapper(Callable<Void> callable) throws CLIPSException {
        CaptureRouter captureRouter = this.captureStart();
        try {
            callable.call();
        }
        catch (Exception exception) {
            this.captureEndWithoutCheck(captureRouter);
            throw new CLIPSException(exception.getMessage(), exception.getCause());
        }
        this.captureEnd(captureRouter);
    }

    private long longCommandWrapper(Callable<Long> callable) throws CLIPSException {
        Long l;
        CaptureRouter captureRouter = this.captureStart();
        try {
            l = callable.call();
        }
        catch (Exception exception) {
            this.captureEndWithoutCheck(captureRouter);
            throw new CLIPSException(exception.getMessage(), exception.getCause());
        }
        this.captureEnd(captureRouter);
        return l;
    }

    static {
        System.loadLibrary("CLIPSJNI");
    }
}

