/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontSample
extends JPanel {
    protected JLabel displayText;

    public FontSample(int n) {
        this.createComponents(n);
        this.buildLayout();
    }

    public FontSample(Font font, int n) {
        this(n);
        this.refreshSampleText(font);
    }

    protected void buildLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.displayText, "First");
    }

    protected void createComponents(int n) {
        this.displayText = new JLabel("Sample Text", n);
    }

    public void refreshSampleText(String string, Font font) {
        this.displayText.setText(string);
        this.displayText.setFont(font);
    }

    public void refreshSampleText(Font font) {
        this.refreshSampleText(FontSample.getSelectedFontDescription(font), font);
    }

    public static String getSelectedFontDescription(Font font) {
        String string = font.isBold() ? (font.isItalic() ? " Bold Italic" : " Bold") : (font.isItalic() ? " Italic" : "");
        return font.getFamily() + " " + font.getSize() + string;
    }
}

