/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sf.clipsrules.jni.FactInstance;
import net.sf.clipsrules.jni.Module;
import net.sf.clipsrules.jni.examples.ide.CLIPSIDE;
import net.sf.clipsrules.jni.examples.ide.ConstructInspectorFrame;
import net.sf.clipsrules.jni.examples.ide.EntityBrowserFrame;

public class InstanceBrowserManager
implements ActionListener {
    private List<EntityBrowserFrame> browsers = new ArrayList<EntityBrowserFrame>();
    private List<Module> modules;
    private List<FactInstance> entities;
    private HashMap<Long, BitSet> scopes;
    private CLIPSIDE ide;
    public static final String ENTITY_NAME = "Instance";
    private static int entityCount = 1;

    InstanceBrowserManager(CLIPSIDE cLIPSIDE) {
        this.ide = cLIPSIDE;
        this.modules = new ArrayList<Module>();
        this.entities = new ArrayList<FactInstance>();
        this.scopes = new HashMap();
    }

    public void createBrowser(Font font) {
        EntityBrowserFrame entityBrowserFrame = new EntityBrowserFrame(ENTITY_NAME, "Name", "Class", entityCount++, font);
        entityBrowserFrame.addInternalFrameListener(this.ide);
        entityBrowserFrame.setActionTarget(this);
        this.browsers.add(entityBrowserFrame);
        this.ide.getPlacer().placeInternalFrame(entityBrowserFrame);
        this.ide.getDesktopPane().add(entityBrowserFrame);
        entityBrowserFrame.setVisible(true);
        if (!this.ide.getDialogWindow().isExecuting()) {
            if (this.browsers.size() == 1) {
                this.fetchData();
            }
            this.assignEntities(entityBrowserFrame);
        }
    }

    public void removeBrowser(EntityBrowserFrame entityBrowserFrame) {
        this.browsers.remove(entityBrowserFrame);
    }

    private synchronized void fetchData() {
        this.modules = this.ide.getEnvironment().getModuleList();
        this.entities = this.ide.getEnvironment().getInstanceList();
        this.scopes = this.ide.getEnvironment().getInstanceScopes();
    }

    private synchronized void assignEntities(EntityBrowserFrame entityBrowserFrame) {
        entityBrowserFrame.assignData(this.modules, this.entities, this.scopes);
    }

    private void updateBrowser(final EntityBrowserFrame entityBrowserFrame) {
        if (EventQueue.isDispatchThread()) {
            this.assignEntities(entityBrowserFrame);
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    InstanceBrowserManager.this.assignEntities(entityBrowserFrame);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateAllBrowsers() {
        if (this.browsers.size() == 0) {
            return;
        }
        this.fetchData();
        for (EntityBrowserFrame entityBrowserFrame : this.browsers) {
            this.updateBrowser(entityBrowserFrame);
        }
    }

    public void assignFontAllBrowsers(Font font) {
        if (this.browsers.size() == 0) {
            return;
        }
        for (EntityBrowserFrame entityBrowserFrame : this.browsers) {
            entityBrowserFrame.assignFont(font);
        }
    }

    public String browserSelectionText(EntityBrowserFrame entityBrowserFrame) {
        long l = entityBrowserFrame.selectedEntityConstruct();
        if (l == -1L) {
            return "";
        }
        return this.ide.getEnvironment().getDefclassText(l);
    }

    public void browserSelection(ActionEvent actionEvent) {
        ConstructInspectorFrame constructInspectorFrame = this.ide.getConstructInspector();
        if (constructInspectorFrame == null) {
            return;
        }
        EntityBrowserFrame entityBrowserFrame = (EntityBrowserFrame)actionEvent.getSource();
        constructInspectorFrame.setText(this.browserSelectionText(entityBrowserFrame));
    }

    public void onActionPerformed(ActionEvent actionEvent) throws Exception {
        if (actionEvent.getActionCommand().equals("BrowserSelectionAction")) {
            this.browserSelection(actionEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.onActionPerformed(actionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

