/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.event.EventListenerList;
import net.sf.clipsrules.jni.CommandExecutionEvent;
import net.sf.clipsrules.jni.CommandExecutionListener;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.PeriodicCallback;
import net.sf.clipsrules.jni.RouterTextArea;

public class CommandPromptTextArea
extends RouterTextArea
implements PeriodicCallback {
    static final int periodicTaskFrequency = 200;
    static final int DEFAULT_COMMAND_MAX = 25;
    private boolean isExecuting = false;
    int oldDot = 0;
    int maxCommandCount;
    int currentCommandCount;
    int currentCommand;
    ArrayList<String> commandHistory;
    EventListenerList listenerList = new EventListenerList();
    private static int CommandPromptTextAreaIndex = 0;
    private String periodicName;
    private String executingCommand = "";
    private boolean paused = false;
    private ReentrantReadWriteLock pauseLock = new ReentrantReadWriteLock();

    public CommandPromptTextArea(Environment environment) {
        this(environment, new Font("monospaced", 0, 12));
    }

    public CommandPromptTextArea(Environment environment, Font font) {
        super(environment, font);
        this.setPlainBorder();
        environment.printBanner();
        environment.printPrompt();
        environment.setInputBufferCount(0L);
        this.getCaret().setVisible(true);
        this.maxCommandCount = 25;
        this.currentCommandCount = 1;
        this.currentCommand = 0;
        this.commandHistory = new ArrayList(25);
        this.commandHistory.add(new String(""));
        this.periodicName = "CPTAP" + CommandPromptTextAreaIndex++;
    }

    public void setPaused(boolean bl) {
        if (this.paused == bl) {
            return;
        }
        this.paused = bl;
        if (this.paused) {
            this.pauseLock.writeLock().lock();
        } else {
            this.pauseLock.writeLock().unlock();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void addCommandExecutionListener(CommandExecutionListener commandExecutionListener) {
        this.listenerList.add(CommandExecutionListener.class, commandExecutionListener);
    }

    public void removeCommandExecutionListener(CommandExecutionListener commandExecutionListener) {
        this.listenerList.remove(CommandExecutionListener.class, commandExecutionListener);
    }

    public void callExecutionCommandListeners(String string, String string2) {
        Object[] objectArray = this.listenerList.getListenerList();
        CommandExecutionEvent commandExecutionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CommandExecutionListener.class) continue;
            if (commandExecutionEvent == null) {
                commandExecutionEvent = new CommandExecutionEvent(this, string, string2);
            }
            ((CommandExecutionListener)objectArray[i + 1]).commandExecutionEventOccurred(commandExecutionEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.getExecuting()) {
            super.keyPressed(keyEvent);
            return;
        }
        if ((keyEvent.getModifiersEx() & 0x380) != 0) {
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 38 || n == 224) {
            if (this.currentCommand + 1 < this.commandHistory.size()) {
                if ((keyEvent.getModifiersEx() & 0x40) != 0) {
                    this.switchCommand(this.currentCommand, this.commandHistory.size() - 1);
                } else {
                    this.switchCommand(this.currentCommand, this.currentCommand + 1);
                }
            }
            keyEvent.consume();
        } else if (n == 40 || n == 225) {
            if (this.currentCommand != 0) {
                if ((keyEvent.getModifiersEx() & 0x40) != 0) {
                    this.switchCommand(this.currentCommand, 0);
                } else {
                    this.switchCommand(this.currentCommand, this.currentCommand - 1);
                }
            }
            keyEvent.consume();
        } else if (n == 27) {
            if ((keyEvent.getModifiersEx() & 0x40) == 0) {
                this.getCaret().setDot(this.getText().length());
            } else {
                this.getCaret().setDot(this.getText().length() - this.clips.getInputBuffer().length());
            }
            keyEvent.consume();
        } else {
            super.keyPressed(keyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.getExecuting()) {
            super.keyTyped(keyEvent);
            return;
        }
        if ((keyEvent.getModifiersEx() & 0x380) != 0) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c == '\b') {
            this.modifyCommand("", true, false);
        } else if (c == '\u007f') {
            this.modifyCommand("", false, true);
        } else if (c != '\u001b') {
            this.modifyCommand(String.valueOf(c), false, false);
            this.commandCheck();
        }
        keyEvent.consume();
    }

    @Override
    public synchronized boolean hasCuttableSelection() {
        int n;
        if (this.getExecuting()) {
            return super.hasCuttableSelection();
        }
        int n2 = this.getText().length();
        int n3 = this.clips.getInputBuffer().length();
        int n4 = n2 - n3;
        int n5 = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
        if (n5 == (n = Math.max(this.getCaret().getDot(), this.getCaret().getMark()))) {
            return false;
        }
        return n5 >= n4;
    }

    @Override
    public synchronized boolean hasPasteableSelection() {
        if (this.getExecuting()) {
            return super.hasPasteableSelection();
        }
        int n = this.getText().length();
        int n2 = this.clips.getInputBuffer().length();
        int n3 = n - n2;
        int n4 = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
        return n4 >= n3;
    }

    protected void modifyCommand(String string, boolean bl, boolean bl2) {
        int n = this.getText().length();
        int n2 = this.clips.getInputBuffer().length();
        int n3 = n - n2;
        boolean bl3 = true;
        int n4 = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
        int n5 = Math.max(this.getCaret().getDot(), this.getCaret().getMark());
        if (bl && n4 == n5 && n4 > n3) {
            --n4;
        } else if (bl2 && n4 == n5 && n4 > n3 && n5 < n) {
            bl3 = false;
            ++n5;
        }
        if (n4 < n3) {
            this.getCaret().setDot(n);
            return;
        }
        String string2 = this.getText().substring(n3, n4) + string + this.getText().substring(n5);
        this.replaceRange(string, n4, n5);
        this.clips.setInputBuffer(string2);
    }

    public void balanceParentheses() {
        long l = this.clips.getInputBuffer().length();
        if (l <= 0L) {
            return;
        }
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        int n3 = this.getCaretPosition();
        if (n3 == 0) {
            return;
        }
        char c = this.getText().charAt(--n3);
        if (c != ')') {
            return;
        }
        int n4 = 0;
        while (n3-- != 0 && l-- != 0L) {
            c = this.getText().charAt(n3);
            if (c == '(') {
                if (n4 == 0) {
                    this.getCaret().setVisible(false);
                    this.setSelectionStart(n3);
                    this.setSelectionEnd(n3 + 1);
                    this.update(this.getGraphics());
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.setSelectionStart(n);
                    this.setSelectionEnd(n2);
                    this.getCaret().setVisible(true);
                    return;
                }
                --n4;
                continue;
            }
            if (c != ')') continue;
            ++n4;
        }
    }

    public void expandInputBuffer(char c) {
        String string = String.valueOf(c);
        try {
            byte[] byArray = string.getBytes("UTF-8");
            for (int i = 0; i < byArray.length; ++i) {
                this.clips.expandInputBuffer(Byte.valueOf(byArray[i]).intValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void commandCheck() {
        if (this.clips.inputBufferContainsCommand()) {
            this.updateCommandHistory();
            this.executeCommand();
        }
    }

    public synchronized boolean getExecuting() {
        return this.isExecuting;
    }

    public synchronized void setExecuting(boolean bl) {
        this.isExecuting = bl;
    }

    private void doExecuteCommand(String string) {
        Timer timer = new Timer();
        this.clips.appendDribble(string);
        this.callExecutionCommandListeners(string, "start");
        this.clips.addPeriodicCallback(this.periodicName, 0, this);
        timer.schedule((TimerTask)new PeriodicTask(), 0L, 200L);
        this.clips.commandLoopOnceThenBatch();
        this.dumpOutput();
        this.setExecuting(false);
        timer.cancel();
        this.clips.removePeriodicCallback(this.periodicName);
        this.callExecutionCommandListeners(string, "finish");
    }

    private void executeCommand() {
        this.executingCommand = this.clips.getInputBuffer();
        this.setExecuting(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CommandPromptTextArea.this.doExecuteCommand(CommandPromptTextArea.this.executingCommand);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void doExecuteBatch() {
        Timer timer = new Timer();
        this.callExecutionCommandListeners("batch", "start");
        this.clips.addPeriodicCallback(this.periodicName, 0, this);
        timer.schedule((TimerTask)new PeriodicTask(), 0L, 200L);
        this.clips.commandLoopBatchDriver();
        this.dumpOutput();
        this.setExecuting(false);
        timer.cancel();
        this.clips.removePeriodicCallback(this.periodicName);
        this.callExecutionCommandListeners("batch", "finish");
    }

    public void executeBatch() {
        this.setExecuting(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CommandPromptTextArea.this.doExecuteBatch();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void updateCommandHistory() {
        String string = this.clips.getInputBuffer();
        int n = string.length();
        int n2 = n;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\n') continue;
            n2 = i;
        }
        this.commandHistory.set(0, string.substring(0, n2));
        if (this.commandHistory.size() > 1 && this.commandHistory.get(0).equals(this.commandHistory.get(1))) {
            this.commandHistory.set(0, new String(""));
            this.currentCommand = 0;
            return;
        }
        this.commandHistory.add(0, new String(""));
        this.currentCommand = 0;
        ++this.currentCommandCount;
        while (this.commandHistory.size() > this.maxCommandCount) {
            this.commandHistory.remove(this.maxCommandCount);
            --this.currentCommandCount;
        }
    }

    private void switchCommand(int n, int n2) {
        String string = this.clips.getInputBuffer();
        int n3 = string.length();
        this.replaceRange("", this.getText().length() - n3, this.getText().length());
        this.commandHistory.set(n, string);
        this.clips.setInputBuffer(this.commandHistory.get(n2));
        this.append(this.commandHistory.get(n2));
        this.currentCommand = n2;
    }

    public void replaceCommand(String string) {
        String string2 = this.clips.getInputBuffer();
        int n = string2.length();
        this.replaceRange("", this.getText().length() - n, this.getText().length());
        this.clips.setInputBuffer(string);
        this.append(string);
        this.commandCheck();
    }

    @Override
    public void cut() {
        if (this.getExecuting()) {
            super.cut();
            return;
        }
        if (!this.hasCuttableSelection()) {
            return;
        }
        this.copy();
        this.modifyCommand("", true, false);
    }

    @Override
    public void paste() {
        if (this.getExecuting()) {
            super.paste();
            return;
        }
        if (!this.hasPasteableSelection()) {
            return;
        }
        try {
            String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            this.modifyCommand(string, false, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void caretUpdateAction(int n, int n2) {
        if (this.getExecuting()) {
            super.caretUpdateAction(n, n2);
            return;
        }
        if (n == n2) {
            int n3;
            int n4 = this.getText().length();
            if (n < n4 - (n3 = this.clips.getInputBuffer().length())) {
                if (this.oldDot < n4 - n3) {
                    this.getCaret().setDot(n4);
                } else {
                    this.getCaret().setDot(this.oldDot);
                }
            }
            this.getCaret().setVisible(true);
        } else {
            this.getCaret().setVisible(false);
        }
        this.oldDot = this.getCaret().getMark();
        this.balanceParentheses();
    }

    @Override
    protected int dragTargetCaretStart() {
        if (this.getExecuting()) {
            return super.dragTargetCaretStart();
        }
        return this.getText().length() - this.clips.getInputBuffer().length();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.getExecuting()) {
            super.drop(dropTargetDropEvent);
            return;
        }
        if ((dropTargetDropEvent.getDropAction() & 3) == 0) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                String string = (String)transferable.getTransferData(dataFlavorArray[i]);
                this.modifyCommand(string, false, false);
                this.requestFocus();
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void periodicCallback() {
        this.pauseLock.readLock().lock();
        this.pauseLock.readLock().unlock();
        this.callExecutionCommandListeners(this.executingCommand, "periodic");
        this.clips.setPeriodicCallbackEnabled(false);
    }

    private class PeriodicTask
    extends TimerTask {
        private PeriodicTask() {
        }

        @Override
        public void run() {
            CommandPromptTextArea.this.clips.setPeriodicCallbackEnabled(true);
        }
    }
}

