#ifndef CARTOBJECT_H
#define CARTOBJECT_H

#include <string>
#include <set>

#include <ode/ode.h>
#include <plib/ssg.h>

#include "worldobject.h"


class CartObject : public WorldObject
{
  public:
    CartObject(ssgEntity *bodymodel, ssgEntity *wheelmodel, ssgEntity *licplatemodel, dWorldID world, dSpaceID bigspace, sgVec3 initialpos);
    virtual ~CartObject();
    void Simulate(float dt);
    void Sustain(float dt);
    ssgTransform *GetTransform(void) { return chassis_trf; }
    void GetPos(sgVec3 dst) const { sgMat4 m; chassis_trf->getTransform(m); sgCopyVec3(dst, m[3]); }
    dBodyID GetBody(void) const { return chassis_body; }
    void SetDesiredWheelSpeed(float s)  { desired_wheel_speed = s; }
    void SetDesiredLinearSpeed(float s);
    void SetDensity(float d);
    void SetReactionTime(float t) { reaction_time = t; }
  protected:
    ssgTransform *chassis_trf;
    ssgTransform *sink_trf; // for lowering center of mass
    ssgTransform *wheel_trfs[4];
    dSpaceID space;
    dBodyID  chassis_body;
    dBodyID  wheel_bodies[4];
    dGeomID  chassis_geom;
    dGeomID  backrest_geom;
    dGeomID  wheel_geoms[4];
    dJointID joint[4]; // joint[0..1] are the front wheels
    float    desired_wheel_speed;
    float    reaction_time;
    std::string state;
};

#endif
