/*
 * Decompiled with CFR 0.152.
 */
package jrm.compressors.zipfs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class ZipCoder {
    private static final ZipCoder utf8 = new UTF8();
    private Charset cs;
    private final ThreadLocal<CharsetDecoder> decTL = new ThreadLocal();
    private final ThreadLocal<CharsetEncoder> encTL = new ThreadLocal();

    public static ZipCoder get(String csn) {
        Charset cs = Charset.forName(csn);
        if (cs.name().equals("UTF-8")) {
            return utf8;
        }
        return new ZipCoder(cs);
    }

    String toString(byte[] ba) {
        CharBuffer cb;
        CharsetDecoder cd = this.decoder().reset();
        int clen = (int)((float)ba.length * cd.maxCharsPerByte());
        char[] ca = new char[clen];
        if (clen == 0) {
            return new String(ca);
        }
        ByteBuffer bb = ByteBuffer.wrap(ba, 0, ba.length);
        CoderResult cr = cd.decode(bb, cb = CharBuffer.wrap(ca), true);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        cr = cd.flush(cb);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        return new String(ca, 0, cb.position());
    }

    byte[] getBytes(String s) {
        CharsetEncoder ce = this.encoder().reset();
        char[] ca = s.toCharArray();
        int len = (int)((float)ca.length * ce.maxBytesPerChar());
        byte[] ba = new byte[len];
        if (len == 0) {
            return ba;
        }
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(ca);
        CoderResult cr = ce.encode(cb, bb, true);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        cr = ce.flush(bb);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        if (bb.position() == ba.length) {
            return ba;
        }
        return Arrays.copyOf(ba, bb.position());
    }

    boolean isUTF8() {
        return this.cs == StandardCharsets.UTF_8;
    }

    private ZipCoder(Charset cs) {
        this.cs = cs;
    }

    private CharsetDecoder decoder() {
        CharsetDecoder dec = this.decTL.get();
        if (dec == null) {
            dec = this.cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.decTL.set(dec);
        }
        return dec;
    }

    private CharsetEncoder encoder() {
        CharsetEncoder enc = this.encTL.get();
        if (enc == null) {
            enc = this.cs.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.encTL.set(enc);
        }
        return enc;
    }

    static class UTF8
    extends ZipCoder {
        UTF8() {
            super(StandardCharsets.UTF_8);
        }

        @Override
        byte[] getBytes(String s) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= '\u007f') continue;
                return super.getBytes(s);
            }
            return s.getBytes(StandardCharsets.ISO_8859_1);
        }

        @Override
        String toString(byte[] ba) {
            for (byte b : ba) {
                if (b >= 0) continue;
                return super.toString(ba);
            }
            return new String(ba, StandardCharsets.ISO_8859_1);
        }
    }
}

