/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public interface EnhTableModel
extends TableModel {
    public TableCellRenderer[] getCellRenderers();

    default public TableCellRenderer getColumnRenderer(int columnIndex) {
        return this.getCellRenderers()[columnIndex];
    }

    public int getColumnWidth(int var1);

    default public void applyColumnsWidths(JTable table) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            int width = this.getColumnWidth(i);
            TableColumn column = table.getColumnModel().getColumn(i);
            if (width > 0) {
                column.setMinWidth(width / 2);
                column.setPreferredWidth(width);
                continue;
            }
            if (width < -20) {
                column.setMinWidth(-width);
                column.setMaxWidth(-width);
                continue;
            }
            if (width >= 0) continue;
            Component component = column.getCellRenderer().getTableCellRendererComponent(table, null, false, false, 0, i);
            int pixwidth = component.getFontMetrics(component.getFont()).stringWidth(String.format("%0" + -width + "d", 0));
            column.setMinWidth(pixwidth / 2);
            column.setPreferredWidth(pixwidth);
            column.setMaxWidth(pixwidth);
        }
    }
}

