/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.batch;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jrm.locale.Messages;
import jrm.ui.basic.SDRTableModel;

public class BatchTableModel
extends SDRTableModel {
    private final String[] headers;
    private final Class<?>[] types = new Class[]{File.class, File.class, String.class, Boolean.class};
    private final int[] widths = new int[]{0, 0, 0, -22};
    private final TableCellRenderer[] cellRenderers = new TableCellRenderer[]{new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row == BatchTableModel.this.getCurrentRow() && column == BatchTableModel.this.getCurrentCol()) {
                this.setBackground(Color.decode("#DDFFDD"));
            } else {
                this.setBackground(Color.white);
            }
            if (value instanceof File) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(BatchTableModel.trimmedStringCalculator(((File)value).getPath(), table, this, table.getColumnModel().getColumn(column).getWidth() - 10));
                return this;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row == BatchTableModel.this.getCurrentRow() && column == BatchTableModel.this.getCurrentCol()) {
                this.setBackground(Color.decode("#DDFFDD"));
            } else {
                this.setBackground(Color.white);
            }
            if (value instanceof File) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(BatchTableModel.trimmedStringCalculator(((File)value).getPath(), table, this, table.getColumnModel().getColumn(column).getWidth() - 10));
                return this;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(Color.white);
            this.setHorizontalAlignment(11);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, null};

    public BatchTableModel() {
        this.headers = new String[]{Messages.getString("BatchTableModel.SrcDats"), Messages.getString("BatchTableModel.DstDirs"), Messages.getString("BatchTableModel.Result"), "Selected"};
    }

    public BatchTableModel(String[] headers) {
        this.headers = headers;
    }

    private static String trimmedStringCalculator(String inputText, JTable table, JLabel component, int width) {
        String ellipses = "...";
        String textToBeDisplayed = "";
        FontMetrics fm = table.getFontMetrics(component.getFont());
        for (int i = inputText.length() - 1; i >= 0; --i) {
            if (fm.stringWidth(ellipses + textToBeDisplayed) > width) continue;
            textToBeDisplayed = inputText.charAt(i) + textToBeDisplayed;
        }
        if (!textToBeDisplayed.equals(inputText)) {
            return ellipses.concat(textToBeDisplayed);
        }
        return inputText;
    }

    @Override
    public int getRowCount() {
        return this.getData().size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.headers[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.types[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getData().get((int)rowIndex).src;
            }
            case 1: {
                return this.getData().get((int)rowIndex).dst;
            }
            case 2: {
                return this.getData().get((int)rowIndex).result;
            }
            case 3: {
                return this.getData().get((int)rowIndex).selected;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.getData().get((int)rowIndex).src = (File)aValue;
                break;
            }
            case 1: {
                this.getData().get((int)rowIndex).dst = (File)aValue;
                break;
            }
            case 2: {
                this.getData().get((int)rowIndex).result = (String)aValue;
                break;
            }
            case 3: {
                this.getData().get((int)rowIndex).selected = (Boolean)aValue;
            }
        }
        this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, columnIndex, 0));
    }

    @Override
    public TableCellRenderer[] getCellRenderers() {
        return this.cellRenderers;
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return this.widths[columnIndex];
    }
}

