/*
 *  include/safealloc.h
 *
 *  makes sure out of memory errors are detected and intercepted.
 *
 */
 
#ifndef __SAFEALLOC_H__
#define __SAFEALLOC_H__

#include <stdlib.h>
#include <string.h>

void *smalloc(size_t size)
{
	void *ptr;
	
	if(!(ptr=malloc(size)))
		fprintf(stderr,"netpipe: out of memory during malloc\n");
	return ptr;
}

void *scmalloc(size_t size)	/* additionally clears the memory allocated */
{
	void *ptr=NULL;
	
	if(!(ptr=malloc(size)))
		fprintf(stderr,"netpipe: out of memory during malloc\n");
	memset(ptr,0,size);
	return ptr;
}

void *srealloc(void *ptr, size_t size)
{
	void *rptr;
	
	if(!(rptr=realloc(ptr,size)))
		fprintf(stderr,"netpipe: out of memory during malloc\n");
	return rptr;
}

#endif
