/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.argo.uml.ui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.i18n.Translator;
import org.argouml.model.Model;
import org.argouml.uml.diagram.ui.UMLDiagram;
import org.argouml.uml.ui.UMLTreeCellRenderer;
import org.dbuml.argo.model.ArgoDBModelFacade;

public class DBUMLTreeCellRenderer
extends UMLTreeCellRenderer {
    private static String name = Translator.localize((String)"label.name");
    private static String typeName = Translator.localize((String)"label.type");

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocusParam) {
        Component r;
        if (value instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)value).getUserObject();
        }
        if ((r = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocusParam)) instanceof JLabel) {
            JLabel lab = (JLabel)r;
            Icon icon = ResourceLoaderWrapper.getInstance().lookupIcon(value);
            if (icon != null) {
                lab.setIcon(icon);
            }
            String type = null;
            if (null != ArgoDBModelFacade.getInstance() && ArgoDBModelFacade.getInstance().representsADbumlElement(value) && (type = ArgoDBModelFacade.getInstance().getDBUMLClassName(value)) != null) {
                ResourceLoaderWrapper.getInstance();
                icon = ResourceLoaderWrapper.lookupIcon((String)type);
                if (icon != null) {
                    lab.setIcon(icon);
                }
            }
            if (type == null) {
                if (Model.getFacade().isAModelElement(value)) {
                    type = Model.getFacade().getUMLClassName(value);
                } else if (value instanceof UMLDiagram) {
                    type = ((UMLDiagram)value).getLabelName();
                }
            }
            if (type != null) {
                StringBuffer buf = new StringBuffer();
                buf.append("<html>");
                buf.append(name);
                buf.append(' ');
                buf.append(lab.getText());
                buf.append("<br>");
                buf.append(typeName);
                buf.append(' ');
                buf.append(type);
                lab.setToolTipText(buf.toString());
            } else {
                lab.setToolTipText(lab.getText());
            }
        }
        return r;
    }
}

