/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.jsp.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.jsp.ast.JspParserVisitorAdapter;
import net.sourceforge.pmd.jsp.ast.SimpleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJspRule
extends JspParserVisitorAdapter
implements Rule {
    private String name = this.getClass().getName();
    private Properties properties = new Properties();
    private String message;
    private String description;
    private List<String> examples = new ArrayList<String>();
    private String ruleSetName;
    private boolean include;
    private boolean usesDFA;
    private int priority = 5;
    private String externalInfoUrl;
    private List<String> ruleChainVisits = new ArrayList<String>();

    @Override
    public String getRuleSetName() {
        return this.ruleSetName;
    }

    @Override
    public void setRuleSetName(String ruleSetName) {
        this.ruleSetName = ruleSetName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<String> getExamples() {
        return this.examples;
    }

    @Override
    public String getExample() {
        if (this.examples.isEmpty()) {
            return null;
        }
        return this.examples.get(this.examples.size() - 1);
    }

    @Override
    public void addExample(String example) {
        this.examples.add(example);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public void addProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    @Override
    public void addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    @Override
    public double getDoubleProperty(String name) {
        return Double.parseDouble(this.properties.getProperty(name));
    }

    @Override
    public int getIntProperty(String name) {
        return Integer.parseInt(this.properties.getProperty(name));
    }

    @Override
    public boolean getBooleanProperty(String name) {
        return Boolean.parseBoolean(this.properties.getProperty(name));
    }

    @Override
    public String getStringProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getExternalInfoUrl() {
        return this.externalInfoUrl;
    }

    @Override
    public void setExternalInfoUrl(String url) {
        this.externalInfoUrl = url;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Rule rule = null;
        boolean equality = this.getClass().getName().equals(o.getClass().getName());
        if (equality) {
            rule = (Rule)o;
            equality = this.getName().equals(rule.getName()) && this.getPriority() == rule.getPriority() && this.getProperties().equals(rule.getProperties());
        }
        return equality;
    }

    public int hashCode() {
        String s = this.getClass().getName() + this.getName() + this.getPriority() + this.getProperties().toString();
        return s.hashCode();
    }

    @Override
    public void apply(List acus, RuleContext ctx) {
        this.visitAll(acus, ctx);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean include() {
        return this.include;
    }

    @Override
    public void setInclude(boolean include) {
        this.include = include;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getPriorityName() {
        return PRIORITIES[this.getPriority() - 1];
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void setUsesDFA() {
        this.usesDFA = true;
    }

    @Override
    public boolean usesDFA() {
        return this.usesDFA;
    }

    @Override
    public void setUsesTypeResolution() {
    }

    @Override
    public boolean usesTypeResolution() {
        return false;
    }

    protected void visitAll(List acus, RuleContext ctx) {
        for (SimpleNode node : acus) {
            this.visit(node, (Object)ctx);
        }
    }

    protected final void addViolation(Object data, SimpleNode node) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node));
    }

    protected final void addViolationWithMessage(Object data, SimpleNode node, String msg) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node, msg));
    }

    protected final void addViolation(Object data, SimpleNode node, String embed) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node, MessageFormat.format(this.getMessage(), embed)));
    }

    protected final void addViolation(Object data, Node node, Object[] args) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, (SimpleNode)node, MessageFormat.format(this.getMessage(), args)));
    }

    @Override
    public PropertyDescriptor propertyDescriptorFor(String name) {
        return null;
    }

    @Override
    public boolean usesRuleChain() {
        return !this.getRuleChainVisits().isEmpty();
    }

    @Override
    public List<String> getRuleChainVisits() {
        return this.ruleChainVisits;
    }

    @Override
    public void addRuleChainVisit(String astNodeName) {
        if (!this.ruleChainVisits.contains(astNodeName)) {
            this.ruleChainVisits.add(astNodeName);
        }
    }
}

