/*========================== begin_copyright_notice ============================

Copyright (C) 2020-2021 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

#include "../imf.h"
#include "../imf_data.h"
#pragma OPENCL FP_CONTRACT OFF

typedef struct
{
    unsigned long _dT[512][4];
    unsigned long _dAbsMask;
    unsigned long _dReductionRangeVal;
    unsigned long _dRangeVal;
    unsigned long _dPIu;
    unsigned long _dRShifter;
    unsigned long _lIndexMask;
    unsigned long _dPIoHi;
    unsigned long _dPIoLo;
    unsigned long _dPIoTail;
    unsigned long _dS1;
    unsigned long _dS2;
    unsigned long _dC1;
    unsigned long _dC2;
    unsigned long _dC3;
} dCosHA_Table_Type_v2;
static __constant dCosHA_Table_Type_v2 __internal_dcos_la_data_ha = {
    {
     {0x0000000000000000uL, 0x0000000000000000uL, 0x3FF0000000000000uL, 0x0000000000000000uL},
     {0x3F6B78B80C84E1EEuL, 0xBF90000000000000uL, 0x3FEFFF62169B92DBuL, 0x3C85DDA3C0000000uL},
     {0x3F7B7AA821726608uL, 0xBFA0000000000000uL, 0x3FEFFD886084CD0DuL, 0xBC81354D40000000uL},
     {0xBF76C32BACA2AE69uL, 0xBFA0000000000000uL, 0x3FEFFA72EFFEF75DuL, 0xBC88B4CDC0000000uL},
     {0x3F8B82683BC89FB0uL, 0xBFB0000000000000uL, 0x3FEFF621E3796D7EuL, 0xBC6C57BC20000000uL},
     {0x3F535230C0FBE402uL, 0xBFB0000000000000uL, 0x3FEFF095658E71ADuL, 0x3C801A8CE0000000uL},
     {0xBF86A9049670CFAEuL, 0xBFB0000000000000uL, 0x3FEFE9CDAD01883AuL, 0x3C6521ECC0000000uL},
     {0xBF97DB402A6A9063uL, 0xBFB0000000000000uL, 0x3FEFE1CAFCBD5B09uL, 0x3C6A23E320000000uL},
     {0x3F9BA1650F592F50uL, 0xBFC0000000000000uL, 0x3FEFD88DA3D12526uL, 0xBC887DF620000000uL},
     {0x3F8E43D1C309E958uL, 0xBFC0000000000000uL, 0x3FEFCE15FD6DA67BuL, 0xBC75DD6F80000000uL},
     {0x3F6536352AD19E39uL, 0xBFC0000000000000uL, 0x3FEFC26470E19FD3uL, 0x3C81EC8660000000uL},
     {0xBF839F0CEDAF576BuL, 0xBFC0000000000000uL, 0x3FEFB5797195D741uL, 0x3C71BFAC60000000uL},
     {0xBF964083747309D1uL, 0xBFC0000000000000uL, 0x3FEFA7557F08A517uL, 0xBC87A0A8C0000000uL},
     {0xBFA155DAC4A4F967uL, 0xBFC0000000000000uL, 0x3FEF97F924C9099BuL, 0xBC8E2AE0E0000000uL},
     {0xBFA78851122CFF19uL, 0xBFC0000000000000uL, 0x3FEF8764FA714BA9uL, 0x3C7AB25660000000uL},
     {0xBFADB7677942FCC5uL, 0xBFC0000000000000uL, 0x3FEF7599A3A12077uL, 0x3C884F31C0000000uL},
     {0x3FAC1D1F0E5967D5uL, 0xBFD0000000000000uL, 0x3FEF6297CFF75CB0uL, 0x3C75621720000000uL},
     {0x3FA5F57F693FEEBEuL, 0xBFD0000000000000uL, 0x3FEF4E603B0B2F2DuL, 0xBC78EE01E0000000uL},
     {0x3F9FA3ECAC0D84E8uL, 0xBFD0000000000000uL, 0x3FEF38F3AC64E589uL, 0xBC7D7BAFA0000000uL},
     {0x3F936580D5D5E775uL, 0xBFD0000000000000uL, 0x3FEF2252F7763ADAuL, 0xBC820CB800000000uL},
     {0x3F7CC0D09BD41CAAuL, 0xBFD0000000000000uL, 0x3FEF0A7EFB9230D7uL, 0x3C752C7AC0000000uL},
     {0xBF73EE038DFF6B80uL, 0xBFD0000000000000uL, 0x3FEEF178A3E473C2uL, 0x3C86310A60000000uL},
     {0xBF911D262B1F6776uL, 0xBFD0000000000000uL, 0x3FEED740E7684963uL, 0x3C7E82C780000000uL},
     {0xBF9D3443F4CDB3DDuL, 0xBFD0000000000000uL, 0x3FEEBBD8C8DF0B74uL, 0x3C7C6C8C60000000uL},
     {0xBFA4A03176ACF82DuL, 0xBFD0000000000000uL, 0x3FEE9F4156C62DDAuL, 0x3C8760B1E0000000uL},
     {0xBFAAA086170C0A8EuL, 0xBFD0000000000000uL, 0x3FEE817BAB4CD10DuL, 0xBC7D0AFE60000000uL},
     {0xBFB04D72505D9805uL, 0xBFD0000000000000uL, 0x3FEE6288EC48E112uL, 0xBC616B56E0000000uL},
     {0xBFB3478909E39DA9uL, 0xBFD0000000000000uL, 0x3FEE426A4B2BC17EuL, 0x3C8A873880000000uL},
     {0xBFB63E69D6AC7F74uL, 0xBFD0000000000000uL, 0x3FEE212104F686E5uL, 0xBC8014C760000000uL},
     {0xBFB931F774FC9F18uL, 0xBFD0000000000000uL, 0x3FEDFEAE622DBE2BuL, 0xBC8514EA80000000uL},
     {0xBFBC2214C3E9167BuL, 0xBFD0000000000000uL, 0x3FEDDB13B6CCC23CuL, 0x3C883C37C0000000uL},
     {0xBFBF0EA4C477339CuL, 0xBFD0000000000000uL, 0x3FEDB6526238A09BuL, 0xBC7ADEE7E0000000uL},
     {0x3FBE087565455A75uL, 0xBFE0000000000000uL, 0x3FED906BCF328D46uL, 0x3C7457E600000000uL},
     {0x3FBB2356710DB0A3uL, 0xBFE0000000000000uL, 0x3FED696173C9E68BuL, 0xBC7E8C61C0000000uL},
     {0x3FB8421AF15C49D7uL, 0xBFE0000000000000uL, 0x3FED4134D14DC93AuL, 0xBC84EF5280000000uL},
     {0x3FB564DF524B00DAuL, 0xBFE0000000000000uL, 0x3FED17E7743E35DCuL, 0xBC5101DA20000000uL},
     {0x3FB28BBFD87A8CFFuL, 0xBFE0000000000000uL, 0x3FECED7AF43CC773uL, 0xBC5E7B6BA0000000uL},
     {0x3FAF6DB13FF708CBuL, 0xBFE0000000000000uL, 0x3FECC1F0F3FCFC5CuL, 0x3C7E576120000000uL},
     {0x3FA9CC8B3671DD0FuL, 0xBFE0000000000000uL, 0x3FEC954B213411F5uL, 0xBC52FB7600000000uL},
     {0x3FA4344523C8E3B5uL, 0xBFE0000000000000uL, 0x3FEC678B3488739BuL, 0x3C6D86CAC0000000uL},
     {0x3F9D4A2C7F909C4EuL, 0xBFE0000000000000uL, 0x3FEC38B2F180BDB1uL, 0xBC76E0B160000000uL},
     {0x3F923E6AD10872A7uL, 0xBFE0000000000000uL, 0x3FEC08C426725549uL, 0x3C5B157FC0000000uL},
     {0x3F7D16C901D95181uL, 0xBFE0000000000000uL, 0x3FEBD7C0AC6F952AuL, 0xBC8825A720000000uL},
     {0xBF6CFC874C3EB6D9uL, 0xBFE0000000000000uL, 0x3FEBA5AA673590D2uL, 0x3C87EA4E20000000uL},
     {0xBF8CE1E648BFFB66uL, 0xBFE0000000000000uL, 0x3FEB728345196E3EuL, 0xBC8BC69F20000000uL},
     {0xBF992E09ABB131D4uL, 0xBFE0000000000000uL, 0x3FEB3E4D3EF55712uL, 0xBC8EB6B8A0000000uL},
     {0xBFA1EB3541B4B228uL, 0xBFE0000000000000uL, 0x3FEB090A58150200uL, 0xBC8926DA20000000uL},
     {0xBFA734D63DEDB48AuL, 0xBFE0000000000000uL, 0x3FEAD2BC9E21D511uL, 0xBC847FBE00000000uL},
     {0xBFAC73B39AE68C87uL, 0xBFE0000000000000uL, 0x3FEA9B66290EA1A3uL, 0x3C39F630E0000000uL},
     {0xBFB0D3CCC99F5AC6uL, 0xBFE0000000000000uL, 0x3FEA63091B02FAE2uL, 0xBC7E911140000000uL},
     {0xBFB3682A66E896F5uL, 0xBFE0000000000000uL, 0x3FEA29A7A0462782uL, 0xBC7128BB00000000uL},
     {0xBFB5F6D92FD79F50uL, 0xBFE0000000000000uL, 0x3FE9EF43EF29AF94uL, 0x3C7B1DFCA0000000uL},
     {0xBFB87FBFE70B81A7uL, 0xBFE0000000000000uL, 0x3FE9B3E047F38741uL, 0xBC830EE280000000uL},
     {0xBFBB02C58832CF96uL, 0xBFE0000000000000uL, 0x3FE9777EF4C7D742uL, 0xBC815479A0000000uL},
     {0xBFBD7FD1490285CAuL, 0xBFE0000000000000uL, 0x3FE93A22499263FBuL, 0x3C83D419A0000000uL},
     {0xBFBFF6CA9A2AB6A2uL, 0xBFE0000000000000uL, 0x3FE8FBCCA3EF940DuL, 0xBC66DFA980000000uL},
     {0xBFC133CC94247758uL, 0xBFE0000000000000uL, 0x3FE8BC806B151741uL, 0xBC82C5E120000000uL},
     {0xBFC269126E6C24E3uL, 0xBFE0000000000000uL, 0x3FE87C400FBA2EBFuL, 0xBC82DABC00000000uL},
     {0xBFC39B2AEF8F97A4uL, 0xBFE0000000000000uL, 0x3FE83B0E0BFF976EuL, 0xBC76F420E0000000uL},
     {0xBFC4CA0A4A8D5657uL, 0xBFE0000000000000uL, 0x3FE7F8ECE3571771uL, 0xBC89C8D8C0000000uL},
     {0xBFC5F5A4D233B27FuL, 0xBFE0000000000000uL, 0x3FE7B5DF226AAFAFuL, 0xBC70F537A0000000uL},
     {0xBFC71DEEF9940631uL, 0xBFE0000000000000uL, 0x3FE771E75F037261uL, 0x3C75CFCE80000000uL},
     {0xBFC842DD5474B37BuL, 0xBFE0000000000000uL, 0x3FE72D0837EFFF96uL, 0x3C80D4EF00000000uL},
     {0xBFC9646497C1E0F6uL, 0xBFE0000000000000uL, 0x3FE6E74454EAA8AFuL, 0xBC8DBC03C0000000uL},
     {0xBFCA827999FCEF32uL, 0xBFE0000000000000uL, 0x3FE6A09E667F3BCDuL, 0xBC8BDD3400000000uL},
     {0xBFCB9D1153AAA2BAuL, 0xBFE0000000000000uL, 0x3FE6591925F0783DuL, 0x3C8C3D64E0000000uL},
     {0xBFCCB420DFBFFE59uL, 0xBFE0000000000000uL, 0x3FE610B7551D2CDFuL, 0xBC7251B340000000uL},
     {0xBFCDC79D7C0DC985uL, 0xBFE0000000000000uL, 0x3FE5C77BBE65018CuL, 0x3C8069EA80000000uL},
     {0xBFCED77C89AABEBBuL, 0xBFE0000000000000uL, 0x3FE57D69348CECA0uL, 0xBC87572080000000uL},
     {0xBFCFE3B38D5C5DC2uL, 0xBFE0000000000000uL, 0x3FE5328292A35596uL, 0xBC7A12EB80000000uL},
     {0x3FCF13C7D001A249uL, 0xBFF0000000000000uL, 0x3FE4E6CABBE3E5E9uL, 0x3C63C293E0000000uL},
     {0x3FCE0EFFC1174505uL, 0xBFF0000000000000uL, 0x3FE49A449B9B0939uL, 0xBC827EE160000000uL},
     {0x3FCD0DFE53ABA2FDuL, 0xBFF0000000000000uL, 0x3FE44CF325091DD6uL, 0x3C68076A20000000uL},
     {0x3FCC10CD7041AFCCuL, 0xBFF0000000000000uL, 0x3FE3FED9534556D4uL, 0x3C83691660000000uL},
     {0x3FCB1776D9B67013uL, 0xBFF0000000000000uL, 0x3FE3AFFA292050B9uL, 0x3C7E3E25E0000000uL},
     {0x3FCA22042CE0A2F9uL, 0xBFF0000000000000uL, 0x3FE36058B10659F3uL, 0xBC81FCB3A0000000uL},
     {0x3FC9307EE031E2FDuL, 0xBFF0000000000000uL, 0x3FE30FF7FCE17035uL, 0xBC6EFCC620000000uL},
     {0x3FC842F0435941AFuL, 0xBFF0000000000000uL, 0x3FE2BEDB25FAF3EAuL, 0xBC514981C0000000uL},
     {0x3FC759617EE761F9uL, 0xBFF0000000000000uL, 0x3FE26D054CDD12DFuL, 0xBC85DA7420000000uL},
     {0x3FC673DB93F41479uL, 0xBFF0000000000000uL, 0x3FE21A799933EB59uL, 0xBC83A7B160000000uL},
     {0x3FC592675BC57974uL, 0xBFF0000000000000uL, 0x3FE1C73B39AE68C8uL, 0x3C8B25DD20000000uL},
     {0x3FC4B50D8778ABBDuL, 0xBFF0000000000000uL, 0x3FE1734D63DEDB49uL, 0xBC87EEF2C0000000uL},
     {0x3FC3DBD69FABF802uL, 0xBFF0000000000000uL, 0x3FE11EB3541B4B23uL, 0xBC8EF23B60000000uL},
     {0x3FC306CB042AA3BAuL, 0xBFF0000000000000uL, 0x3FE0C9704D5D898FuL, 0xBC88D3D7C0000000uL},
     {0x3FC235F2EB9A470AuL, 0xBFF0000000000000uL, 0x3FE073879922FFEEuL, 0xBC8A5A0140000000uL},
     {0x3FC169566329BCB7uL, 0xBFF0000000000000uL, 0x3FE01CFC874C3EB7uL, 0xBC734A35E0000000uL},
     {0x3FC0A0FD4E41AB5AuL, 0xBFF0000000000000uL, 0x3FDF8BA4DBF89ABAuL, 0xBC32EC1FC0000000uL},
     {0x3FBFB9DECC6D55B8uL, 0xBFF0000000000000uL, 0x3FDEDC1952EF78D6uL, 0xBC7DD0F7C0000000uL},
     {0x3FBE3A6873FA1279uL, 0xBFF0000000000000uL, 0x3FDE2B5D3806F63BuL, 0x3C5E0D8900000000uL},
     {0x3FBCC3A65BBC6327uL, 0xBFF0000000000000uL, 0x3FDD79775B86E389uL, 0x3C7550EC80000000uL},
     {0x3FBB55A6F65F7058uL, 0xBFF0000000000000uL, 0x3FDCC66E9931C45EuL, 0x3C56850E40000000uL},
     {0x3FB9F07860181D1EuL, 0xBFF0000000000000uL, 0x3FDC1249D8011EE7uL, 0xBC7813AAA0000000uL},
     {0x3FB894285E19C468uL, 0xBFF0000000000000uL, 0x3FDB5D1009E15CC0uL, 0x3C65B362C0000000uL},
     {0x3FB740C45E0E5120uL, 0xBFF0000000000000uL, 0x3FDAA6C82B6D3FCAuL, 0xBC7D5F1060000000uL},
     {0x3FB5F6597591B633uL, 0xBFF0000000000000uL, 0x3FD9EF7943A8ED8AuL, 0x3C66DA8120000000uL},
     {0x3FB4B4F461B0CBAAuL, 0xBFF0000000000000uL, 0x3FD9372A63BC93D7uL, 0x3C66843180000000uL},
     {0x3FB37CA1866B95CFuL, 0xBFF0000000000000uL, 0x3FD87DE2A6AEA963uL, 0xBC672CEDC0000000uL},
     {0x3FB24D6CEE3AFB2AuL, 0xBFF0000000000000uL, 0x3FD7C3A9311DCCE7uL, 0x3C19A3F200000000uL},
     {0x3FB127624999EE1DuL, 0xBFF0000000000000uL, 0x3FD7088530FA459FuL, 0xBC744B19E0000000uL},
     {0x3FB00A8CEE920EABuL, 0xBFF0000000000000uL, 0x3FD64C7DDD3F27C6uL, 0x3C510D2B40000000uL},
     {0x3FADEDEFB09791B4uL, 0xBFF0000000000000uL, 0x3FD58F9A75AB1FDDuL, 0xBC1EFDC0C0000000uL},
     {0x3FABD95B4D43E819uL, 0xBFF0000000000000uL, 0x3FD4D1E24278E76AuL, 0x3C62417200000000uL},
     {0x3FA9D7713B71EEE1uL, 0xBFF0000000000000uL, 0x3FD4135C94176601uL, 0x3C70C97C40000000uL},
     {0x3FA7E8454B32EF34uL, 0xBFF0000000000000uL, 0x3FD35410C2E18152uL, 0xBC73CB0020000000uL},
     {0x3FA60BEA939D225AuL, 0xBFF0000000000000uL, 0x3FD294062ED59F06uL, 0xBC75D28DA0000000uL},
     {0x3FA44273720F48BCuL, 0xBFF0000000000000uL, 0x3FD1D3443F4CDB3EuL, 0xBC6720D400000000uL},
     {0x3FA28BF1897B69CCuL, 0xBFF0000000000000uL, 0x3FD111D262B1F677uL, 0x3C7824C200000000uL},
     {0x3FA0E875C1B8C3DAuL, 0xBFF0000000000000uL, 0x3FD04FB80E37FDAEuL, 0xBC0412CDA0000000uL},
     {0x3F9EB0208DB9E51BuL, 0xBFF0000000000000uL, 0x3FCF19F97B215F1BuL, 0xBC642DEEE0000000uL},
     {0x3F9BB5A11138A4C9uL, 0xBFF0000000000000uL, 0x3FCD934FE5454311uL, 0x3C675B9220000000uL},
     {0x3F98E18A73634EE7uL, 0xBFF0000000000000uL, 0x3FCC0B826A7E4F63uL, 0xBC1AF14380000000uL},
     {0x3F9633F89E9A1A66uL, 0xBFF0000000000000uL, 0x3FCA82A025B00451uL, 0xBC687905E0000000uL},
     {0x3F93AD06011469FBuL, 0xBFF0000000000000uL, 0x3FC8F8B83C69A60BuL, 0xBC626D19A0000000uL},
     {0x3F914CCB8BDBF114uL, 0xBFF0000000000000uL, 0x3FC76DD9DE50BF31uL, 0x3C61D5EEE0000000uL},
     {0x3F8E26C163AD15B3uL, 0xBFF0000000000000uL, 0x3FC5E214448B3FC6uL, 0x3C6531FF60000000uL},
     {0x3F8A01B6CDBD995EuL, 0xBFF0000000000000uL, 0x3FC45576B1293E5AuL, 0xBC5285A240000000uL},
     {0x3F862AA03DD6BA58uL, 0xBFF0000000000000uL, 0x3FC2C8106E8E613AuL, 0x3C513000A0000000uL},
     {0x3F82A1A39A8A2FB7uL, 0xBFF0000000000000uL, 0x3FC139F0CEDAF577uL, 0xBC65234340000000uL},
     {0x3F7ECDC78F30165CuL, 0xBFF0000000000000uL, 0x3FBF564E56A9730EuL, 0x3C4A270460000000uL},
     {0x3F78F501492CC296uL, 0xBFF0000000000000uL, 0x3FBC3785C79EC2D5uL, 0xBC24F39DE0000000uL},
     {0x3F73B92E176D6D31uL, 0xBFF0000000000000uL, 0x3FB917A6BC29B42CuL, 0xBC3E2718C0000000uL},
     {0x3F6E350342A4F6E6uL, 0xBFF0000000000000uL, 0x3FB5F6D00A9AA419uL, 0xBC4F4022C0000000uL},
     {0x3F663252FE77C5EBuL, 0xBFF0000000000000uL, 0x3FB2D52092CE19F6uL, 0xBC49A088A0000000uL},
     {0x3F5ED534E31CA57FuL, 0xBFF0000000000000uL, 0x3FAF656E79F820E0uL, 0xBC22E1EBE0000000uL},
     {0x3F53BC390D250439uL, 0xBFF0000000000000uL, 0x3FA91F65F10DD814uL, 0xBC2912BD00000000uL},
     {0x3F46344004228D8BuL, 0xBFF0000000000000uL, 0x3FA2D865759455CDuL, 0x3C2686F640000000uL},
     {0x3F33BCFBD9979A27uL, 0xBFF0000000000000uL, 0x3F992155F7A3667EuL, 0xBBFB1D6300000000uL},
     {0x3F13BD2C8DA49511uL, 0xBFF0000000000000uL, 0x3F8921D1FCDEC784uL, 0x3C29878EA0000000uL},
     {0x0000000000000000uL, 0xBFF0000000000000uL, 0x0000000000000000uL, 0x0000000000000000uL},
     {0x3F13BD2C8DA49511uL, 0xBFF0000000000000uL, 0xBF8921D1FCDEC784uL, 0xBC29878EA0000000uL},
     {0x3F33BCFBD9979A27uL, 0xBFF0000000000000uL, 0xBF992155F7A3667EuL, 0x3BFB1D6300000000uL},
     {0x3F46344004228D8BuL, 0xBFF0000000000000uL, 0xBFA2D865759455CDuL, 0xBC2686F640000000uL},
     {0x3F53BC390D250439uL, 0xBFF0000000000000uL, 0xBFA91F65F10DD814uL, 0x3C2912BD00000000uL},
     {0x3F5ED534E31CA57FuL, 0xBFF0000000000000uL, 0xBFAF656E79F820E0uL, 0x3C22E1EBE0000000uL},
     {0x3F663252FE77C5EBuL, 0xBFF0000000000000uL, 0xBFB2D52092CE19F6uL, 0x3C49A088A0000000uL},
     {0x3F6E350342A4F6E6uL, 0xBFF0000000000000uL, 0xBFB5F6D00A9AA419uL, 0x3C4F4022C0000000uL},
     {0x3F73B92E176D6D31uL, 0xBFF0000000000000uL, 0xBFB917A6BC29B42CuL, 0x3C3E2718C0000000uL},
     {0x3F78F501492CC296uL, 0xBFF0000000000000uL, 0xBFBC3785C79EC2D5uL, 0x3C24F39DE0000000uL},
     {0x3F7ECDC78F30165CuL, 0xBFF0000000000000uL, 0xBFBF564E56A9730EuL, 0xBC4A270460000000uL},
     {0x3F82A1A39A8A2FB7uL, 0xBFF0000000000000uL, 0xBFC139F0CEDAF577uL, 0x3C65234340000000uL},
     {0x3F862AA03DD6BA58uL, 0xBFF0000000000000uL, 0xBFC2C8106E8E613AuL, 0xBC513000A0000000uL},
     {0x3F8A01B6CDBD995EuL, 0xBFF0000000000000uL, 0xBFC45576B1293E5AuL, 0x3C5285A240000000uL},
     {0x3F8E26C163AD15B3uL, 0xBFF0000000000000uL, 0xBFC5E214448B3FC6uL, 0xBC6531FF60000000uL},
     {0x3F914CCB8BDBF114uL, 0xBFF0000000000000uL, 0xBFC76DD9DE50BF31uL, 0xBC61D5EEE0000000uL},
     {0x3F93AD06011469FBuL, 0xBFF0000000000000uL, 0xBFC8F8B83C69A60BuL, 0x3C626D19A0000000uL},
     {0x3F9633F89E9A1A66uL, 0xBFF0000000000000uL, 0xBFCA82A025B00451uL, 0x3C687905E0000000uL},
     {0x3F98E18A73634EE7uL, 0xBFF0000000000000uL, 0xBFCC0B826A7E4F63uL, 0x3C1AF14380000000uL},
     {0x3F9BB5A11138A4C9uL, 0xBFF0000000000000uL, 0xBFCD934FE5454311uL, 0xBC675B9220000000uL},
     {0x3F9EB0208DB9E51BuL, 0xBFF0000000000000uL, 0xBFCF19F97B215F1BuL, 0x3C642DEEE0000000uL},
     {0x3FA0E875C1B8C3DAuL, 0xBFF0000000000000uL, 0xBFD04FB80E37FDAEuL, 0x3C0412CDA0000000uL},
     {0x3FA28BF1897B69CCuL, 0xBFF0000000000000uL, 0xBFD111D262B1F677uL, 0xBC7824C200000000uL},
     {0x3FA44273720F48BCuL, 0xBFF0000000000000uL, 0xBFD1D3443F4CDB3EuL, 0x3C6720D400000000uL},
     {0x3FA60BEA939D225AuL, 0xBFF0000000000000uL, 0xBFD294062ED59F06uL, 0x3C75D28DA0000000uL},
     {0x3FA7E8454B32EF34uL, 0xBFF0000000000000uL, 0xBFD35410C2E18152uL, 0x3C73CB0020000000uL},
     {0x3FA9D7713B71EEE1uL, 0xBFF0000000000000uL, 0xBFD4135C94176601uL, 0xBC70C97C40000000uL},
     {0x3FABD95B4D43E819uL, 0xBFF0000000000000uL, 0xBFD4D1E24278E76AuL, 0xBC62417200000000uL},
     {0x3FADEDEFB09791B4uL, 0xBFF0000000000000uL, 0xBFD58F9A75AB1FDDuL, 0x3C1EFDC0C0000000uL},
     {0x3FB00A8CEE920EABuL, 0xBFF0000000000000uL, 0xBFD64C7DDD3F27C6uL, 0xBC510D2B40000000uL},
     {0x3FB127624999EE1DuL, 0xBFF0000000000000uL, 0xBFD7088530FA459FuL, 0x3C744B19E0000000uL},
     {0x3FB24D6CEE3AFB2AuL, 0xBFF0000000000000uL, 0xBFD7C3A9311DCCE7uL, 0xBC19A3F200000000uL},
     {0x3FB37CA1866B95CFuL, 0xBFF0000000000000uL, 0xBFD87DE2A6AEA963uL, 0x3C672CEDC0000000uL},
     {0x3FB4B4F461B0CBAAuL, 0xBFF0000000000000uL, 0xBFD9372A63BC93D7uL, 0xBC66843180000000uL},
     {0x3FB5F6597591B633uL, 0xBFF0000000000000uL, 0xBFD9EF7943A8ED8AuL, 0xBC66DA8120000000uL},
     {0x3FB740C45E0E5120uL, 0xBFF0000000000000uL, 0xBFDAA6C82B6D3FCAuL, 0x3C7D5F1060000000uL},
     {0x3FB894285E19C468uL, 0xBFF0000000000000uL, 0xBFDB5D1009E15CC0uL, 0xBC65B362C0000000uL},
     {0x3FB9F07860181D1EuL, 0xBFF0000000000000uL, 0xBFDC1249D8011EE7uL, 0x3C7813AAA0000000uL},
     {0x3FBB55A6F65F7058uL, 0xBFF0000000000000uL, 0xBFDCC66E9931C45EuL, 0xBC56850E40000000uL},
     {0x3FBCC3A65BBC6327uL, 0xBFF0000000000000uL, 0xBFDD79775B86E389uL, 0xBC7550EC80000000uL},
     {0x3FBE3A6873FA1279uL, 0xBFF0000000000000uL, 0xBFDE2B5D3806F63BuL, 0xBC5E0D8900000000uL},
     {0x3FBFB9DECC6D55B8uL, 0xBFF0000000000000uL, 0xBFDEDC1952EF78D6uL, 0x3C7DD0F7C0000000uL},
     {0x3FC0A0FD4E41AB5AuL, 0xBFF0000000000000uL, 0xBFDF8BA4DBF89ABAuL, 0x3C32EC1FC0000000uL},
     {0x3FC169566329BCB7uL, 0xBFF0000000000000uL, 0xBFE01CFC874C3EB7uL, 0x3C734A35E0000000uL},
     {0x3FC235F2EB9A470AuL, 0xBFF0000000000000uL, 0xBFE073879922FFEEuL, 0x3C8A5A0140000000uL},
     {0x3FC306CB042AA3BAuL, 0xBFF0000000000000uL, 0xBFE0C9704D5D898FuL, 0x3C88D3D7C0000000uL},
     {0x3FC3DBD69FABF802uL, 0xBFF0000000000000uL, 0xBFE11EB3541B4B23uL, 0x3C8EF23B60000000uL},
     {0x3FC4B50D8778ABBDuL, 0xBFF0000000000000uL, 0xBFE1734D63DEDB49uL, 0x3C87EEF2C0000000uL},
     {0x3FC592675BC57974uL, 0xBFF0000000000000uL, 0xBFE1C73B39AE68C8uL, 0xBC8B25DD20000000uL},
     {0x3FC673DB93F41479uL, 0xBFF0000000000000uL, 0xBFE21A799933EB59uL, 0x3C83A7B160000000uL},
     {0x3FC759617EE761F9uL, 0xBFF0000000000000uL, 0xBFE26D054CDD12DFuL, 0x3C85DA7420000000uL},
     {0x3FC842F0435941AFuL, 0xBFF0000000000000uL, 0xBFE2BEDB25FAF3EAuL, 0x3C514981C0000000uL},
     {0x3FC9307EE031E2FDuL, 0xBFF0000000000000uL, 0xBFE30FF7FCE17035uL, 0x3C6EFCC620000000uL},
     {0x3FCA22042CE0A2F9uL, 0xBFF0000000000000uL, 0xBFE36058B10659F3uL, 0x3C81FCB3A0000000uL},
     {0x3FCB1776D9B67013uL, 0xBFF0000000000000uL, 0xBFE3AFFA292050B9uL, 0xBC7E3E25E0000000uL},
     {0x3FCC10CD7041AFCCuL, 0xBFF0000000000000uL, 0xBFE3FED9534556D4uL, 0xBC83691660000000uL},
     {0x3FCD0DFE53ABA2FDuL, 0xBFF0000000000000uL, 0xBFE44CF325091DD6uL, 0xBC68076A20000000uL},
     {0x3FCE0EFFC1174505uL, 0xBFF0000000000000uL, 0xBFE49A449B9B0939uL, 0x3C827EE160000000uL},
     {0x3FCF13C7D001A249uL, 0xBFF0000000000000uL, 0xBFE4E6CABBE3E5E9uL, 0xBC63C293E0000000uL},
     {0xBFCFE3B38D5C5DC2uL, 0xBFE0000000000000uL, 0xBFE5328292A35596uL, 0x3C7A12EB80000000uL},
     {0xBFCED77C89AABEBBuL, 0xBFE0000000000000uL, 0xBFE57D69348CECA0uL, 0x3C87572080000000uL},
     {0xBFCDC79D7C0DC985uL, 0xBFE0000000000000uL, 0xBFE5C77BBE65018CuL, 0xBC8069EA80000000uL},
     {0xBFCCB420DFBFFE59uL, 0xBFE0000000000000uL, 0xBFE610B7551D2CDFuL, 0x3C7251B340000000uL},
     {0xBFCB9D1153AAA2BAuL, 0xBFE0000000000000uL, 0xBFE6591925F0783DuL, 0xBC8C3D64E0000000uL},
     {0xBFCA827999FCEF32uL, 0xBFE0000000000000uL, 0xBFE6A09E667F3BCDuL, 0x3C8BDD3400000000uL},
     {0xBFC9646497C1E0F6uL, 0xBFE0000000000000uL, 0xBFE6E74454EAA8AFuL, 0x3C8DBC03C0000000uL},
     {0xBFC842DD5474B37BuL, 0xBFE0000000000000uL, 0xBFE72D0837EFFF96uL, 0xBC80D4EF00000000uL},
     {0xBFC71DEEF9940631uL, 0xBFE0000000000000uL, 0xBFE771E75F037261uL, 0xBC75CFCE80000000uL},
     {0xBFC5F5A4D233B27FuL, 0xBFE0000000000000uL, 0xBFE7B5DF226AAFAFuL, 0x3C70F537A0000000uL},
     {0xBFC4CA0A4A8D5657uL, 0xBFE0000000000000uL, 0xBFE7F8ECE3571771uL, 0x3C89C8D8C0000000uL},
     {0xBFC39B2AEF8F97A4uL, 0xBFE0000000000000uL, 0xBFE83B0E0BFF976EuL, 0x3C76F420E0000000uL},
     {0xBFC269126E6C24E3uL, 0xBFE0000000000000uL, 0xBFE87C400FBA2EBFuL, 0x3C82DABC00000000uL},
     {0xBFC133CC94247758uL, 0xBFE0000000000000uL, 0xBFE8BC806B151741uL, 0x3C82C5E120000000uL},
     {0xBFBFF6CA9A2AB6A2uL, 0xBFE0000000000000uL, 0xBFE8FBCCA3EF940DuL, 0x3C66DFA980000000uL},
     {0xBFBD7FD1490285CAuL, 0xBFE0000000000000uL, 0xBFE93A22499263FBuL, 0xBC83D419A0000000uL},
     {0xBFBB02C58832CF96uL, 0xBFE0000000000000uL, 0xBFE9777EF4C7D742uL, 0x3C815479A0000000uL},
     {0xBFB87FBFE70B81A7uL, 0xBFE0000000000000uL, 0xBFE9B3E047F38741uL, 0x3C830EE280000000uL},
     {0xBFB5F6D92FD79F50uL, 0xBFE0000000000000uL, 0xBFE9EF43EF29AF94uL, 0xBC7B1DFCA0000000uL},
     {0xBFB3682A66E896F5uL, 0xBFE0000000000000uL, 0xBFEA29A7A0462782uL, 0x3C7128BB00000000uL},
     {0xBFB0D3CCC99F5AC6uL, 0xBFE0000000000000uL, 0xBFEA63091B02FAE2uL, 0x3C7E911140000000uL},
     {0xBFAC73B39AE68C87uL, 0xBFE0000000000000uL, 0xBFEA9B66290EA1A3uL, 0xBC39F630E0000000uL},
     {0xBFA734D63DEDB48AuL, 0xBFE0000000000000uL, 0xBFEAD2BC9E21D511uL, 0x3C847FBE00000000uL},
     {0xBFA1EB3541B4B228uL, 0xBFE0000000000000uL, 0xBFEB090A58150200uL, 0x3C8926DA20000000uL},
     {0xBF992E09ABB131D4uL, 0xBFE0000000000000uL, 0xBFEB3E4D3EF55712uL, 0x3C8EB6B8A0000000uL},
     {0xBF8CE1E648BFFB66uL, 0xBFE0000000000000uL, 0xBFEB728345196E3EuL, 0x3C8BC69F20000000uL},
     {0xBF6CFC874C3EB6D9uL, 0xBFE0000000000000uL, 0xBFEBA5AA673590D2uL, 0xBC87EA4E20000000uL},
     {0x3F7D16C901D95181uL, 0xBFE0000000000000uL, 0xBFEBD7C0AC6F952AuL, 0x3C8825A720000000uL},
     {0x3F923E6AD10872A7uL, 0xBFE0000000000000uL, 0xBFEC08C426725549uL, 0xBC5B157FC0000000uL},
     {0x3F9D4A2C7F909C4EuL, 0xBFE0000000000000uL, 0xBFEC38B2F180BDB1uL, 0x3C76E0B160000000uL},
     {0x3FA4344523C8E3B5uL, 0xBFE0000000000000uL, 0xBFEC678B3488739BuL, 0xBC6D86CAC0000000uL},
     {0x3FA9CC8B3671DD0FuL, 0xBFE0000000000000uL, 0xBFEC954B213411F5uL, 0x3C52FB7600000000uL},
     {0x3FAF6DB13FF708CBuL, 0xBFE0000000000000uL, 0xBFECC1F0F3FCFC5CuL, 0xBC7E576120000000uL},
     {0x3FB28BBFD87A8CFFuL, 0xBFE0000000000000uL, 0xBFECED7AF43CC773uL, 0x3C5E7B6BA0000000uL},
     {0x3FB564DF524B00DAuL, 0xBFE0000000000000uL, 0xBFED17E7743E35DCuL, 0x3C5101DA20000000uL},
     {0x3FB8421AF15C49D7uL, 0xBFE0000000000000uL, 0xBFED4134D14DC93AuL, 0x3C84EF5280000000uL},
     {0x3FBB2356710DB0A3uL, 0xBFE0000000000000uL, 0xBFED696173C9E68BuL, 0x3C7E8C61C0000000uL},
     {0x3FBE087565455A75uL, 0xBFE0000000000000uL, 0xBFED906BCF328D46uL, 0xBC7457E600000000uL},
     {0xBFBF0EA4C477339CuL, 0xBFD0000000000000uL, 0xBFEDB6526238A09BuL, 0x3C7ADEE7E0000000uL},
     {0xBFBC2214C3E9167BuL, 0xBFD0000000000000uL, 0xBFEDDB13B6CCC23CuL, 0xBC883C37C0000000uL},
     {0xBFB931F774FC9F18uL, 0xBFD0000000000000uL, 0xBFEDFEAE622DBE2BuL, 0x3C8514EA80000000uL},
     {0xBFB63E69D6AC7F74uL, 0xBFD0000000000000uL, 0xBFEE212104F686E5uL, 0x3C8014C760000000uL},
     {0xBFB3478909E39DA9uL, 0xBFD0000000000000uL, 0xBFEE426A4B2BC17EuL, 0xBC8A873880000000uL},
     {0xBFB04D72505D9805uL, 0xBFD0000000000000uL, 0xBFEE6288EC48E112uL, 0x3C616B56E0000000uL},
     {0xBFAAA086170C0A8EuL, 0xBFD0000000000000uL, 0xBFEE817BAB4CD10DuL, 0x3C7D0AFE60000000uL},
     {0xBFA4A03176ACF82DuL, 0xBFD0000000000000uL, 0xBFEE9F4156C62DDAuL, 0xBC8760B1E0000000uL},
     {0xBF9D3443F4CDB3DDuL, 0xBFD0000000000000uL, 0xBFEEBBD8C8DF0B74uL, 0xBC7C6C8C60000000uL},
     {0xBF911D262B1F6776uL, 0xBFD0000000000000uL, 0xBFEED740E7684963uL, 0xBC7E82C780000000uL},
     {0xBF73EE038DFF6B80uL, 0xBFD0000000000000uL, 0xBFEEF178A3E473C2uL, 0xBC86310A60000000uL},
     {0x3F7CC0D09BD41CAAuL, 0xBFD0000000000000uL, 0xBFEF0A7EFB9230D7uL, 0xBC752C7AC0000000uL},
     {0x3F936580D5D5E775uL, 0xBFD0000000000000uL, 0xBFEF2252F7763ADAuL, 0x3C820CB800000000uL},
     {0x3F9FA3ECAC0D84E8uL, 0xBFD0000000000000uL, 0xBFEF38F3AC64E589uL, 0x3C7D7BAFA0000000uL},
     {0x3FA5F57F693FEEBEuL, 0xBFD0000000000000uL, 0xBFEF4E603B0B2F2DuL, 0x3C78EE01E0000000uL},
     {0x3FAC1D1F0E5967D5uL, 0xBFD0000000000000uL, 0xBFEF6297CFF75CB0uL, 0xBC75621720000000uL},
     {0xBFADB7677942FCC5uL, 0xBFC0000000000000uL, 0xBFEF7599A3A12077uL, 0xBC884F31C0000000uL},
     {0xBFA78851122CFF19uL, 0xBFC0000000000000uL, 0xBFEF8764FA714BA9uL, 0xBC7AB25660000000uL},
     {0xBFA155DAC4A4F967uL, 0xBFC0000000000000uL, 0xBFEF97F924C9099BuL, 0x3C8E2AE0E0000000uL},
     {0xBF964083747309D1uL, 0xBFC0000000000000uL, 0xBFEFA7557F08A517uL, 0x3C87A0A8C0000000uL},
     {0xBF839F0CEDAF576BuL, 0xBFC0000000000000uL, 0xBFEFB5797195D741uL, 0xBC71BFAC60000000uL},
     {0x3F6536352AD19E39uL, 0xBFC0000000000000uL, 0xBFEFC26470E19FD3uL, 0xBC81EC8660000000uL},
     {0x3F8E43D1C309E958uL, 0xBFC0000000000000uL, 0xBFEFCE15FD6DA67BuL, 0x3C75DD6F80000000uL},
     {0x3F9BA1650F592F50uL, 0xBFC0000000000000uL, 0xBFEFD88DA3D12526uL, 0x3C887DF620000000uL},
     {0xBF97DB402A6A9063uL, 0xBFB0000000000000uL, 0xBFEFE1CAFCBD5B09uL, 0xBC6A23E320000000uL},
     {0xBF86A9049670CFAEuL, 0xBFB0000000000000uL, 0xBFEFE9CDAD01883AuL, 0xBC6521ECC0000000uL},
     {0x3F535230C0FBE402uL, 0xBFB0000000000000uL, 0xBFEFF095658E71ADuL, 0xBC801A8CE0000000uL},
     {0x3F8B82683BC89FB0uL, 0xBFB0000000000000uL, 0xBFEFF621E3796D7EuL, 0x3C6C57BC20000000uL},
     {0xBF76C32BACA2AE69uL, 0xBFA0000000000000uL, 0xBFEFFA72EFFEF75DuL, 0x3C88B4CDC0000000uL},
     {0x3F7B7AA821726608uL, 0xBFA0000000000000uL, 0xBFEFFD886084CD0DuL, 0x3C81354D40000000uL},
     {0x3F6B78B80C84E1EEuL, 0xBF90000000000000uL, 0xBFEFFF62169B92DBuL, 0xBC85DDA3C0000000uL},
     {0x0000000000000000uL, 0x0000000000000000uL, 0xBFF0000000000000uL, 0x0000000000000000uL},
     {0xBF6B78B80C84E1EEuL, 0x3F90000000000000uL, 0xBFEFFF62169B92DBuL, 0xBC85DDA3C0000000uL},
     {0xBF7B7AA821726608uL, 0x3FA0000000000000uL, 0xBFEFFD886084CD0DuL, 0x3C81354D40000000uL},
     {0x3F76C32BACA2AE69uL, 0x3FA0000000000000uL, 0xBFEFFA72EFFEF75DuL, 0x3C88B4CDC0000000uL},
     {0xBF8B82683BC89FB0uL, 0x3FB0000000000000uL, 0xBFEFF621E3796D7EuL, 0x3C6C57BC20000000uL},
     {0xBF535230C0FBE402uL, 0x3FB0000000000000uL, 0xBFEFF095658E71ADuL, 0xBC801A8CE0000000uL},
     {0x3F86A9049670CFAEuL, 0x3FB0000000000000uL, 0xBFEFE9CDAD01883AuL, 0xBC6521ECC0000000uL},
     {0x3F97DB402A6A9063uL, 0x3FB0000000000000uL, 0xBFEFE1CAFCBD5B09uL, 0xBC6A23E320000000uL},
     {0xBF9BA1650F592F50uL, 0x3FC0000000000000uL, 0xBFEFD88DA3D12526uL, 0x3C887DF620000000uL},
     {0xBF8E43D1C309E958uL, 0x3FC0000000000000uL, 0xBFEFCE15FD6DA67BuL, 0x3C75DD6F80000000uL},
     {0xBF6536352AD19E39uL, 0x3FC0000000000000uL, 0xBFEFC26470E19FD3uL, 0xBC81EC8660000000uL},
     {0x3F839F0CEDAF576BuL, 0x3FC0000000000000uL, 0xBFEFB5797195D741uL, 0xBC71BFAC60000000uL},
     {0x3F964083747309D1uL, 0x3FC0000000000000uL, 0xBFEFA7557F08A517uL, 0x3C87A0A8C0000000uL},
     {0x3FA155DAC4A4F967uL, 0x3FC0000000000000uL, 0xBFEF97F924C9099BuL, 0x3C8E2AE0E0000000uL},
     {0x3FA78851122CFF19uL, 0x3FC0000000000000uL, 0xBFEF8764FA714BA9uL, 0xBC7AB25660000000uL},
     {0x3FADB7677942FCC5uL, 0x3FC0000000000000uL, 0xBFEF7599A3A12077uL, 0xBC884F31C0000000uL},
     {0xBFAC1D1F0E5967D5uL, 0x3FD0000000000000uL, 0xBFEF6297CFF75CB0uL, 0xBC75621720000000uL},
     {0xBFA5F57F693FEEBEuL, 0x3FD0000000000000uL, 0xBFEF4E603B0B2F2DuL, 0x3C78EE01E0000000uL},
     {0xBF9FA3ECAC0D84E8uL, 0x3FD0000000000000uL, 0xBFEF38F3AC64E589uL, 0x3C7D7BAFA0000000uL},
     {0xBF936580D5D5E775uL, 0x3FD0000000000000uL, 0xBFEF2252F7763ADAuL, 0x3C820CB800000000uL},
     {0xBF7CC0D09BD41CAAuL, 0x3FD0000000000000uL, 0xBFEF0A7EFB9230D7uL, 0xBC752C7AC0000000uL},
     {0x3F73EE038DFF6B80uL, 0x3FD0000000000000uL, 0xBFEEF178A3E473C2uL, 0xBC86310A60000000uL},
     {0x3F911D262B1F6776uL, 0x3FD0000000000000uL, 0xBFEED740E7684963uL, 0xBC7E82C780000000uL},
     {0x3F9D3443F4CDB3DDuL, 0x3FD0000000000000uL, 0xBFEEBBD8C8DF0B74uL, 0xBC7C6C8C60000000uL},
     {0x3FA4A03176ACF82DuL, 0x3FD0000000000000uL, 0xBFEE9F4156C62DDAuL, 0xBC8760B1E0000000uL},
     {0x3FAAA086170C0A8EuL, 0x3FD0000000000000uL, 0xBFEE817BAB4CD10DuL, 0x3C7D0AFE60000000uL},
     {0x3FB04D72505D9805uL, 0x3FD0000000000000uL, 0xBFEE6288EC48E112uL, 0x3C616B56E0000000uL},
     {0x3FB3478909E39DA9uL, 0x3FD0000000000000uL, 0xBFEE426A4B2BC17EuL, 0xBC8A873880000000uL},
     {0x3FB63E69D6AC7F74uL, 0x3FD0000000000000uL, 0xBFEE212104F686E5uL, 0x3C8014C760000000uL},
     {0x3FB931F774FC9F18uL, 0x3FD0000000000000uL, 0xBFEDFEAE622DBE2BuL, 0x3C8514EA80000000uL},
     {0x3FBC2214C3E9167BuL, 0x3FD0000000000000uL, 0xBFEDDB13B6CCC23CuL, 0xBC883C37C0000000uL},
     {0x3FBF0EA4C477339CuL, 0x3FD0000000000000uL, 0xBFEDB6526238A09BuL, 0x3C7ADEE7E0000000uL},
     {0xBFBE087565455A75uL, 0x3FE0000000000000uL, 0xBFED906BCF328D46uL, 0xBC7457E600000000uL},
     {0xBFBB2356710DB0A3uL, 0x3FE0000000000000uL, 0xBFED696173C9E68BuL, 0x3C7E8C61C0000000uL},
     {0xBFB8421AF15C49D7uL, 0x3FE0000000000000uL, 0xBFED4134D14DC93AuL, 0x3C84EF5280000000uL},
     {0xBFB564DF524B00DAuL, 0x3FE0000000000000uL, 0xBFED17E7743E35DCuL, 0x3C5101DA20000000uL},
     {0xBFB28BBFD87A8CFFuL, 0x3FE0000000000000uL, 0xBFECED7AF43CC773uL, 0x3C5E7B6BA0000000uL},
     {0xBFAF6DB13FF708CBuL, 0x3FE0000000000000uL, 0xBFECC1F0F3FCFC5CuL, 0xBC7E576120000000uL},
     {0xBFA9CC8B3671DD0FuL, 0x3FE0000000000000uL, 0xBFEC954B213411F5uL, 0x3C52FB7600000000uL},
     {0xBFA4344523C8E3B5uL, 0x3FE0000000000000uL, 0xBFEC678B3488739BuL, 0xBC6D86CAC0000000uL},
     {0xBF9D4A2C7F909C4EuL, 0x3FE0000000000000uL, 0xBFEC38B2F180BDB1uL, 0x3C76E0B160000000uL},
     {0xBF923E6AD10872A7uL, 0x3FE0000000000000uL, 0xBFEC08C426725549uL, 0xBC5B157FC0000000uL},
     {0xBF7D16C901D95181uL, 0x3FE0000000000000uL, 0xBFEBD7C0AC6F952AuL, 0x3C8825A720000000uL},
     {0x3F6CFC874C3EB6D9uL, 0x3FE0000000000000uL, 0xBFEBA5AA673590D2uL, 0xBC87EA4E20000000uL},
     {0x3F8CE1E648BFFB66uL, 0x3FE0000000000000uL, 0xBFEB728345196E3EuL, 0x3C8BC69F20000000uL},
     {0x3F992E09ABB131D4uL, 0x3FE0000000000000uL, 0xBFEB3E4D3EF55712uL, 0x3C8EB6B8A0000000uL},
     {0x3FA1EB3541B4B228uL, 0x3FE0000000000000uL, 0xBFEB090A58150200uL, 0x3C8926DA20000000uL},
     {0x3FA734D63DEDB48AuL, 0x3FE0000000000000uL, 0xBFEAD2BC9E21D511uL, 0x3C847FBE00000000uL},
     {0x3FAC73B39AE68C87uL, 0x3FE0000000000000uL, 0xBFEA9B66290EA1A3uL, 0xBC39F630E0000000uL},
     {0x3FB0D3CCC99F5AC6uL, 0x3FE0000000000000uL, 0xBFEA63091B02FAE2uL, 0x3C7E911140000000uL},
     {0x3FB3682A66E896F5uL, 0x3FE0000000000000uL, 0xBFEA29A7A0462782uL, 0x3C7128BB00000000uL},
     {0x3FB5F6D92FD79F50uL, 0x3FE0000000000000uL, 0xBFE9EF43EF29AF94uL, 0xBC7B1DFCA0000000uL},
     {0x3FB87FBFE70B81A7uL, 0x3FE0000000000000uL, 0xBFE9B3E047F38741uL, 0x3C830EE280000000uL},
     {0x3FBB02C58832CF96uL, 0x3FE0000000000000uL, 0xBFE9777EF4C7D742uL, 0x3C815479A0000000uL},
     {0x3FBD7FD1490285CAuL, 0x3FE0000000000000uL, 0xBFE93A22499263FBuL, 0xBC83D419A0000000uL},
     {0x3FBFF6CA9A2AB6A2uL, 0x3FE0000000000000uL, 0xBFE8FBCCA3EF940DuL, 0x3C66DFA980000000uL},
     {0x3FC133CC94247758uL, 0x3FE0000000000000uL, 0xBFE8BC806B151741uL, 0x3C82C5E120000000uL},
     {0x3FC269126E6C24E3uL, 0x3FE0000000000000uL, 0xBFE87C400FBA2EBFuL, 0x3C82DABC00000000uL},
     {0x3FC39B2AEF8F97A4uL, 0x3FE0000000000000uL, 0xBFE83B0E0BFF976EuL, 0x3C76F420E0000000uL},
     {0x3FC4CA0A4A8D5657uL, 0x3FE0000000000000uL, 0xBFE7F8ECE3571771uL, 0x3C89C8D8C0000000uL},
     {0x3FC5F5A4D233B27FuL, 0x3FE0000000000000uL, 0xBFE7B5DF226AAFAFuL, 0x3C70F537A0000000uL},
     {0x3FC71DEEF9940631uL, 0x3FE0000000000000uL, 0xBFE771E75F037261uL, 0xBC75CFCE80000000uL},
     {0x3FC842DD5474B37BuL, 0x3FE0000000000000uL, 0xBFE72D0837EFFF96uL, 0xBC80D4EF00000000uL},
     {0x3FC9646497C1E0F6uL, 0x3FE0000000000000uL, 0xBFE6E74454EAA8AFuL, 0x3C8DBC03C0000000uL},
     {0x3FCA827999FCEF32uL, 0x3FE0000000000000uL, 0xBFE6A09E667F3BCDuL, 0x3C8BDD3400000000uL},
     {0x3FCB9D1153AAA2BAuL, 0x3FE0000000000000uL, 0xBFE6591925F0783DuL, 0xBC8C3D64E0000000uL},
     {0x3FCCB420DFBFFE59uL, 0x3FE0000000000000uL, 0xBFE610B7551D2CDFuL, 0x3C7251B340000000uL},
     {0x3FCDC79D7C0DC985uL, 0x3FE0000000000000uL, 0xBFE5C77BBE65018CuL, 0xBC8069EA80000000uL},
     {0x3FCED77C89AABEBBuL, 0x3FE0000000000000uL, 0xBFE57D69348CECA0uL, 0x3C87572080000000uL},
     {0x3FCFE3B38D5C5DC2uL, 0x3FE0000000000000uL, 0xBFE5328292A35596uL, 0x3C7A12EB80000000uL},
     {0xBFCF13C7D001A249uL, 0x3FF0000000000000uL, 0xBFE4E6CABBE3E5E9uL, 0xBC63C293E0000000uL},
     {0xBFCE0EFFC1174505uL, 0x3FF0000000000000uL, 0xBFE49A449B9B0939uL, 0x3C827EE160000000uL},
     {0xBFCD0DFE53ABA2FDuL, 0x3FF0000000000000uL, 0xBFE44CF325091DD6uL, 0xBC68076A20000000uL},
     {0xBFCC10CD7041AFCCuL, 0x3FF0000000000000uL, 0xBFE3FED9534556D4uL, 0xBC83691660000000uL},
     {0xBFCB1776D9B67013uL, 0x3FF0000000000000uL, 0xBFE3AFFA292050B9uL, 0xBC7E3E25E0000000uL},
     {0xBFCA22042CE0A2F9uL, 0x3FF0000000000000uL, 0xBFE36058B10659F3uL, 0x3C81FCB3A0000000uL},
     {0xBFC9307EE031E2FDuL, 0x3FF0000000000000uL, 0xBFE30FF7FCE17035uL, 0x3C6EFCC620000000uL},
     {0xBFC842F0435941AFuL, 0x3FF0000000000000uL, 0xBFE2BEDB25FAF3EAuL, 0x3C514981C0000000uL},
     {0xBFC759617EE761F9uL, 0x3FF0000000000000uL, 0xBFE26D054CDD12DFuL, 0x3C85DA7420000000uL},
     {0xBFC673DB93F41479uL, 0x3FF0000000000000uL, 0xBFE21A799933EB59uL, 0x3C83A7B160000000uL},
     {0xBFC592675BC57974uL, 0x3FF0000000000000uL, 0xBFE1C73B39AE68C8uL, 0xBC8B25DD20000000uL},
     {0xBFC4B50D8778ABBDuL, 0x3FF0000000000000uL, 0xBFE1734D63DEDB49uL, 0x3C87EEF2C0000000uL},
     {0xBFC3DBD69FABF802uL, 0x3FF0000000000000uL, 0xBFE11EB3541B4B23uL, 0x3C8EF23B60000000uL},
     {0xBFC306CB042AA3BAuL, 0x3FF0000000000000uL, 0xBFE0C9704D5D898FuL, 0x3C88D3D7C0000000uL},
     {0xBFC235F2EB9A470AuL, 0x3FF0000000000000uL, 0xBFE073879922FFEEuL, 0x3C8A5A0140000000uL},
     {0xBFC169566329BCB7uL, 0x3FF0000000000000uL, 0xBFE01CFC874C3EB7uL, 0x3C734A35E0000000uL},
     {0xBFC0A0FD4E41AB5AuL, 0x3FF0000000000000uL, 0xBFDF8BA4DBF89ABAuL, 0x3C32EC1FC0000000uL},
     {0xBFBFB9DECC6D55B8uL, 0x3FF0000000000000uL, 0xBFDEDC1952EF78D6uL, 0x3C7DD0F7C0000000uL},
     {0xBFBE3A6873FA1279uL, 0x3FF0000000000000uL, 0xBFDE2B5D3806F63BuL, 0xBC5E0D8900000000uL},
     {0xBFBCC3A65BBC6327uL, 0x3FF0000000000000uL, 0xBFDD79775B86E389uL, 0xBC7550EC80000000uL},
     {0xBFBB55A6F65F7058uL, 0x3FF0000000000000uL, 0xBFDCC66E9931C45EuL, 0xBC56850E40000000uL},
     {0xBFB9F07860181D1EuL, 0x3FF0000000000000uL, 0xBFDC1249D8011EE7uL, 0x3C7813AAA0000000uL},
     {0xBFB894285E19C468uL, 0x3FF0000000000000uL, 0xBFDB5D1009E15CC0uL, 0xBC65B362C0000000uL},
     {0xBFB740C45E0E5120uL, 0x3FF0000000000000uL, 0xBFDAA6C82B6D3FCAuL, 0x3C7D5F1060000000uL},
     {0xBFB5F6597591B633uL, 0x3FF0000000000000uL, 0xBFD9EF7943A8ED8AuL, 0xBC66DA8120000000uL},
     {0xBFB4B4F461B0CBAAuL, 0x3FF0000000000000uL, 0xBFD9372A63BC93D7uL, 0xBC66843180000000uL},
     {0xBFB37CA1866B95CFuL, 0x3FF0000000000000uL, 0xBFD87DE2A6AEA963uL, 0x3C672CEDC0000000uL},
     {0xBFB24D6CEE3AFB2AuL, 0x3FF0000000000000uL, 0xBFD7C3A9311DCCE7uL, 0xBC19A3F200000000uL},
     {0xBFB127624999EE1DuL, 0x3FF0000000000000uL, 0xBFD7088530FA459FuL, 0x3C744B19E0000000uL},
     {0xBFB00A8CEE920EABuL, 0x3FF0000000000000uL, 0xBFD64C7DDD3F27C6uL, 0xBC510D2B40000000uL},
     {0xBFADEDEFB09791B4uL, 0x3FF0000000000000uL, 0xBFD58F9A75AB1FDDuL, 0x3C1EFDC0C0000000uL},
     {0xBFABD95B4D43E819uL, 0x3FF0000000000000uL, 0xBFD4D1E24278E76AuL, 0xBC62417200000000uL},
     {0xBFA9D7713B71EEE1uL, 0x3FF0000000000000uL, 0xBFD4135C94176601uL, 0xBC70C97C40000000uL},
     {0xBFA7E8454B32EF34uL, 0x3FF0000000000000uL, 0xBFD35410C2E18152uL, 0x3C73CB0020000000uL},
     {0xBFA60BEA939D225AuL, 0x3FF0000000000000uL, 0xBFD294062ED59F06uL, 0x3C75D28DA0000000uL},
     {0xBFA44273720F48BCuL, 0x3FF0000000000000uL, 0xBFD1D3443F4CDB3EuL, 0x3C6720D400000000uL},
     {0xBFA28BF1897B69CCuL, 0x3FF0000000000000uL, 0xBFD111D262B1F677uL, 0xBC7824C200000000uL},
     {0xBFA0E875C1B8C3DAuL, 0x3FF0000000000000uL, 0xBFD04FB80E37FDAEuL, 0x3C0412CDA0000000uL},
     {0xBF9EB0208DB9E51BuL, 0x3FF0000000000000uL, 0xBFCF19F97B215F1BuL, 0x3C642DEEE0000000uL},
     {0xBF9BB5A11138A4C9uL, 0x3FF0000000000000uL, 0xBFCD934FE5454311uL, 0xBC675B9220000000uL},
     {0xBF98E18A73634EE7uL, 0x3FF0000000000000uL, 0xBFCC0B826A7E4F63uL, 0x3C1AF14380000000uL},
     {0xBF9633F89E9A1A66uL, 0x3FF0000000000000uL, 0xBFCA82A025B00451uL, 0x3C687905E0000000uL},
     {0xBF93AD06011469FBuL, 0x3FF0000000000000uL, 0xBFC8F8B83C69A60BuL, 0x3C626D19A0000000uL},
     {0xBF914CCB8BDBF114uL, 0x3FF0000000000000uL, 0xBFC76DD9DE50BF31uL, 0xBC61D5EEE0000000uL},
     {0xBF8E26C163AD15B3uL, 0x3FF0000000000000uL, 0xBFC5E214448B3FC6uL, 0xBC6531FF60000000uL},
     {0xBF8A01B6CDBD995EuL, 0x3FF0000000000000uL, 0xBFC45576B1293E5AuL, 0x3C5285A240000000uL},
     {0xBF862AA03DD6BA58uL, 0x3FF0000000000000uL, 0xBFC2C8106E8E613AuL, 0xBC513000A0000000uL},
     {0xBF82A1A39A8A2FB7uL, 0x3FF0000000000000uL, 0xBFC139F0CEDAF577uL, 0x3C65234340000000uL},
     {0xBF7ECDC78F30165CuL, 0x3FF0000000000000uL, 0xBFBF564E56A9730EuL, 0xBC4A270460000000uL},
     {0xBF78F501492CC296uL, 0x3FF0000000000000uL, 0xBFBC3785C79EC2D5uL, 0x3C24F39DE0000000uL},
     {0xBF73B92E176D6D31uL, 0x3FF0000000000000uL, 0xBFB917A6BC29B42CuL, 0x3C3E2718C0000000uL},
     {0xBF6E350342A4F6E6uL, 0x3FF0000000000000uL, 0xBFB5F6D00A9AA419uL, 0x3C4F4022C0000000uL},
     {0xBF663252FE77C5EBuL, 0x3FF0000000000000uL, 0xBFB2D52092CE19F6uL, 0x3C49A088A0000000uL},
     {0xBF5ED534E31CA57FuL, 0x3FF0000000000000uL, 0xBFAF656E79F820E0uL, 0x3C22E1EBE0000000uL},
     {0xBF53BC390D250439uL, 0x3FF0000000000000uL, 0xBFA91F65F10DD814uL, 0x3C2912BD00000000uL},
     {0xBF46344004228D8BuL, 0x3FF0000000000000uL, 0xBFA2D865759455CDuL, 0xBC2686F640000000uL},
     {0xBF33BCFBD9979A27uL, 0x3FF0000000000000uL, 0xBF992155F7A3667EuL, 0x3BFB1D6300000000uL},
     {0xBF13BD2C8DA49511uL, 0x3FF0000000000000uL, 0xBF8921D1FCDEC784uL, 0xBC29878EA0000000uL},
     {0x0000000000000000uL, 0x3FF0000000000000uL, 0x0000000000000000uL, 0x0000000000000000uL},
     {0xBF13BD2C8DA49511uL, 0x3FF0000000000000uL, 0x3F8921D1FCDEC784uL, 0x3C29878EA0000000uL},
     {0xBF33BCFBD9979A27uL, 0x3FF0000000000000uL, 0x3F992155F7A3667EuL, 0xBBFB1D6300000000uL},
     {0xBF46344004228D8BuL, 0x3FF0000000000000uL, 0x3FA2D865759455CDuL, 0x3C2686F640000000uL},
     {0xBF53BC390D250439uL, 0x3FF0000000000000uL, 0x3FA91F65F10DD814uL, 0xBC2912BD00000000uL},
     {0xBF5ED534E31CA57FuL, 0x3FF0000000000000uL, 0x3FAF656E79F820E0uL, 0xBC22E1EBE0000000uL},
     {0xBF663252FE77C5EBuL, 0x3FF0000000000000uL, 0x3FB2D52092CE19F6uL, 0xBC49A088A0000000uL},
     {0xBF6E350342A4F6E6uL, 0x3FF0000000000000uL, 0x3FB5F6D00A9AA419uL, 0xBC4F4022C0000000uL},
     {0xBF73B92E176D6D31uL, 0x3FF0000000000000uL, 0x3FB917A6BC29B42CuL, 0xBC3E2718C0000000uL},
     {0xBF78F501492CC296uL, 0x3FF0000000000000uL, 0x3FBC3785C79EC2D5uL, 0xBC24F39DE0000000uL},
     {0xBF7ECDC78F30165CuL, 0x3FF0000000000000uL, 0x3FBF564E56A9730EuL, 0x3C4A270460000000uL},
     {0xBF82A1A39A8A2FB7uL, 0x3FF0000000000000uL, 0x3FC139F0CEDAF577uL, 0xBC65234340000000uL},
     {0xBF862AA03DD6BA58uL, 0x3FF0000000000000uL, 0x3FC2C8106E8E613AuL, 0x3C513000A0000000uL},
     {0xBF8A01B6CDBD995EuL, 0x3FF0000000000000uL, 0x3FC45576B1293E5AuL, 0xBC5285A240000000uL},
     {0xBF8E26C163AD15B3uL, 0x3FF0000000000000uL, 0x3FC5E214448B3FC6uL, 0x3C6531FF60000000uL},
     {0xBF914CCB8BDBF114uL, 0x3FF0000000000000uL, 0x3FC76DD9DE50BF31uL, 0x3C61D5EEE0000000uL},
     {0xBF93AD06011469FBuL, 0x3FF0000000000000uL, 0x3FC8F8B83C69A60BuL, 0xBC626D19A0000000uL},
     {0xBF9633F89E9A1A66uL, 0x3FF0000000000000uL, 0x3FCA82A025B00451uL, 0xBC687905E0000000uL},
     {0xBF98E18A73634EE7uL, 0x3FF0000000000000uL, 0x3FCC0B826A7E4F63uL, 0xBC1AF14380000000uL},
     {0xBF9BB5A11138A4C9uL, 0x3FF0000000000000uL, 0x3FCD934FE5454311uL, 0x3C675B9220000000uL},
     {0xBF9EB0208DB9E51BuL, 0x3FF0000000000000uL, 0x3FCF19F97B215F1BuL, 0xBC642DEEE0000000uL},
     {0xBFA0E875C1B8C3DAuL, 0x3FF0000000000000uL, 0x3FD04FB80E37FDAEuL, 0xBC0412CDA0000000uL},
     {0xBFA28BF1897B69CCuL, 0x3FF0000000000000uL, 0x3FD111D262B1F677uL, 0x3C7824C200000000uL},
     {0xBFA44273720F48BCuL, 0x3FF0000000000000uL, 0x3FD1D3443F4CDB3EuL, 0xBC6720D400000000uL},
     {0xBFA60BEA939D225AuL, 0x3FF0000000000000uL, 0x3FD294062ED59F06uL, 0xBC75D28DA0000000uL},
     {0xBFA7E8454B32EF34uL, 0x3FF0000000000000uL, 0x3FD35410C2E18152uL, 0xBC73CB0020000000uL},
     {0xBFA9D7713B71EEE1uL, 0x3FF0000000000000uL, 0x3FD4135C94176601uL, 0x3C70C97C40000000uL},
     {0xBFABD95B4D43E819uL, 0x3FF0000000000000uL, 0x3FD4D1E24278E76AuL, 0x3C62417200000000uL},
     {0xBFADEDEFB09791B4uL, 0x3FF0000000000000uL, 0x3FD58F9A75AB1FDDuL, 0xBC1EFDC0C0000000uL},
     {0xBFB00A8CEE920EABuL, 0x3FF0000000000000uL, 0x3FD64C7DDD3F27C6uL, 0x3C510D2B40000000uL},
     {0xBFB127624999EE1DuL, 0x3FF0000000000000uL, 0x3FD7088530FA459FuL, 0xBC744B19E0000000uL},
     {0xBFB24D6CEE3AFB2AuL, 0x3FF0000000000000uL, 0x3FD7C3A9311DCCE7uL, 0x3C19A3F200000000uL},
     {0xBFB37CA1866B95CFuL, 0x3FF0000000000000uL, 0x3FD87DE2A6AEA963uL, 0xBC672CEDC0000000uL},
     {0xBFB4B4F461B0CBAAuL, 0x3FF0000000000000uL, 0x3FD9372A63BC93D7uL, 0x3C66843180000000uL},
     {0xBFB5F6597591B633uL, 0x3FF0000000000000uL, 0x3FD9EF7943A8ED8AuL, 0x3C66DA8120000000uL},
     {0xBFB740C45E0E5120uL, 0x3FF0000000000000uL, 0x3FDAA6C82B6D3FCAuL, 0xBC7D5F1060000000uL},
     {0xBFB894285E19C468uL, 0x3FF0000000000000uL, 0x3FDB5D1009E15CC0uL, 0x3C65B362C0000000uL},
     {0xBFB9F07860181D1EuL, 0x3FF0000000000000uL, 0x3FDC1249D8011EE7uL, 0xBC7813AAA0000000uL},
     {0xBFBB55A6F65F7058uL, 0x3FF0000000000000uL, 0x3FDCC66E9931C45EuL, 0x3C56850E40000000uL},
     {0xBFBCC3A65BBC6327uL, 0x3FF0000000000000uL, 0x3FDD79775B86E389uL, 0x3C7550EC80000000uL},
     {0xBFBE3A6873FA1279uL, 0x3FF0000000000000uL, 0x3FDE2B5D3806F63BuL, 0x3C5E0D8900000000uL},
     {0xBFBFB9DECC6D55B8uL, 0x3FF0000000000000uL, 0x3FDEDC1952EF78D6uL, 0xBC7DD0F7C0000000uL},
     {0xBFC0A0FD4E41AB5AuL, 0x3FF0000000000000uL, 0x3FDF8BA4DBF89ABAuL, 0xBC32EC1FC0000000uL},
     {0xBFC169566329BCB7uL, 0x3FF0000000000000uL, 0x3FE01CFC874C3EB7uL, 0xBC734A35E0000000uL},
     {0xBFC235F2EB9A470AuL, 0x3FF0000000000000uL, 0x3FE073879922FFEEuL, 0xBC8A5A0140000000uL},
     {0xBFC306CB042AA3BAuL, 0x3FF0000000000000uL, 0x3FE0C9704D5D898FuL, 0xBC88D3D7C0000000uL},
     {0xBFC3DBD69FABF802uL, 0x3FF0000000000000uL, 0x3FE11EB3541B4B23uL, 0xBC8EF23B60000000uL},
     {0xBFC4B50D8778ABBDuL, 0x3FF0000000000000uL, 0x3FE1734D63DEDB49uL, 0xBC87EEF2C0000000uL},
     {0xBFC592675BC57974uL, 0x3FF0000000000000uL, 0x3FE1C73B39AE68C8uL, 0x3C8B25DD20000000uL},
     {0xBFC673DB93F41479uL, 0x3FF0000000000000uL, 0x3FE21A799933EB59uL, 0xBC83A7B160000000uL},
     {0xBFC759617EE761F9uL, 0x3FF0000000000000uL, 0x3FE26D054CDD12DFuL, 0xBC85DA7420000000uL},
     {0xBFC842F0435941AFuL, 0x3FF0000000000000uL, 0x3FE2BEDB25FAF3EAuL, 0xBC514981C0000000uL},
     {0xBFC9307EE031E2FDuL, 0x3FF0000000000000uL, 0x3FE30FF7FCE17035uL, 0xBC6EFCC620000000uL},
     {0xBFCA22042CE0A2F9uL, 0x3FF0000000000000uL, 0x3FE36058B10659F3uL, 0xBC81FCB3A0000000uL},
     {0xBFCB1776D9B67013uL, 0x3FF0000000000000uL, 0x3FE3AFFA292050B9uL, 0x3C7E3E25E0000000uL},
     {0xBFCC10CD7041AFCCuL, 0x3FF0000000000000uL, 0x3FE3FED9534556D4uL, 0x3C83691660000000uL},
     {0xBFCD0DFE53ABA2FDuL, 0x3FF0000000000000uL, 0x3FE44CF325091DD6uL, 0x3C68076A20000000uL},
     {0xBFCE0EFFC1174505uL, 0x3FF0000000000000uL, 0x3FE49A449B9B0939uL, 0xBC827EE160000000uL},
     {0xBFCF13C7D001A249uL, 0x3FF0000000000000uL, 0x3FE4E6CABBE3E5E9uL, 0x3C63C293E0000000uL},
     {0x3FCFE3B38D5C5DC2uL, 0x3FE0000000000000uL, 0x3FE5328292A35596uL, 0xBC7A12EB80000000uL},
     {0x3FCED77C89AABEBBuL, 0x3FE0000000000000uL, 0x3FE57D69348CECA0uL, 0xBC87572080000000uL},
     {0x3FCDC79D7C0DC985uL, 0x3FE0000000000000uL, 0x3FE5C77BBE65018CuL, 0x3C8069EA80000000uL},
     {0x3FCCB420DFBFFE59uL, 0x3FE0000000000000uL, 0x3FE610B7551D2CDFuL, 0xBC7251B340000000uL},
     {0x3FCB9D1153AAA2BAuL, 0x3FE0000000000000uL, 0x3FE6591925F0783DuL, 0x3C8C3D64E0000000uL},
     {0x3FCA827999FCEF32uL, 0x3FE0000000000000uL, 0x3FE6A09E667F3BCDuL, 0xBC8BDD3400000000uL},
     {0x3FC9646497C1E0F6uL, 0x3FE0000000000000uL, 0x3FE6E74454EAA8AFuL, 0xBC8DBC03C0000000uL},
     {0x3FC842DD5474B37BuL, 0x3FE0000000000000uL, 0x3FE72D0837EFFF96uL, 0x3C80D4EF00000000uL},
     {0x3FC71DEEF9940631uL, 0x3FE0000000000000uL, 0x3FE771E75F037261uL, 0x3C75CFCE80000000uL},
     {0x3FC5F5A4D233B27FuL, 0x3FE0000000000000uL, 0x3FE7B5DF226AAFAFuL, 0xBC70F537A0000000uL},
     {0x3FC4CA0A4A8D5657uL, 0x3FE0000000000000uL, 0x3FE7F8ECE3571771uL, 0xBC89C8D8C0000000uL},
     {0x3FC39B2AEF8F97A4uL, 0x3FE0000000000000uL, 0x3FE83B0E0BFF976EuL, 0xBC76F420E0000000uL},
     {0x3FC269126E6C24E3uL, 0x3FE0000000000000uL, 0x3FE87C400FBA2EBFuL, 0xBC82DABC00000000uL},
     {0x3FC133CC94247758uL, 0x3FE0000000000000uL, 0x3FE8BC806B151741uL, 0xBC82C5E120000000uL},
     {0x3FBFF6CA9A2AB6A2uL, 0x3FE0000000000000uL, 0x3FE8FBCCA3EF940DuL, 0xBC66DFA980000000uL},
     {0x3FBD7FD1490285CAuL, 0x3FE0000000000000uL, 0x3FE93A22499263FBuL, 0x3C83D419A0000000uL},
     {0x3FBB02C58832CF96uL, 0x3FE0000000000000uL, 0x3FE9777EF4C7D742uL, 0xBC815479A0000000uL},
     {0x3FB87FBFE70B81A7uL, 0x3FE0000000000000uL, 0x3FE9B3E047F38741uL, 0xBC830EE280000000uL},
     {0x3FB5F6D92FD79F50uL, 0x3FE0000000000000uL, 0x3FE9EF43EF29AF94uL, 0x3C7B1DFCA0000000uL},
     {0x3FB3682A66E896F5uL, 0x3FE0000000000000uL, 0x3FEA29A7A0462782uL, 0xBC7128BB00000000uL},
     {0x3FB0D3CCC99F5AC6uL, 0x3FE0000000000000uL, 0x3FEA63091B02FAE2uL, 0xBC7E911140000000uL},
     {0x3FAC73B39AE68C87uL, 0x3FE0000000000000uL, 0x3FEA9B66290EA1A3uL, 0x3C39F630E0000000uL},
     {0x3FA734D63DEDB48AuL, 0x3FE0000000000000uL, 0x3FEAD2BC9E21D511uL, 0xBC847FBE00000000uL},
     {0x3FA1EB3541B4B228uL, 0x3FE0000000000000uL, 0x3FEB090A58150200uL, 0xBC8926DA20000000uL},
     {0x3F992E09ABB131D4uL, 0x3FE0000000000000uL, 0x3FEB3E4D3EF55712uL, 0xBC8EB6B8A0000000uL},
     {0x3F8CE1E648BFFB66uL, 0x3FE0000000000000uL, 0x3FEB728345196E3EuL, 0xBC8BC69F20000000uL},
     {0x3F6CFC874C3EB6D9uL, 0x3FE0000000000000uL, 0x3FEBA5AA673590D2uL, 0x3C87EA4E20000000uL},
     {0xBF7D16C901D95181uL, 0x3FE0000000000000uL, 0x3FEBD7C0AC6F952AuL, 0xBC8825A720000000uL},
     {0xBF923E6AD10872A7uL, 0x3FE0000000000000uL, 0x3FEC08C426725549uL, 0x3C5B157FC0000000uL},
     {0xBF9D4A2C7F909C4EuL, 0x3FE0000000000000uL, 0x3FEC38B2F180BDB1uL, 0xBC76E0B160000000uL},
     {0xBFA4344523C8E3B5uL, 0x3FE0000000000000uL, 0x3FEC678B3488739BuL, 0x3C6D86CAC0000000uL},
     {0xBFA9CC8B3671DD0FuL, 0x3FE0000000000000uL, 0x3FEC954B213411F5uL, 0xBC52FB7600000000uL},
     {0xBFAF6DB13FF708CBuL, 0x3FE0000000000000uL, 0x3FECC1F0F3FCFC5CuL, 0x3C7E576120000000uL},
     {0xBFB28BBFD87A8CFFuL, 0x3FE0000000000000uL, 0x3FECED7AF43CC773uL, 0xBC5E7B6BA0000000uL},
     {0xBFB564DF524B00DAuL, 0x3FE0000000000000uL, 0x3FED17E7743E35DCuL, 0xBC5101DA20000000uL},
     {0xBFB8421AF15C49D7uL, 0x3FE0000000000000uL, 0x3FED4134D14DC93AuL, 0xBC84EF5280000000uL},
     {0xBFBB2356710DB0A3uL, 0x3FE0000000000000uL, 0x3FED696173C9E68BuL, 0xBC7E8C61C0000000uL},
     {0xBFBE087565455A75uL, 0x3FE0000000000000uL, 0x3FED906BCF328D46uL, 0x3C7457E600000000uL},
     {0x3FBF0EA4C477339CuL, 0x3FD0000000000000uL, 0x3FEDB6526238A09BuL, 0xBC7ADEE7E0000000uL},
     {0x3FBC2214C3E9167BuL, 0x3FD0000000000000uL, 0x3FEDDB13B6CCC23CuL, 0x3C883C37C0000000uL},
     {0x3FB931F774FC9F18uL, 0x3FD0000000000000uL, 0x3FEDFEAE622DBE2BuL, 0xBC8514EA80000000uL},
     {0x3FB63E69D6AC7F74uL, 0x3FD0000000000000uL, 0x3FEE212104F686E5uL, 0xBC8014C760000000uL},
     {0x3FB3478909E39DA9uL, 0x3FD0000000000000uL, 0x3FEE426A4B2BC17EuL, 0x3C8A873880000000uL},
     {0x3FB04D72505D9805uL, 0x3FD0000000000000uL, 0x3FEE6288EC48E112uL, 0xBC616B56E0000000uL},
     {0x3FAAA086170C0A8EuL, 0x3FD0000000000000uL, 0x3FEE817BAB4CD10DuL, 0xBC7D0AFE60000000uL},
     {0x3FA4A03176ACF82DuL, 0x3FD0000000000000uL, 0x3FEE9F4156C62DDAuL, 0x3C8760B1E0000000uL},
     {0x3F9D3443F4CDB3DDuL, 0x3FD0000000000000uL, 0x3FEEBBD8C8DF0B74uL, 0x3C7C6C8C60000000uL},
     {0x3F911D262B1F6776uL, 0x3FD0000000000000uL, 0x3FEED740E7684963uL, 0x3C7E82C780000000uL},
     {0x3F73EE038DFF6B80uL, 0x3FD0000000000000uL, 0x3FEEF178A3E473C2uL, 0x3C86310A60000000uL},
     {0xBF7CC0D09BD41CAAuL, 0x3FD0000000000000uL, 0x3FEF0A7EFB9230D7uL, 0x3C752C7AC0000000uL},
     {0xBF936580D5D5E775uL, 0x3FD0000000000000uL, 0x3FEF2252F7763ADAuL, 0xBC820CB800000000uL},
     {0xBF9FA3ECAC0D84E8uL, 0x3FD0000000000000uL, 0x3FEF38F3AC64E589uL, 0xBC7D7BAFA0000000uL},
     {0xBFA5F57F693FEEBEuL, 0x3FD0000000000000uL, 0x3FEF4E603B0B2F2DuL, 0xBC78EE01E0000000uL},
     {0xBFAC1D1F0E5967D5uL, 0x3FD0000000000000uL, 0x3FEF6297CFF75CB0uL, 0x3C75621720000000uL},
     {0x3FADB7677942FCC5uL, 0x3FC0000000000000uL, 0x3FEF7599A3A12077uL, 0x3C884F31C0000000uL},
     {0x3FA78851122CFF19uL, 0x3FC0000000000000uL, 0x3FEF8764FA714BA9uL, 0x3C7AB25660000000uL},
     {0x3FA155DAC4A4F967uL, 0x3FC0000000000000uL, 0x3FEF97F924C9099BuL, 0xBC8E2AE0E0000000uL},
     {0x3F964083747309D1uL, 0x3FC0000000000000uL, 0x3FEFA7557F08A517uL, 0xBC87A0A8C0000000uL},
     {0x3F839F0CEDAF576BuL, 0x3FC0000000000000uL, 0x3FEFB5797195D741uL, 0x3C71BFAC60000000uL},
     {0xBF6536352AD19E39uL, 0x3FC0000000000000uL, 0x3FEFC26470E19FD3uL, 0x3C81EC8660000000uL},
     {0xBF8E43D1C309E958uL, 0x3FC0000000000000uL, 0x3FEFCE15FD6DA67BuL, 0xBC75DD6F80000000uL},
     {0xBF9BA1650F592F50uL, 0x3FC0000000000000uL, 0x3FEFD88DA3D12526uL, 0xBC887DF620000000uL},
     {0x3F97DB402A6A9063uL, 0x3FB0000000000000uL, 0x3FEFE1CAFCBD5B09uL, 0x3C6A23E320000000uL},
     {0x3F86A9049670CFAEuL, 0x3FB0000000000000uL, 0x3FEFE9CDAD01883AuL, 0x3C6521ECC0000000uL},
     {0xBF535230C0FBE402uL, 0x3FB0000000000000uL, 0x3FEFF095658E71ADuL, 0x3C801A8CE0000000uL},
     {0xBF8B82683BC89FB0uL, 0x3FB0000000000000uL, 0x3FEFF621E3796D7EuL, 0xBC6C57BC20000000uL},
     {0x3F76C32BACA2AE69uL, 0x3FA0000000000000uL, 0x3FEFFA72EFFEF75DuL, 0xBC88B4CDC0000000uL},
     {0xBF7B7AA821726608uL, 0x3FA0000000000000uL, 0x3FEFFD886084CD0DuL, 0xBC81354D40000000uL},
     {0xBF6B78B80C84E1EEuL, 0x3F90000000000000uL, 0x3FEFFF62169B92DBuL, 0x3C85DDA3C0000000uL},
     },
    0x7FFFFFFFFFFFFFFFuL,
    0x40F000000E4DB24CuL,
    0x7FF0000000000000uL,
    0x40545F306DC9C883uL,
    0x4338000000000000uL,
    0x00000000000001FFuL,
    0x3F8921FB54400000uL,
    0x3D60B4611A600000uL,
    0x3B33198A2E037073uL,
    0xBFC5555555554448uL,
    0x3F81110FABB3551CuL,
    0xBFE0000000000000uL,
    0x3FA5555555554CCFuL,
    0xBF56C16AB163B2D7uL,
};

typedef struct
{
    unsigned long _dAbsMask;
    unsigned long _dRangeVal;
    unsigned long _dHalfPI;
    unsigned long _dInvPI;
    unsigned long _dRShifter;
    unsigned long _dOneHalf;
    unsigned long _dPI1;
    unsigned long _dPI2;
    unsigned long _dPI3;
    unsigned long _dPI4;
    unsigned long _dPI1_FMA;
    unsigned long _dPI2_FMA;
    unsigned long _dPI3_FMA;
    unsigned long _dC1;
    unsigned long _dC2_0;
    unsigned long _dC2;
    unsigned long _dC3;
    unsigned long _dC4;
    unsigned long _dC5;
    unsigned long _dC6;
    unsigned long _dC7;
    unsigned long _dOne;

    unsigned long _dAbsMask_la;
    unsigned long _dInvPI_la;
    unsigned long _dRShifter_la;
    unsigned long _dRShifterm5_la;
    unsigned long _dRXmax_la;
    unsigned long _dZThres;

} __internal_dcos_la_data_t;
static __constant __internal_dcos_la_data_t __internal_dcos_la_data = {

    0x7FFFFFFFFFFFFFFFuL,
    0x4160000000000000uL,
    0x3FF921FB54442D18uL,
    0x3FD45F306DC9C883uL,
    0x4338000000000000uL,
    0x3FE0000000000000uL,

    0x400921FB40000000uL,
    0x3E84442D00000000uL,
    0x3D08469880000000uL,
    0x3B88CC51701B839AuL,

    0x400921fb54442d18uL,
    0x3ca1a62633145c06uL,
    0x395c1cd129024e09uL,

    0xbfc55555555554a7uL,
    0x3f8111111110a4a7uL,
    0x3f8111111110a4a8uL,
    0xbf2a01a019a5b87buL,
    0x3ec71de38030fea0uL,
    0xbe5ae63546002231uL,
    0x3de60e6857a2f220uL,
    0xbd69f0d60811aac8uL,
    0x3ff0000000000000uL,

    0x7FFFFFFFFFFFFFFFuL,
    0x3FD45F306DC9C883uL,
    0x4330000000000000uL,
    0x432FFFFFFFFFFFFFuL,
    0x43300000007FFFFEuL,
    0x3e40000000000000uL,
};

static __constant _iml_v2_dp_union_t __dcos_la_CoutTab[2] = {
    0x00000000, 0x00000000,
    0x00000000, 0x7FF00000
};

__attribute__((always_inline))
inline int __internal_dcos_la_cout (double *a, double *r)
{
    int nRet = 0;
    double absx;

    absx = (*a);
    (((_iml_v2_dp_union_t *) & absx)->dwords.hi_dword = (((_iml_v2_dp_union_t *) & absx)->dwords.hi_dword & 0x7FFFFFFF) | ((_iml_uint32_t) (0) << 31));

    if (!((((((_iml_v2_dp_union_t *) & (*a))->dwords.hi_dword >> 20) & 0x7FF) != 0x7FF)))
    {
        if ((((_iml_v2_dp_union_t *) & (absx))->hex[0] == ((__constant _iml_v2_dp_union_t *) & (((__constant double *) __dcos_la_CoutTab)[1]))->hex[0])
            && (((_iml_v2_dp_union_t *) & (absx))->hex[1] == ((__constant _iml_v2_dp_union_t *) & (((__constant double *) __dcos_la_CoutTab)[1]))->hex[1]))
        {

            (*r) = (*a) * ((__constant double *) __dcos_la_CoutTab)[0];

            nRet = 1;
            return nRet;
        }
        else
        {

            (*r) = (*a) * (*a);
            return nRet;
        }
    }
    return nRet;
}

double __ocl_svml_cos (double a)
{

    double va1;
    double vr1;
    unsigned int vm;

    double r;

    va1 = a;;

    {

        double dX;
        double dX0;
        double dReductionRangeMask;
        unsigned long lReductionRangeMask;
        unsigned int mReductionRangeMask;
        double dRangeMask;
        unsigned long lRangeMask;
        double dN;
        double dY;
        unsigned long lY;
        unsigned long lIndex;
        double dMLo;
        double dZ;
        double dZp2;
        double dZ1;
        double dE;
        double dPS;
        double dPC;
        double dZSigma;
        double dMed;
        double dResInt;
        double dD;
        double dCorr;
        double dK0;
        double dK1;
        double dK2;
        double dK3;
        double dResHi;
        double dResLo;
        double dXAddHalfPi;
        double dSignRes;
        double dR;
        double dRp2;
        double dPoly;

        double dAbsMask;
        double dReductionRangeVal;
        double dRangeVal;
        double dPIu;
        unsigned long lIndexMask;
        double dPIoHi;
        double dPIoLo;
        double dPIoTail;
        double dSigma;
        double dCHL;
        double dSHi;
        double dSLo;
        double dS1;
        double dS2;
        double dRShifter;
        double dOneHalf;
        double dHalfPI;
        double dInvPI;
        double dPI1;
        double dPI2;
        double dPI3;
        double dPI4;
        double dC1;
        double dC2;
        double dC3;
        double dC4;
        double dC5;
        double dC6;
        double dC7;

        double dNearZero;
        double dOne;
        double dR3;

        vm = 0;
        dAbsMask = as_double (__internal_dcos_la_data._dAbsMask);
        dReductionRangeVal = as_double (__internal_dcos_la_data._dRangeVal);
        dHalfPI = as_double (__internal_dcos_la_data._dHalfPI);
        dX0 = as_double ((as_ulong (va1) & as_ulong (dAbsMask)));

        dXAddHalfPi = (dHalfPI - dX0);

        dNearZero = as_double ((unsigned long) ((dXAddHalfPi == dHalfPI) ? 0xffffffffffffffff : 0x0));

        dX = as_double ((as_ulong (dXAddHalfPi) & as_ulong (dAbsMask)));

        dReductionRangeMask = as_double ((unsigned long) (((!(dX <= dReductionRangeVal)) ? 0xffffffffffffffff : 0x0)));
        lReductionRangeMask = as_ulong (dReductionRangeMask);
        dInvPI = as_double (__internal_dcos_la_data._dInvPI);
        dRShifter = as_double (__internal_dcos_la_data._dRShifter);

        dY = __spirv_ocl_fma(dXAddHalfPi,dInvPI,dRShifter);

        dN = (dY - dRShifter);
        dOneHalf = as_double (__internal_dcos_la_data._dOneHalf);

        dN = (dOneHalf - dN);

        dSignRes = as_double (((unsigned long) as_ulong (dY) << (63)));

        dPI1 = as_double (__internal_dcos_la_data._dPI1);

        dR = __spirv_ocl_fma(dN,dPI1,-(dX0));
        dPI2 = as_double (__internal_dcos_la_data._dPI2);

        dR = __spirv_ocl_fma(dN,dPI2,dR);
        dPI3 = as_double (__internal_dcos_la_data._dPI3);

        dR = __spirv_ocl_fma(dN,dPI3,dR);

        dPI4 = as_double (__internal_dcos_la_data._dPI4);
        dR = __spirv_ocl_fma(dN,dPI4,dR);
        dRp2 = (dR * dR);

        dR = as_double ((as_ulong (dR) ^ as_ulong (dSignRes)));

        dC7 = as_double (__internal_dcos_la_data._dC7);
        dC6 = as_double (__internal_dcos_la_data._dC6);
        dPoly = __spirv_ocl_fma(dC7,dRp2,dC6);
        dC5 = as_double (__internal_dcos_la_data._dC5);
        dPoly = __spirv_ocl_fma(dPoly,dRp2,dC5);
        dC4 = as_double (__internal_dcos_la_data._dC4);
        dPoly = __spirv_ocl_fma(dPoly,dRp2,dC4);
        dC3 = as_double (__internal_dcos_la_data._dC3);

        dPoly = __spirv_ocl_fma(dPoly,dRp2,dC3);
        dC2 = as_double (__internal_dcos_la_data._dC2);
        dPoly = __spirv_ocl_fma(dPoly,dRp2,dC2);
        dC1 = as_double (__internal_dcos_la_data._dC1);
        dPoly = __spirv_ocl_fma(dPoly,dRp2,dC1);
        dR3 = (dRp2 * dR);
        vr1 = __spirv_ocl_fma(dPoly,dR3,dR);

        dOne = as_double (__internal_dcos_la_data._dOne);
        vr1 = as_double ((((~as_ulong (dNearZero)) & as_ulong (vr1)) | (as_ulong (dNearZero) & as_ulong (dOne))));
        mReductionRangeMask = 0;
        mReductionRangeMask = lReductionRangeMask;
        if ((mReductionRangeMask) != 0)
        {
            double dResLarge;

            dRangeVal = as_double (__internal_dcos_la_data_ha._dRangeVal);

            dX = as_double ((as_ulong (dRangeVal) & as_ulong (dX)));
            dRangeMask = as_double ((unsigned long) ((dX == dRangeVal) ? 0xffffffffffffffff : 0x0));
            lRangeMask = as_ulong (dRangeMask);
            vm = 0;
            vm = lRangeMask;

            {

                double dExponent;
                unsigned long lInput;
                unsigned long lExponent;
                unsigned long lSignificand;

                unsigned long lIntegerBit;

                double dP_hi;
                double dP_med;
                double dP_lo;

                unsigned long lP_hi;
                unsigned long lP_med;
                unsigned long lP_lo;

                unsigned long lLowMask;

                unsigned long lP5;
                unsigned long lP4;
                unsigned long lP3;
                unsigned long lP2;
                unsigned long lP1;
                unsigned long lP0;

                unsigned long lM1;
                unsigned long lM0;

                unsigned long lM15;
                unsigned long lM14;
                unsigned long lM13;
                unsigned long lM12;
                unsigned long lM11;
                unsigned long lM10;
                unsigned long lM05;
                unsigned long lM04;
                unsigned long lM03;
                unsigned long lM02;
                unsigned long lM01;
                unsigned long lM00;

                unsigned long lN14;
                unsigned long lN13;
                unsigned long lN12;
                unsigned long lN11;

                unsigned long lP15;
                unsigned long lP14;
                unsigned long lP13;
                unsigned long lP12;
                unsigned long lP11;

                unsigned long lQ14;
                unsigned long lQ13;
                unsigned long lQ12;
                unsigned long lQ11;

                unsigned long lReducedHi;
                unsigned long lReducedMed;
                unsigned long lReducedLo;

                unsigned long lRoundBump;
                unsigned long lShiftedN;
                unsigned long lNMask;

                double dReducedHi;
                double dReducedMed;
                double dReducedLo;

                unsigned long lExponentPart;
                unsigned long lShiftedSig;

                double dShifter;
                double dIntegerPart;

                double dRHi;
                double dRLo;
                unsigned long lSignBit;

                double d2pi_full;
                double d2pi_lead;
                double d2pi_trail;

                double dLeadmask;
                double dRHi_lead;
                double dRHi_trail;

                double dPir1;
                double dPir2;
                double dPir3;
                double dPir4;
                double dPir12;
                double dPir34;
                double dRedPreHi;
                double dRedHi;
                double dRedLo;

                double dMinInput;
                double dAbs;
                double dMultiplex;
                double dNotMultiplex;
                double dMultiplexedInput;
                double dMultiplexedOutput;

                lInput = as_ulong (va1);

                lExponent = 0x7ff0000000000000uL;;
                lExponent = (lExponent & lInput);
                lExponent = ((unsigned long) (lExponent) >> (52));

                dP_hi =
                    as_double (((__constant unsigned long *) (__internal_dsincos_la_reduction_data._dPtable))[(((0 + lExponent) * (3 * 8)) >> (3)) + 0]);
                dP_med =
                    as_double (((__constant unsigned long *) (__internal_dsincos_la_reduction_data._dPtable))[(((0 + lExponent) * (3 * 8)) >> (3)) + 1]);
                dP_lo =
                    as_double (((__constant unsigned long *) (__internal_dsincos_la_reduction_data._dPtable))[(((0 + lExponent) * (3 * 8)) >> (3)) + 2]);

                lP_hi = as_ulong (dP_hi);
                lP_med = as_ulong (dP_med);
                lP_lo = as_ulong (dP_lo);

                lSignificand = 0x000fffffffffffffuL;;
                lIntegerBit = 0x0010000000000000uL;
                lSignificand = (lSignificand & lInput);
                lSignificand = (lSignificand + lIntegerBit);

                lLowMask = 0x00000000FFFFFFFFuL;
                lP5 = ((unsigned long) (lP_hi) >> (32));
                lP4 = (lP_hi & lLowMask);
                lP3 = ((unsigned long) (lP_med) >> (32));
                lP2 = (lP_med & lLowMask);
                lP1 = ((unsigned long) (lP_lo) >> (32));
                lP0 = (lP_lo & lLowMask);
                lM1 = ((unsigned long) (lSignificand) >> (32));
                lM0 = (lSignificand & lLowMask);

                lM15 = (lM1 * lP5);
                lM14 = (lM1 * lP4);
                lM13 = (lM1 * lP3);
                lM12 = (lM1 * lP2);
                lM11 = (lM1 * lP1);
                lM10 = (lM1 * lP0);
                lM05 = (lM0 * lP5);
                lM04 = (lM0 * lP4);
                lM03 = (lM0 * lP3);
                lM02 = (lM0 * lP2);
                lM01 = (lM0 * lP1);
                lM00 = (lM0 * lP0);

                lN11 = ((unsigned long) (lM01) >> (32));
                lN12 = ((unsigned long) (lM02) >> (32));
                lN13 = ((unsigned long) (lM03) >> (32));
                lN14 = ((unsigned long) (lM04) >> (32));

                lN11 = (lM11 + lN11);
                lN12 = (lM12 + lN12);
                lN13 = (lM13 + lN13);
                lN14 = (lM14 + lN14);

                lP11 = (lM02 & lLowMask);
                lP12 = (lM03 & lLowMask);
                lP13 = (lM04 & lLowMask);
                lP14 = (lM05 & lLowMask);
                lP15 = ((unsigned long) (lM05) >> (32));

                lP11 = (lP11 + lN11);
                lP12 = (lP12 + lN12);
                lP13 = (lP13 + lN13);
                lP14 = (lP14 + lN14);
                lP15 = (lP15 + lM15);

                lQ11 = ((unsigned long) (lM10) >> (32));
                lQ11 = (lQ11 + lP11);

                lQ12 = ((unsigned long) (lQ11) >> (32));
                lQ12 = (lQ12 + lP12);

                lQ13 = ((unsigned long) (lQ12) >> (32));
                lQ13 = (lQ13 + lP13);

                lQ14 = ((unsigned long) (lQ13) >> (32));
                lQ14 = (lQ14 + lP14);

                lQ11 = (lQ11 & lLowMask);
                lQ13 = (lQ13 & lLowMask);

                lReducedHi = ((unsigned long) (lQ14) << (32));
                lReducedLo = ((unsigned long) (lQ12) << (32));

                lReducedHi = (lReducedHi + lQ13);
                lReducedLo = (lReducedLo + lQ11);

                lSignBit = 0x8000000000000000uL;;
                lSignBit = (lSignBit & lInput);

                lExponentPart = 0x3FF0000000000000uL;
                lExponentPart = (lSignBit ^ lExponentPart);
                lShiftedSig = ((unsigned long) (lReducedHi) >> (12));
                lShiftedSig = (lShiftedSig | lExponentPart);
                dReducedHi = as_double (lShiftedSig);
                dShifter = as_double (0x42A8000000000000uL);
                dIntegerPart = (dShifter + dReducedHi);
                dN = (dIntegerPart - dShifter);
                dReducedHi = (dReducedHi - dN);

                lIndex = as_ulong (dIntegerPart);
                lNMask = 0x00000000000001FFuL;
                lIndex = (lIndex & lNMask);
                lExponentPart = 0x3970000000000000uL;
                lExponentPart = (lSignBit ^ lExponentPart);
                lShiftedSig = 0x0000000000FFFFFFuL;
                lShiftedSig = (lShiftedSig & lReducedLo);
                lShiftedSig = ((unsigned long) (lShiftedSig) << (28));
                lShiftedSig = (lShiftedSig | lExponentPart);
                dReducedLo = as_double (lShiftedSig);
                dShifter = as_double (lExponentPart);
                dReducedLo = (dReducedLo - dShifter);

                lExponentPart = 0x3CB0000000000000uL;
                lExponentPart = (lSignBit ^ lExponentPart);
                lShiftedSig = 0x0000000000000FFFuL;
                lShiftedSig = (lShiftedSig & lReducedHi);
                lShiftedSig = ((unsigned long) (lShiftedSig) << (40));
                lReducedLo = ((unsigned long) (lReducedLo) >> (24));
                lShiftedSig = (lShiftedSig | lReducedLo);
                lShiftedSig = (lShiftedSig | lExponentPart);
                dReducedMed = as_double (lShiftedSig);
                dShifter = as_double (lExponentPart);
                dReducedMed = (dReducedMed - dShifter);

                dRHi = (dReducedHi + dReducedMed);
                dReducedHi = (dReducedHi - dRHi);
                dReducedMed = (dReducedMed + dReducedHi);
                dRLo = (dReducedMed + dReducedLo);
                d2pi_full = as_double (0x401921FB54442D18uL);
                d2pi_lead = as_double (0x401921FB54000000uL);
                d2pi_trail = as_double (0x3E310B4611A62633uL);

                dLeadmask = as_double (0xFFFFFFFFF8000000uL);
                dRHi_lead = as_double ((as_ulong (dRHi) & as_ulong (dLeadmask)));
                dRHi_trail = (dRHi - dRHi_lead);

                dRedPreHi = (d2pi_lead * dRHi_lead);
                dPir1 = (d2pi_lead * dRHi_trail);
                dPir2 = (d2pi_trail * dRHi_lead);
                dPir3 = (d2pi_full * dRLo);
                dPir4 = (d2pi_trail * dRHi_trail);

                dPir12 = (dPir1 + dPir2);
                dPir34 = (dPir3 + dPir4);
                dRedLo = (dPir12 + dPir34);

                dRedHi = (dRedPreHi + dRedLo);
                dRedPreHi = (dRedPreHi - dRedHi);
                dRedLo = (dRedPreHi + dRedLo);
                dAbsMask = as_double (0x7FFFFFFFFFFFFFFFuL);
                dMinInput = as_double (0x3EB0000000000000uL);
                dAbs = as_double ((as_ulong (va1) & as_ulong (dAbsMask)));
                dMultiplex = as_double ((unsigned long) ((dAbs > dMinInput) ? 0xffffffffffffffff : 0x0));
                dNotMultiplex = as_double ((unsigned long) ((dAbs <= dMinInput) ? 0xffffffffffffffff : 0x0));

                dMultiplexedInput = as_double ((as_ulong (dNotMultiplex) & as_ulong (va1)));
                dMultiplexedOutput = as_double ((as_ulong (dMultiplex) & as_ulong (dRedHi)));
                dZ = as_double ((as_ulong (dMultiplexedInput) | as_ulong (dMultiplexedOutput)));

                dE = as_double ((as_ulong (dMultiplex) & as_ulong (dRedLo)));

            }

            dCHL = as_double (((__constant unsigned long *) (__internal_dcos_la_data_ha._dT))[(((0 + lIndex) * (4 * 8)) >> (3)) + 0]);
            dSHi = as_double (((__constant unsigned long *) (__internal_dcos_la_data_ha._dT))[(((0 + lIndex) * (4 * 8)) >> (3)) + 2]);
            dSigma = as_double (((__constant unsigned long *) (__internal_dcos_la_data_ha._dT))[(((0 + lIndex) * (4 * 8)) >> (3)) + 1]);

            dMed = (dCHL * dZ);
            dZSigma = (dZ * dSigma);
            dResInt = (dSHi + dZSigma);
            dResHi = (dMed + dResInt);

            dK0 = (dSHi - dResInt);
            dK2 = (dK0 + dZSigma);
            dK1 = (dResInt - dResHi);
            dK3 = (dK1 + dMed);
            dResLo = (dK3 + dK2);
            dZp2 = (dZ * dZ);

            dS2 = as_double (__internal_dcos_la_data_ha._dS2);
            dS1 = as_double (__internal_dcos_la_data_ha._dS1);

            dPS = __spirv_ocl_fma(dS2,dZp2,dS1);

            dPS = (dPS * dZp2);

            dPS = (dPS * dZ);

            dD = (dCHL + dSigma);

            dResLo = __spirv_ocl_fma(dPS,dD,dResLo);

            dC3 = as_double (__internal_dcos_la_data_ha._dC3);
            dC2 = as_double (__internal_dcos_la_data_ha._dC2);

            dPC = __spirv_ocl_fma(dC3,dZp2,dC2);
            dC1 = as_double (__internal_dcos_la_data_ha._dC1);

            dPC = __spirv_ocl_fma(dPC,dZp2,dC1);

            dPC = (dPC * dZp2);

            dResLo = __spirv_ocl_fma(dPC,dSHi,dResLo);

            dD = __spirv_ocl_fma(-(dZ),dSHi,dD);
            dSLo = as_double (((__constant unsigned long *) (__internal_dcos_la_data_ha._dT))[(((0 + lIndex) * (4 * 8)) >> (3)) + 3]);

            dCorr = __spirv_ocl_fma(dE,dD,dSLo);

            dResLo = (dResLo + dCorr);

            dResLarge = (dResHi + dResLo);

            vr1 = as_double ((((~as_ulong (dReductionRangeMask)) & as_ulong (vr1)) | (as_ulong (dReductionRangeMask) & as_ulong (dResLarge))));

        }
    }

    if ((vm) != 0)
    {
        double _vapi_arg1[1];
        double _vapi_res1[1];
        ((double *) _vapi_arg1)[0] = va1;
        ((double *) _vapi_res1)[0] = vr1;
        __internal_dcos_la_cout (_vapi_arg1, _vapi_res1);
        vr1 = ((double *) _vapi_res1)[0];
    };
    r = vr1;;

    return r;

}
