// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkfirewall

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateFirewallPolicy = "AssociateFirewallPolicy"

// AssociateFirewallPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AssociateFirewallPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateFirewallPolicy for more information on using the AssociateFirewallPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateFirewallPolicyRequest method.
//    req, resp := client.AssociateFirewallPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateFirewallPolicy
func (c *NetworkFirewall) AssociateFirewallPolicyRequest(input *AssociateFirewallPolicyInput) (req *request.Request, output *AssociateFirewallPolicyOutput) {
	op := &request.Operation{
		Name:       opAssociateFirewallPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateFirewallPolicyInput{}
	}

	output = &AssociateFirewallPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateFirewallPolicy API operation for AWS Network Firewall.
//
// Associates a FirewallPolicy to a Firewall.
//
// A firewall policy defines how to monitor and manage your VPC network traffic,
// using a collection of inspection rule groups and other settings. Each firewall
// requires one firewall policy association, and you can use the same firewall
// policy for multiple firewalls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation AssociateFirewallPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InvalidTokenException
//   The token you provided is stale or isn't valid for the operation.
//
//   * InvalidOperationException
//   The operation failed because it's not valid. For example, you might have
//   tried to delete a rule group or firewall policy that's in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateFirewallPolicy
func (c *NetworkFirewall) AssociateFirewallPolicy(input *AssociateFirewallPolicyInput) (*AssociateFirewallPolicyOutput, error) {
	req, out := c.AssociateFirewallPolicyRequest(input)
	return out, req.Send()
}

// AssociateFirewallPolicyWithContext is the same as AssociateFirewallPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateFirewallPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) AssociateFirewallPolicyWithContext(ctx aws.Context, input *AssociateFirewallPolicyInput, opts ...request.Option) (*AssociateFirewallPolicyOutput, error) {
	req, out := c.AssociateFirewallPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSubnets = "AssociateSubnets"

// AssociateSubnetsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSubnets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSubnets for more information on using the AssociateSubnets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateSubnetsRequest method.
//    req, resp := client.AssociateSubnetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateSubnets
func (c *NetworkFirewall) AssociateSubnetsRequest(input *AssociateSubnetsInput) (req *request.Request, output *AssociateSubnetsOutput) {
	op := &request.Operation{
		Name:       opAssociateSubnets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSubnetsInput{}
	}

	output = &AssociateSubnetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateSubnets API operation for AWS Network Firewall.
//
// Associates the specified subnets in the Amazon VPC to the firewall. You can
// specify one subnet for each of the Availability Zones that the VPC spans.
//
// This request creates an AWS Network Firewall firewall endpoint in each of
// the subnets. To enable the firewall's protections, you must also modify the
// VPC's route tables for each subnet's Availability Zone, to redirect the traffic
// that's coming into and going out of the zone through the firewall endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation AssociateSubnets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InvalidTokenException
//   The token you provided is stale or isn't valid for the operation.
//
//   * InvalidOperationException
//   The operation failed because it's not valid. For example, you might have
//   tried to delete a rule group or firewall policy that's in use.
//
//   * InsufficientCapacityException
//   AWS doesn't currently have enough available capacity to fulfill your request.
//   Try your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateSubnets
func (c *NetworkFirewall) AssociateSubnets(input *AssociateSubnetsInput) (*AssociateSubnetsOutput, error) {
	req, out := c.AssociateSubnetsRequest(input)
	return out, req.Send()
}

// AssociateSubnetsWithContext is the same as AssociateSubnets with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSubnets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) AssociateSubnetsWithContext(ctx aws.Context, input *AssociateSubnetsInput, opts ...request.Option) (*AssociateSubnetsOutput, error) {
	req, out := c.AssociateSubnetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFirewall = "CreateFirewall"

// CreateFirewallRequest generates a "aws/request.Request" representing the
// client's request for the CreateFirewall operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFirewall for more information on using the CreateFirewall
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFirewallRequest method.
//    req, resp := client.CreateFirewallRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewall
func (c *NetworkFirewall) CreateFirewallRequest(input *CreateFirewallInput) (req *request.Request, output *CreateFirewallOutput) {
	op := &request.Operation{
		Name:       opCreateFirewall,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFirewallInput{}
	}

	output = &CreateFirewallOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFirewall API operation for AWS Network Firewall.
//
// Creates an AWS Network Firewall Firewall and accompanying FirewallStatus
// for a VPC.
//
// The firewall defines the configuration settings for an AWS Network Firewall
// firewall. The settings that you can define at creation include the firewall
// policy, the subnets in your VPC to use for the firewall endpoints, and any
// tags that are attached to the firewall AWS resource.
//
// After you create a firewall, you can provide additional settings, like the
// logging configuration.
//
// To update the settings for a firewall, you use the operations that apply
// to the settings themselves, for example UpdateLoggingConfiguration, AssociateSubnets,
// and UpdateFirewallDeleteProtection.
//
// To manage a firewall's tags, use the standard AWS resource tagging operations,
// ListTagsForResource, TagResource, and UntagResource.
//
// To retrieve information about firewalls, use ListFirewalls and DescribeFirewall.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation CreateFirewall for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * LimitExceededException
//   Unable to perform the operation because doing so would violate a limit setting.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InsufficientCapacityException
//   AWS doesn't currently have enough available capacity to fulfill your request.
//   Try your request later.
//
//   * InvalidOperationException
//   The operation failed because it's not valid. For example, you might have
//   tried to delete a rule group or firewall policy that's in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewall
func (c *NetworkFirewall) CreateFirewall(input *CreateFirewallInput) (*CreateFirewallOutput, error) {
	req, out := c.CreateFirewallRequest(input)
	return out, req.Send()
}

// CreateFirewallWithContext is the same as CreateFirewall with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFirewall for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) CreateFirewallWithContext(ctx aws.Context, input *CreateFirewallInput, opts ...request.Option) (*CreateFirewallOutput, error) {
	req, out := c.CreateFirewallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFirewallPolicy = "CreateFirewallPolicy"

// CreateFirewallPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateFirewallPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFirewallPolicy for more information on using the CreateFirewallPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFirewallPolicyRequest method.
//    req, resp := client.CreateFirewallPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewallPolicy
func (c *NetworkFirewall) CreateFirewallPolicyRequest(input *CreateFirewallPolicyInput) (req *request.Request, output *CreateFirewallPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateFirewallPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFirewallPolicyInput{}
	}

	output = &CreateFirewallPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFirewallPolicy API operation for AWS Network Firewall.
//
// Creates the firewall policy for the firewall according to the specifications.
//
// An AWS Network Firewall firewall policy defines the behavior of a firewall,
// in a collection of stateless and stateful rule groups and other settings.
// You can use one firewall policy for multiple firewalls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation CreateFirewallPolicy for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   Unable to perform the operation because doing so would violate a limit setting.
//
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * InsufficientCapacityException
//   AWS doesn't currently have enough available capacity to fulfill your request.
//   Try your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewallPolicy
func (c *NetworkFirewall) CreateFirewallPolicy(input *CreateFirewallPolicyInput) (*CreateFirewallPolicyOutput, error) {
	req, out := c.CreateFirewallPolicyRequest(input)
	return out, req.Send()
}

// CreateFirewallPolicyWithContext is the same as CreateFirewallPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFirewallPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) CreateFirewallPolicyWithContext(ctx aws.Context, input *CreateFirewallPolicyInput, opts ...request.Option) (*CreateFirewallPolicyOutput, error) {
	req, out := c.CreateFirewallPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRuleGroup = "CreateRuleGroup"

// CreateRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRuleGroup for more information on using the CreateRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRuleGroupRequest method.
//    req, resp := client.CreateRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateRuleGroup
func (c *NetworkFirewall) CreateRuleGroupRequest(input *CreateRuleGroupInput) (req *request.Request, output *CreateRuleGroupOutput) {
	op := &request.Operation{
		Name:       opCreateRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleGroupInput{}
	}

	output = &CreateRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRuleGroup API operation for AWS Network Firewall.
//
// Creates the specified stateless or stateful rule group, which includes the
// rules for network traffic inspection, a capacity setting, and tags.
//
// You provide your rule group specification in your request using either RuleGroup
// or Rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation CreateRuleGroup for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   Unable to perform the operation because doing so would violate a limit setting.
//
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * InsufficientCapacityException
//   AWS doesn't currently have enough available capacity to fulfill your request.
//   Try your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateRuleGroup
func (c *NetworkFirewall) CreateRuleGroup(input *CreateRuleGroupInput) (*CreateRuleGroupOutput, error) {
	req, out := c.CreateRuleGroupRequest(input)
	return out, req.Send()
}

// CreateRuleGroupWithContext is the same as CreateRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) CreateRuleGroupWithContext(ctx aws.Context, input *CreateRuleGroupInput, opts ...request.Option) (*CreateRuleGroupOutput, error) {
	req, out := c.CreateRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFirewall = "DeleteFirewall"

// DeleteFirewallRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFirewall operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFirewall for more information on using the DeleteFirewall
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFirewallRequest method.
//    req, resp := client.DeleteFirewallRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewall
func (c *NetworkFirewall) DeleteFirewallRequest(input *DeleteFirewallInput) (req *request.Request, output *DeleteFirewallOutput) {
	op := &request.Operation{
		Name:       opDeleteFirewall,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFirewallInput{}
	}

	output = &DeleteFirewallOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFirewall API operation for AWS Network Firewall.
//
// Deletes the specified Firewall and its FirewallStatus. This operation requires
// the firewall's DeleteProtection flag to be FALSE. You can't revert this operation.
//
// You can check whether a firewall is in use by reviewing the route tables
// for the Availability Zones where you have firewall subnet mappings. Retrieve
// the subnet mappings by calling DescribeFirewall. You define and update the
// route tables through Amazon VPC. As needed, update the route tables for the
// zones to remove the firewall endpoints. When the route tables no longer use
// the firewall endpoints, you can remove the firewall safely.
//
// To delete a firewall, remove the delete protection if you need to using UpdateFirewallDeleteProtection,
// then delete the firewall by calling DeleteFirewall.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation DeleteFirewall for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * UnsupportedOperationException
//   The operation you requested isn't supported by Network Firewall.
//
//   * InvalidOperationException
//   The operation failed because it's not valid. For example, you might have
//   tried to delete a rule group or firewall policy that's in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewall
func (c *NetworkFirewall) DeleteFirewall(input *DeleteFirewallInput) (*DeleteFirewallOutput, error) {
	req, out := c.DeleteFirewallRequest(input)
	return out, req.Send()
}

// DeleteFirewallWithContext is the same as DeleteFirewall with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFirewall for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) DeleteFirewallWithContext(ctx aws.Context, input *DeleteFirewallInput, opts ...request.Option) (*DeleteFirewallOutput, error) {
	req, out := c.DeleteFirewallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFirewallPolicy = "DeleteFirewallPolicy"

// DeleteFirewallPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFirewallPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFirewallPolicy for more information on using the DeleteFirewallPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFirewallPolicyRequest method.
//    req, resp := client.DeleteFirewallPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewallPolicy
func (c *NetworkFirewall) DeleteFirewallPolicyRequest(input *DeleteFirewallPolicyInput) (req *request.Request, output *DeleteFirewallPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteFirewallPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFirewallPolicyInput{}
	}

	output = &DeleteFirewallPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFirewallPolicy API operation for AWS Network Firewall.
//
// Deletes the specified FirewallPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation DeleteFirewallPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * UnsupportedOperationException
//   The operation you requested isn't supported by Network Firewall.
//
//   * InvalidOperationException
//   The operation failed because it's not valid. For example, you might have
//   tried to delete a rule group or firewall policy that's in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewallPolicy
func (c *NetworkFirewall) DeleteFirewallPolicy(input *DeleteFirewallPolicyInput) (*DeleteFirewallPolicyOutput, error) {
	req, out := c.DeleteFirewallPolicyRequest(input)
	return out, req.Send()
}

// DeleteFirewallPolicyWithContext is the same as DeleteFirewallPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFirewallPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) DeleteFirewallPolicyWithContext(ctx aws.Context, input *DeleteFirewallPolicyInput, opts ...request.Option) (*DeleteFirewallPolicyOutput, error) {
	req, out := c.DeleteFirewallPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourcePolicyRequest method.
//    req, resp := client.DeleteResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteResourcePolicy
func (c *NetworkFirewall) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourcePolicy API operation for AWS Network Firewall.
//
// Deletes a resource policy that you created in a PutResourcePolicy request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InvalidResourcePolicyException
//   The policy statement failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteResourcePolicy
func (c *NetworkFirewall) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRuleGroup = "DeleteRuleGroup"

// DeleteRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRuleGroup for more information on using the DeleteRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRuleGroupRequest method.
//    req, resp := client.DeleteRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteRuleGroup
func (c *NetworkFirewall) DeleteRuleGroupRequest(input *DeleteRuleGroupInput) (req *request.Request, output *DeleteRuleGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleGroupInput{}
	}

	output = &DeleteRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRuleGroup API operation for AWS Network Firewall.
//
// Deletes the specified RuleGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation DeleteRuleGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * UnsupportedOperationException
//   The operation you requested isn't supported by Network Firewall.
//
//   * InvalidOperationException
//   The operation failed because it's not valid. For example, you might have
//   tried to delete a rule group or firewall policy that's in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteRuleGroup
func (c *NetworkFirewall) DeleteRuleGroup(input *DeleteRuleGroupInput) (*DeleteRuleGroupOutput, error) {
	req, out := c.DeleteRuleGroupRequest(input)
	return out, req.Send()
}

// DeleteRuleGroupWithContext is the same as DeleteRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) DeleteRuleGroupWithContext(ctx aws.Context, input *DeleteRuleGroupInput, opts ...request.Option) (*DeleteRuleGroupOutput, error) {
	req, out := c.DeleteRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFirewall = "DescribeFirewall"

// DescribeFirewallRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFirewall operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFirewall for more information on using the DescribeFirewall
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFirewallRequest method.
//    req, resp := client.DescribeFirewallRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewall
func (c *NetworkFirewall) DescribeFirewallRequest(input *DescribeFirewallInput) (req *request.Request, output *DescribeFirewallOutput) {
	op := &request.Operation{
		Name:       opDescribeFirewall,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFirewallInput{}
	}

	output = &DescribeFirewallOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFirewall API operation for AWS Network Firewall.
//
// Returns the data objects for the specified firewall.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation DescribeFirewall for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewall
func (c *NetworkFirewall) DescribeFirewall(input *DescribeFirewallInput) (*DescribeFirewallOutput, error) {
	req, out := c.DescribeFirewallRequest(input)
	return out, req.Send()
}

// DescribeFirewallWithContext is the same as DescribeFirewall with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFirewall for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) DescribeFirewallWithContext(ctx aws.Context, input *DescribeFirewallInput, opts ...request.Option) (*DescribeFirewallOutput, error) {
	req, out := c.DescribeFirewallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFirewallPolicy = "DescribeFirewallPolicy"

// DescribeFirewallPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFirewallPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFirewallPolicy for more information on using the DescribeFirewallPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFirewallPolicyRequest method.
//    req, resp := client.DescribeFirewallPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallPolicy
func (c *NetworkFirewall) DescribeFirewallPolicyRequest(input *DescribeFirewallPolicyInput) (req *request.Request, output *DescribeFirewallPolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeFirewallPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFirewallPolicyInput{}
	}

	output = &DescribeFirewallPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFirewallPolicy API operation for AWS Network Firewall.
//
// Returns the data objects for the specified firewall policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation DescribeFirewallPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallPolicy
func (c *NetworkFirewall) DescribeFirewallPolicy(input *DescribeFirewallPolicyInput) (*DescribeFirewallPolicyOutput, error) {
	req, out := c.DescribeFirewallPolicyRequest(input)
	return out, req.Send()
}

// DescribeFirewallPolicyWithContext is the same as DescribeFirewallPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFirewallPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) DescribeFirewallPolicyWithContext(ctx aws.Context, input *DescribeFirewallPolicyInput, opts ...request.Option) (*DescribeFirewallPolicyOutput, error) {
	req, out := c.DescribeFirewallPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLoggingConfiguration = "DescribeLoggingConfiguration"

// DescribeLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoggingConfiguration for more information on using the DescribeLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLoggingConfigurationRequest method.
//    req, resp := client.DescribeLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeLoggingConfiguration
func (c *NetworkFirewall) DescribeLoggingConfigurationRequest(input *DescribeLoggingConfigurationInput) (req *request.Request, output *DescribeLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoggingConfigurationInput{}
	}

	output = &DescribeLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLoggingConfiguration API operation for AWS Network Firewall.
//
// Returns the logging configuration for the specified firewall.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation DescribeLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeLoggingConfiguration
func (c *NetworkFirewall) DescribeLoggingConfiguration(input *DescribeLoggingConfigurationInput) (*DescribeLoggingConfigurationOutput, error) {
	req, out := c.DescribeLoggingConfigurationRequest(input)
	return out, req.Send()
}

// DescribeLoggingConfigurationWithContext is the same as DescribeLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) DescribeLoggingConfigurationWithContext(ctx aws.Context, input *DescribeLoggingConfigurationInput, opts ...request.Option) (*DescribeLoggingConfigurationOutput, error) {
	req, out := c.DescribeLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResourcePolicy = "DescribeResourcePolicy"

// DescribeResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourcePolicy for more information on using the DescribeResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeResourcePolicyRequest method.
//    req, resp := client.DescribeResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeResourcePolicy
func (c *NetworkFirewall) DescribeResourcePolicyRequest(input *DescribeResourcePolicyInput) (req *request.Request, output *DescribeResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourcePolicyInput{}
	}

	output = &DescribeResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourcePolicy API operation for AWS Network Firewall.
//
// Retrieves a resource policy that you created in a PutResourcePolicy request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation DescribeResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeResourcePolicy
func (c *NetworkFirewall) DescribeResourcePolicy(input *DescribeResourcePolicyInput) (*DescribeResourcePolicyOutput, error) {
	req, out := c.DescribeResourcePolicyRequest(input)
	return out, req.Send()
}

// DescribeResourcePolicyWithContext is the same as DescribeResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) DescribeResourcePolicyWithContext(ctx aws.Context, input *DescribeResourcePolicyInput, opts ...request.Option) (*DescribeResourcePolicyOutput, error) {
	req, out := c.DescribeResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRuleGroup = "DescribeRuleGroup"

// DescribeRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRuleGroup for more information on using the DescribeRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRuleGroupRequest method.
//    req, resp := client.DescribeRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroup
func (c *NetworkFirewall) DescribeRuleGroupRequest(input *DescribeRuleGroupInput) (req *request.Request, output *DescribeRuleGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRuleGroupInput{}
	}

	output = &DescribeRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRuleGroup API operation for AWS Network Firewall.
//
// Returns the data objects for the specified rule group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation DescribeRuleGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroup
func (c *NetworkFirewall) DescribeRuleGroup(input *DescribeRuleGroupInput) (*DescribeRuleGroupOutput, error) {
	req, out := c.DescribeRuleGroupRequest(input)
	return out, req.Send()
}

// DescribeRuleGroupWithContext is the same as DescribeRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) DescribeRuleGroupWithContext(ctx aws.Context, input *DescribeRuleGroupInput, opts ...request.Option) (*DescribeRuleGroupOutput, error) {
	req, out := c.DescribeRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRuleGroupMetadata = "DescribeRuleGroupMetadata"

// DescribeRuleGroupMetadataRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRuleGroupMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRuleGroupMetadata for more information on using the DescribeRuleGroupMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRuleGroupMetadataRequest method.
//    req, resp := client.DescribeRuleGroupMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupMetadata
func (c *NetworkFirewall) DescribeRuleGroupMetadataRequest(input *DescribeRuleGroupMetadataInput) (req *request.Request, output *DescribeRuleGroupMetadataOutput) {
	op := &request.Operation{
		Name:       opDescribeRuleGroupMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRuleGroupMetadataInput{}
	}

	output = &DescribeRuleGroupMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRuleGroupMetadata API operation for AWS Network Firewall.
//
// High-level information about a rule group, returned by operations like create
// and describe. You can use the information provided in the metadata to retrieve
// and manage a rule group. You can retrieve all objects for a rule group by
// calling DescribeRuleGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation DescribeRuleGroupMetadata for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupMetadata
func (c *NetworkFirewall) DescribeRuleGroupMetadata(input *DescribeRuleGroupMetadataInput) (*DescribeRuleGroupMetadataOutput, error) {
	req, out := c.DescribeRuleGroupMetadataRequest(input)
	return out, req.Send()
}

// DescribeRuleGroupMetadataWithContext is the same as DescribeRuleGroupMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRuleGroupMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) DescribeRuleGroupMetadataWithContext(ctx aws.Context, input *DescribeRuleGroupMetadataInput, opts ...request.Option) (*DescribeRuleGroupMetadataOutput, error) {
	req, out := c.DescribeRuleGroupMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateSubnets = "DisassociateSubnets"

// DisassociateSubnetsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateSubnets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateSubnets for more information on using the DisassociateSubnets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateSubnetsRequest method.
//    req, resp := client.DisassociateSubnetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateSubnets
func (c *NetworkFirewall) DisassociateSubnetsRequest(input *DisassociateSubnetsInput) (req *request.Request, output *DisassociateSubnetsOutput) {
	op := &request.Operation{
		Name:       opDisassociateSubnets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateSubnetsInput{}
	}

	output = &DisassociateSubnetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateSubnets API operation for AWS Network Firewall.
//
// Removes the specified subnet associations from the firewall. This removes
// the firewall endpoints from the subnets and removes any network filtering
// protections that the endpoints were providing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation DisassociateSubnets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InvalidTokenException
//   The token you provided is stale or isn't valid for the operation.
//
//   * InvalidOperationException
//   The operation failed because it's not valid. For example, you might have
//   tried to delete a rule group or firewall policy that's in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateSubnets
func (c *NetworkFirewall) DisassociateSubnets(input *DisassociateSubnetsInput) (*DisassociateSubnetsOutput, error) {
	req, out := c.DisassociateSubnetsRequest(input)
	return out, req.Send()
}

// DisassociateSubnetsWithContext is the same as DisassociateSubnets with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateSubnets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) DisassociateSubnetsWithContext(ctx aws.Context, input *DisassociateSubnetsInput, opts ...request.Option) (*DisassociateSubnetsOutput, error) {
	req, out := c.DisassociateSubnetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFirewallPolicies = "ListFirewallPolicies"

// ListFirewallPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListFirewallPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFirewallPolicies for more information on using the ListFirewallPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFirewallPoliciesRequest method.
//    req, resp := client.ListFirewallPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies
func (c *NetworkFirewall) ListFirewallPoliciesRequest(input *ListFirewallPoliciesInput) (req *request.Request, output *ListFirewallPoliciesOutput) {
	op := &request.Operation{
		Name:       opListFirewallPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFirewallPoliciesInput{}
	}

	output = &ListFirewallPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFirewallPolicies API operation for AWS Network Firewall.
//
// Retrieves the metadata for the firewall policies that you have defined. Depending
// on your setting for max results and the number of firewall policies, a single
// call might not return the full list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation ListFirewallPolicies for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies
func (c *NetworkFirewall) ListFirewallPolicies(input *ListFirewallPoliciesInput) (*ListFirewallPoliciesOutput, error) {
	req, out := c.ListFirewallPoliciesRequest(input)
	return out, req.Send()
}

// ListFirewallPoliciesWithContext is the same as ListFirewallPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListFirewallPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) ListFirewallPoliciesWithContext(ctx aws.Context, input *ListFirewallPoliciesInput, opts ...request.Option) (*ListFirewallPoliciesOutput, error) {
	req, out := c.ListFirewallPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFirewallPoliciesPages iterates over the pages of a ListFirewallPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFirewallPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFirewallPolicies operation.
//    pageNum := 0
//    err := client.ListFirewallPoliciesPages(params,
//        func(page *networkfirewall.ListFirewallPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *NetworkFirewall) ListFirewallPoliciesPages(input *ListFirewallPoliciesInput, fn func(*ListFirewallPoliciesOutput, bool) bool) error {
	return c.ListFirewallPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFirewallPoliciesPagesWithContext same as ListFirewallPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) ListFirewallPoliciesPagesWithContext(ctx aws.Context, input *ListFirewallPoliciesInput, fn func(*ListFirewallPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFirewallPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFirewallPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFirewallPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFirewalls = "ListFirewalls"

// ListFirewallsRequest generates a "aws/request.Request" representing the
// client's request for the ListFirewalls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFirewalls for more information on using the ListFirewalls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFirewallsRequest method.
//    req, resp := client.ListFirewallsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls
func (c *NetworkFirewall) ListFirewallsRequest(input *ListFirewallsInput) (req *request.Request, output *ListFirewallsOutput) {
	op := &request.Operation{
		Name:       opListFirewalls,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFirewallsInput{}
	}

	output = &ListFirewallsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFirewalls API operation for AWS Network Firewall.
//
// Retrieves the metadata for the firewalls that you have defined. If you provide
// VPC identifiers in your request, this returns only the firewalls for those
// VPCs.
//
// Depending on your setting for max results and the number of firewalls, a
// single call might not return the full list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation ListFirewalls for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls
func (c *NetworkFirewall) ListFirewalls(input *ListFirewallsInput) (*ListFirewallsOutput, error) {
	req, out := c.ListFirewallsRequest(input)
	return out, req.Send()
}

// ListFirewallsWithContext is the same as ListFirewalls with the addition of
// the ability to pass a context and additional request options.
//
// See ListFirewalls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) ListFirewallsWithContext(ctx aws.Context, input *ListFirewallsInput, opts ...request.Option) (*ListFirewallsOutput, error) {
	req, out := c.ListFirewallsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFirewallsPages iterates over the pages of a ListFirewalls operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFirewalls method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFirewalls operation.
//    pageNum := 0
//    err := client.ListFirewallsPages(params,
//        func(page *networkfirewall.ListFirewallsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *NetworkFirewall) ListFirewallsPages(input *ListFirewallsInput, fn func(*ListFirewallsOutput, bool) bool) error {
	return c.ListFirewallsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFirewallsPagesWithContext same as ListFirewallsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) ListFirewallsPagesWithContext(ctx aws.Context, input *ListFirewallsInput, fn func(*ListFirewallsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFirewallsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFirewallsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFirewallsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRuleGroups = "ListRuleGroups"

// ListRuleGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListRuleGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRuleGroups for more information on using the ListRuleGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRuleGroupsRequest method.
//    req, resp := client.ListRuleGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups
func (c *NetworkFirewall) ListRuleGroupsRequest(input *ListRuleGroupsInput) (req *request.Request, output *ListRuleGroupsOutput) {
	op := &request.Operation{
		Name:       opListRuleGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRuleGroupsInput{}
	}

	output = &ListRuleGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuleGroups API operation for AWS Network Firewall.
//
// Retrieves the metadata for the rule groups that you have defined. Depending
// on your setting for max results and the number of rule groups, a single call
// might not return the full list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation ListRuleGroups for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups
func (c *NetworkFirewall) ListRuleGroups(input *ListRuleGroupsInput) (*ListRuleGroupsOutput, error) {
	req, out := c.ListRuleGroupsRequest(input)
	return out, req.Send()
}

// ListRuleGroupsWithContext is the same as ListRuleGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuleGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) ListRuleGroupsWithContext(ctx aws.Context, input *ListRuleGroupsInput, opts ...request.Option) (*ListRuleGroupsOutput, error) {
	req, out := c.ListRuleGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRuleGroupsPages iterates over the pages of a ListRuleGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRuleGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRuleGroups operation.
//    pageNum := 0
//    err := client.ListRuleGroupsPages(params,
//        func(page *networkfirewall.ListRuleGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *NetworkFirewall) ListRuleGroupsPages(input *ListRuleGroupsInput, fn func(*ListRuleGroupsOutput, bool) bool) error {
	return c.ListRuleGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRuleGroupsPagesWithContext same as ListRuleGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) ListRuleGroupsPagesWithContext(ctx aws.Context, input *ListRuleGroupsInput, fn func(*ListRuleGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRuleGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRuleGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRuleGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource
func (c *NetworkFirewall) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Network Firewall.
//
// Retrieves the tags associated with the specified resource. Tags are key:value
// pairs that you can use to categorize and manage your resources, for purposes
// like billing. For example, you might set the tag key to "customer" and the
// value to the customer name or ID. You can specify one or more tags to add
// to each AWS resource, up to 50 tags for a resource.
//
// You can tag the AWS resources that you manage through AWS Network Firewall:
// firewalls, firewall policies, and rule groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource
func (c *NetworkFirewall) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *networkfirewall.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *NetworkFirewall) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutResourcePolicyRequest method.
//    req, resp := client.PutResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/PutResourcePolicy
func (c *NetworkFirewall) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutResourcePolicy API operation for AWS Network Firewall.
//
// Creates or updates an AWS Identity and Access Management policy for your
// rule group or firewall policy. Use this to share rule groups and firewall
// policies between accounts. This operation works in conjunction with the AWS
// Resource Access Manager (RAM) service to manage resource sharing for Network
// Firewall.
//
// Use this operation to create or update a resource policy for your rule group
// or firewall policy. In the policy, you specify the accounts that you want
// to share the resource with and the operations that you want the accounts
// to be able to perform.
//
// When you add an account in the resource policy, you then run the following
// Resource Access Manager (RAM) operations to access and accept the shared
// rule group or firewall policy.
//
//    * GetResourceShareInvitations (https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html)
//    - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
//
//    * AcceptResourceShareInvitation (https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html)
//    - Accepts the share invitation for a specified resource share.
//
// For additional information about resource sharing using RAM, see AWS Resource
// Access Manager User Guide (https://docs.aws.amazon.com/ram/latest/userguide/what-is.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InvalidResourcePolicyException
//   The policy statement failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/PutResourcePolicy
func (c *NetworkFirewall) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/TagResource
func (c *NetworkFirewall) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Network Firewall.
//
// Adds the specified tags to the specified resource. Tags are key:value pairs
// that you can use to categorize and manage your resources, for purposes like
// billing. For example, you might set the tag key to "customer" and the value
// to the customer name or ID. You can specify one or more tags to add to each
// AWS resource, up to 50 tags for a resource.
//
// You can tag the AWS resources that you manage through AWS Network Firewall:
// firewalls, firewall policies, and rule groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/TagResource
func (c *NetworkFirewall) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UntagResource
func (c *NetworkFirewall) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Network Firewall.
//
// Removes the tags with the specified keys from the specified resource. Tags
// are key:value pairs that you can use to categorize and manage your resources,
// for purposes like billing. For example, you might set the tag key to "customer"
// and the value to the customer name or ID. You can specify one or more tags
// to add to each AWS resource, up to 50 tags for a resource.
//
// You can manage tags for the AWS resources that you manage through AWS Network
// Firewall: firewalls, firewall policies, and rule groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UntagResource
func (c *NetworkFirewall) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFirewallDeleteProtection = "UpdateFirewallDeleteProtection"

// UpdateFirewallDeleteProtectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFirewallDeleteProtection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFirewallDeleteProtection for more information on using the UpdateFirewallDeleteProtection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFirewallDeleteProtectionRequest method.
//    req, resp := client.UpdateFirewallDeleteProtectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDeleteProtection
func (c *NetworkFirewall) UpdateFirewallDeleteProtectionRequest(input *UpdateFirewallDeleteProtectionInput) (req *request.Request, output *UpdateFirewallDeleteProtectionOutput) {
	op := &request.Operation{
		Name:       opUpdateFirewallDeleteProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFirewallDeleteProtectionInput{}
	}

	output = &UpdateFirewallDeleteProtectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFirewallDeleteProtection API operation for AWS Network Firewall.
//
// Modifies the flag, DeleteProtection, which indicates whether it is possible
// to delete the firewall. If the flag is set to TRUE, the firewall is protected
// against deletion. This setting helps protect against accidentally deleting
// a firewall that's in use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation UpdateFirewallDeleteProtection for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InvalidTokenException
//   The token you provided is stale or isn't valid for the operation.
//
//   * ResourceOwnerCheckException
//   Unable to change the resource because your account doesn't own it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDeleteProtection
func (c *NetworkFirewall) UpdateFirewallDeleteProtection(input *UpdateFirewallDeleteProtectionInput) (*UpdateFirewallDeleteProtectionOutput, error) {
	req, out := c.UpdateFirewallDeleteProtectionRequest(input)
	return out, req.Send()
}

// UpdateFirewallDeleteProtectionWithContext is the same as UpdateFirewallDeleteProtection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFirewallDeleteProtection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) UpdateFirewallDeleteProtectionWithContext(ctx aws.Context, input *UpdateFirewallDeleteProtectionInput, opts ...request.Option) (*UpdateFirewallDeleteProtectionOutput, error) {
	req, out := c.UpdateFirewallDeleteProtectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFirewallDescription = "UpdateFirewallDescription"

// UpdateFirewallDescriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFirewallDescription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFirewallDescription for more information on using the UpdateFirewallDescription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFirewallDescriptionRequest method.
//    req, resp := client.UpdateFirewallDescriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDescription
func (c *NetworkFirewall) UpdateFirewallDescriptionRequest(input *UpdateFirewallDescriptionInput) (req *request.Request, output *UpdateFirewallDescriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateFirewallDescription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFirewallDescriptionInput{}
	}

	output = &UpdateFirewallDescriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFirewallDescription API operation for AWS Network Firewall.
//
// Modifies the description for the specified firewall. Use the description
// to help you identify the firewall when you're working with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation UpdateFirewallDescription for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InvalidTokenException
//   The token you provided is stale or isn't valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDescription
func (c *NetworkFirewall) UpdateFirewallDescription(input *UpdateFirewallDescriptionInput) (*UpdateFirewallDescriptionOutput, error) {
	req, out := c.UpdateFirewallDescriptionRequest(input)
	return out, req.Send()
}

// UpdateFirewallDescriptionWithContext is the same as UpdateFirewallDescription with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFirewallDescription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) UpdateFirewallDescriptionWithContext(ctx aws.Context, input *UpdateFirewallDescriptionInput, opts ...request.Option) (*UpdateFirewallDescriptionOutput, error) {
	req, out := c.UpdateFirewallDescriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFirewallPolicy = "UpdateFirewallPolicy"

// UpdateFirewallPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFirewallPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFirewallPolicy for more information on using the UpdateFirewallPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFirewallPolicyRequest method.
//    req, resp := client.UpdateFirewallPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicy
func (c *NetworkFirewall) UpdateFirewallPolicyRequest(input *UpdateFirewallPolicyInput) (req *request.Request, output *UpdateFirewallPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateFirewallPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFirewallPolicyInput{}
	}

	output = &UpdateFirewallPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFirewallPolicy API operation for AWS Network Firewall.
//
// Updates the properties of the specified firewall policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation UpdateFirewallPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * InvalidTokenException
//   The token you provided is stale or isn't valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicy
func (c *NetworkFirewall) UpdateFirewallPolicy(input *UpdateFirewallPolicyInput) (*UpdateFirewallPolicyOutput, error) {
	req, out := c.UpdateFirewallPolicyRequest(input)
	return out, req.Send()
}

// UpdateFirewallPolicyWithContext is the same as UpdateFirewallPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFirewallPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) UpdateFirewallPolicyWithContext(ctx aws.Context, input *UpdateFirewallPolicyInput, opts ...request.Option) (*UpdateFirewallPolicyOutput, error) {
	req, out := c.UpdateFirewallPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFirewallPolicyChangeProtection = "UpdateFirewallPolicyChangeProtection"

// UpdateFirewallPolicyChangeProtectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFirewallPolicyChangeProtection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFirewallPolicyChangeProtection for more information on using the UpdateFirewallPolicyChangeProtection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFirewallPolicyChangeProtectionRequest method.
//    req, resp := client.UpdateFirewallPolicyChangeProtectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicyChangeProtection
func (c *NetworkFirewall) UpdateFirewallPolicyChangeProtectionRequest(input *UpdateFirewallPolicyChangeProtectionInput) (req *request.Request, output *UpdateFirewallPolicyChangeProtectionOutput) {
	op := &request.Operation{
		Name:       opUpdateFirewallPolicyChangeProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFirewallPolicyChangeProtectionInput{}
	}

	output = &UpdateFirewallPolicyChangeProtectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFirewallPolicyChangeProtection API operation for AWS Network Firewall.
//
// Modifies the flag, ChangeProtection, which indicates whether it is possible
// to change the firewall. If the flag is set to TRUE, the firewall is protected
// from changes. This setting helps protect against accidentally changing a
// firewall that's in use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation UpdateFirewallPolicyChangeProtection for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InvalidTokenException
//   The token you provided is stale or isn't valid for the operation.
//
//   * ResourceOwnerCheckException
//   Unable to change the resource because your account doesn't own it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicyChangeProtection
func (c *NetworkFirewall) UpdateFirewallPolicyChangeProtection(input *UpdateFirewallPolicyChangeProtectionInput) (*UpdateFirewallPolicyChangeProtectionOutput, error) {
	req, out := c.UpdateFirewallPolicyChangeProtectionRequest(input)
	return out, req.Send()
}

// UpdateFirewallPolicyChangeProtectionWithContext is the same as UpdateFirewallPolicyChangeProtection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFirewallPolicyChangeProtection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) UpdateFirewallPolicyChangeProtectionWithContext(ctx aws.Context, input *UpdateFirewallPolicyChangeProtectionInput, opts ...request.Option) (*UpdateFirewallPolicyChangeProtectionOutput, error) {
	req, out := c.UpdateFirewallPolicyChangeProtectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLoggingConfiguration = "UpdateLoggingConfiguration"

// UpdateLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLoggingConfiguration for more information on using the UpdateLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLoggingConfigurationRequest method.
//    req, resp := client.UpdateLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateLoggingConfiguration
func (c *NetworkFirewall) UpdateLoggingConfigurationRequest(input *UpdateLoggingConfigurationInput) (req *request.Request, output *UpdateLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLoggingConfigurationInput{}
	}

	output = &UpdateLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLoggingConfiguration API operation for AWS Network Firewall.
//
// Sets the logging configuration for the specified firewall.
//
// To change the logging configuration, retrieve the LoggingConfiguration by
// calling DescribeLoggingConfiguration, then change it and provide the modified
// object to this update call. You must change the logging configuration one
// LogDestinationConfig at a time inside the retrieved LoggingConfiguration
// object.
//
// You can perform only one of the following actions in any call to UpdateLoggingConfiguration:
//
//    * Create a new log destination object by adding a single LogDestinationConfig
//    array element to LogDestinationConfigs.
//
//    * Delete a log destination object by removing a single LogDestinationConfig
//    array element from LogDestinationConfigs.
//
//    * Change the LogDestination setting in a single LogDestinationConfig array
//    element.
//
// You can't change the LogDestinationType or LogType in a LogDestinationConfig.
// To change these settings, delete the existing LogDestinationConfig object
// and create a new one, using two separate calls to this update operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation UpdateLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InvalidTokenException
//   The token you provided is stale or isn't valid for the operation.
//
//   * LogDestinationPermissionException
//   Unable to send logs to a configured logging destination.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateLoggingConfiguration
func (c *NetworkFirewall) UpdateLoggingConfiguration(input *UpdateLoggingConfigurationInput) (*UpdateLoggingConfigurationOutput, error) {
	req, out := c.UpdateLoggingConfigurationRequest(input)
	return out, req.Send()
}

// UpdateLoggingConfigurationWithContext is the same as UpdateLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) UpdateLoggingConfigurationWithContext(ctx aws.Context, input *UpdateLoggingConfigurationInput, opts ...request.Option) (*UpdateLoggingConfigurationOutput, error) {
	req, out := c.UpdateLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleGroup = "UpdateRuleGroup"

// UpdateRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleGroup for more information on using the UpdateRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuleGroupRequest method.
//    req, resp := client.UpdateRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateRuleGroup
func (c *NetworkFirewall) UpdateRuleGroupRequest(input *UpdateRuleGroupInput) (req *request.Request, output *UpdateRuleGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleGroupInput{}
	}

	output = &UpdateRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRuleGroup API operation for AWS Network Firewall.
//
// Updates the rule settings for the specified rule group. You use a rule group
// by reference in one or more firewall policies. When you modify a rule group,
// you modify all firewall policies that use the rule group.
//
// To update a rule group, first call DescribeRuleGroup to retrieve the current
// RuleGroup object, update the object as needed, and then provide the updated
// object to this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation UpdateRuleGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * InvalidTokenException
//   The token you provided is stale or isn't valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateRuleGroup
func (c *NetworkFirewall) UpdateRuleGroup(input *UpdateRuleGroupInput) (*UpdateRuleGroupOutput, error) {
	req, out := c.UpdateRuleGroupRequest(input)
	return out, req.Send()
}

// UpdateRuleGroupWithContext is the same as UpdateRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) UpdateRuleGroupWithContext(ctx aws.Context, input *UpdateRuleGroupInput, opts ...request.Option) (*UpdateRuleGroupOutput, error) {
	req, out := c.UpdateRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubnetChangeProtection = "UpdateSubnetChangeProtection"

// UpdateSubnetChangeProtectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubnetChangeProtection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubnetChangeProtection for more information on using the UpdateSubnetChangeProtection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSubnetChangeProtectionRequest method.
//    req, resp := client.UpdateSubnetChangeProtectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateSubnetChangeProtection
func (c *NetworkFirewall) UpdateSubnetChangeProtectionRequest(input *UpdateSubnetChangeProtectionInput) (req *request.Request, output *UpdateSubnetChangeProtectionOutput) {
	op := &request.Operation{
		Name:       opUpdateSubnetChangeProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSubnetChangeProtectionInput{}
	}

	output = &UpdateSubnetChangeProtectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubnetChangeProtection API operation for AWS Network Firewall.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Network Firewall's
// API operation UpdateSubnetChangeProtection for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The operation failed because of a problem with your request. Examples include:
//
//      * You specified an unsupported parameter name or value.
//
//      * You tried to update a property with a value that isn't among the available
//      types.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource that isn't valid in the context of the request.
//
//   * InternalServerError
//   Your request is valid, but Network Firewall couldn’t perform the operation
//   because of a system problem. Retry your request.
//
//   * ResourceNotFoundException
//   Unable to locate a resource using the parameters that you provided.
//
//   * ThrottlingException
//   Unable to process the request due to throttling limitations.
//
//   * InvalidTokenException
//   The token you provided is stale or isn't valid for the operation.
//
//   * ResourceOwnerCheckException
//   Unable to change the resource because your account doesn't own it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateSubnetChangeProtection
func (c *NetworkFirewall) UpdateSubnetChangeProtection(input *UpdateSubnetChangeProtectionInput) (*UpdateSubnetChangeProtectionOutput, error) {
	req, out := c.UpdateSubnetChangeProtectionRequest(input)
	return out, req.Send()
}

// UpdateSubnetChangeProtectionWithContext is the same as UpdateSubnetChangeProtection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubnetChangeProtection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkFirewall) UpdateSubnetChangeProtectionWithContext(ctx aws.Context, input *UpdateSubnetChangeProtectionInput, opts ...request.Option) (*UpdateSubnetChangeProtectionOutput, error) {
	req, out := c.UpdateSubnetChangeProtectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A custom action to use in stateless rule actions settings. This is used in
// CustomAction.
type ActionDefinition struct {
	_ struct{} `type:"structure"`

	// Stateless inspection criteria that publishes the specified metrics to Amazon
	// CloudWatch for the matching packet. This setting defines a CloudWatch dimension
	// value to be published.
	//
	// You can pair this custom action with any of the standard stateless rule actions.
	// For example, you could pair this in a rule action with the standard action
	// that forwards the packet for stateful inspection. Then, when a packet matches
	// the rule, Network Firewall publishes metrics for the packet and forwards
	// it.
	PublishMetricAction *PublishMetricAction `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionDefinition"}
	if s.PublishMetricAction != nil {
		if err := s.PublishMetricAction.Validate(); err != nil {
			invalidParams.AddNested("PublishMetricAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPublishMetricAction sets the PublishMetricAction field's value.
func (s *ActionDefinition) SetPublishMetricAction(v *PublishMetricAction) *ActionDefinition {
	s.PublishMetricAction = v
	return s
}

// A single IP address specification. This is used in the MatchAttributes source
// and destination specifications.
type Address struct {
	_ struct{} `type:"structure"`

	// Specify an IP address or a block of IP addresses in Classless Inter-Domain
	// Routing (CIDR) notation. Network Firewall supports all address ranges for
	// IPv4.
	//
	// Examples:
	//
	//    * To configure Network Firewall to inspect for the IP address 192.0.2.44,
	//    specify 192.0.2.44/32.
	//
	//    * To configure Network Firewall to inspect for IP addresses from 192.0.2.0
	//    to 192.0.2.255, specify 192.0.2.0/24.
	//
	// For more information about CIDR notation, see the Wikipedia entry Classless
	// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// AddressDefinition is a required field
	AddressDefinition *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Address) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Address"}
	if s.AddressDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressDefinition"))
	}
	if s.AddressDefinition != nil && len(*s.AddressDefinition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddressDefinition", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressDefinition sets the AddressDefinition field's value.
func (s *Address) SetAddressDefinition(v string) *Address {
	s.AddressDefinition = &v
	return s
}

type AssociateFirewallPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the firewall policy.
	//
	// FirewallPolicyArn is a required field
	FirewallPolicyArn *string `min:"1" type:"string" required:"true"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFirewallPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFirewallPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateFirewallPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateFirewallPolicyInput"}
	if s.FirewallArn != nil && len(*s.FirewallArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallArn", 1))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}
	if s.FirewallPolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallPolicyArn"))
	}
	if s.FirewallPolicyArn != nil && len(*s.FirewallPolicyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallPolicyArn", 1))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *AssociateFirewallPolicyInput) SetFirewallArn(v string) *AssociateFirewallPolicyInput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *AssociateFirewallPolicyInput) SetFirewallName(v string) *AssociateFirewallPolicyInput {
	s.FirewallName = &v
	return s
}

// SetFirewallPolicyArn sets the FirewallPolicyArn field's value.
func (s *AssociateFirewallPolicyInput) SetFirewallPolicyArn(v string) *AssociateFirewallPolicyInput {
	s.FirewallPolicyArn = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *AssociateFirewallPolicyInput) SetUpdateToken(v string) *AssociateFirewallPolicyInput {
	s.UpdateToken = &v
	return s
}

type AssociateFirewallPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the firewall policy.
	FirewallPolicyArn *string `min:"1" type:"string"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFirewallPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFirewallPolicyOutput) GoString() string {
	return s.String()
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *AssociateFirewallPolicyOutput) SetFirewallArn(v string) *AssociateFirewallPolicyOutput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *AssociateFirewallPolicyOutput) SetFirewallName(v string) *AssociateFirewallPolicyOutput {
	s.FirewallName = &v
	return s
}

// SetFirewallPolicyArn sets the FirewallPolicyArn field's value.
func (s *AssociateFirewallPolicyOutput) SetFirewallPolicyArn(v string) *AssociateFirewallPolicyOutput {
	s.FirewallPolicyArn = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *AssociateFirewallPolicyOutput) SetUpdateToken(v string) *AssociateFirewallPolicyOutput {
	s.UpdateToken = &v
	return s
}

type AssociateSubnetsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string `min:"1" type:"string"`

	// The IDs of the subnets that you want to associate with the firewall.
	//
	// SubnetMappings is a required field
	SubnetMappings []*SubnetMapping `type:"list" required:"true"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSubnetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSubnetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSubnetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateSubnetsInput"}
	if s.FirewallArn != nil && len(*s.FirewallArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallArn", 1))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}
	if s.SubnetMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetMappings"))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}
	if s.SubnetMappings != nil {
		for i, v := range s.SubnetMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubnetMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *AssociateSubnetsInput) SetFirewallArn(v string) *AssociateSubnetsInput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *AssociateSubnetsInput) SetFirewallName(v string) *AssociateSubnetsInput {
	s.FirewallName = &v
	return s
}

// SetSubnetMappings sets the SubnetMappings field's value.
func (s *AssociateSubnetsInput) SetSubnetMappings(v []*SubnetMapping) *AssociateSubnetsInput {
	s.SubnetMappings = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *AssociateSubnetsInput) SetUpdateToken(v string) *AssociateSubnetsInput {
	s.UpdateToken = &v
	return s
}

type AssociateSubnetsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string `min:"1" type:"string"`

	// The IDs of the subnets that are associated with the firewall.
	SubnetMappings []*SubnetMapping `type:"list"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSubnetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSubnetsOutput) GoString() string {
	return s.String()
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *AssociateSubnetsOutput) SetFirewallArn(v string) *AssociateSubnetsOutput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *AssociateSubnetsOutput) SetFirewallName(v string) *AssociateSubnetsOutput {
	s.FirewallName = &v
	return s
}

// SetSubnetMappings sets the SubnetMappings field's value.
func (s *AssociateSubnetsOutput) SetSubnetMappings(v []*SubnetMapping) *AssociateSubnetsOutput {
	s.SubnetMappings = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *AssociateSubnetsOutput) SetUpdateToken(v string) *AssociateSubnetsOutput {
	s.UpdateToken = &v
	return s
}

// The configuration and status for a single subnet that you've specified for
// use by the AWS Network Firewall firewall. This is part of the FirewallStatus.
type Attachment struct {
	_ struct{} `type:"structure"`

	// The identifier of the firewall endpoint that Network Firewall has instantiated
	// in the subnet. You use this to identify the firewall endpoint in the VPC
	// route tables, when you redirect the VPC traffic through the endpoint.
	EndpointId *string `type:"string"`

	// The current status of the firewall endpoint in the subnet. This value reflects
	// both the instantiation of the endpoint in the VPC subnet and the sync states
	// that are reported in the Config settings. When this value is READY, the endpoint
	// is available and configured properly to handle network traffic. When the
	// endpoint isn't available for traffic, this value will reflect its state,
	// for example CREATING, DELETING, or FAILED.
	Status *string `type:"string" enum:"AttachmentStatus"`

	// The unique identifier of the subnet that you've specified to be used for
	// a firewall endpoint.
	SubnetId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attachment) GoString() string {
	return s.String()
}

// SetEndpointId sets the EndpointId field's value.
func (s *Attachment) SetEndpointId(v string) *Attachment {
	s.EndpointId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Attachment) SetStatus(v string) *Attachment {
	s.Status = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *Attachment) SetSubnetId(v string) *Attachment {
	s.SubnetId = &v
	return s
}

type CreateFirewallInput struct {
	_ struct{} `type:"structure"`

	// A flag indicating whether it is possible to delete the firewall. A setting
	// of TRUE indicates that the firewall is protected against deletion. Use this
	// setting to protect against accidentally deleting a firewall that is in use.
	// When you create a firewall, the operation initializes this flag to TRUE.
	DeleteProtection *bool `type:"boolean"`

	// A description of the firewall.
	Description *string `type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// FirewallName is a required field
	FirewallName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the FirewallPolicy that you want to use
	// for the firewall.
	//
	// FirewallPolicyArn is a required field
	FirewallPolicyArn *string `min:"1" type:"string" required:"true"`

	// A setting indicating whether the firewall is protected against a change to
	// the firewall policy association. Use this setting to protect against accidentally
	// modifying the firewall policy for a firewall that is in use. When you create
	// a firewall, the operation initializes this setting to TRUE.
	FirewallPolicyChangeProtection *bool `type:"boolean"`

	// A setting indicating whether the firewall is protected against changes to
	// the subnet associations. Use this setting to protect against accidentally
	// modifying the subnet associations for a firewall that is in use. When you
	// create a firewall, the operation initializes this setting to TRUE.
	SubnetChangeProtection *bool `type:"boolean"`

	// The public subnets to use for your Network Firewall firewalls. Each subnet
	// must belong to a different Availability Zone in the VPC. Network Firewall
	// creates a firewall endpoint in each subnet.
	//
	// SubnetMappings is a required field
	SubnetMappings []*SubnetMapping `type:"list" required:"true"`

	// The key:value pairs to associate with the resource.
	Tags []*Tag `min:"1" type:"list"`

	// The unique identifier of the VPC where Network Firewall should create the
	// firewall.
	//
	// You can't change this setting after you create the firewall.
	//
	// VpcId is a required field
	VpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFirewallInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFirewallInput"}
	if s.FirewallName == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallName"))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}
	if s.FirewallPolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallPolicyArn"))
	}
	if s.FirewallPolicyArn != nil && len(*s.FirewallPolicyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallPolicyArn", 1))
	}
	if s.SubnetMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetMappings"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}
	if s.SubnetMappings != nil {
		for i, v := range s.SubnetMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubnetMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteProtection sets the DeleteProtection field's value.
func (s *CreateFirewallInput) SetDeleteProtection(v bool) *CreateFirewallInput {
	s.DeleteProtection = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFirewallInput) SetDescription(v string) *CreateFirewallInput {
	s.Description = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *CreateFirewallInput) SetFirewallName(v string) *CreateFirewallInput {
	s.FirewallName = &v
	return s
}

// SetFirewallPolicyArn sets the FirewallPolicyArn field's value.
func (s *CreateFirewallInput) SetFirewallPolicyArn(v string) *CreateFirewallInput {
	s.FirewallPolicyArn = &v
	return s
}

// SetFirewallPolicyChangeProtection sets the FirewallPolicyChangeProtection field's value.
func (s *CreateFirewallInput) SetFirewallPolicyChangeProtection(v bool) *CreateFirewallInput {
	s.FirewallPolicyChangeProtection = &v
	return s
}

// SetSubnetChangeProtection sets the SubnetChangeProtection field's value.
func (s *CreateFirewallInput) SetSubnetChangeProtection(v bool) *CreateFirewallInput {
	s.SubnetChangeProtection = &v
	return s
}

// SetSubnetMappings sets the SubnetMappings field's value.
func (s *CreateFirewallInput) SetSubnetMappings(v []*SubnetMapping) *CreateFirewallInput {
	s.SubnetMappings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFirewallInput) SetTags(v []*Tag) *CreateFirewallInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateFirewallInput) SetVpcId(v string) *CreateFirewallInput {
	s.VpcId = &v
	return s
}

type CreateFirewallOutput struct {
	_ struct{} `type:"structure"`

	// The configuration settings for the firewall. These settings include the firewall
	// policy and the subnets in your VPC to use for the firewall endpoints.
	Firewall *Firewall `type:"structure"`

	// Detailed information about the current status of a Firewall. You can retrieve
	// this for a firewall by calling DescribeFirewall and providing the firewall
	// name and ARN.
	FirewallStatus *FirewallStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallOutput) GoString() string {
	return s.String()
}

// SetFirewall sets the Firewall field's value.
func (s *CreateFirewallOutput) SetFirewall(v *Firewall) *CreateFirewallOutput {
	s.Firewall = v
	return s
}

// SetFirewallStatus sets the FirewallStatus field's value.
func (s *CreateFirewallOutput) SetFirewallStatus(v *FirewallStatus) *CreateFirewallOutput {
	s.FirewallStatus = v
	return s
}

type CreateFirewallPolicyInput struct {
	_ struct{} `type:"structure"`

	// A description of the firewall policy.
	Description *string `type:"string"`

	// Indicates whether you want Network Firewall to just check the validity of
	// the request, rather than run the request.
	//
	// If set to TRUE, Network Firewall checks whether the request can run successfully,
	// but doesn't actually make the requested changes. The call returns the value
	// that the request would return if you ran it with dry run set to FALSE, but
	// doesn't make additions or changes to your resources. This option allows you
	// to make sure that you have the required permissions to run the request and
	// that your request parameters are valid.
	//
	// If set to FALSE, Network Firewall makes the requested changes to your resources.
	DryRun *bool `type:"boolean"`

	// The rule groups and policy actions to use in the firewall policy.
	//
	// FirewallPolicy is a required field
	FirewallPolicy *FirewallPolicy `type:"structure" required:"true"`

	// The descriptive name of the firewall policy. You can't change the name of
	// a firewall policy after you create it.
	//
	// FirewallPolicyName is a required field
	FirewallPolicyName *string `min:"1" type:"string" required:"true"`

	// The key:value pairs to associate with the resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFirewallPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFirewallPolicyInput"}
	if s.FirewallPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallPolicy"))
	}
	if s.FirewallPolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallPolicyName"))
	}
	if s.FirewallPolicyName != nil && len(*s.FirewallPolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallPolicyName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.FirewallPolicy != nil {
		if err := s.FirewallPolicy.Validate(); err != nil {
			invalidParams.AddNested("FirewallPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateFirewallPolicyInput) SetDescription(v string) *CreateFirewallPolicyInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateFirewallPolicyInput) SetDryRun(v bool) *CreateFirewallPolicyInput {
	s.DryRun = &v
	return s
}

// SetFirewallPolicy sets the FirewallPolicy field's value.
func (s *CreateFirewallPolicyInput) SetFirewallPolicy(v *FirewallPolicy) *CreateFirewallPolicyInput {
	s.FirewallPolicy = v
	return s
}

// SetFirewallPolicyName sets the FirewallPolicyName field's value.
func (s *CreateFirewallPolicyInput) SetFirewallPolicyName(v string) *CreateFirewallPolicyInput {
	s.FirewallPolicyName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFirewallPolicyInput) SetTags(v []*Tag) *CreateFirewallPolicyInput {
	s.Tags = v
	return s
}

type CreateFirewallPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The high-level properties of a firewall policy. This, along with the FirewallPolicy,
	// define the policy. You can retrieve all objects for a firewall policy by
	// calling DescribeFirewallPolicy.
	//
	// FirewallPolicyResponse is a required field
	FirewallPolicyResponse *FirewallPolicyResponse `type:"structure" required:"true"`

	// A token used for optimistic locking. Network Firewall returns a token to
	// your requests that access the firewall policy. The token marks the state
	// of the policy resource at the time of the request.
	//
	// To make changes to the policy, you provide the token in your request. Network
	// Firewall uses the token to ensure that the policy hasn't changed since you
	// last retrieved it. If it has changed, the operation fails with an InvalidTokenException.
	// If this happens, retrieve the firewall policy again to get a current copy
	// of it with current token. Reapply your changes as needed, then try the operation
	// again using the new token.
	//
	// UpdateToken is a required field
	UpdateToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallPolicyOutput) GoString() string {
	return s.String()
}

// SetFirewallPolicyResponse sets the FirewallPolicyResponse field's value.
func (s *CreateFirewallPolicyOutput) SetFirewallPolicyResponse(v *FirewallPolicyResponse) *CreateFirewallPolicyOutput {
	s.FirewallPolicyResponse = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *CreateFirewallPolicyOutput) SetUpdateToken(v string) *CreateFirewallPolicyOutput {
	s.UpdateToken = &v
	return s
}

type CreateRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The maximum operating resources that this rule group can use. Rule group
	// capacity is fixed at creation. When you update a rule group, you are limited
	// to this capacity. When you reference a rule group from a firewall policy,
	// Network Firewall reserves this capacity for the rule group.
	//
	// You can retrieve the capacity that would be required for a rule group before
	// you create the rule group by calling CreateRuleGroup with DryRun set to TRUE.
	//
	// You can't change or exceed this capacity when you update the rule group,
	// so leave room for your rule group to grow.
	//
	// Capacity for a stateless rule group
	//
	// For a stateless rule group, the capacity required is the sum of the capacity
	// requirements of the individual rules that you expect to have in the rule
	// group.
	//
	// To calculate the capacity requirement of a single rule, multiply the capacity
	// requirement values of each of the rule's match settings:
	//
	//    * A match setting with no criteria specified has a value of 1.
	//
	//    * A match setting with Any specified has a value of 1.
	//
	//    * All other match settings have a value equal to the number of elements
	//    provided in the setting. For example, a protocol setting ["UDP"] and a
	//    source setting ["10.0.0.0/24"] each have a value of 1. A protocol setting
	//    ["UDP","TCP"] has a value of 2. A source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"]
	//    has a value of 3.
	//
	// A rule with no criteria specified in any of its match settings has a capacity
	// requirement of 1. A rule with protocol setting ["UDP","TCP"], source setting
	// ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a single specification or
	// no specification for each of the other match settings has a capacity requirement
	// of 6.
	//
	// Capacity for a stateful rule group
	//
	// For a stateful rule group, the minimum capacity required is the number of
	// individual rules that you expect to have in the rule group.
	//
	// Capacity is a required field
	Capacity *int64 `type:"integer" required:"true"`

	// A description of the rule group.
	Description *string `type:"string"`

	// Indicates whether you want Network Firewall to just check the validity of
	// the request, rather than run the request.
	//
	// If set to TRUE, Network Firewall checks whether the request can run successfully,
	// but doesn't actually make the requested changes. The call returns the value
	// that the request would return if you ran it with dry run set to FALSE, but
	// doesn't make additions or changes to your resources. This option allows you
	// to make sure that you have the required permissions to run the request and
	// that your request parameters are valid.
	//
	// If set to FALSE, Network Firewall makes the requested changes to your resources.
	DryRun *bool `type:"boolean"`

	// An object that defines the rule group rules.
	//
	// You must provide either this rule group setting or a Rules setting, but not
	// both.
	RuleGroup *RuleGroup `type:"structure"`

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// RuleGroupName is a required field
	RuleGroupName *string `min:"1" type:"string" required:"true"`

	// A string containing stateful rule group rules specifications in Suricata
	// flat format, with one rule per line. Use this to import your existing Suricata
	// compatible rule groups.
	//
	// You must provide either this rules setting or a populated RuleGroup setting,
	// but not both.
	//
	// You can provide your rule group specification in Suricata flat format through
	// this setting when you create or update your rule group. The call response
	// returns a RuleGroup object that Network Firewall has populated from your
	// string.
	Rules *string `type:"string"`

	// The key:value pairs to associate with the resource.
	Tags []*Tag `min:"1" type:"list"`

	// Indicates whether the rule group is stateless or stateful. If the rule group
	// is stateless, it contains stateless rules. If it is stateful, it contains
	// stateful rules.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RuleGroupType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleGroupInput"}
	if s.Capacity == nil {
		invalidParams.Add(request.NewErrParamRequired("Capacity"))
	}
	if s.RuleGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleGroupName"))
	}
	if s.RuleGroupName != nil && len(*s.RuleGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.RuleGroup != nil {
		if err := s.RuleGroup.Validate(); err != nil {
			invalidParams.AddNested("RuleGroup", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacity sets the Capacity field's value.
func (s *CreateRuleGroupInput) SetCapacity(v int64) *CreateRuleGroupInput {
	s.Capacity = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRuleGroupInput) SetDescription(v string) *CreateRuleGroupInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateRuleGroupInput) SetDryRun(v bool) *CreateRuleGroupInput {
	s.DryRun = &v
	return s
}

// SetRuleGroup sets the RuleGroup field's value.
func (s *CreateRuleGroupInput) SetRuleGroup(v *RuleGroup) *CreateRuleGroupInput {
	s.RuleGroup = v
	return s
}

// SetRuleGroupName sets the RuleGroupName field's value.
func (s *CreateRuleGroupInput) SetRuleGroupName(v string) *CreateRuleGroupInput {
	s.RuleGroupName = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateRuleGroupInput) SetRules(v string) *CreateRuleGroupInput {
	s.Rules = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleGroupInput) SetTags(v []*Tag) *CreateRuleGroupInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateRuleGroupInput) SetType(v string) *CreateRuleGroupInput {
	s.Type = &v
	return s
}

type CreateRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The high-level properties of a rule group. This, along with the RuleGroup,
	// define the rule group. You can retrieve all objects for a rule group by calling
	// DescribeRuleGroup.
	//
	// RuleGroupResponse is a required field
	RuleGroupResponse *RuleGroupResponse `type:"structure" required:"true"`

	// A token used for optimistic locking. Network Firewall returns a token to
	// your requests that access the rule group. The token marks the state of the
	// rule group resource at the time of the request.
	//
	// To make changes to the rule group, you provide the token in your request.
	// Network Firewall uses the token to ensure that the rule group hasn't changed
	// since you last retrieved it. If it has changed, the operation fails with
	// an InvalidTokenException. If this happens, retrieve the rule group again
	// to get a current copy of it with a current token. Reapply your changes as
	// needed, then try the operation again using the new token.
	//
	// UpdateToken is a required field
	UpdateToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleGroupOutput) GoString() string {
	return s.String()
}

// SetRuleGroupResponse sets the RuleGroupResponse field's value.
func (s *CreateRuleGroupOutput) SetRuleGroupResponse(v *RuleGroupResponse) *CreateRuleGroupOutput {
	s.RuleGroupResponse = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *CreateRuleGroupOutput) SetUpdateToken(v string) *CreateRuleGroupOutput {
	s.UpdateToken = &v
	return s
}

// An optional, non-standard action to use for stateless packet handling. You
// can define this in addition to the standard action that you must specify.
//
// You define and name the custom actions that you want to be able to use, and
// then you reference them by name in your actions settings.
//
// You can use custom actions in the following places:
//
//    * In a rule group's StatelessRulesAndCustomActions specification. The
//    custom actions are available for use by name inside the StatelessRulesAndCustomActions
//    where you define them. You can use them for your stateless rule actions
//    to specify what to do with a packet that matches the rule's match attributes.
//
//    * In a FirewallPolicy specification, in StatelessCustomActions. The custom
//    actions are available for use inside the policy where you define them.
//    You can use them for the policy's default stateless actions settings to
//    specify what to do with packets that don't match any of the policy's stateless
//    rules.
type CustomAction struct {
	_ struct{} `type:"structure"`

	// The custom action associated with the action name.
	//
	// ActionDefinition is a required field
	ActionDefinition *ActionDefinition `type:"structure" required:"true"`

	// The descriptive name of the custom action. You can't change the name of a
	// custom action after you create it.
	//
	// ActionName is a required field
	ActionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomAction"}
	if s.ActionDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionDefinition"))
	}
	if s.ActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionName"))
	}
	if s.ActionName != nil && len(*s.ActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionName", 1))
	}
	if s.ActionDefinition != nil {
		if err := s.ActionDefinition.Validate(); err != nil {
			invalidParams.AddNested("ActionDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionDefinition sets the ActionDefinition field's value.
func (s *CustomAction) SetActionDefinition(v *ActionDefinition) *CustomAction {
	s.ActionDefinition = v
	return s
}

// SetActionName sets the ActionName field's value.
func (s *CustomAction) SetActionName(v string) *CustomAction {
	s.ActionName = &v
	return s
}

type DeleteFirewallInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFirewallInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFirewallInput"}
	if s.FirewallArn != nil && len(*s.FirewallArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallArn", 1))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *DeleteFirewallInput) SetFirewallArn(v string) *DeleteFirewallInput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *DeleteFirewallInput) SetFirewallName(v string) *DeleteFirewallInput {
	s.FirewallName = &v
	return s
}

type DeleteFirewallOutput struct {
	_ struct{} `type:"structure"`

	// The firewall defines the configuration settings for an AWS Network Firewall
	// firewall. These settings include the firewall policy, the subnets in your
	// VPC to use for the firewall endpoints, and any tags that are attached to
	// the firewall AWS resource.
	//
	// The status of the firewall, for example whether it's ready to filter network
	// traffic, is provided in the corresponding FirewallStatus. You can retrieve
	// both objects by calling DescribeFirewall.
	Firewall *Firewall `type:"structure"`

	// Detailed information about the current status of a Firewall. You can retrieve
	// this for a firewall by calling DescribeFirewall and providing the firewall
	// name and ARN.
	FirewallStatus *FirewallStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallOutput) GoString() string {
	return s.String()
}

// SetFirewall sets the Firewall field's value.
func (s *DeleteFirewallOutput) SetFirewall(v *Firewall) *DeleteFirewallOutput {
	s.Firewall = v
	return s
}

// SetFirewallStatus sets the FirewallStatus field's value.
func (s *DeleteFirewallOutput) SetFirewallStatus(v *FirewallStatus) *DeleteFirewallOutput {
	s.FirewallStatus = v
	return s
}

type DeleteFirewallPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall policy.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallPolicyArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall policy. You can't change the name of
	// a firewall policy after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallPolicyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFirewallPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFirewallPolicyInput"}
	if s.FirewallPolicyArn != nil && len(*s.FirewallPolicyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallPolicyArn", 1))
	}
	if s.FirewallPolicyName != nil && len(*s.FirewallPolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallPolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallPolicyArn sets the FirewallPolicyArn field's value.
func (s *DeleteFirewallPolicyInput) SetFirewallPolicyArn(v string) *DeleteFirewallPolicyInput {
	s.FirewallPolicyArn = &v
	return s
}

// SetFirewallPolicyName sets the FirewallPolicyName field's value.
func (s *DeleteFirewallPolicyInput) SetFirewallPolicyName(v string) *DeleteFirewallPolicyInput {
	s.FirewallPolicyName = &v
	return s
}

type DeleteFirewallPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The object containing the definition of the FirewallPolicyResponse that you
	// asked to delete.
	//
	// FirewallPolicyResponse is a required field
	FirewallPolicyResponse *FirewallPolicyResponse `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallPolicyOutput) GoString() string {
	return s.String()
}

// SetFirewallPolicyResponse sets the FirewallPolicyResponse field's value.
func (s *DeleteFirewallPolicyOutput) SetFirewallPolicyResponse(v *FirewallPolicyResponse) *DeleteFirewallPolicyOutput {
	s.FirewallPolicyResponse = v
	return s
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule group or firewall policy whose
	// resource policy you want to delete.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyInput) SetResourceArn(v string) *DeleteResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

type DeleteRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule group.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupArn *string `min:"1" type:"string"`

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupName *string `min:"1" type:"string"`

	// Indicates whether the rule group is stateless or stateful. If the rule group
	// is stateless, it contains stateless rules. If it is stateful, it contains
	// stateful rules.
	//
	// This setting is required for requests that do not include the RuleGroupARN.
	Type *string `type:"string" enum:"RuleGroupType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleGroupInput"}
	if s.RuleGroupArn != nil && len(*s.RuleGroupArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupArn", 1))
	}
	if s.RuleGroupName != nil && len(*s.RuleGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleGroupArn sets the RuleGroupArn field's value.
func (s *DeleteRuleGroupInput) SetRuleGroupArn(v string) *DeleteRuleGroupInput {
	s.RuleGroupArn = &v
	return s
}

// SetRuleGroupName sets the RuleGroupName field's value.
func (s *DeleteRuleGroupInput) SetRuleGroupName(v string) *DeleteRuleGroupInput {
	s.RuleGroupName = &v
	return s
}

// SetType sets the Type field's value.
func (s *DeleteRuleGroupInput) SetType(v string) *DeleteRuleGroupInput {
	s.Type = &v
	return s
}

type DeleteRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The high-level properties of a rule group. This, along with the RuleGroup,
	// define the rule group. You can retrieve all objects for a rule group by calling
	// DescribeRuleGroup.
	//
	// RuleGroupResponse is a required field
	RuleGroupResponse *RuleGroupResponse `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleGroupOutput) GoString() string {
	return s.String()
}

// SetRuleGroupResponse sets the RuleGroupResponse field's value.
func (s *DeleteRuleGroupOutput) SetRuleGroupResponse(v *RuleGroupResponse) *DeleteRuleGroupOutput {
	s.RuleGroupResponse = v
	return s
}

type DescribeFirewallInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFirewallInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFirewallInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFirewallInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFirewallInput"}
	if s.FirewallArn != nil && len(*s.FirewallArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallArn", 1))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *DescribeFirewallInput) SetFirewallArn(v string) *DescribeFirewallInput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *DescribeFirewallInput) SetFirewallName(v string) *DescribeFirewallInput {
	s.FirewallName = &v
	return s
}

type DescribeFirewallOutput struct {
	_ struct{} `type:"structure"`

	// The configuration settings for the firewall. These settings include the firewall
	// policy and the subnets in your VPC to use for the firewall endpoints.
	Firewall *Firewall `type:"structure"`

	// Detailed information about the current status of a Firewall. You can retrieve
	// this for a firewall by calling DescribeFirewall and providing the firewall
	// name and ARN.
	FirewallStatus *FirewallStatus `type:"structure"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFirewallOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFirewallOutput) GoString() string {
	return s.String()
}

// SetFirewall sets the Firewall field's value.
func (s *DescribeFirewallOutput) SetFirewall(v *Firewall) *DescribeFirewallOutput {
	s.Firewall = v
	return s
}

// SetFirewallStatus sets the FirewallStatus field's value.
func (s *DescribeFirewallOutput) SetFirewallStatus(v *FirewallStatus) *DescribeFirewallOutput {
	s.FirewallStatus = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *DescribeFirewallOutput) SetUpdateToken(v string) *DescribeFirewallOutput {
	s.UpdateToken = &v
	return s
}

type DescribeFirewallPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall policy.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallPolicyArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall policy. You can't change the name of
	// a firewall policy after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallPolicyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFirewallPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFirewallPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFirewallPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFirewallPolicyInput"}
	if s.FirewallPolicyArn != nil && len(*s.FirewallPolicyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallPolicyArn", 1))
	}
	if s.FirewallPolicyName != nil && len(*s.FirewallPolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallPolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallPolicyArn sets the FirewallPolicyArn field's value.
func (s *DescribeFirewallPolicyInput) SetFirewallPolicyArn(v string) *DescribeFirewallPolicyInput {
	s.FirewallPolicyArn = &v
	return s
}

// SetFirewallPolicyName sets the FirewallPolicyName field's value.
func (s *DescribeFirewallPolicyInput) SetFirewallPolicyName(v string) *DescribeFirewallPolicyInput {
	s.FirewallPolicyName = &v
	return s
}

type DescribeFirewallPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy for the specified firewall policy.
	FirewallPolicy *FirewallPolicy `type:"structure"`

	// The high-level properties of a firewall policy. This, along with the FirewallPolicy,
	// define the policy. You can retrieve all objects for a firewall policy by
	// calling DescribeFirewallPolicy.
	//
	// FirewallPolicyResponse is a required field
	FirewallPolicyResponse *FirewallPolicyResponse `type:"structure" required:"true"`

	// A token used for optimistic locking. Network Firewall returns a token to
	// your requests that access the firewall policy. The token marks the state
	// of the policy resource at the time of the request.
	//
	// To make changes to the policy, you provide the token in your request. Network
	// Firewall uses the token to ensure that the policy hasn't changed since you
	// last retrieved it. If it has changed, the operation fails with an InvalidTokenException.
	// If this happens, retrieve the firewall policy again to get a current copy
	// of it with current token. Reapply your changes as needed, then try the operation
	// again using the new token.
	//
	// UpdateToken is a required field
	UpdateToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFirewallPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFirewallPolicyOutput) GoString() string {
	return s.String()
}

// SetFirewallPolicy sets the FirewallPolicy field's value.
func (s *DescribeFirewallPolicyOutput) SetFirewallPolicy(v *FirewallPolicy) *DescribeFirewallPolicyOutput {
	s.FirewallPolicy = v
	return s
}

// SetFirewallPolicyResponse sets the FirewallPolicyResponse field's value.
func (s *DescribeFirewallPolicyOutput) SetFirewallPolicyResponse(v *FirewallPolicyResponse) *DescribeFirewallPolicyOutput {
	s.FirewallPolicyResponse = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *DescribeFirewallPolicyOutput) SetUpdateToken(v string) *DescribeFirewallPolicyOutput {
	s.UpdateToken = &v
	return s
}

type DescribeLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoggingConfigurationInput"}
	if s.FirewallArn != nil && len(*s.FirewallArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallArn", 1))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *DescribeLoggingConfigurationInput) SetFirewallArn(v string) *DescribeLoggingConfigurationInput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *DescribeLoggingConfigurationInput) SetFirewallName(v string) *DescribeLoggingConfigurationInput {
	s.FirewallName = &v
	return s
}

type DescribeLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string `min:"1" type:"string"`

	// Defines how AWS Network Firewall performs logging for a Firewall.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *DescribeLoggingConfigurationOutput) SetFirewallArn(v string) *DescribeLoggingConfigurationOutput {
	s.FirewallArn = &v
	return s
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *DescribeLoggingConfigurationOutput) SetLoggingConfiguration(v *LoggingConfiguration) *DescribeLoggingConfigurationOutput {
	s.LoggingConfiguration = v
	return s
}

type DescribeResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule group or firewall policy whose
	// resource policy you want to retrieve.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeResourcePolicyInput) SetResourceArn(v string) *DescribeResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DescribeResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The AWS Identity and Access Management policy for the resource.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *DescribeResourcePolicyOutput) SetPolicy(v string) *DescribeResourcePolicyOutput {
	s.Policy = &v
	return s
}

type DescribeRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule group.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupArn *string `min:"1" type:"string"`

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupName *string `min:"1" type:"string"`

	// Indicates whether the rule group is stateless or stateful. If the rule group
	// is stateless, it contains stateless rules. If it is stateful, it contains
	// stateful rules.
	//
	// This setting is required for requests that do not include the RuleGroupARN.
	Type *string `type:"string" enum:"RuleGroupType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRuleGroupInput"}
	if s.RuleGroupArn != nil && len(*s.RuleGroupArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupArn", 1))
	}
	if s.RuleGroupName != nil && len(*s.RuleGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleGroupArn sets the RuleGroupArn field's value.
func (s *DescribeRuleGroupInput) SetRuleGroupArn(v string) *DescribeRuleGroupInput {
	s.RuleGroupArn = &v
	return s
}

// SetRuleGroupName sets the RuleGroupName field's value.
func (s *DescribeRuleGroupInput) SetRuleGroupName(v string) *DescribeRuleGroupInput {
	s.RuleGroupName = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeRuleGroupInput) SetType(v string) *DescribeRuleGroupInput {
	s.Type = &v
	return s
}

type DescribeRuleGroupMetadataInput struct {
	_ struct{} `type:"structure"`

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupArn *string `min:"1" type:"string"`

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupName *string `min:"1" type:"string"`

	// Indicates whether the rule group is stateless or stateful. If the rule group
	// is stateless, it contains stateless rules. If it is stateful, it contains
	// stateful rules.
	//
	// This setting is required for requests that do not include the RuleGroupARN.
	Type *string `type:"string" enum:"RuleGroupType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuleGroupMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRuleGroupMetadataInput"}
	if s.RuleGroupArn != nil && len(*s.RuleGroupArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupArn", 1))
	}
	if s.RuleGroupName != nil && len(*s.RuleGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleGroupArn sets the RuleGroupArn field's value.
func (s *DescribeRuleGroupMetadataInput) SetRuleGroupArn(v string) *DescribeRuleGroupMetadataInput {
	s.RuleGroupArn = &v
	return s
}

// SetRuleGroupName sets the RuleGroupName field's value.
func (s *DescribeRuleGroupMetadataInput) SetRuleGroupName(v string) *DescribeRuleGroupMetadataInput {
	s.RuleGroupName = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeRuleGroupMetadataInput) SetType(v string) *DescribeRuleGroupMetadataInput {
	s.Type = &v
	return s
}

type DescribeRuleGroupMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The maximum operating resources that this rule group can use. Rule group
	// capacity is fixed at creation. When you update a rule group, you are limited
	// to this capacity. When you reference a rule group from a firewall policy,
	// Network Firewall reserves this capacity for the rule group.
	//
	// You can retrieve the capacity that would be required for a rule group before
	// you create the rule group by calling CreateRuleGroup with DryRun set to TRUE.
	Capacity *int64 `type:"integer"`

	// Returns the metadata objects for the specified rule group.
	Description *string `type:"string"`

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	//
	// RuleGroupArn is a required field
	RuleGroupArn *string `min:"1" type:"string" required:"true"`

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	//
	// RuleGroupName is a required field
	RuleGroupName *string `min:"1" type:"string" required:"true"`

	// Additional options governing how Network Firewall handles the rule group.
	// You can only use these for stateful rule groups.
	StatefulRuleOptions *StatefulRuleOptions `type:"structure"`

	// Indicates whether the rule group is stateless or stateful. If the rule group
	// is stateless, it contains stateless rules. If it is stateful, it contains
	// stateful rules.
	//
	// This setting is required for requests that do not include the RuleGroupARN.
	Type *string `type:"string" enum:"RuleGroupType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupMetadataOutput) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *DescribeRuleGroupMetadataOutput) SetCapacity(v int64) *DescribeRuleGroupMetadataOutput {
	s.Capacity = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeRuleGroupMetadataOutput) SetDescription(v string) *DescribeRuleGroupMetadataOutput {
	s.Description = &v
	return s
}

// SetRuleGroupArn sets the RuleGroupArn field's value.
func (s *DescribeRuleGroupMetadataOutput) SetRuleGroupArn(v string) *DescribeRuleGroupMetadataOutput {
	s.RuleGroupArn = &v
	return s
}

// SetRuleGroupName sets the RuleGroupName field's value.
func (s *DescribeRuleGroupMetadataOutput) SetRuleGroupName(v string) *DescribeRuleGroupMetadataOutput {
	s.RuleGroupName = &v
	return s
}

// SetStatefulRuleOptions sets the StatefulRuleOptions field's value.
func (s *DescribeRuleGroupMetadataOutput) SetStatefulRuleOptions(v *StatefulRuleOptions) *DescribeRuleGroupMetadataOutput {
	s.StatefulRuleOptions = v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeRuleGroupMetadataOutput) SetType(v string) *DescribeRuleGroupMetadataOutput {
	s.Type = &v
	return s
}

type DescribeRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The object that defines the rules in a rule group. This, along with RuleGroupResponse,
	// define the rule group. You can retrieve all objects for a rule group by calling
	// DescribeRuleGroup.
	//
	// AWS Network Firewall uses a rule group to inspect and control network traffic.
	// You define stateless rule groups to inspect individual packets and you define
	// stateful rule groups to inspect packets in the context of their traffic flow.
	//
	// To use a rule group, you include it by reference in an Network Firewall firewall
	// policy, then you use the policy in a firewall. You can reference a rule group
	// from more than one firewall policy, and you can use a firewall policy in
	// more than one firewall.
	RuleGroup *RuleGroup `type:"structure"`

	// The high-level properties of a rule group. This, along with the RuleGroup,
	// define the rule group. You can retrieve all objects for a rule group by calling
	// DescribeRuleGroup.
	//
	// RuleGroupResponse is a required field
	RuleGroupResponse *RuleGroupResponse `type:"structure" required:"true"`

	// A token used for optimistic locking. Network Firewall returns a token to
	// your requests that access the rule group. The token marks the state of the
	// rule group resource at the time of the request.
	//
	// To make changes to the rule group, you provide the token in your request.
	// Network Firewall uses the token to ensure that the rule group hasn't changed
	// since you last retrieved it. If it has changed, the operation fails with
	// an InvalidTokenException. If this happens, retrieve the rule group again
	// to get a current copy of it with a current token. Reapply your changes as
	// needed, then try the operation again using the new token.
	//
	// UpdateToken is a required field
	UpdateToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupOutput) GoString() string {
	return s.String()
}

// SetRuleGroup sets the RuleGroup field's value.
func (s *DescribeRuleGroupOutput) SetRuleGroup(v *RuleGroup) *DescribeRuleGroupOutput {
	s.RuleGroup = v
	return s
}

// SetRuleGroupResponse sets the RuleGroupResponse field's value.
func (s *DescribeRuleGroupOutput) SetRuleGroupResponse(v *RuleGroupResponse) *DescribeRuleGroupOutput {
	s.RuleGroupResponse = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *DescribeRuleGroupOutput) SetUpdateToken(v string) *DescribeRuleGroupOutput {
	s.UpdateToken = &v
	return s
}

// The value to use in an Amazon CloudWatch custom metric dimension. This is
// used in the PublishMetrics CustomAction. A CloudWatch custom metric dimension
// is a name/value pair that's part of the identity of a metric.
//
// AWS Network Firewall sets the dimension name to CustomAction and you provide
// the dimension value.
//
// For more information about CloudWatch custom metric dimensions, see Publishing
// Custom Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#usingDimensions)
// in the Amazon CloudWatch User Guide (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html).
type Dimension struct {
	_ struct{} `type:"structure"`

	// The value to use in the custom metric dimension.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Dimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Dimension"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValue sets the Value field's value.
func (s *Dimension) SetValue(v string) *Dimension {
	s.Value = &v
	return s
}

type DisassociateSubnetsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string `min:"1" type:"string"`

	// The unique identifiers for the subnets that you want to disassociate.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSubnetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSubnetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateSubnetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateSubnetsInput"}
	if s.FirewallArn != nil && len(*s.FirewallArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallArn", 1))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *DisassociateSubnetsInput) SetFirewallArn(v string) *DisassociateSubnetsInput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *DisassociateSubnetsInput) SetFirewallName(v string) *DisassociateSubnetsInput {
	s.FirewallName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *DisassociateSubnetsInput) SetSubnetIds(v []*string) *DisassociateSubnetsInput {
	s.SubnetIds = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *DisassociateSubnetsInput) SetUpdateToken(v string) *DisassociateSubnetsInput {
	s.UpdateToken = &v
	return s
}

type DisassociateSubnetsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string `min:"1" type:"string"`

	// The IDs of the subnets that are associated with the firewall.
	SubnetMappings []*SubnetMapping `type:"list"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSubnetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSubnetsOutput) GoString() string {
	return s.String()
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *DisassociateSubnetsOutput) SetFirewallArn(v string) *DisassociateSubnetsOutput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *DisassociateSubnetsOutput) SetFirewallName(v string) *DisassociateSubnetsOutput {
	s.FirewallName = &v
	return s
}

// SetSubnetMappings sets the SubnetMappings field's value.
func (s *DisassociateSubnetsOutput) SetSubnetMappings(v []*SubnetMapping) *DisassociateSubnetsOutput {
	s.SubnetMappings = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *DisassociateSubnetsOutput) SetUpdateToken(v string) *DisassociateSubnetsOutput {
	s.UpdateToken = &v
	return s
}

// The firewall defines the configuration settings for an AWS Network Firewall
// firewall. These settings include the firewall policy, the subnets in your
// VPC to use for the firewall endpoints, and any tags that are attached to
// the firewall AWS resource.
//
// The status of the firewall, for example whether it's ready to filter network
// traffic, is provided in the corresponding FirewallStatus. You can retrieve
// both objects by calling DescribeFirewall.
type Firewall struct {
	_ struct{} `type:"structure"`

	// A flag indicating whether it is possible to delete the firewall. A setting
	// of TRUE indicates that the firewall is protected against deletion. Use this
	// setting to protect against accidentally deleting a firewall that is in use.
	// When you create a firewall, the operation initializes this flag to TRUE.
	DeleteProtection *bool `type:"boolean"`

	// A description of the firewall.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string `min:"1" type:"string"`

	// The unique identifier for the firewall.
	//
	// FirewallId is a required field
	FirewallId *string `min:"36" type:"string" required:"true"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the firewall policy.
	//
	// The relationship of firewall to firewall policy is many to one. Each firewall
	// requires one firewall policy association, and you can use the same firewall
	// policy for multiple firewalls.
	//
	// FirewallPolicyArn is a required field
	FirewallPolicyArn *string `min:"1" type:"string" required:"true"`

	// A setting indicating whether the firewall is protected against a change to
	// the firewall policy association. Use this setting to protect against accidentally
	// modifying the firewall policy for a firewall that is in use. When you create
	// a firewall, the operation initializes this setting to TRUE.
	FirewallPolicyChangeProtection *bool `type:"boolean"`

	// A setting indicating whether the firewall is protected against changes to
	// the subnet associations. Use this setting to protect against accidentally
	// modifying the subnet associations for a firewall that is in use. When you
	// create a firewall, the operation initializes this setting to TRUE.
	SubnetChangeProtection *bool `type:"boolean"`

	// The public subnets that Network Firewall is using for the firewall. Each
	// subnet must belong to a different Availability Zone.
	//
	// SubnetMappings is a required field
	SubnetMappings []*SubnetMapping `type:"list" required:"true"`

	Tags []*Tag `min:"1" type:"list"`

	// The unique identifier of the VPC where the firewall is in use.
	//
	// VpcId is a required field
	VpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Firewall) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Firewall) GoString() string {
	return s.String()
}

// SetDeleteProtection sets the DeleteProtection field's value.
func (s *Firewall) SetDeleteProtection(v bool) *Firewall {
	s.DeleteProtection = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Firewall) SetDescription(v string) *Firewall {
	s.Description = &v
	return s
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *Firewall) SetFirewallArn(v string) *Firewall {
	s.FirewallArn = &v
	return s
}

// SetFirewallId sets the FirewallId field's value.
func (s *Firewall) SetFirewallId(v string) *Firewall {
	s.FirewallId = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *Firewall) SetFirewallName(v string) *Firewall {
	s.FirewallName = &v
	return s
}

// SetFirewallPolicyArn sets the FirewallPolicyArn field's value.
func (s *Firewall) SetFirewallPolicyArn(v string) *Firewall {
	s.FirewallPolicyArn = &v
	return s
}

// SetFirewallPolicyChangeProtection sets the FirewallPolicyChangeProtection field's value.
func (s *Firewall) SetFirewallPolicyChangeProtection(v bool) *Firewall {
	s.FirewallPolicyChangeProtection = &v
	return s
}

// SetSubnetChangeProtection sets the SubnetChangeProtection field's value.
func (s *Firewall) SetSubnetChangeProtection(v bool) *Firewall {
	s.SubnetChangeProtection = &v
	return s
}

// SetSubnetMappings sets the SubnetMappings field's value.
func (s *Firewall) SetSubnetMappings(v []*SubnetMapping) *Firewall {
	s.SubnetMappings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Firewall) SetTags(v []*Tag) *Firewall {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Firewall) SetVpcId(v string) *Firewall {
	s.VpcId = &v
	return s
}

// High-level information about a firewall, returned by operations like create
// and describe. You can use the information provided in the metadata to retrieve
// and manage a firewall.
type FirewallMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallMetadata) GoString() string {
	return s.String()
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *FirewallMetadata) SetFirewallArn(v string) *FirewallMetadata {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *FirewallMetadata) SetFirewallName(v string) *FirewallMetadata {
	s.FirewallName = &v
	return s
}

// The firewall policy defines the behavior of a firewall using a collection
// of stateless and stateful rule groups and other settings. You can use one
// firewall policy for multiple firewalls.
//
// This, along with FirewallPolicyResponse, define the policy. You can retrieve
// all objects for a firewall policy by calling DescribeFirewallPolicy.
type FirewallPolicy struct {
	_ struct{} `type:"structure"`

	// The default actions to take on a packet that doesn't match any stateful rules.
	// The stateful default action is optional, and is only valid when using the
	// strict rule order.
	//
	// Valid values of the stateful default action:
	//
	//    * aws:drop_strict
	//
	//    * aws:drop_established
	//
	//    * aws:alert_strict
	//
	//    * aws:alert_established
	//
	// For more information, see Strict evaluation order (https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-strict-rule-evaluation-order.html)
	// in the AWS Network Firewall Developer Guide.
	StatefulDefaultActions []*string `type:"list"`

	// Additional options governing how Network Firewall handles stateful rules.
	// The stateful rule groups that you use in your policy must have stateful rule
	// options settings that are compatible with these settings.
	StatefulEngineOptions *StatefulEngineOptions `type:"structure"`

	// References to the stateful rule groups that are used in the policy. These
	// define the inspection criteria in stateful rules.
	StatefulRuleGroupReferences []*StatefulRuleGroupReference `type:"list"`

	// The custom action definitions that are available for use in the firewall
	// policy's StatelessDefaultActions setting. You name each custom action that
	// you define, and then you can use it by name in your default actions specifications.
	StatelessCustomActions []*CustomAction `type:"list"`

	// The actions to take on a packet if it doesn't match any of the stateless
	// rules in the policy. If you want non-matching packets to be forwarded for
	// stateful inspection, specify aws:forward_to_sfe.
	//
	// You must specify one of the standard actions: aws:pass, aws:drop, or aws:forward_to_sfe.
	// In addition, you can specify custom actions that are compatible with your
	// standard section choice.
	//
	// For example, you could specify ["aws:pass"] or you could specify ["aws:pass",
	// “customActionName”]. For information about compatibility, see the custom
	// action descriptions under CustomAction.
	//
	// StatelessDefaultActions is a required field
	StatelessDefaultActions []*string `type:"list" required:"true"`

	// The actions to take on a fragmented UDP packet if it doesn't match any of
	// the stateless rules in the policy. Network Firewall only manages UDP packet
	// fragments and silently drops packet fragments for other protocols. If you
	// want non-matching fragmented UDP packets to be forwarded for stateful inspection,
	// specify aws:forward_to_sfe.
	//
	// You must specify one of the standard actions: aws:pass, aws:drop, or aws:forward_to_sfe.
	// In addition, you can specify custom actions that are compatible with your
	// standard section choice.
	//
	// For example, you could specify ["aws:pass"] or you could specify ["aws:pass",
	// “customActionName”]. For information about compatibility, see the custom
	// action descriptions under CustomAction.
	//
	// StatelessFragmentDefaultActions is a required field
	StatelessFragmentDefaultActions []*string `type:"list" required:"true"`

	// References to the stateless rule groups that are used in the policy. These
	// define the matching criteria in stateless rules.
	StatelessRuleGroupReferences []*StatelessRuleGroupReference `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FirewallPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FirewallPolicy"}
	if s.StatelessDefaultActions == nil {
		invalidParams.Add(request.NewErrParamRequired("StatelessDefaultActions"))
	}
	if s.StatelessFragmentDefaultActions == nil {
		invalidParams.Add(request.NewErrParamRequired("StatelessFragmentDefaultActions"))
	}
	if s.StatefulRuleGroupReferences != nil {
		for i, v := range s.StatefulRuleGroupReferences {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StatefulRuleGroupReferences", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StatelessCustomActions != nil {
		for i, v := range s.StatelessCustomActions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StatelessCustomActions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StatelessRuleGroupReferences != nil {
		for i, v := range s.StatelessRuleGroupReferences {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StatelessRuleGroupReferences", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatefulDefaultActions sets the StatefulDefaultActions field's value.
func (s *FirewallPolicy) SetStatefulDefaultActions(v []*string) *FirewallPolicy {
	s.StatefulDefaultActions = v
	return s
}

// SetStatefulEngineOptions sets the StatefulEngineOptions field's value.
func (s *FirewallPolicy) SetStatefulEngineOptions(v *StatefulEngineOptions) *FirewallPolicy {
	s.StatefulEngineOptions = v
	return s
}

// SetStatefulRuleGroupReferences sets the StatefulRuleGroupReferences field's value.
func (s *FirewallPolicy) SetStatefulRuleGroupReferences(v []*StatefulRuleGroupReference) *FirewallPolicy {
	s.StatefulRuleGroupReferences = v
	return s
}

// SetStatelessCustomActions sets the StatelessCustomActions field's value.
func (s *FirewallPolicy) SetStatelessCustomActions(v []*CustomAction) *FirewallPolicy {
	s.StatelessCustomActions = v
	return s
}

// SetStatelessDefaultActions sets the StatelessDefaultActions field's value.
func (s *FirewallPolicy) SetStatelessDefaultActions(v []*string) *FirewallPolicy {
	s.StatelessDefaultActions = v
	return s
}

// SetStatelessFragmentDefaultActions sets the StatelessFragmentDefaultActions field's value.
func (s *FirewallPolicy) SetStatelessFragmentDefaultActions(v []*string) *FirewallPolicy {
	s.StatelessFragmentDefaultActions = v
	return s
}

// SetStatelessRuleGroupReferences sets the StatelessRuleGroupReferences field's value.
func (s *FirewallPolicy) SetStatelessRuleGroupReferences(v []*StatelessRuleGroupReference) *FirewallPolicy {
	s.StatelessRuleGroupReferences = v
	return s
}

// High-level information about a firewall policy, returned by operations like
// create and describe. You can use the information provided in the metadata
// to retrieve and manage a firewall policy. You can retrieve all objects for
// a firewall policy by calling DescribeFirewallPolicy.
type FirewallPolicyMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall policy.
	Arn *string `min:"1" type:"string"`

	// The descriptive name of the firewall policy. You can't change the name of
	// a firewall policy after you create it.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallPolicyMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallPolicyMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FirewallPolicyMetadata) SetArn(v string) *FirewallPolicyMetadata {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *FirewallPolicyMetadata) SetName(v string) *FirewallPolicyMetadata {
	s.Name = &v
	return s
}

// The high-level properties of a firewall policy. This, along with the FirewallPolicy,
// define the policy. You can retrieve all objects for a firewall policy by
// calling DescribeFirewallPolicy.
type FirewallPolicyResponse struct {
	_ struct{} `type:"structure"`

	// The number of capacity units currently consumed by the policy's stateful
	// rules.
	ConsumedStatefulRuleCapacity *int64 `type:"integer"`

	// The number of capacity units currently consumed by the policy's stateless
	// rules.
	ConsumedStatelessRuleCapacity *int64 `type:"integer"`

	// A description of the firewall policy.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the firewall policy.
	//
	// If this response is for a create request that had DryRun set to TRUE, then
	// this ARN is a placeholder that isn't attached to a valid resource.
	//
	// FirewallPolicyArn is a required field
	FirewallPolicyArn *string `min:"1" type:"string" required:"true"`

	// The unique identifier for the firewall policy.
	//
	// FirewallPolicyId is a required field
	FirewallPolicyId *string `min:"36" type:"string" required:"true"`

	// The descriptive name of the firewall policy. You can't change the name of
	// a firewall policy after you create it.
	//
	// FirewallPolicyName is a required field
	FirewallPolicyName *string `min:"1" type:"string" required:"true"`

	// The current status of the firewall policy. You can retrieve this for a firewall
	// policy by calling DescribeFirewallPolicy and providing the firewall policy's
	// name or ARN.
	FirewallPolicyStatus *string `type:"string" enum:"ResourceStatus"`

	// The number of firewalls that are associated with this firewall policy.
	NumberOfAssociations *int64 `type:"integer"`

	// The key:value pairs to associate with the resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallPolicyResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallPolicyResponse) GoString() string {
	return s.String()
}

// SetConsumedStatefulRuleCapacity sets the ConsumedStatefulRuleCapacity field's value.
func (s *FirewallPolicyResponse) SetConsumedStatefulRuleCapacity(v int64) *FirewallPolicyResponse {
	s.ConsumedStatefulRuleCapacity = &v
	return s
}

// SetConsumedStatelessRuleCapacity sets the ConsumedStatelessRuleCapacity field's value.
func (s *FirewallPolicyResponse) SetConsumedStatelessRuleCapacity(v int64) *FirewallPolicyResponse {
	s.ConsumedStatelessRuleCapacity = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FirewallPolicyResponse) SetDescription(v string) *FirewallPolicyResponse {
	s.Description = &v
	return s
}

// SetFirewallPolicyArn sets the FirewallPolicyArn field's value.
func (s *FirewallPolicyResponse) SetFirewallPolicyArn(v string) *FirewallPolicyResponse {
	s.FirewallPolicyArn = &v
	return s
}

// SetFirewallPolicyId sets the FirewallPolicyId field's value.
func (s *FirewallPolicyResponse) SetFirewallPolicyId(v string) *FirewallPolicyResponse {
	s.FirewallPolicyId = &v
	return s
}

// SetFirewallPolicyName sets the FirewallPolicyName field's value.
func (s *FirewallPolicyResponse) SetFirewallPolicyName(v string) *FirewallPolicyResponse {
	s.FirewallPolicyName = &v
	return s
}

// SetFirewallPolicyStatus sets the FirewallPolicyStatus field's value.
func (s *FirewallPolicyResponse) SetFirewallPolicyStatus(v string) *FirewallPolicyResponse {
	s.FirewallPolicyStatus = &v
	return s
}

// SetNumberOfAssociations sets the NumberOfAssociations field's value.
func (s *FirewallPolicyResponse) SetNumberOfAssociations(v int64) *FirewallPolicyResponse {
	s.NumberOfAssociations = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *FirewallPolicyResponse) SetTags(v []*Tag) *FirewallPolicyResponse {
	s.Tags = v
	return s
}

// Detailed information about the current status of a Firewall. You can retrieve
// this for a firewall by calling DescribeFirewall and providing the firewall
// name and ARN.
type FirewallStatus struct {
	_ struct{} `type:"structure"`

	// The configuration sync state for the firewall. This summarizes the sync states
	// reported in the Config settings for all of the Availability Zones where you
	// have configured the firewall.
	//
	// When you create a firewall or update its configuration, for example by adding
	// a rule group to its firewall policy, Network Firewall distributes the configuration
	// changes to all zones where the firewall is in use. This summary indicates
	// whether the configuration changes have been applied everywhere.
	//
	// This status must be IN_SYNC for the firewall to be ready for use, but it
	// doesn't indicate that the firewall is ready. The Status setting indicates
	// firewall readiness.
	//
	// ConfigurationSyncStateSummary is a required field
	ConfigurationSyncStateSummary *string `type:"string" required:"true" enum:"ConfigurationSyncState"`

	// The readiness of the configured firewall to handle network traffic across
	// all of the Availability Zones where you've configured it. This setting is
	// READY only when the ConfigurationSyncStateSummary value is IN_SYNC and the
	// Attachment Status values for all of the configured subnets are READY.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"FirewallStatusValue"`

	// The subnets that you've configured for use by the Network Firewall firewall.
	// This contains one array element per Availability Zone where you've configured
	// a subnet. These objects provide details of the information that is summarized
	// in the ConfigurationSyncStateSummary and Status, broken down by zone and
	// configuration object.
	SyncStates map[string]*SyncState `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallStatus) GoString() string {
	return s.String()
}

// SetConfigurationSyncStateSummary sets the ConfigurationSyncStateSummary field's value.
func (s *FirewallStatus) SetConfigurationSyncStateSummary(v string) *FirewallStatus {
	s.ConfigurationSyncStateSummary = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FirewallStatus) SetStatus(v string) *FirewallStatus {
	s.Status = &v
	return s
}

// SetSyncStates sets the SyncStates field's value.
func (s *FirewallStatus) SetSyncStates(v map[string]*SyncState) *FirewallStatus {
	s.SyncStates = v
	return s
}

// The basic rule criteria for AWS Network Firewall to use to inspect packet
// headers in stateful traffic flow inspection. Traffic flows that match the
// criteria are a match for the corresponding StatefulRule.
type Header struct {
	_ struct{} `type:"structure"`

	// The destination IP address or address range to inspect for, in CIDR notation.
	// To match with any address, specify ANY.
	//
	// Specify an IP address or a block of IP addresses in Classless Inter-Domain
	// Routing (CIDR) notation. Network Firewall supports all address ranges for
	// IPv4.
	//
	// Examples:
	//
	//    * To configure Network Firewall to inspect for the IP address 192.0.2.44,
	//    specify 192.0.2.44/32.
	//
	//    * To configure Network Firewall to inspect for IP addresses from 192.0.2.0
	//    to 192.0.2.255, specify 192.0.2.0/24.
	//
	// For more information about CIDR notation, see the Wikipedia entry Classless
	// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// Destination is a required field
	Destination *string `min:"1" type:"string" required:"true"`

	// The destination port to inspect for. You can specify an individual port,
	// for example 1994 and you can specify a port range, for example 1990:1994.
	// To match with any port, specify ANY.
	//
	// DestinationPort is a required field
	DestinationPort *string `min:"1" type:"string" required:"true"`

	// The direction of traffic flow to inspect. If set to ANY, the inspection matches
	// bidirectional traffic, both from the source to the destination and from the
	// destination to the source. If set to FORWARD, the inspection only matches
	// traffic going from the source to the destination.
	//
	// Direction is a required field
	Direction *string `type:"string" required:"true" enum:"StatefulRuleDirection"`

	// The protocol to inspect for. To specify all, you can use IP, because all
	// traffic on AWS and on the internet is IP.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true" enum:"StatefulRuleProtocol"`

	// The source IP address or address range to inspect for, in CIDR notation.
	// To match with any address, specify ANY.
	//
	// Specify an IP address or a block of IP addresses in Classless Inter-Domain
	// Routing (CIDR) notation. Network Firewall supports all address ranges for
	// IPv4.
	//
	// Examples:
	//
	//    * To configure Network Firewall to inspect for the IP address 192.0.2.44,
	//    specify 192.0.2.44/32.
	//
	//    * To configure Network Firewall to inspect for IP addresses from 192.0.2.0
	//    to 192.0.2.255, specify 192.0.2.0/24.
	//
	// For more information about CIDR notation, see the Wikipedia entry Classless
	// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// Source is a required field
	Source *string `min:"1" type:"string" required:"true"`

	// The source port to inspect for. You can specify an individual port, for example
	// 1994 and you can specify a port range, for example 1990:1994. To match with
	// any port, specify ANY.
	//
	// SourcePort is a required field
	SourcePort *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Header) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Header) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Header) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Header"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Destination != nil && len(*s.Destination) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Destination", 1))
	}
	if s.DestinationPort == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationPort"))
	}
	if s.DestinationPort != nil && len(*s.DestinationPort) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationPort", 1))
	}
	if s.Direction == nil {
		invalidParams.Add(request.NewErrParamRequired("Direction"))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}
	if s.SourcePort == nil {
		invalidParams.Add(request.NewErrParamRequired("SourcePort"))
	}
	if s.SourcePort != nil && len(*s.SourcePort) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourcePort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *Header) SetDestination(v string) *Header {
	s.Destination = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *Header) SetDestinationPort(v string) *Header {
	s.DestinationPort = &v
	return s
}

// SetDirection sets the Direction field's value.
func (s *Header) SetDirection(v string) *Header {
	s.Direction = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Header) SetProtocol(v string) *Header {
	s.Protocol = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Header) SetSource(v string) *Header {
	s.Source = &v
	return s
}

// SetSourcePort sets the SourcePort field's value.
func (s *Header) SetSourcePort(v string) *Header {
	s.SourcePort = &v
	return s
}

// A list of IP addresses and address ranges, in CIDR notation. This is part
// of a RuleVariables.
type IPSet struct {
	_ struct{} `type:"structure"`

	// The list of IP addresses and address ranges, in CIDR notation.
	//
	// Definition is a required field
	Definition []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IPSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IPSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IPSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IPSet"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefinition sets the Definition field's value.
func (s *IPSet) SetDefinition(v []*string) *IPSet {
	s.Definition = v
	return s
}

// AWS doesn't currently have enough available capacity to fulfill your request.
// Try your request later.
type InsufficientCapacityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientCapacityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientCapacityException) GoString() string {
	return s.String()
}

func newErrorInsufficientCapacityException(v protocol.ResponseMetadata) error {
	return &InsufficientCapacityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientCapacityException) Code() string {
	return "InsufficientCapacityException"
}

// Message returns the exception's message.
func (s *InsufficientCapacityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientCapacityException) OrigErr() error {
	return nil
}

func (s *InsufficientCapacityException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientCapacityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientCapacityException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your request is valid, but Network Firewall couldn’t perform the operation
// because of a system problem. Retry your request.
type InternalServerError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) GoString() string {
	return s.String()
}

func newErrorInternalServerError(v protocol.ResponseMetadata) error {
	return &InternalServerError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerError) Code() string {
	return "InternalServerError"
}

// Message returns the exception's message.
func (s *InternalServerError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerError) OrigErr() error {
	return nil
}

func (s *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerError) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because it's not valid. For example, you might have
// tried to delete a rule group or firewall policy that's in use.
type InvalidOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidOperationException) GoString() string {
	return s.String()
}

func newErrorInvalidOperationException(v protocol.ResponseMetadata) error {
	return &InvalidOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidOperationException) Code() string {
	return "InvalidOperationException"
}

// Message returns the exception's message.
func (s *InvalidOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidOperationException) OrigErr() error {
	return nil
}

func (s *InvalidOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because of a problem with your request. Examples include:
//
//    * You specified an unsupported parameter name or value.
//
//    * You tried to update a property with a value that isn't among the available
//    types.
//
//    * Your request references an ARN that is malformed, or corresponds to
//    a resource that isn't valid in the context of the request.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The policy statement failed validation.
type InvalidResourcePolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourcePolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourcePolicyException) GoString() string {
	return s.String()
}

func newErrorInvalidResourcePolicyException(v protocol.ResponseMetadata) error {
	return &InvalidResourcePolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourcePolicyException) Code() string {
	return "InvalidResourcePolicyException"
}

// Message returns the exception's message.
func (s *InvalidResourcePolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourcePolicyException) OrigErr() error {
	return nil
}

func (s *InvalidResourcePolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourcePolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourcePolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The token you provided is stale or isn't valid for the operation.
type InvalidTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidTokenException(v protocol.ResponseMetadata) error {
	return &InvalidTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTokenException) Code() string {
	return "InvalidTokenException"
}

// Message returns the exception's message.
func (s *InvalidTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTokenException) OrigErr() error {
	return nil
}

func (s *InvalidTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Unable to perform the operation because doing so would violate a limit setting.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListFirewallPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want Network Firewall to return for
	// this request. If more objects are available, in the response, Network Firewall
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFirewallPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFirewallPoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFirewallPoliciesInput) SetMaxResults(v int64) *ListFirewallPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallPoliciesInput) SetNextToken(v string) *ListFirewallPoliciesInput {
	s.NextToken = &v
	return s
}

type ListFirewallPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The metadata for the firewall policies. Depending on your setting for max
	// results and the number of firewall policies that you have, this might not
	// be the full list.
	FirewallPolicies []*FirewallPolicyMetadata `type:"list"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallPoliciesOutput) GoString() string {
	return s.String()
}

// SetFirewallPolicies sets the FirewallPolicies field's value.
func (s *ListFirewallPoliciesOutput) SetFirewallPolicies(v []*FirewallPolicyMetadata) *ListFirewallPoliciesOutput {
	s.FirewallPolicies = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallPoliciesOutput) SetNextToken(v string) *ListFirewallPoliciesOutput {
	s.NextToken = &v
	return s
}

type ListFirewallsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want Network Firewall to return for
	// this request. If more objects are available, in the response, Network Firewall
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`

	// The unique identifiers of the VPCs that you want Network Firewall to retrieve
	// the firewalls for. Leave this blank to retrieve all firewalls that you have
	// defined.
	VpcIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFirewallsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFirewallsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFirewallsInput) SetMaxResults(v int64) *ListFirewallsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallsInput) SetNextToken(v string) *ListFirewallsInput {
	s.NextToken = &v
	return s
}

// SetVpcIds sets the VpcIds field's value.
func (s *ListFirewallsInput) SetVpcIds(v []*string) *ListFirewallsInput {
	s.VpcIds = v
	return s
}

type ListFirewallsOutput struct {
	_ struct{} `type:"structure"`

	// The firewall metadata objects for the VPCs that you specified. Depending
	// on your setting for max results and the number of firewalls you have, a single
	// call might not be the full list.
	Firewalls []*FirewallMetadata `type:"list"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallsOutput) GoString() string {
	return s.String()
}

// SetFirewalls sets the Firewalls field's value.
func (s *ListFirewallsOutput) SetFirewalls(v []*FirewallMetadata) *ListFirewallsOutput {
	s.Firewalls = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallsOutput) SetNextToken(v string) *ListFirewallsOutput {
	s.NextToken = &v
	return s
}

type ListRuleGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want Network Firewall to return for
	// this request. If more objects are available, in the response, Network Firewall
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`

	// The scope of the request. The default setting of ACCOUNT or a setting of
	// NULL returns all of the rule groups in your account. A setting of MANAGED
	// returns all available managed rule groups.
	Scope *string `type:"string" enum:"ResourceManagedStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRuleGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRuleGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRuleGroupsInput) SetMaxResults(v int64) *ListRuleGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleGroupsInput) SetNextToken(v string) *ListRuleGroupsInput {
	s.NextToken = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListRuleGroupsInput) SetScope(v string) *ListRuleGroupsInput {
	s.Scope = &v
	return s
}

type ListRuleGroupsOutput struct {
	_ struct{} `type:"structure"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`

	// The rule group metadata objects that you've defined. Depending on your setting
	// for max results and the number of rule groups, this might not be the full
	// list.
	RuleGroups []*RuleGroupMetadata `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleGroupsOutput) SetNextToken(v string) *ListRuleGroupsOutput {
	s.NextToken = &v
	return s
}

// SetRuleGroups sets the RuleGroups field's value.
func (s *ListRuleGroupsOutput) SetRuleGroups(v []*RuleGroupMetadata) *ListRuleGroupsOutput {
	s.RuleGroups = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want Network Firewall to return for
	// this request. If more objects are available, in the response, Network Firewall
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int64 `type:"integer"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`

	// The tags that are associated with the resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Defines where AWS Network Firewall sends logs for the firewall for one log
// type. This is used in LoggingConfiguration. You can send each type of log
// to an Amazon S3 bucket, a CloudWatch log group, or a Kinesis Data Firehose
// delivery stream.
//
// Network Firewall generates logs for stateful rule groups. You can save alert
// and flow log types. The stateful rules engine records flow logs for all network
// traffic that it receives. It records alert logs for traffic that matches
// stateful rules that have the rule action set to DROP or ALERT.
type LogDestinationConfig struct {
	_ struct{} `type:"structure"`

	// The named location for the logs, provided in a key:value mapping that is
	// specific to the chosen destination type.
	//
	//    * For an Amazon S3 bucket, provide the name of the bucket, with key bucketName,
	//    and optionally provide a prefix, with key prefix. The following example
	//    specifies an Amazon S3 bucket named DOC-EXAMPLE-BUCKET and the prefix
	//    alerts: "LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix":
	//    "alerts" }
	//
	//    * For a CloudWatch log group, provide the name of the CloudWatch log group,
	//    with key logGroup. The following example specifies a log group named alert-log-group:
	//    "LogDestination": { "logGroup": "alert-log-group" }
	//
	//    * For a Kinesis Data Firehose delivery stream, provide the name of the
	//    delivery stream, with key deliveryStream. The following example specifies
	//    a delivery stream named alert-delivery-stream: "LogDestination": { "deliveryStream":
	//    "alert-delivery-stream" }
	//
	// LogDestination is a required field
	LogDestination map[string]*string `type:"map" required:"true"`

	// The type of storage destination to send these logs to. You can send logs
	// to an Amazon S3 bucket, a CloudWatch log group, or a Kinesis Data Firehose
	// delivery stream.
	//
	// LogDestinationType is a required field
	LogDestinationType *string `min:"2" type:"string" required:"true" enum:"LogDestinationType"`

	// The type of log to send. Alert logs report traffic that matches a StatefulRule
	// with an action setting that sends an alert log message. Flow logs are standard
	// network traffic flow logs.
	//
	// LogType is a required field
	LogType *string `type:"string" required:"true" enum:"LogType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDestinationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDestinationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogDestinationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogDestinationConfig"}
	if s.LogDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("LogDestination"))
	}
	if s.LogDestinationType == nil {
		invalidParams.Add(request.NewErrParamRequired("LogDestinationType"))
	}
	if s.LogDestinationType != nil && len(*s.LogDestinationType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("LogDestinationType", 2))
	}
	if s.LogType == nil {
		invalidParams.Add(request.NewErrParamRequired("LogType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogDestination sets the LogDestination field's value.
func (s *LogDestinationConfig) SetLogDestination(v map[string]*string) *LogDestinationConfig {
	s.LogDestination = v
	return s
}

// SetLogDestinationType sets the LogDestinationType field's value.
func (s *LogDestinationConfig) SetLogDestinationType(v string) *LogDestinationConfig {
	s.LogDestinationType = &v
	return s
}

// SetLogType sets the LogType field's value.
func (s *LogDestinationConfig) SetLogType(v string) *LogDestinationConfig {
	s.LogType = &v
	return s
}

// Unable to send logs to a configured logging destination.
type LogDestinationPermissionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDestinationPermissionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDestinationPermissionException) GoString() string {
	return s.String()
}

func newErrorLogDestinationPermissionException(v protocol.ResponseMetadata) error {
	return &LogDestinationPermissionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LogDestinationPermissionException) Code() string {
	return "LogDestinationPermissionException"
}

// Message returns the exception's message.
func (s *LogDestinationPermissionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LogDestinationPermissionException) OrigErr() error {
	return nil
}

func (s *LogDestinationPermissionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LogDestinationPermissionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LogDestinationPermissionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines how AWS Network Firewall performs logging for a Firewall.
type LoggingConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines the logging destinations for the logs for a firewall. Network Firewall
	// generates logs for stateful rule groups.
	//
	// LogDestinationConfigs is a required field
	LogDestinationConfigs []*LogDestinationConfig `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingConfiguration"}
	if s.LogDestinationConfigs == nil {
		invalidParams.Add(request.NewErrParamRequired("LogDestinationConfigs"))
	}
	if s.LogDestinationConfigs != nil {
		for i, v := range s.LogDestinationConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogDestinationConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogDestinationConfigs sets the LogDestinationConfigs field's value.
func (s *LoggingConfiguration) SetLogDestinationConfigs(v []*LogDestinationConfig) *LoggingConfiguration {
	s.LogDestinationConfigs = v
	return s
}

// Criteria for Network Firewall to use to inspect an individual packet in stateless
// rule inspection. Each match attributes set can include one or more items
// such as IP address, CIDR range, port number, protocol, and TCP flags.
type MatchAttributes struct {
	_ struct{} `type:"structure"`

	// The destination ports to inspect for. If not specified, this matches with
	// any destination port. This setting is only used for protocols 6 (TCP) and
	// 17 (UDP).
	//
	// You can specify individual ports, for example 1994 and you can specify port
	// ranges, for example 1990:1994.
	DestinationPorts []*PortRange `type:"list"`

	// The destination IP addresses and address ranges to inspect for, in CIDR notation.
	// If not specified, this matches with any destination address.
	Destinations []*Address `type:"list"`

	// The protocols to inspect for, specified using each protocol's assigned internet
	// protocol number (IANA). If not specified, this matches with any protocol.
	Protocols []*int64 `type:"list"`

	// The source ports to inspect for. If not specified, this matches with any
	// source port. This setting is only used for protocols 6 (TCP) and 17 (UDP).
	//
	// You can specify individual ports, for example 1994 and you can specify port
	// ranges, for example 1990:1994.
	SourcePorts []*PortRange `type:"list"`

	// The source IP addresses and address ranges to inspect for, in CIDR notation.
	// If not specified, this matches with any source address.
	Sources []*Address `type:"list"`

	// The TCP flags and masks to inspect for. If not specified, this matches with
	// any settings. This setting is only used for protocol 6 (TCP).
	TCPFlags []*TCPFlagField `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MatchAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MatchAttributes"}
	if s.DestinationPorts != nil {
		for i, v := range s.DestinationPorts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DestinationPorts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourcePorts != nil {
		for i, v := range s.SourcePorts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourcePorts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TCPFlags != nil {
		for i, v := range s.TCPFlags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TCPFlags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationPorts sets the DestinationPorts field's value.
func (s *MatchAttributes) SetDestinationPorts(v []*PortRange) *MatchAttributes {
	s.DestinationPorts = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *MatchAttributes) SetDestinations(v []*Address) *MatchAttributes {
	s.Destinations = v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *MatchAttributes) SetProtocols(v []*int64) *MatchAttributes {
	s.Protocols = v
	return s
}

// SetSourcePorts sets the SourcePorts field's value.
func (s *MatchAttributes) SetSourcePorts(v []*PortRange) *MatchAttributes {
	s.SourcePorts = v
	return s
}

// SetSources sets the Sources field's value.
func (s *MatchAttributes) SetSources(v []*Address) *MatchAttributes {
	s.Sources = v
	return s
}

// SetTCPFlags sets the TCPFlags field's value.
func (s *MatchAttributes) SetTCPFlags(v []*TCPFlagField) *MatchAttributes {
	s.TCPFlags = v
	return s
}

// Provides configuration status for a single policy or rule group that is used
// for a firewall endpoint. Network Firewall provides each endpoint with the
// rules that are configured in the firewall policy. Each time you add a subnet
// or modify the associated firewall policy, Network Firewall synchronizes the
// rules in the endpoint, so it can properly filter network traffic. This is
// part of a SyncState for a firewall.
type PerObjectStatus struct {
	_ struct{} `type:"structure"`

	// Indicates whether this object is in sync with the version indicated in the
	// update token.
	SyncStatus *string `type:"string" enum:"PerObjectSyncStatus"`

	// The current version of the object that is either in sync or pending synchronization.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerObjectStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PerObjectStatus) GoString() string {
	return s.String()
}

// SetSyncStatus sets the SyncStatus field's value.
func (s *PerObjectStatus) SetSyncStatus(v string) *PerObjectStatus {
	s.SyncStatus = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *PerObjectStatus) SetUpdateToken(v string) *PerObjectStatus {
	s.UpdateToken = &v
	return s
}

// A single port range specification. This is used for source and destination
// port ranges in the stateless rule MatchAttributes, SourcePorts, and DestinationPorts
// settings.
type PortRange struct {
	_ struct{} `type:"structure"`

	// The lower limit of the port range. This must be less than or equal to the
	// ToPort specification.
	//
	// FromPort is a required field
	FromPort *int64 `type:"integer" required:"true"`

	// The upper limit of the port range. This must be greater than or equal to
	// the FromPort specification.
	//
	// ToPort is a required field
	ToPort *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortRange"}
	if s.FromPort == nil {
		invalidParams.Add(request.NewErrParamRequired("FromPort"))
	}
	if s.ToPort == nil {
		invalidParams.Add(request.NewErrParamRequired("ToPort"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromPort sets the FromPort field's value.
func (s *PortRange) SetFromPort(v int64) *PortRange {
	s.FromPort = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *PortRange) SetToPort(v int64) *PortRange {
	s.ToPort = &v
	return s
}

// A set of port ranges for use in the rules in a rule group.
type PortSet struct {
	_ struct{} `type:"structure"`

	// The set of port ranges.
	Definition []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortSet) GoString() string {
	return s.String()
}

// SetDefinition sets the Definition field's value.
func (s *PortSet) SetDefinition(v []*string) *PortSet {
	s.Definition = v
	return s
}

// Stateless inspection criteria that publishes the specified metrics to Amazon
// CloudWatch for the matching packet. This setting defines a CloudWatch dimension
// value to be published.
type PublishMetricAction struct {
	_ struct{} `type:"structure"`

	// Dimensions is a required field
	Dimensions []*Dimension `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishMetricAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishMetricAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishMetricAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishMetricAction"}
	if s.Dimensions == nil {
		invalidParams.Add(request.NewErrParamRequired("Dimensions"))
	}
	if s.Dimensions != nil && len(s.Dimensions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Dimensions", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *PublishMetricAction) SetDimensions(v []*Dimension) *PublishMetricAction {
	s.Dimensions = v
	return s
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The AWS Identity and Access Management policy statement that lists the accounts
	// that you want to share your rule group or firewall policy with and the operations
	// that you want the accounts to be able to perform.
	//
	// For a rule group resource, you can specify the following operations in the
	// Actions section of the statement:
	//
	//    * network-firewall:CreateFirewallPolicy
	//
	//    * network-firewall:UpdateFirewallPolicy
	//
	//    * network-firewall:ListRuleGroups
	//
	// For a firewall policy resource, you can specify the following operations
	// in the Actions section of the statement:
	//
	//    * network-firewall:CreateFirewall
	//
	//    * network-firewall:UpdateFirewall
	//
	//    * network-firewall:AssociateFirewallPolicy
	//
	//    * network-firewall:ListFirewallPolicies
	//
	// In the Resource section of the statement, you specify the ARNs for the rule
	// groups and firewall policies that you want to share with the account that
	// you specified in Arn.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the account that you want to share rule
	// groups and firewall policies with.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePolicyInput) SetPolicy(v string) *PutResourcePolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutResourcePolicyInput) SetResourceArn(v string) *PutResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// Unable to locate a resource using the parameters that you provided.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Unable to change the resource because your account doesn't own it.
type ResourceOwnerCheckException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceOwnerCheckException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceOwnerCheckException) GoString() string {
	return s.String()
}

func newErrorResourceOwnerCheckException(v protocol.ResponseMetadata) error {
	return &ResourceOwnerCheckException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceOwnerCheckException) Code() string {
	return "ResourceOwnerCheckException"
}

// Message returns the exception's message.
func (s *ResourceOwnerCheckException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceOwnerCheckException) OrigErr() error {
	return nil
}

func (s *ResourceOwnerCheckException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceOwnerCheckException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceOwnerCheckException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The inspection criteria and action for a single stateless rule. AWS Network
// Firewall inspects each packet for the specified matching criteria. When a
// packet matches the criteria, Network Firewall performs the rule's actions
// on the packet.
type RuleDefinition struct {
	_ struct{} `type:"structure"`

	// The actions to take on a packet that matches one of the stateless rule definition's
	// match attributes. You must specify a standard action and you can add custom
	// actions.
	//
	// Network Firewall only forwards a packet for stateful rule inspection if you
	// specify aws:forward_to_sfe for a rule that the packet matches, or if the
	// packet doesn't match any stateless rule and you specify aws:forward_to_sfe
	// for the StatelessDefaultActions setting for the FirewallPolicy.
	//
	// For every rule, you must specify exactly one of the following standard actions.
	//
	//    * aws:pass - Discontinues all inspection of the packet and permits it
	//    to go to its intended destination.
	//
	//    * aws:drop - Discontinues all inspection of the packet and blocks it from
	//    going to its intended destination.
	//
	//    * aws:forward_to_sfe - Discontinues stateless inspection of the packet
	//    and forwards it to the stateful rule engine for inspection.
	//
	// Additionally, you can specify a custom action. To do this, you define a custom
	// action by name and type, then provide the name you've assigned to the action
	// in this Actions setting. For information about the options, see CustomAction.
	//
	// To provide more than one action in this setting, separate the settings with
	// a comma. For example, if you have a custom PublishMetrics action that you've
	// named MyMetricsAction, then you could specify the standard action aws:pass
	// and the custom action with [“aws:pass”, “MyMetricsAction”].
	//
	// Actions is a required field
	Actions []*string `type:"list" required:"true"`

	// Criteria for Network Firewall to use to inspect an individual packet in stateless
	// rule inspection. Each match attributes set can include one or more items
	// such as IP address, CIDR range, port number, protocol, and TCP flags.
	//
	// MatchAttributes is a required field
	MatchAttributes *MatchAttributes `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleDefinition"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.MatchAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("MatchAttributes"))
	}
	if s.MatchAttributes != nil {
		if err := s.MatchAttributes.Validate(); err != nil {
			invalidParams.AddNested("MatchAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *RuleDefinition) SetActions(v []*string) *RuleDefinition {
	s.Actions = v
	return s
}

// SetMatchAttributes sets the MatchAttributes field's value.
func (s *RuleDefinition) SetMatchAttributes(v *MatchAttributes) *RuleDefinition {
	s.MatchAttributes = v
	return s
}

// The object that defines the rules in a rule group. This, along with RuleGroupResponse,
// define the rule group. You can retrieve all objects for a rule group by calling
// DescribeRuleGroup.
//
// AWS Network Firewall uses a rule group to inspect and control network traffic.
// You define stateless rule groups to inspect individual packets and you define
// stateful rule groups to inspect packets in the context of their traffic flow.
//
// To use a rule group, you include it by reference in an Network Firewall firewall
// policy, then you use the policy in a firewall. You can reference a rule group
// from more than one firewall policy, and you can use a firewall policy in
// more than one firewall.
type RuleGroup struct {
	_ struct{} `type:"structure"`

	// Settings that are available for use in the rules in the rule group. You can
	// only use these for stateful rule groups.
	RuleVariables *RuleVariables `type:"structure"`

	// The stateful rules or stateless rules for the rule group.
	//
	// RulesSource is a required field
	RulesSource *RulesSource `type:"structure" required:"true"`

	// Additional options governing how Network Firewall handles stateful rules.
	// The policies where you use your stateful rule group must have stateful rule
	// options settings that are compatible with these settings.
	StatefulRuleOptions *StatefulRuleOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleGroup"}
	if s.RulesSource == nil {
		invalidParams.Add(request.NewErrParamRequired("RulesSource"))
	}
	if s.RuleVariables != nil {
		if err := s.RuleVariables.Validate(); err != nil {
			invalidParams.AddNested("RuleVariables", err.(request.ErrInvalidParams))
		}
	}
	if s.RulesSource != nil {
		if err := s.RulesSource.Validate(); err != nil {
			invalidParams.AddNested("RulesSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleVariables sets the RuleVariables field's value.
func (s *RuleGroup) SetRuleVariables(v *RuleVariables) *RuleGroup {
	s.RuleVariables = v
	return s
}

// SetRulesSource sets the RulesSource field's value.
func (s *RuleGroup) SetRulesSource(v *RulesSource) *RuleGroup {
	s.RulesSource = v
	return s
}

// SetStatefulRuleOptions sets the StatefulRuleOptions field's value.
func (s *RuleGroup) SetStatefulRuleOptions(v *StatefulRuleOptions) *RuleGroup {
	s.StatefulRuleOptions = v
	return s
}

// High-level information about a rule group, returned by ListRuleGroups. You
// can use the information provided in the metadata to retrieve and manage a
// rule group.
type RuleGroupMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule group.
	Arn *string `min:"1" type:"string"`

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroupMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroupMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RuleGroupMetadata) SetArn(v string) *RuleGroupMetadata {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *RuleGroupMetadata) SetName(v string) *RuleGroupMetadata {
	s.Name = &v
	return s
}

// The high-level properties of a rule group. This, along with the RuleGroup,
// define the rule group. You can retrieve all objects for a rule group by calling
// DescribeRuleGroup.
type RuleGroupResponse struct {
	_ struct{} `type:"structure"`

	// The maximum operating resources that this rule group can use. Rule group
	// capacity is fixed at creation. When you update a rule group, you are limited
	// to this capacity. When you reference a rule group from a firewall policy,
	// Network Firewall reserves this capacity for the rule group.
	//
	// You can retrieve the capacity that would be required for a rule group before
	// you create the rule group by calling CreateRuleGroup with DryRun set to TRUE.
	Capacity *int64 `type:"integer"`

	// The number of capacity units currently consumed by the rule group rules.
	ConsumedCapacity *int64 `type:"integer"`

	// A description of the rule group.
	Description *string `type:"string"`

	// The number of firewall policies that use this rule group.
	NumberOfAssociations *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the rule group.
	//
	// If this response is for a create request that had DryRun set to TRUE, then
	// this ARN is a placeholder that isn't attached to a valid resource.
	//
	// RuleGroupArn is a required field
	RuleGroupArn *string `min:"1" type:"string" required:"true"`

	// The unique identifier for the rule group.
	//
	// RuleGroupId is a required field
	RuleGroupId *string `min:"36" type:"string" required:"true"`

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// RuleGroupName is a required field
	RuleGroupName *string `min:"1" type:"string" required:"true"`

	// Detailed information about the current status of a rule group.
	RuleGroupStatus *string `type:"string" enum:"ResourceStatus"`

	// The key:value pairs to associate with the resource.
	Tags []*Tag `min:"1" type:"list"`

	// Indicates whether the rule group is stateless or stateful. If the rule group
	// is stateless, it contains stateless rules. If it is stateful, it contains
	// stateful rules.
	Type *string `type:"string" enum:"RuleGroupType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroupResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroupResponse) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *RuleGroupResponse) SetCapacity(v int64) *RuleGroupResponse {
	s.Capacity = &v
	return s
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *RuleGroupResponse) SetConsumedCapacity(v int64) *RuleGroupResponse {
	s.ConsumedCapacity = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RuleGroupResponse) SetDescription(v string) *RuleGroupResponse {
	s.Description = &v
	return s
}

// SetNumberOfAssociations sets the NumberOfAssociations field's value.
func (s *RuleGroupResponse) SetNumberOfAssociations(v int64) *RuleGroupResponse {
	s.NumberOfAssociations = &v
	return s
}

// SetRuleGroupArn sets the RuleGroupArn field's value.
func (s *RuleGroupResponse) SetRuleGroupArn(v string) *RuleGroupResponse {
	s.RuleGroupArn = &v
	return s
}

// SetRuleGroupId sets the RuleGroupId field's value.
func (s *RuleGroupResponse) SetRuleGroupId(v string) *RuleGroupResponse {
	s.RuleGroupId = &v
	return s
}

// SetRuleGroupName sets the RuleGroupName field's value.
func (s *RuleGroupResponse) SetRuleGroupName(v string) *RuleGroupResponse {
	s.RuleGroupName = &v
	return s
}

// SetRuleGroupStatus sets the RuleGroupStatus field's value.
func (s *RuleGroupResponse) SetRuleGroupStatus(v string) *RuleGroupResponse {
	s.RuleGroupStatus = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RuleGroupResponse) SetTags(v []*Tag) *RuleGroupResponse {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *RuleGroupResponse) SetType(v string) *RuleGroupResponse {
	s.Type = &v
	return s
}

// Additional settings for a stateful rule. This is part of the StatefulRule
// configuration.
type RuleOption struct {
	_ struct{} `type:"structure"`

	// Keyword is a required field
	Keyword *string `min:"1" type:"string" required:"true"`

	Settings []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleOption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleOption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleOption"}
	if s.Keyword == nil {
		invalidParams.Add(request.NewErrParamRequired("Keyword"))
	}
	if s.Keyword != nil && len(*s.Keyword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Keyword", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyword sets the Keyword field's value.
func (s *RuleOption) SetKeyword(v string) *RuleOption {
	s.Keyword = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *RuleOption) SetSettings(v []*string) *RuleOption {
	s.Settings = v
	return s
}

// Settings that are available for use in the rules in the RuleGroup where this
// is defined.
type RuleVariables struct {
	_ struct{} `type:"structure"`

	// A list of IP addresses and address ranges, in CIDR notation.
	IPSets map[string]*IPSet `type:"map"`

	// A list of port ranges.
	PortSets map[string]*PortSet `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleVariables) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleVariables) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleVariables) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleVariables"}
	if s.IPSets != nil {
		for i, v := range s.IPSets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IPSets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIPSets sets the IPSets field's value.
func (s *RuleVariables) SetIPSets(v map[string]*IPSet) *RuleVariables {
	s.IPSets = v
	return s
}

// SetPortSets sets the PortSets field's value.
func (s *RuleVariables) SetPortSets(v map[string]*PortSet) *RuleVariables {
	s.PortSets = v
	return s
}

// The stateless or stateful rules definitions for use in a single rule group.
// Each rule group requires a single RulesSource. You can use an instance of
// this for either stateless rules or stateful rules.
type RulesSource struct {
	_ struct{} `type:"structure"`

	// Stateful inspection criteria for a domain list rule group.
	RulesSourceList *RulesSourceList `type:"structure"`

	// Stateful inspection criteria, provided in Suricata compatible intrusion prevention
	// system (IPS) rules. Suricata is an open-source network IPS that includes
	// a standard rule-based language for network traffic inspection.
	//
	// These rules contain the inspection criteria and the action to take for traffic
	// that matches the criteria, so this type of rule group doesn't have a separate
	// action setting.
	RulesString *string `type:"string"`

	// An array of individual stateful rules inspection criteria to be used together
	// in a stateful rule group. Use this option to specify simple Suricata rules
	// with protocol, source and destination, ports, direction, and rule options.
	// For information about the Suricata Rules format, see Rules Format (https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#).
	StatefulRules []*StatefulRule `type:"list"`

	// Stateless inspection criteria to be used in a stateless rule group.
	StatelessRulesAndCustomActions *StatelessRulesAndCustomActions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RulesSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RulesSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RulesSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RulesSource"}
	if s.RulesSourceList != nil {
		if err := s.RulesSourceList.Validate(); err != nil {
			invalidParams.AddNested("RulesSourceList", err.(request.ErrInvalidParams))
		}
	}
	if s.StatefulRules != nil {
		for i, v := range s.StatefulRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StatefulRules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StatelessRulesAndCustomActions != nil {
		if err := s.StatelessRulesAndCustomActions.Validate(); err != nil {
			invalidParams.AddNested("StatelessRulesAndCustomActions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRulesSourceList sets the RulesSourceList field's value.
func (s *RulesSource) SetRulesSourceList(v *RulesSourceList) *RulesSource {
	s.RulesSourceList = v
	return s
}

// SetRulesString sets the RulesString field's value.
func (s *RulesSource) SetRulesString(v string) *RulesSource {
	s.RulesString = &v
	return s
}

// SetStatefulRules sets the StatefulRules field's value.
func (s *RulesSource) SetStatefulRules(v []*StatefulRule) *RulesSource {
	s.StatefulRules = v
	return s
}

// SetStatelessRulesAndCustomActions sets the StatelessRulesAndCustomActions field's value.
func (s *RulesSource) SetStatelessRulesAndCustomActions(v *StatelessRulesAndCustomActions) *RulesSource {
	s.StatelessRulesAndCustomActions = v
	return s
}

// Stateful inspection criteria for a domain list rule group.
//
// For HTTPS traffic, domain filtering is SNI-based. It uses the server name
// indicator extension of the TLS handshake.
//
// By default, Network Firewall domain list inspection only includes traffic
// coming from the VPC where you deploy the firewall. To inspect traffic from
// IP addresses outside of the deployment VPC, you set the HOME_NET rule variable
// to include the CIDR range of the deployment VPC plus the other CIDR ranges.
// For more information, see RuleVariables in this guide and Stateful domain
// list rule groups in AWS Network Firewall (https://docs.aws.amazon.com/network-firewall/latest/developerguide/stateful-rule-groups-domain-names.html)
// in the Network Firewall Developer Guide.
type RulesSourceList struct {
	_ struct{} `type:"structure"`

	// Whether you want to allow or deny access to the domains in your target list.
	//
	// GeneratedRulesType is a required field
	GeneratedRulesType *string `type:"string" required:"true" enum:"GeneratedRulesType"`

	// The protocols you want to inspect. Specify TLS_SNI for HTTPS. Specify HTTP_HOST
	// for HTTP. You can specify either or both.
	//
	// TargetTypes is a required field
	TargetTypes []*string `type:"list" required:"true" enum:"TargetType"`

	// The domains that you want to inspect for in your traffic flows. Valid domain
	// specifications are the following:
	//
	//    * Explicit names. For example, abc.example.com matches only the domain
	//    abc.example.com.
	//
	//    * Names that use a domain wildcard, which you indicate with an initial
	//    '.'. For example,.example.com matches example.com and matches all subdomains
	//    of example.com, such as abc.example.com and www.example.com.
	//
	// Targets is a required field
	Targets []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RulesSourceList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RulesSourceList) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RulesSourceList) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RulesSourceList"}
	if s.GeneratedRulesType == nil {
		invalidParams.Add(request.NewErrParamRequired("GeneratedRulesType"))
	}
	if s.TargetTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetTypes"))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeneratedRulesType sets the GeneratedRulesType field's value.
func (s *RulesSourceList) SetGeneratedRulesType(v string) *RulesSourceList {
	s.GeneratedRulesType = &v
	return s
}

// SetTargetTypes sets the TargetTypes field's value.
func (s *RulesSourceList) SetTargetTypes(v []*string) *RulesSourceList {
	s.TargetTypes = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *RulesSourceList) SetTargets(v []*string) *RulesSourceList {
	s.Targets = v
	return s
}

// Configuration settings for the handling of the stateful rule groups in a
// firewall policy.
type StatefulEngineOptions struct {
	_ struct{} `type:"structure"`

	// Indicates how to manage the order of stateful rule evaluation for the policy.
	// DEFAULT_ACTION_ORDER is the default behavior. Stateful rules are provided
	// to the rule engine as Suricata compatible strings, and Suricata evaluates
	// them based on certain settings. For more information, see Evaluation order
	// for stateful rules (https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html)
	// in the AWS Network Firewall Developer Guide.
	RuleOrder *string `type:"string" enum:"RuleOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulEngineOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulEngineOptions) GoString() string {
	return s.String()
}

// SetRuleOrder sets the RuleOrder field's value.
func (s *StatefulEngineOptions) SetRuleOrder(v string) *StatefulEngineOptions {
	s.RuleOrder = &v
	return s
}

// A single Suricata rules specification, for use in a stateful rule group.
// Use this option to specify a simple Suricata rule with protocol, source and
// destination, ports, direction, and rule options. For information about the
// Suricata Rules format, see Rules Format (https://suricata.readthedocs.io/en/suricata-5.0.0/rules/intro.html#).
type StatefulRule struct {
	_ struct{} `type:"structure"`

	// Defines what Network Firewall should do with the packets in a traffic flow
	// when the flow matches the stateful rule criteria. For all actions, Network
	// Firewall performs the specified action and discontinues stateful inspection
	// of the traffic flow.
	//
	// The actions for a stateful rule are defined as follows:
	//
	//    * PASS - Permits the packets to go to the intended destination.
	//
	//    * DROP - Blocks the packets from going to the intended destination and
	//    sends an alert log message, if alert logging is configured in the Firewall
	//    LoggingConfiguration.
	//
	//    * ALERT - Permits the packets to go to the intended destination and sends
	//    an alert log message, if alert logging is configured in the Firewall LoggingConfiguration.
	//    You can use this action to test a rule that you intend to use to drop
	//    traffic. You can enable the rule with ALERT action, verify in the logs
	//    that the rule is filtering as you want, then change the action to DROP.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"StatefulAction"`

	// The stateful inspection criteria for this rule, used to inspect traffic flows.
	//
	// Header is a required field
	Header *Header `type:"structure" required:"true"`

	// Additional options for the rule. These are the Suricata RuleOptions settings.
	//
	// RuleOptions is a required field
	RuleOptions []*RuleOption `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatefulRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatefulRule"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Header == nil {
		invalidParams.Add(request.NewErrParamRequired("Header"))
	}
	if s.RuleOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleOptions"))
	}
	if s.Header != nil {
		if err := s.Header.Validate(); err != nil {
			invalidParams.AddNested("Header", err.(request.ErrInvalidParams))
		}
	}
	if s.RuleOptions != nil {
		for i, v := range s.RuleOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RuleOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *StatefulRule) SetAction(v string) *StatefulRule {
	s.Action = &v
	return s
}

// SetHeader sets the Header field's value.
func (s *StatefulRule) SetHeader(v *Header) *StatefulRule {
	s.Header = v
	return s
}

// SetRuleOptions sets the RuleOptions field's value.
func (s *StatefulRule) SetRuleOptions(v []*RuleOption) *StatefulRule {
	s.RuleOptions = v
	return s
}

// The setting that allows the policy owner to change the behavior of the rule
// group within a policy.
type StatefulRuleGroupOverride struct {
	_ struct{} `type:"structure"`

	// The action that changes the rule group from DROP to ALERT. This only applies
	// to managed rule groups.
	Action *string `type:"string" enum:"OverrideAction"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulRuleGroupOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulRuleGroupOverride) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *StatefulRuleGroupOverride) SetAction(v string) *StatefulRuleGroupOverride {
	s.Action = &v
	return s
}

// Identifier for a single stateful rule group, used in a firewall policy to
// refer to a rule group.
type StatefulRuleGroupReference struct {
	_ struct{} `type:"structure"`

	// The action that allows the policy owner to override the behavior of the rule
	// group within a policy.
	Override *StatefulRuleGroupOverride `type:"structure"`

	// An integer setting that indicates the order in which to run the stateful
	// rule groups in a single FirewallPolicy. This setting only applies to firewall
	// policies that specify the STRICT_ORDER rule order in the stateful engine
	// options settings.
	//
	// Network Firewall evalutes each stateful rule group against a packet starting
	// with the group that has the lowest priority setting. You must ensure that
	// the priority settings are unique within each policy.
	//
	// You can change the priority settings of your rule groups at any time. To
	// make it easier to insert rule groups later, number them so there's a wide
	// range in between, for example use 100, 200, and so on.
	Priority *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the stateful rule group.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulRuleGroupReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulRuleGroupReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatefulRuleGroupReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatefulRuleGroupReference"}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOverride sets the Override field's value.
func (s *StatefulRuleGroupReference) SetOverride(v *StatefulRuleGroupOverride) *StatefulRuleGroupReference {
	s.Override = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *StatefulRuleGroupReference) SetPriority(v int64) *StatefulRuleGroupReference {
	s.Priority = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *StatefulRuleGroupReference) SetResourceArn(v string) *StatefulRuleGroupReference {
	s.ResourceArn = &v
	return s
}

// Additional options governing how Network Firewall handles the rule group.
// You can only use these for stateful rule groups.
type StatefulRuleOptions struct {
	_ struct{} `type:"structure"`

	// Indicates how to manage the order of the rule evaluation for the rule group.
	// DEFAULT_ACTION_ORDER is the default behavior. Stateful rules are provided
	// to the rule engine as Suricata compatible strings, and Suricata evaluates
	// them based on certain settings. For more information, see Evaluation order
	// for stateful rules (https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html)
	// in the AWS Network Firewall Developer Guide.
	RuleOrder *string `type:"string" enum:"RuleOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulRuleOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatefulRuleOptions) GoString() string {
	return s.String()
}

// SetRuleOrder sets the RuleOrder field's value.
func (s *StatefulRuleOptions) SetRuleOrder(v string) *StatefulRuleOptions {
	s.RuleOrder = &v
	return s
}

// A single stateless rule. This is used in StatelessRulesAndCustomActions.
type StatelessRule struct {
	_ struct{} `type:"structure"`

	// Indicates the order in which to run this rule relative to all of the rules
	// that are defined for a stateless rule group. Network Firewall evaluates the
	// rules in a rule group starting with the lowest priority setting. You must
	// ensure that the priority settings are unique for the rule group.
	//
	// Each stateless rule group uses exactly one StatelessRulesAndCustomActions
	// object, and each StatelessRulesAndCustomActions contains exactly one StatelessRules
	// object. To ensure unique priority settings for your rule groups, set unique
	// priorities for the stateless rules that you define inside any single StatelessRules
	// object.
	//
	// You can change the priority settings of your rules at any time. To make it
	// easier to insert rules later, number them so there's a wide range in between,
	// for example use 100, 200, and so on.
	//
	// Priority is a required field
	Priority *int64 `min:"1" type:"integer" required:"true"`

	// Defines the stateless 5-tuple packet inspection criteria and the action to
	// take on a packet that matches the criteria.
	//
	// RuleDefinition is a required field
	RuleDefinition *RuleDefinition `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatelessRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatelessRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatelessRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatelessRule"}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.RuleDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleDefinition"))
	}
	if s.RuleDefinition != nil {
		if err := s.RuleDefinition.Validate(); err != nil {
			invalidParams.AddNested("RuleDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPriority sets the Priority field's value.
func (s *StatelessRule) SetPriority(v int64) *StatelessRule {
	s.Priority = &v
	return s
}

// SetRuleDefinition sets the RuleDefinition field's value.
func (s *StatelessRule) SetRuleDefinition(v *RuleDefinition) *StatelessRule {
	s.RuleDefinition = v
	return s
}

// Identifier for a single stateless rule group, used in a firewall policy to
// refer to the rule group.
type StatelessRuleGroupReference struct {
	_ struct{} `type:"structure"`

	// An integer setting that indicates the order in which to run the stateless
	// rule groups in a single FirewallPolicy. Network Firewall applies each stateless
	// rule group to a packet starting with the group that has the lowest priority
	// setting. You must ensure that the priority settings are unique within each
	// policy.
	//
	// Priority is a required field
	Priority *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the stateless rule group.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatelessRuleGroupReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatelessRuleGroupReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatelessRuleGroupReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatelessRuleGroupReference"}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPriority sets the Priority field's value.
func (s *StatelessRuleGroupReference) SetPriority(v int64) *StatelessRuleGroupReference {
	s.Priority = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *StatelessRuleGroupReference) SetResourceArn(v string) *StatelessRuleGroupReference {
	s.ResourceArn = &v
	return s
}

// Stateless inspection criteria. Each stateless rule group uses exactly one
// of these data types to define its stateless rules.
type StatelessRulesAndCustomActions struct {
	_ struct{} `type:"structure"`

	// Defines an array of individual custom action definitions that are available
	// for use by the stateless rules in this StatelessRulesAndCustomActions specification.
	// You name each custom action that you define, and then you can use it by name
	// in your StatelessRule RuleDefinition Actions specification.
	CustomActions []*CustomAction `type:"list"`

	// Defines the set of stateless rules for use in a stateless rule group.
	//
	// StatelessRules is a required field
	StatelessRules []*StatelessRule `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatelessRulesAndCustomActions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatelessRulesAndCustomActions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatelessRulesAndCustomActions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatelessRulesAndCustomActions"}
	if s.StatelessRules == nil {
		invalidParams.Add(request.NewErrParamRequired("StatelessRules"))
	}
	if s.CustomActions != nil {
		for i, v := range s.CustomActions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomActions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StatelessRules != nil {
		for i, v := range s.StatelessRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StatelessRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomActions sets the CustomActions field's value.
func (s *StatelessRulesAndCustomActions) SetCustomActions(v []*CustomAction) *StatelessRulesAndCustomActions {
	s.CustomActions = v
	return s
}

// SetStatelessRules sets the StatelessRules field's value.
func (s *StatelessRulesAndCustomActions) SetStatelessRules(v []*StatelessRule) *StatelessRulesAndCustomActions {
	s.StatelessRules = v
	return s
}

// The ID for a subnet that you want to associate with the firewall. This is
// used with CreateFirewall and AssociateSubnets. AWS Network Firewall creates
// an instance of the associated firewall in each subnet that you specify, to
// filter traffic in the subnet's Availability Zone.
type SubnetMapping struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the subnet.
	//
	// SubnetId is a required field
	SubnetId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubnetMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubnetMapping"}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubnetId sets the SubnetId field's value.
func (s *SubnetMapping) SetSubnetId(v string) *SubnetMapping {
	s.SubnetId = &v
	return s
}

// The status of the firewall endpoint and firewall policy configuration for
// a single VPC subnet.
//
// For each VPC subnet that you associate with a firewall, AWS Network Firewall
// does the following:
//
//    * Instantiates a firewall endpoint in the subnet, ready to take traffic.
//
//    * Configures the endpoint with the current firewall policy settings, to
//    provide the filtering behavior for the endpoint.
//
// When you update a firewall, for example to add a subnet association or change
// a rule group in the firewall policy, the affected sync states reflect out-of-sync
// or not ready status until the changes are complete.
type SyncState struct {
	_ struct{} `type:"structure"`

	// The attachment status of the firewall's association with a single VPC subnet.
	// For each configured subnet, Network Firewall creates the attachment by instantiating
	// the firewall endpoint in the subnet so that it's ready to take traffic. This
	// is part of the FirewallStatus.
	Attachment *Attachment `type:"structure"`

	// The configuration status of the firewall endpoint in a single VPC subnet.
	// Network Firewall provides each endpoint with the rules that are configured
	// in the firewall policy. Each time you add a subnet or modify the associated
	// firewall policy, Network Firewall synchronizes the rules in the endpoint,
	// so it can properly filter network traffic. This is part of the FirewallStatus.
	Config map[string]*PerObjectStatus `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncState) GoString() string {
	return s.String()
}

// SetAttachment sets the Attachment field's value.
func (s *SyncState) SetAttachment(v *Attachment) *SyncState {
	s.Attachment = v
	return s
}

// SetConfig sets the Config field's value.
func (s *SyncState) SetConfig(v map[string]*PerObjectStatus) *SyncState {
	s.Config = v
	return s
}

// TCP flags and masks to inspect packets for, used in stateless rules MatchAttributes
// settings.
type TCPFlagField struct {
	_ struct{} `type:"structure"`

	// Used in conjunction with the Masks setting to define the flags that must
	// be set and flags that must not be set in order for the packet to match. This
	// setting can only specify values that are also specified in the Masks setting.
	//
	// For the flags that are specified in the masks setting, the following must
	// be true for the packet to match:
	//
	//    * The ones that are set in this flags setting must be set in the packet.
	//
	//    * The ones that are not set in this flags setting must also not be set
	//    in the packet.
	//
	// Flags is a required field
	Flags []*string `type:"list" required:"true" enum:"TCPFlag"`

	// The set of flags to consider in the inspection. To inspect all flags in the
	// valid values list, leave this with no setting.
	Masks []*string `type:"list" enum:"TCPFlag"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TCPFlagField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TCPFlagField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TCPFlagField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TCPFlagField"}
	if s.Flags == nil {
		invalidParams.Add(request.NewErrParamRequired("Flags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlags sets the Flags field's value.
func (s *TCPFlagField) SetFlags(v []*string) *TCPFlagField {
	s.Flags = v
	return s
}

// SetMasks sets the Masks field's value.
func (s *TCPFlagField) SetMasks(v []*string) *TCPFlagField {
	s.Masks = v
	return s
}

// A key:value pair associated with an AWS resource. The key:value pair can
// be anything you define. Typically, the tag key represents a category (such
// as "environment") and the tag value represents a specific value within that
// category (such as "test," "development," or "production"). You can add up
// to 50 tags to each AWS resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The part of the key:value pair that defines a tag. You can use a tag key
	// to describe a category of information, such as "customer." Tag keys are case-sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The part of the key:value pair that defines a tag. You can use a tag value
	// to describe a specific value within a category, such as "companyA" or "companyB."
	// Tag values are case-sensitive.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Unable to process the request due to throttling limitations.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation you requested isn't supported by Network Firewall.
type UnsupportedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedOperationException(v protocol.ResponseMetadata) error {
	return &UnsupportedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedOperationException) Code() string {
	return "UnsupportedOperationException"
}

// Message returns the exception's message.
func (s *UnsupportedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedOperationException) OrigErr() error {
	return nil
}

func (s *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateFirewallDeleteProtectionInput struct {
	_ struct{} `type:"structure"`

	// A flag indicating whether it is possible to delete the firewall. A setting
	// of TRUE indicates that the firewall is protected against deletion. Use this
	// setting to protect against accidentally deleting a firewall that is in use.
	// When you create a firewall, the operation initializes this flag to TRUE.
	//
	// DeleteProtection is a required field
	DeleteProtection *bool `type:"boolean" required:"true"`

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string `min:"1" type:"string"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDeleteProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDeleteProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFirewallDeleteProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFirewallDeleteProtectionInput"}
	if s.DeleteProtection == nil {
		invalidParams.Add(request.NewErrParamRequired("DeleteProtection"))
	}
	if s.FirewallArn != nil && len(*s.FirewallArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallArn", 1))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteProtection sets the DeleteProtection field's value.
func (s *UpdateFirewallDeleteProtectionInput) SetDeleteProtection(v bool) *UpdateFirewallDeleteProtectionInput {
	s.DeleteProtection = &v
	return s
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *UpdateFirewallDeleteProtectionInput) SetFirewallArn(v string) *UpdateFirewallDeleteProtectionInput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *UpdateFirewallDeleteProtectionInput) SetFirewallName(v string) *UpdateFirewallDeleteProtectionInput {
	s.FirewallName = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateFirewallDeleteProtectionInput) SetUpdateToken(v string) *UpdateFirewallDeleteProtectionInput {
	s.UpdateToken = &v
	return s
}

type UpdateFirewallDeleteProtectionOutput struct {
	_ struct{} `type:"structure"`

	// A flag indicating whether it is possible to delete the firewall. A setting
	// of TRUE indicates that the firewall is protected against deletion. Use this
	// setting to protect against accidentally deleting a firewall that is in use.
	// When you create a firewall, the operation initializes this flag to TRUE.
	DeleteProtection *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string `min:"1" type:"string"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDeleteProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDeleteProtectionOutput) GoString() string {
	return s.String()
}

// SetDeleteProtection sets the DeleteProtection field's value.
func (s *UpdateFirewallDeleteProtectionOutput) SetDeleteProtection(v bool) *UpdateFirewallDeleteProtectionOutput {
	s.DeleteProtection = &v
	return s
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *UpdateFirewallDeleteProtectionOutput) SetFirewallArn(v string) *UpdateFirewallDeleteProtectionOutput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *UpdateFirewallDeleteProtectionOutput) SetFirewallName(v string) *UpdateFirewallDeleteProtectionOutput {
	s.FirewallName = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateFirewallDeleteProtectionOutput) SetUpdateToken(v string) *UpdateFirewallDeleteProtectionOutput {
	s.UpdateToken = &v
	return s
}

type UpdateFirewallDescriptionInput struct {
	_ struct{} `type:"structure"`

	// The new description for the firewall. If you omit this setting, Network Firewall
	// removes the description for the firewall.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string `min:"1" type:"string"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDescriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDescriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFirewallDescriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFirewallDescriptionInput"}
	if s.FirewallArn != nil && len(*s.FirewallArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallArn", 1))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateFirewallDescriptionInput) SetDescription(v string) *UpdateFirewallDescriptionInput {
	s.Description = &v
	return s
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *UpdateFirewallDescriptionInput) SetFirewallArn(v string) *UpdateFirewallDescriptionInput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *UpdateFirewallDescriptionInput) SetFirewallName(v string) *UpdateFirewallDescriptionInput {
	s.FirewallName = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateFirewallDescriptionInput) SetUpdateToken(v string) *UpdateFirewallDescriptionInput {
	s.UpdateToken = &v
	return s
}

type UpdateFirewallDescriptionOutput struct {
	_ struct{} `type:"structure"`

	// A description of the firewall.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string `min:"1" type:"string"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDescriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDescriptionOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateFirewallDescriptionOutput) SetDescription(v string) *UpdateFirewallDescriptionOutput {
	s.Description = &v
	return s
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *UpdateFirewallDescriptionOutput) SetFirewallArn(v string) *UpdateFirewallDescriptionOutput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *UpdateFirewallDescriptionOutput) SetFirewallName(v string) *UpdateFirewallDescriptionOutput {
	s.FirewallName = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateFirewallDescriptionOutput) SetUpdateToken(v string) *UpdateFirewallDescriptionOutput {
	s.UpdateToken = &v
	return s
}

type UpdateFirewallPolicyChangeProtectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string `min:"1" type:"string"`

	// A setting indicating whether the firewall is protected against a change to
	// the firewall policy association. Use this setting to protect against accidentally
	// modifying the firewall policy for a firewall that is in use. When you create
	// a firewall, the operation initializes this setting to TRUE.
	//
	// FirewallPolicyChangeProtection is a required field
	FirewallPolicyChangeProtection *bool `type:"boolean" required:"true"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallPolicyChangeProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallPolicyChangeProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFirewallPolicyChangeProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFirewallPolicyChangeProtectionInput"}
	if s.FirewallArn != nil && len(*s.FirewallArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallArn", 1))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}
	if s.FirewallPolicyChangeProtection == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallPolicyChangeProtection"))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *UpdateFirewallPolicyChangeProtectionInput) SetFirewallArn(v string) *UpdateFirewallPolicyChangeProtectionInput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *UpdateFirewallPolicyChangeProtectionInput) SetFirewallName(v string) *UpdateFirewallPolicyChangeProtectionInput {
	s.FirewallName = &v
	return s
}

// SetFirewallPolicyChangeProtection sets the FirewallPolicyChangeProtection field's value.
func (s *UpdateFirewallPolicyChangeProtectionInput) SetFirewallPolicyChangeProtection(v bool) *UpdateFirewallPolicyChangeProtectionInput {
	s.FirewallPolicyChangeProtection = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateFirewallPolicyChangeProtectionInput) SetUpdateToken(v string) *UpdateFirewallPolicyChangeProtectionInput {
	s.UpdateToken = &v
	return s
}

type UpdateFirewallPolicyChangeProtectionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string `min:"1" type:"string"`

	// A setting indicating whether the firewall is protected against a change to
	// the firewall policy association. Use this setting to protect against accidentally
	// modifying the firewall policy for a firewall that is in use. When you create
	// a firewall, the operation initializes this setting to TRUE.
	FirewallPolicyChangeProtection *bool `type:"boolean"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallPolicyChangeProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallPolicyChangeProtectionOutput) GoString() string {
	return s.String()
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *UpdateFirewallPolicyChangeProtectionOutput) SetFirewallArn(v string) *UpdateFirewallPolicyChangeProtectionOutput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *UpdateFirewallPolicyChangeProtectionOutput) SetFirewallName(v string) *UpdateFirewallPolicyChangeProtectionOutput {
	s.FirewallName = &v
	return s
}

// SetFirewallPolicyChangeProtection sets the FirewallPolicyChangeProtection field's value.
func (s *UpdateFirewallPolicyChangeProtectionOutput) SetFirewallPolicyChangeProtection(v bool) *UpdateFirewallPolicyChangeProtectionOutput {
	s.FirewallPolicyChangeProtection = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateFirewallPolicyChangeProtectionOutput) SetUpdateToken(v string) *UpdateFirewallPolicyChangeProtectionOutput {
	s.UpdateToken = &v
	return s
}

type UpdateFirewallPolicyInput struct {
	_ struct{} `type:"structure"`

	// A description of the firewall policy.
	Description *string `type:"string"`

	// Indicates whether you want Network Firewall to just check the validity of
	// the request, rather than run the request.
	//
	// If set to TRUE, Network Firewall checks whether the request can run successfully,
	// but doesn't actually make the requested changes. The call returns the value
	// that the request would return if you ran it with dry run set to FALSE, but
	// doesn't make additions or changes to your resources. This option allows you
	// to make sure that you have the required permissions to run the request and
	// that your request parameters are valid.
	//
	// If set to FALSE, Network Firewall makes the requested changes to your resources.
	DryRun *bool `type:"boolean"`

	// The updated firewall policy to use for the firewall.
	//
	// FirewallPolicy is a required field
	FirewallPolicy *FirewallPolicy `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the firewall policy.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallPolicyArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall policy. You can't change the name of
	// a firewall policy after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallPolicyName *string `min:"1" type:"string"`

	// A token used for optimistic locking. Network Firewall returns a token to
	// your requests that access the firewall policy. The token marks the state
	// of the policy resource at the time of the request.
	//
	// To make changes to the policy, you provide the token in your request. Network
	// Firewall uses the token to ensure that the policy hasn't changed since you
	// last retrieved it. If it has changed, the operation fails with an InvalidTokenException.
	// If this happens, retrieve the firewall policy again to get a current copy
	// of it with current token. Reapply your changes as needed, then try the operation
	// again using the new token.
	//
	// UpdateToken is a required field
	UpdateToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFirewallPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFirewallPolicyInput"}
	if s.FirewallPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallPolicy"))
	}
	if s.FirewallPolicyArn != nil && len(*s.FirewallPolicyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallPolicyArn", 1))
	}
	if s.FirewallPolicyName != nil && len(*s.FirewallPolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallPolicyName", 1))
	}
	if s.UpdateToken == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateToken"))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}
	if s.FirewallPolicy != nil {
		if err := s.FirewallPolicy.Validate(); err != nil {
			invalidParams.AddNested("FirewallPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateFirewallPolicyInput) SetDescription(v string) *UpdateFirewallPolicyInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *UpdateFirewallPolicyInput) SetDryRun(v bool) *UpdateFirewallPolicyInput {
	s.DryRun = &v
	return s
}

// SetFirewallPolicy sets the FirewallPolicy field's value.
func (s *UpdateFirewallPolicyInput) SetFirewallPolicy(v *FirewallPolicy) *UpdateFirewallPolicyInput {
	s.FirewallPolicy = v
	return s
}

// SetFirewallPolicyArn sets the FirewallPolicyArn field's value.
func (s *UpdateFirewallPolicyInput) SetFirewallPolicyArn(v string) *UpdateFirewallPolicyInput {
	s.FirewallPolicyArn = &v
	return s
}

// SetFirewallPolicyName sets the FirewallPolicyName field's value.
func (s *UpdateFirewallPolicyInput) SetFirewallPolicyName(v string) *UpdateFirewallPolicyInput {
	s.FirewallPolicyName = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateFirewallPolicyInput) SetUpdateToken(v string) *UpdateFirewallPolicyInput {
	s.UpdateToken = &v
	return s
}

type UpdateFirewallPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The high-level properties of a firewall policy. This, along with the FirewallPolicy,
	// define the policy. You can retrieve all objects for a firewall policy by
	// calling DescribeFirewallPolicy.
	//
	// FirewallPolicyResponse is a required field
	FirewallPolicyResponse *FirewallPolicyResponse `type:"structure" required:"true"`

	// A token used for optimistic locking. Network Firewall returns a token to
	// your requests that access the firewall policy. The token marks the state
	// of the policy resource at the time of the request.
	//
	// To make changes to the policy, you provide the token in your request. Network
	// Firewall uses the token to ensure that the policy hasn't changed since you
	// last retrieved it. If it has changed, the operation fails with an InvalidTokenException.
	// If this happens, retrieve the firewall policy again to get a current copy
	// of it with current token. Reapply your changes as needed, then try the operation
	// again using the new token.
	//
	// UpdateToken is a required field
	UpdateToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallPolicyOutput) GoString() string {
	return s.String()
}

// SetFirewallPolicyResponse sets the FirewallPolicyResponse field's value.
func (s *UpdateFirewallPolicyOutput) SetFirewallPolicyResponse(v *FirewallPolicyResponse) *UpdateFirewallPolicyOutput {
	s.FirewallPolicyResponse = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateFirewallPolicyOutput) SetUpdateToken(v string) *UpdateFirewallPolicyOutput {
	s.UpdateToken = &v
	return s
}

type UpdateLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string `min:"1" type:"string"`

	// Defines how Network Firewall performs logging for a firewall. If you omit
	// this setting, Network Firewall disables logging for the firewall.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLoggingConfigurationInput"}
	if s.FirewallArn != nil && len(*s.FirewallArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallArn", 1))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}
	if s.LoggingConfiguration != nil {
		if err := s.LoggingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *UpdateLoggingConfigurationInput) SetFirewallArn(v string) *UpdateLoggingConfigurationInput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *UpdateLoggingConfigurationInput) SetFirewallName(v string) *UpdateLoggingConfigurationInput {
	s.FirewallName = &v
	return s
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *UpdateLoggingConfigurationInput) SetLoggingConfiguration(v *LoggingConfiguration) *UpdateLoggingConfigurationInput {
	s.LoggingConfiguration = v
	return s
}

type UpdateLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string `min:"1" type:"string"`

	// Defines how AWS Network Firewall performs logging for a Firewall.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *UpdateLoggingConfigurationOutput) SetFirewallArn(v string) *UpdateLoggingConfigurationOutput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *UpdateLoggingConfigurationOutput) SetFirewallName(v string) *UpdateLoggingConfigurationOutput {
	s.FirewallName = &v
	return s
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *UpdateLoggingConfigurationOutput) SetLoggingConfiguration(v *LoggingConfiguration) *UpdateLoggingConfigurationOutput {
	s.LoggingConfiguration = v
	return s
}

type UpdateRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// A description of the rule group.
	Description *string `type:"string"`

	// Indicates whether you want Network Firewall to just check the validity of
	// the request, rather than run the request.
	//
	// If set to TRUE, Network Firewall checks whether the request can run successfully,
	// but doesn't actually make the requested changes. The call returns the value
	// that the request would return if you ran it with dry run set to FALSE, but
	// doesn't make additions or changes to your resources. This option allows you
	// to make sure that you have the required permissions to run the request and
	// that your request parameters are valid.
	//
	// If set to FALSE, Network Firewall makes the requested changes to your resources.
	DryRun *bool `type:"boolean"`

	// An object that defines the rule group rules.
	//
	// You must provide either this rule group setting or a Rules setting, but not
	// both.
	RuleGroup *RuleGroup `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule group.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupArn *string `min:"1" type:"string"`

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupName *string `min:"1" type:"string"`

	// A string containing stateful rule group rules specifications in Suricata
	// flat format, with one rule per line. Use this to import your existing Suricata
	// compatible rule groups.
	//
	// You must provide either this rules setting or a populated RuleGroup setting,
	// but not both.
	//
	// You can provide your rule group specification in Suricata flat format through
	// this setting when you create or update your rule group. The call response
	// returns a RuleGroup object that Network Firewall has populated from your
	// string.
	Rules *string `type:"string"`

	// Indicates whether the rule group is stateless or stateful. If the rule group
	// is stateless, it contains stateless rules. If it is stateful, it contains
	// stateful rules.
	//
	// This setting is required for requests that do not include the RuleGroupARN.
	Type *string `type:"string" enum:"RuleGroupType"`

	// A token used for optimistic locking. Network Firewall returns a token to
	// your requests that access the rule group. The token marks the state of the
	// rule group resource at the time of the request.
	//
	// To make changes to the rule group, you provide the token in your request.
	// Network Firewall uses the token to ensure that the rule group hasn't changed
	// since you last retrieved it. If it has changed, the operation fails with
	// an InvalidTokenException. If this happens, retrieve the rule group again
	// to get a current copy of it with a current token. Reapply your changes as
	// needed, then try the operation again using the new token.
	//
	// UpdateToken is a required field
	UpdateToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleGroupInput"}
	if s.RuleGroupArn != nil && len(*s.RuleGroupArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupArn", 1))
	}
	if s.RuleGroupName != nil && len(*s.RuleGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupName", 1))
	}
	if s.UpdateToken == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateToken"))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}
	if s.RuleGroup != nil {
		if err := s.RuleGroup.Validate(); err != nil {
			invalidParams.AddNested("RuleGroup", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRuleGroupInput) SetDescription(v string) *UpdateRuleGroupInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *UpdateRuleGroupInput) SetDryRun(v bool) *UpdateRuleGroupInput {
	s.DryRun = &v
	return s
}

// SetRuleGroup sets the RuleGroup field's value.
func (s *UpdateRuleGroupInput) SetRuleGroup(v *RuleGroup) *UpdateRuleGroupInput {
	s.RuleGroup = v
	return s
}

// SetRuleGroupArn sets the RuleGroupArn field's value.
func (s *UpdateRuleGroupInput) SetRuleGroupArn(v string) *UpdateRuleGroupInput {
	s.RuleGroupArn = &v
	return s
}

// SetRuleGroupName sets the RuleGroupName field's value.
func (s *UpdateRuleGroupInput) SetRuleGroupName(v string) *UpdateRuleGroupInput {
	s.RuleGroupName = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateRuleGroupInput) SetRules(v string) *UpdateRuleGroupInput {
	s.Rules = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateRuleGroupInput) SetType(v string) *UpdateRuleGroupInput {
	s.Type = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateRuleGroupInput) SetUpdateToken(v string) *UpdateRuleGroupInput {
	s.UpdateToken = &v
	return s
}

type UpdateRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The high-level properties of a rule group. This, along with the RuleGroup,
	// define the rule group. You can retrieve all objects for a rule group by calling
	// DescribeRuleGroup.
	//
	// RuleGroupResponse is a required field
	RuleGroupResponse *RuleGroupResponse `type:"structure" required:"true"`

	// A token used for optimistic locking. Network Firewall returns a token to
	// your requests that access the rule group. The token marks the state of the
	// rule group resource at the time of the request.
	//
	// To make changes to the rule group, you provide the token in your request.
	// Network Firewall uses the token to ensure that the rule group hasn't changed
	// since you last retrieved it. If it has changed, the operation fails with
	// an InvalidTokenException. If this happens, retrieve the rule group again
	// to get a current copy of it with a current token. Reapply your changes as
	// needed, then try the operation again using the new token.
	//
	// UpdateToken is a required field
	UpdateToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleGroupOutput) GoString() string {
	return s.String()
}

// SetRuleGroupResponse sets the RuleGroupResponse field's value.
func (s *UpdateRuleGroupOutput) SetRuleGroupResponse(v *RuleGroupResponse) *UpdateRuleGroupOutput {
	s.RuleGroupResponse = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateRuleGroupOutput) SetUpdateToken(v string) *UpdateRuleGroupOutput {
	s.UpdateToken = &v
	return s
}

type UpdateSubnetChangeProtectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string `min:"1" type:"string"`

	// A setting indicating whether the firewall is protected against changes to
	// the subnet associations. Use this setting to protect against accidentally
	// modifying the subnet associations for a firewall that is in use. When you
	// create a firewall, the operation initializes this setting to TRUE.
	//
	// SubnetChangeProtection is a required field
	SubnetChangeProtection *bool `type:"boolean" required:"true"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubnetChangeProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubnetChangeProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSubnetChangeProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSubnetChangeProtectionInput"}
	if s.FirewallArn != nil && len(*s.FirewallArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallArn", 1))
	}
	if s.FirewallName != nil && len(*s.FirewallName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallName", 1))
	}
	if s.SubnetChangeProtection == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetChangeProtection"))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *UpdateSubnetChangeProtectionInput) SetFirewallArn(v string) *UpdateSubnetChangeProtectionInput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *UpdateSubnetChangeProtectionInput) SetFirewallName(v string) *UpdateSubnetChangeProtectionInput {
	s.FirewallName = &v
	return s
}

// SetSubnetChangeProtection sets the SubnetChangeProtection field's value.
func (s *UpdateSubnetChangeProtectionInput) SetSubnetChangeProtection(v bool) *UpdateSubnetChangeProtectionInput {
	s.SubnetChangeProtection = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateSubnetChangeProtectionInput) SetUpdateToken(v string) *UpdateSubnetChangeProtectionInput {
	s.UpdateToken = &v
	return s
}

type UpdateSubnetChangeProtectionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string `min:"1" type:"string"`

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string `min:"1" type:"string"`

	// A setting indicating whether the firewall is protected against changes to
	// the subnet associations. Use this setting to protect against accidentally
	// modifying the subnet associations for a firewall that is in use. When you
	// create a firewall, the operation initializes this setting to TRUE.
	SubnetChangeProtection *bool `type:"boolean"`

	// An optional token that you can use for optimistic locking. Network Firewall
	// returns a token to your requests that access the firewall. The token marks
	// the state of the firewall resource at the time of the request.
	//
	// To make an unconditional change to the firewall, omit the token in your update
	// request. Without the token, Network Firewall performs your updates regardless
	// of whether the firewall has changed since you last retrieved it.
	//
	// To make a conditional change to the firewall, provide the token in your update
	// request. Network Firewall uses the token to ensure that the firewall hasn't
	// changed since you last retrieved it. If it has changed, the operation fails
	// with an InvalidTokenException. If this happens, retrieve the firewall again
	// to get a current copy of it with a new token. Reapply your changes as needed,
	// then try the operation again using the new token.
	UpdateToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubnetChangeProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubnetChangeProtectionOutput) GoString() string {
	return s.String()
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *UpdateSubnetChangeProtectionOutput) SetFirewallArn(v string) *UpdateSubnetChangeProtectionOutput {
	s.FirewallArn = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *UpdateSubnetChangeProtectionOutput) SetFirewallName(v string) *UpdateSubnetChangeProtectionOutput {
	s.FirewallName = &v
	return s
}

// SetSubnetChangeProtection sets the SubnetChangeProtection field's value.
func (s *UpdateSubnetChangeProtectionOutput) SetSubnetChangeProtection(v bool) *UpdateSubnetChangeProtectionOutput {
	s.SubnetChangeProtection = &v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateSubnetChangeProtectionOutput) SetUpdateToken(v string) *UpdateSubnetChangeProtectionOutput {
	s.UpdateToken = &v
	return s
}

const (
	// AttachmentStatusCreating is a AttachmentStatus enum value
	AttachmentStatusCreating = "CREATING"

	// AttachmentStatusDeleting is a AttachmentStatus enum value
	AttachmentStatusDeleting = "DELETING"

	// AttachmentStatusScaling is a AttachmentStatus enum value
	AttachmentStatusScaling = "SCALING"

	// AttachmentStatusReady is a AttachmentStatus enum value
	AttachmentStatusReady = "READY"
)

// AttachmentStatus_Values returns all elements of the AttachmentStatus enum
func AttachmentStatus_Values() []string {
	return []string{
		AttachmentStatusCreating,
		AttachmentStatusDeleting,
		AttachmentStatusScaling,
		AttachmentStatusReady,
	}
}

const (
	// ConfigurationSyncStatePending is a ConfigurationSyncState enum value
	ConfigurationSyncStatePending = "PENDING"

	// ConfigurationSyncStateInSync is a ConfigurationSyncState enum value
	ConfigurationSyncStateInSync = "IN_SYNC"
)

// ConfigurationSyncState_Values returns all elements of the ConfigurationSyncState enum
func ConfigurationSyncState_Values() []string {
	return []string{
		ConfigurationSyncStatePending,
		ConfigurationSyncStateInSync,
	}
}

const (
	// FirewallStatusValueProvisioning is a FirewallStatusValue enum value
	FirewallStatusValueProvisioning = "PROVISIONING"

	// FirewallStatusValueDeleting is a FirewallStatusValue enum value
	FirewallStatusValueDeleting = "DELETING"

	// FirewallStatusValueReady is a FirewallStatusValue enum value
	FirewallStatusValueReady = "READY"
)

// FirewallStatusValue_Values returns all elements of the FirewallStatusValue enum
func FirewallStatusValue_Values() []string {
	return []string{
		FirewallStatusValueProvisioning,
		FirewallStatusValueDeleting,
		FirewallStatusValueReady,
	}
}

const (
	// GeneratedRulesTypeAllowlist is a GeneratedRulesType enum value
	GeneratedRulesTypeAllowlist = "ALLOWLIST"

	// GeneratedRulesTypeDenylist is a GeneratedRulesType enum value
	GeneratedRulesTypeDenylist = "DENYLIST"
)

// GeneratedRulesType_Values returns all elements of the GeneratedRulesType enum
func GeneratedRulesType_Values() []string {
	return []string{
		GeneratedRulesTypeAllowlist,
		GeneratedRulesTypeDenylist,
	}
}

const (
	// LogDestinationTypeS3 is a LogDestinationType enum value
	LogDestinationTypeS3 = "S3"

	// LogDestinationTypeCloudWatchLogs is a LogDestinationType enum value
	LogDestinationTypeCloudWatchLogs = "CloudWatchLogs"

	// LogDestinationTypeKinesisDataFirehose is a LogDestinationType enum value
	LogDestinationTypeKinesisDataFirehose = "KinesisDataFirehose"
)

// LogDestinationType_Values returns all elements of the LogDestinationType enum
func LogDestinationType_Values() []string {
	return []string{
		LogDestinationTypeS3,
		LogDestinationTypeCloudWatchLogs,
		LogDestinationTypeKinesisDataFirehose,
	}
}

const (
	// LogTypeAlert is a LogType enum value
	LogTypeAlert = "ALERT"

	// LogTypeFlow is a LogType enum value
	LogTypeFlow = "FLOW"
)

// LogType_Values returns all elements of the LogType enum
func LogType_Values() []string {
	return []string{
		LogTypeAlert,
		LogTypeFlow,
	}
}

const (
	// OverrideActionDropToAlert is a OverrideAction enum value
	OverrideActionDropToAlert = "DROP_TO_ALERT"
)

// OverrideAction_Values returns all elements of the OverrideAction enum
func OverrideAction_Values() []string {
	return []string{
		OverrideActionDropToAlert,
	}
}

const (
	// PerObjectSyncStatusPending is a PerObjectSyncStatus enum value
	PerObjectSyncStatusPending = "PENDING"

	// PerObjectSyncStatusInSync is a PerObjectSyncStatus enum value
	PerObjectSyncStatusInSync = "IN_SYNC"
)

// PerObjectSyncStatus_Values returns all elements of the PerObjectSyncStatus enum
func PerObjectSyncStatus_Values() []string {
	return []string{
		PerObjectSyncStatusPending,
		PerObjectSyncStatusInSync,
	}
}

const (
	// ResourceManagedStatusManaged is a ResourceManagedStatus enum value
	ResourceManagedStatusManaged = "MANAGED"

	// ResourceManagedStatusAccount is a ResourceManagedStatus enum value
	ResourceManagedStatusAccount = "ACCOUNT"
)

// ResourceManagedStatus_Values returns all elements of the ResourceManagedStatus enum
func ResourceManagedStatus_Values() []string {
	return []string{
		ResourceManagedStatusManaged,
		ResourceManagedStatusAccount,
	}
}

const (
	// ResourceStatusActive is a ResourceStatus enum value
	ResourceStatusActive = "ACTIVE"

	// ResourceStatusDeleting is a ResourceStatus enum value
	ResourceStatusDeleting = "DELETING"
)

// ResourceStatus_Values returns all elements of the ResourceStatus enum
func ResourceStatus_Values() []string {
	return []string{
		ResourceStatusActive,
		ResourceStatusDeleting,
	}
}

const (
	// RuleGroupTypeStateless is a RuleGroupType enum value
	RuleGroupTypeStateless = "STATELESS"

	// RuleGroupTypeStateful is a RuleGroupType enum value
	RuleGroupTypeStateful = "STATEFUL"
)

// RuleGroupType_Values returns all elements of the RuleGroupType enum
func RuleGroupType_Values() []string {
	return []string{
		RuleGroupTypeStateless,
		RuleGroupTypeStateful,
	}
}

const (
	// RuleOrderDefaultActionOrder is a RuleOrder enum value
	RuleOrderDefaultActionOrder = "DEFAULT_ACTION_ORDER"

	// RuleOrderStrictOrder is a RuleOrder enum value
	RuleOrderStrictOrder = "STRICT_ORDER"
)

// RuleOrder_Values returns all elements of the RuleOrder enum
func RuleOrder_Values() []string {
	return []string{
		RuleOrderDefaultActionOrder,
		RuleOrderStrictOrder,
	}
}

const (
	// StatefulActionPass is a StatefulAction enum value
	StatefulActionPass = "PASS"

	// StatefulActionDrop is a StatefulAction enum value
	StatefulActionDrop = "DROP"

	// StatefulActionAlert is a StatefulAction enum value
	StatefulActionAlert = "ALERT"
)

// StatefulAction_Values returns all elements of the StatefulAction enum
func StatefulAction_Values() []string {
	return []string{
		StatefulActionPass,
		StatefulActionDrop,
		StatefulActionAlert,
	}
}

const (
	// StatefulRuleDirectionForward is a StatefulRuleDirection enum value
	StatefulRuleDirectionForward = "FORWARD"

	// StatefulRuleDirectionAny is a StatefulRuleDirection enum value
	StatefulRuleDirectionAny = "ANY"
)

// StatefulRuleDirection_Values returns all elements of the StatefulRuleDirection enum
func StatefulRuleDirection_Values() []string {
	return []string{
		StatefulRuleDirectionForward,
		StatefulRuleDirectionAny,
	}
}

const (
	// StatefulRuleProtocolIp is a StatefulRuleProtocol enum value
	StatefulRuleProtocolIp = "IP"

	// StatefulRuleProtocolTcp is a StatefulRuleProtocol enum value
	StatefulRuleProtocolTcp = "TCP"

	// StatefulRuleProtocolUdp is a StatefulRuleProtocol enum value
	StatefulRuleProtocolUdp = "UDP"

	// StatefulRuleProtocolIcmp is a StatefulRuleProtocol enum value
	StatefulRuleProtocolIcmp = "ICMP"

	// StatefulRuleProtocolHttp is a StatefulRuleProtocol enum value
	StatefulRuleProtocolHttp = "HTTP"

	// StatefulRuleProtocolFtp is a StatefulRuleProtocol enum value
	StatefulRuleProtocolFtp = "FTP"

	// StatefulRuleProtocolTls is a StatefulRuleProtocol enum value
	StatefulRuleProtocolTls = "TLS"

	// StatefulRuleProtocolSmb is a StatefulRuleProtocol enum value
	StatefulRuleProtocolSmb = "SMB"

	// StatefulRuleProtocolDns is a StatefulRuleProtocol enum value
	StatefulRuleProtocolDns = "DNS"

	// StatefulRuleProtocolDcerpc is a StatefulRuleProtocol enum value
	StatefulRuleProtocolDcerpc = "DCERPC"

	// StatefulRuleProtocolSsh is a StatefulRuleProtocol enum value
	StatefulRuleProtocolSsh = "SSH"

	// StatefulRuleProtocolSmtp is a StatefulRuleProtocol enum value
	StatefulRuleProtocolSmtp = "SMTP"

	// StatefulRuleProtocolImap is a StatefulRuleProtocol enum value
	StatefulRuleProtocolImap = "IMAP"

	// StatefulRuleProtocolMsn is a StatefulRuleProtocol enum value
	StatefulRuleProtocolMsn = "MSN"

	// StatefulRuleProtocolKrb5 is a StatefulRuleProtocol enum value
	StatefulRuleProtocolKrb5 = "KRB5"

	// StatefulRuleProtocolIkev2 is a StatefulRuleProtocol enum value
	StatefulRuleProtocolIkev2 = "IKEV2"

	// StatefulRuleProtocolTftp is a StatefulRuleProtocol enum value
	StatefulRuleProtocolTftp = "TFTP"

	// StatefulRuleProtocolNtp is a StatefulRuleProtocol enum value
	StatefulRuleProtocolNtp = "NTP"

	// StatefulRuleProtocolDhcp is a StatefulRuleProtocol enum value
	StatefulRuleProtocolDhcp = "DHCP"
)

// StatefulRuleProtocol_Values returns all elements of the StatefulRuleProtocol enum
func StatefulRuleProtocol_Values() []string {
	return []string{
		StatefulRuleProtocolIp,
		StatefulRuleProtocolTcp,
		StatefulRuleProtocolUdp,
		StatefulRuleProtocolIcmp,
		StatefulRuleProtocolHttp,
		StatefulRuleProtocolFtp,
		StatefulRuleProtocolTls,
		StatefulRuleProtocolSmb,
		StatefulRuleProtocolDns,
		StatefulRuleProtocolDcerpc,
		StatefulRuleProtocolSsh,
		StatefulRuleProtocolSmtp,
		StatefulRuleProtocolImap,
		StatefulRuleProtocolMsn,
		StatefulRuleProtocolKrb5,
		StatefulRuleProtocolIkev2,
		StatefulRuleProtocolTftp,
		StatefulRuleProtocolNtp,
		StatefulRuleProtocolDhcp,
	}
}

const (
	// TCPFlagFin is a TCPFlag enum value
	TCPFlagFin = "FIN"

	// TCPFlagSyn is a TCPFlag enum value
	TCPFlagSyn = "SYN"

	// TCPFlagRst is a TCPFlag enum value
	TCPFlagRst = "RST"

	// TCPFlagPsh is a TCPFlag enum value
	TCPFlagPsh = "PSH"

	// TCPFlagAck is a TCPFlag enum value
	TCPFlagAck = "ACK"

	// TCPFlagUrg is a TCPFlag enum value
	TCPFlagUrg = "URG"

	// TCPFlagEce is a TCPFlag enum value
	TCPFlagEce = "ECE"

	// TCPFlagCwr is a TCPFlag enum value
	TCPFlagCwr = "CWR"
)

// TCPFlag_Values returns all elements of the TCPFlag enum
func TCPFlag_Values() []string {
	return []string{
		TCPFlagFin,
		TCPFlagSyn,
		TCPFlagRst,
		TCPFlagPsh,
		TCPFlagAck,
		TCPFlagUrg,
		TCPFlagEce,
		TCPFlagCwr,
	}
}

const (
	// TargetTypeTlsSni is a TargetType enum value
	TargetTypeTlsSni = "TLS_SNI"

	// TargetTypeHttpHost is a TargetType enum value
	TargetTypeHttpHost = "HTTP_HOST"
)

// TargetType_Values returns all elements of the TargetType enum
func TargetType_Values() []string {
	return []string{
		TargetTypeTlsSni,
		TargetTypeHttpHost,
	}
}
