/*
 *    This program written by Edward Der-Hua Liu,Taiwan for xcin-2.1b
 *    		fix by Pa,Taiwan for zh-kcfonts-1.0x
 *						     PM5:10 12/16/1997
 *
 */


#include <stdio.h>
#include <sys/types.h>

char head[]=
"STARTFONT 2.1\n"
"COMMENT 16x15 Font\n"
"FONT kc15f\n"
"SIZE 16 100 100\n"
"FONTBOUNDINGBOX 16 15 0 -1\n"
"STARTPROPERTIES 12\n"
"FONT_ASCENT 14\n"
"FONT_DESCENT 1\n"
"DEFAULT_CHAR 41280\n"
"COPYRIGHT \"KC\"\n"
"POINT_SIZE 240\n"
"FONT \"kc15f\"\n"
"WEIGHT 10\n"
"RESOLUTION 103\n"
"RESOLUTION_X 100\n"
"RESOLUTION_Y 100\n"
"X_HEIGHT 4294967295\n"
"QUAD_WIDTH 16\n"
"ENDPROPERTIES\n"
"CHARS 13867\n";

FILE *fp,*fr1, *fr2, *fw=stdout;

int count, ofs;

void out(FILE *fp)
{
	u_char tt[3],uu[3];
	u_char bf[15][2];
	int v,i;

	if ((v=fread(bf,1,sizeof(bf),fp)) != sizeof(bf)) return; 
	fprintf(fw,"STARTCHAR %d\n", count);
	tt[0]=ofs>>8;
	tt[1]=ofs&255;
	ser_b5(tt,uu);
	fprintf(fw,"ENCODING %d\n", (u_short)uu[0]<<8 | uu[1]);
	fprintf(fw,"SWIDTH 640 0\n");
	fprintf(fw,"DWIDTH 16 0\n");
	fprintf(fw,"BBX 16 15 0 -1\n");
	fprintf(fw,"BITMAP\n");
	
	for(i=0;i<15;i++) {
		v=((u_int)bf[i][0]<<8) | bf[i][1];
		fprintf(fw,"%04x\n", v);
	}
	fprintf(fw,"ENDCHAR\n");
}

main()
{

	if ((fp=fopen("spcfont.15","r"))==NULL) {
		fprintf(stderr,"kc15 Error01:Can't open spcfont.15\n"); exit(2); 
	}
	fputs(head,fw);

	ofs=0x8400;
	while (!feof(fp)) {
		out(fp);
		ofs++; count++;
	}

	fclose(fp);

	if ((fr1=fopen("stdfont.15f","r"))==NULL) {
		fprintf(stderr,"kc15 Error01:Can't open stdfont.15f\n"); exit(2); 
	}

	if ((fr2=fopen("spcfsupp.15","r"))==NULL) {
		fprintf(stderr,"kc15 Error01:Can't open spcfsupp.15\n"); exit(2);
	}
	ofs=0x8800;
	while (!feof(fr1)) {
		out(fr1);
		ofs++; count++;
		if (ofs==0x9b81) {
			fp=fr2;
			ofs=0xe000+63;
			fseek(fr2,0,0);
			while (!feof(fr2)) {
				out(fr2);
				ofs++;
				count++;
			}
			ofs=0x9b81;
		}
	}

	fclose(fr1);
	fclose(fr2);

	fprintf(fw,"ENDFONT\n");

	fclose(fp);
	fclose(fw);
}
