/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.commons.nullanalysis.Nullable;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CookieHandlerTask
extends Task {
    private final List<Runnable> actions = new ArrayList<Runnable>();

    public void addConfiguredPrint(PrintElement element) {
        final URI uri = element.uri;
        if (uri == null) {
            throw new BuildException("\"uri=...\" attribute must be set");
        }
        this.actions.add(new Runnable(){

            @Override
            public void run() {
                Map<String, List<String>> cookieHeaders;
                CookieHandler ch = CookieHandler.getDefault();
                if (ch == null) {
                    throw new BuildException("No cookie handler installed");
                }
                try {
                    cookieHeaders = ch.get(uri, Collections.emptyMap());
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
                for (Map.Entry<String, List<String>> e : cookieHeaders.entrySet()) {
                    String headerName = e.getKey();
                    List<String> headerValues = e.getValue();
                    System.out.println(headerName + ":");
                    for (String headerValue : headerValues) {
                        System.out.println(headerValue);
                    }
                }
            }
        });
    }

    public void execute() throws BuildException {
        for (Runnable a : this.actions) {
            a.run();
        }
    }

    public static final class PrintElement {
        @Nullable
        private URI uri;

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }
}

