/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.PercentEncoding;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PercentEncodingOutputStream
extends FilterOutputStream {
    public PercentEncodingOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        if (PercentEncoding.isUnreserved(b)) {
            this.out.write(b);
        } else {
            this.writePercentEncoded(b);
        }
    }

    public void writeUnencoded(int b) throws IOException {
        this.out.write(b);
    }

    private void writePercentEncoded(int b) throws IOException {
        this.out.write(new byte[]{37, (byte)Character.forDigit(b >> 4 & 0xF, 16), (byte)Character.forDigit(b & 0xF, 16)});
    }
}

