/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.security;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.security.Permission;

public final class ExitCatcher {
    private ExitCatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <EX extends Throwable> Integer catchExit(RunnableWhichThrows<EX> runnable) throws EX {
        SecurityManager originalSecurityManager = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(@Nullable Permission permission) {
                }

                @Override
                public void checkExit(int status) {
                    throw new ExitTrappedException(status);
                }
            });
            try {
                runnable.run();
                Integer n = null;
                return n;
            }
            catch (ExitTrappedException ete) {
                Integer n = ete.getStatus();
                System.setSecurityManager(originalSecurityManager);
                return n;
            }
        }
        finally {
            System.setSecurityManager(originalSecurityManager);
        }
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private static final class ExitTrappedException
    extends SecurityException {
        private static final long serialVersionUID = 1L;
        private final int status;

        ExitTrappedException(int status) {
            this.status = status;
        }

        int getStatus() {
            return this.status;
        }
    }
}

