/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http;

import de.unkrig.commons.nullanalysis.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ParametrizedHeaderValue {
    private final String token;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public ParametrizedHeaderValue(String s) {
        StringTokenizer st = new StringTokenizer(s, ";");
        this.token = st.nextToken().trim();
        while (st.hasMoreTokens()) {
            String parameterValue;
            String parameterName;
            String t = st.nextToken();
            int idx = t.indexOf(61);
            if (idx == -1) {
                parameterName = t.trim();
                parameterValue = "";
            } else {
                parameterName = t.substring(0, idx).trim();
                parameterValue = t.substring(idx + 1).trim();
            }
            this.parameters.put(parameterName.toLowerCase(), parameterValue);
        }
    }

    public String getToken() {
        return this.token;
    }

    @Nullable
    public String getParameter(String name) {
        return this.parameters.get(name.toLowerCase());
    }

    @Nullable
    public String setParameter(String name, String value) {
        return this.parameters.put(name.toLowerCase(), value);
    }

    @Nullable
    public String removeParameter(String name) {
        return this.parameters.remove(name.toLowerCase());
    }

    public String toString() {
        if (this.parameters.isEmpty()) {
            return this.token;
        }
        StringBuilder sb = new StringBuilder(this.token);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String parameterName = entry.getKey();
            String parameterValue = entry.getValue();
            sb.append("; ").append(parameterName);
            if (parameterValue.isEmpty()) continue;
            sb.append("=").append(parameterValue);
        }
        return sb.toString();
    }
}

