/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.tool.ftpmon;

import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.net.ftp.DataConnectionProxy;
import de.unkrig.commons.net.ftp.FtpReverseProxy;
import de.unkrig.commons.util.logging.LogUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    public static void main(String[] args) throws IOException {
        int i = 0;
        Level logLevel = Level.FINE;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) break;
            ++i;
            if ("-help".equals(arg)) {
                System.out.println("Usage:");
                System.out.println("  java " + Main.class.getName());
                System.out.println("        [ <global-option> ... ]");
                System.out.println("        ( [ <local-option> ... ]");
                System.out.println("              <local-port> <remote-server-host-name> <remote-server-port> ) ...");
                System.out.println("Valid <global-option>s are:");
                System.out.println("  -help");
                System.out.println("  -log <level>                          Activate logging to STDERR on level OFF");
                System.out.println("                                        SEVERE WARNING INFO CONFIG FINE FINER");
                System.out.println("                                        FINEST ALL");
                System.out.println("  -data-connection-port <port>          Use exactly this passive port for data");
                System.out.println("                                        connection forwarding (allows for at");
                System.out.println("                                        most one data connection at a time)");
                System.out.println("  -data-connection-port <first>-<last>  Use the given range for the passive");
                System.out.println("                                        port for data connection forwarding");
                System.out.println("Valid <local-option>s are:");
                System.out.println("  -backlog <n>                     The maximum queue length for incoming");
                System.out.println("                                   requests to connect");
                System.out.println("  -bind-address <address>          Accept connect requests to only this address");
                System.out.println("  -server-connection-timeout <ms>  Timeout for creating connections to the");
                System.out.println("                                   remote server");
                System.exit(0);
                continue;
            }
            if ("-log".equals(arg)) {
                logLevel = Level.parse(args[i++]);
                continue;
            }
            if (!"-data-connection-port".equals(arg)) break;
            Matcher m = Pattern.compile("(\\d+)(?:-(\\d+))?").matcher(args[i++]);
            if (!m.matches()) {
                System.err.println("Invalid argument to '-data-connection-port'; try '-help'");
                System.exit(1);
            }
            int firstDataConnectionPort = Integer.parseInt(m.group(1));
            int lastDataConnectionPort = m.group(2) == null ? firstDataConnectionPort : Integer.parseInt(m.group(2));
            DataConnectionProxy.setLocalPortRange(firstDataConnectionPort, lastDataConnectionPort);
        }
        LogUtil.removeAllHandlersFromRootLogger();
        LogUtil.addConsoleHandlerToRootLogger();
        LogUtil.setRootLoggerLevel(logLevel);
        while (true) {
            int backlog = 0;
            InetAddress bindAddress = null;
            int serverConnectionTimeout = 0;
            while (i < args.length) {
                String arg = args[i];
                if (!arg.startsWith("-")) break;
                ++i;
                if ("-backlog".equals(arg)) {
                    backlog = Integer.parseInt(args[i++]);
                    continue;
                }
                if ("-bind-address".equals(arg)) {
                    bindAddress = InetAddress.getByName(args[i++]);
                    continue;
                }
                if ("-server-connection-timeout".equals(arg)) {
                    serverConnectionTimeout = Integer.parseInt(args[i++]);
                    continue;
                }
                System.err.println("Invalid command line option '" + arg + "'; try '-help'");
                System.exit(1);
            }
            if (i + 3 > args.length) {
                System.err.println("Local port, remote server host name and/or remote server port missing; try '-help'");
                System.exit(1);
            }
            InetSocketAddress endpoint = new InetSocketAddress(bindAddress, Integer.parseInt(args[i++]));
            InetSocketAddress serverAddress = new InetSocketAddress(args[i++], Integer.parseInt(args[i++]));
            FtpReverseProxy ftpReverseProxy = new FtpReverseProxy(endpoint, backlog, serverAddress, serverConnectionTimeout);
            if (i == args.length) {
                ThreadUtil.runInForeground(ftpReverseProxy);
                continue;
            }
            ThreadUtil.runInBackground(ftpReverseProxy, null);
        }
    }
}

