/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  util.h - utility function header                                         */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2004-2007                         */
/*             Authors: Yumiko Sugita (yumiko.sugita.yf@hitachi.com),        */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

/* define TRUE/FALSE */
#define	FALSE		0
#define	TRUE		1


/* print macro */
#define	PRINT1(s, d)					\
	do {						\
		printf((s));				\
		printf("%u (%02x)\n", (d), (d));	\
	} while (0)
#define	PRINT2(s, d)					\
	do {						\
		printf((s));				\
		printf("%u (%04x)\n", (d), (d));	\
	} while (0)
#define	PRINT4(s, d)					\
	do {						\
		printf((s));				\
		printf("%u (%08x)\n", (d), (d));	\
	} while (0)
#define	PRINTS(s, d, n)					\
	do {						\
		printf((s));				\
		printf("\"%.*s\"\n", (n), (d));		\
	} while (0)


/* utility function proto type */
void uDumpN(char* buf, size_t n);
int uOpen(const char *pathname, int flags);
int uSeek(int f, off_t pos);
int uRead(int f, void* buf, size_t n);
int uWrite(int f, void* buf, size_t n);
int uSeekRead(int f, off_t pos, void* buf, size_t n);
void *uCalloc(size_t nmemb, size_t n);
void *uMalloc(size_t n);
void *uRealloc(void *ptr, size_t n);
int uLstat(const char *pathname, struct stat *buf);
int uChdir(char* path);
DIR *uOpendir(const char *pathname);
struct dirent* uReaddir(DIR *d);
int uClosedir(DIR *d);
char *uGetCwd(char *buf, size_t *size);
FILE *uSetmntent(const char *filename, const char *type);
int uSyncDisk(char* dev);
