---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, références,
              citation invisible, référence invisible, 
              références bibliographiques
---

# Comment citer un document sans y faire référence ?

La commande `\nocite` permet de faire apparaître un document 
dans la [bibliographie](/3_composition/annexes/bibliographie/start) 
que la référence apparaisse dans le corps du texte. Elle s'utilise exactement 
comme la commande `\cite` :

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{\jobname.bib}
  @book{poetique,
    author = {Aristote},
    title = {La poétique},
    volume={2},
  }
  @book{nombres,
    author = {Speusippus},
    title = {Sur les nombres pythagoriciens},
  }
  @book{alex,
    author = {Cleitarchus},
    title = {Histoire d'Alexandre},
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Qui est doux d'avoir dans sa bibliothèque un exemplaire d'une \oe uvre
fort rare d'Aristote\cite{poetique} ou quelques autres pépites de ce
type. \nocite{alex}
\bibliographystyle{plain}
\bibliography{\jobname}
\end{document}
```

Ici, la référence faite à `alex` avec `\nocite` est invisible dans le texte
affichée, mais est bien listée dans la bibliographie en fin de document (tandis
que la référence `nombres` n'apparaît pas puisque non citée par une commande
`\cite` ou une commande `\nocite`).

Si le 
[style bibliographique](/3_composition/annexes/bibliographie/style_bst/start)
utilisé ne trie pas les entrées, la référence incluse par `\nocite` 
sera placée comme si elle avait été incluse par `\cite`.

Notez que la commande `\nocite` peut répondre à un autre besoin, 
vu à la question 
"[](/3_composition/annexes/bibliographie/afficher_toutes_les_entrees_d_un_fichier_bib)".