---
myst:
  html_meta:
    keywords: foire aux questions LaTeX,documentation sur LaTeX,aide sur LaTeX,aide sur TeX,Association GUTenberg"
---
# Comment contribuer ?

Vous pouvez contribuer à la présente FAQ de multiples façons, notamment en :

- corrigeant les imperfections et éventuelles erreurs, certaines pages [attendant des
  corrections](/8_contribuer/corrections/questions_a_reviser) ;
- mettant à jour des informations parfois datées ;
- ajoutant ou précisant des réponses aux questions ;
- créant de nouvelles pages pour partager votre expérience avec LaTeX.

## Principe de fonctionnement de la FAQ

Le processus de création du site Web de la présente FAQ est analogue à celui de
LaTeX : des fichiers sources sont compilés pour fournir d'autres fichiers plus
"exploitables".

### Fichiers sources

Les fichiers sources de cette FAQ sont (pour l'instant) uniquement au format
<wpfr:Markdown>. Markdown est un langage de balisage léger, à la syntaxe facile
à lire et à écrire (comme le sont les courriers électroniques écrits en mode
texte).

Mais c’est plus précisément une version enrichie de Markdown,
[`MyST-Parser`](https://myst-parser.readthedocs.io/), qui est utilisée
ici. Celle-ci fournit de très nombreuses fonctionnalités dont nous décrivons la
syntaxe [sur une page dédiée](/8_contribuer/syntaxe/syntax.md).

### Compilation

La compilation est effectuée par le logiciel générateur de documentation
<wpfr:Sphinx> et, pour l'instant, seulement pour fabriquer les pages HTML du
présent site Web. Cette compilation est lancée automatiquement et de façon
transparente pour le contributeur dès lors que les modifications qu'il
a apportées aux fichiers sources sont intégrées au dépôt (plus de détails
ci-dessous).

## Dépôt GitLab

L’ensemble des fichiers de la FAQ est géré par le logiciel <wpfr:Git> (de façon
transparente pour ceux qui ne souhaitent pas apprendre à l'utiliser) et est
stocké dans un dépôt <wpfr:GitLab> :
https://gitlab.gutenberg-asso.fr/gutenberg/faq-gut/.

Pour pouvoir contribuer à la présente FAQ, il vous faut au préalable suivre une
procédure classique d'inscription :

1. inscription sur [l'instance GitLab de l'association
GUTenberg](https://gitlab.gutenberg-asso.fr/users/sign_up) ;
2. (une fois votre inscription validée par un membre du bureau de l'association)
   [connexion sur cette instance
   GitLab](https://gitlab.gutenberg-asso.fr/users/sign_in) ;
3. [demande d'accès au projet de la
   FAQ](https://gitlab.gutenberg-asso.fr/gutenberg/faq-gut/-/project_members/request_access).

## Contribution au contenu de la FAQ

### Édition via l’éditeur de texte de GitLab

Si vous ne connaissez pas et ne souhaitez pas apprendre à utiliser `Git`, vous
pouvez néanmoins très facilement contribuer à la présente FAQ en en modifiant les
fichiers sources dans un éditeur de texte en ligne (qui est une version Web et
_light_ de l’éditeur [`Visual Studio Code`](https://code.visualstudio.com)).

Le moyen le plus simple pour ce faire est de cliquer sur le lien "Modifier
(<kbd>Ctrl</kbd>+ <i class="fas fa-mouse-pointer"></i> conseillé)", présent dans
le volet droit de chacune des pages de la FAQ.
```{image} /_static/images/modifier_sombre.png
:class: only-dark
:width: 100%
:alt: Image du lien "Modifier"
:name: modifier_sombre
:align: center
```
```{image} /_static/images/modifier_clair.png
:class: only-light
:width: 100%
:alt: Image du lien "Modifier"
:name: modifier_clair
:align: center
```
:::{attention}
Il est souvent préférable d’ouvrir ce lien dans un nouvel onglet (d’où
l’indication "<kbd>Ctrl</kbd>+ <i class="fas fa-mouse-pointer"></i> conseillé")
de façon à garder "sous la main" la page du site dont on souhaite modifier le contenu.
:::

```{figure} /_static/images/vscode.png
:width: 100%
:alt: Illustration de l’éditeur de texte Web intégré à GitLab
:name: vscode
:align: center
Éditeur de texte Web intégré à GitLab
```

:::{note}
Le thème par défaut pour l'éditeur Web est sombre ("GitLab Dark"). Vous pouvez
en changer de la façon suivante :
1. En haut du volet latéral gauche, sélectionnez <i class="fa-solid
   fa-bars"></i> → File → Preferences → Theme → Color Theme.
2. Dans la liste déroulante, prévisualisez les thèmes avec les touches fléchées
   (les thèmes clairs se trouvant en haut de liste).
3. Sélectionnez un thème.
:::

Une fois l’onglet ouvert, vous pourrez contribuer à la FAQ en modifiant :

- donc la page d'où vous venez ;
- mais aussi d'autres pages que vous pourrez ouvrir en naviguant dans
  l'arborescence de fichiers accessible dans le volet gauche.

Lorsque vos modifications seront prêtes, il vous faudra les décrire dans un
message (dit "de *commit*") avant qu'elles soient intégrées à la FAQ. Pour ce
faire, cliquez sur le bouton mis en évidence dans l'image suivante (ou saisissez
le raccourci clavier <kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>G</kbd>) afin
d'ouvrir la zone de l'éditeur dédiée à la gestion de versions du dépôt :

```{figure} /_static/images/vscodeGit.png
:width: 100%
:alt: Zone de l'éditeur dédiée à la gestion de versions du dépôt
:name: vscodegit
:align: center
Zone de l'éditeur dédiée à la gestion de versions du dépôt
```

Saisissez ensuite votre message dans la boîte de saisie "*Commit message*" et
enfin cliquez sur le bouton _Commit to ‘main’_ pour envoyer vos modifications
sur le dépôt.

La plupart du temps, celles-ci apparaîtront sur le site de la FAQ en moins d'une
minute.

<!-- Saisissez ensuite votre message dans la boîte de saisie "*Commit message*" puis -->
<!-- cliquez sur le bouton "_Commit to ‘main’_" pour envoyer vos modifications sur la -->
<!-- ["branche"](wpfr:Branche_(gestion_de_configuration)) principale (*main*) par -->
<!-- défaut du dépôt. Une fenêtre *pop-up* vous demande alors de confirmer que vous -->
<!-- souhaitez envoyer vos modifications sur la branche par défaut (principale) : -->
<!--  -->
<!-- ```{figure} /_static/images/confirmation.png -->
<!-- :width: 100% -->
<!-- :alt: Confirmation de la branche où envoyer les modifications -->
<!-- :name: confirmation -->
<!-- :align: center -->
<!-- Confirmation de la branche où envoyer les modifications -->
<!-- ``` -->
<!--  -->
<!-- Confirmez en pressant la touche "Entrée" ou en cliquant sur le bouton "*Continue*". -->
<!--  -->
<!-- <\!-- You're committing your changes to the default branch. Do you want to continue? -\-> -->
<!--  -->
<!-- La plupart du temps, vos modifications apparaîtront sur le site de la FAQ en -->
<!-- moins d'une minute. -->

(edition-en-clonant)=
### Édition en clonant le dépôt

Si vous êtes déjà utilisateur de `Git`, vous pouvez contribuer à la présente FAQ
en en modifiant les fichiers sources dans votre environnement de travail
habituel. Pour ce faire, il vous suffit de cloner le dépôt, ce qui peut se faire
de deux manières :

1. la plus simple à moyen terme consiste à cloner avec SSH en utilisant l'URL
   `ssh://git@gitlab.gutenberg-asso.fr:31022/gutenberg/faq-gut.git`.
   :::{warning}
   Cette méthode est moins simple immédiatement car elle nécessite d'utiliser
   une clé SSH pour envoyer vos modifications de la FAQ. La procédure pour ce faire dépasse
   le cadre de cette page et nous renvoyons vers la
   [documentation](https://docs.gitlab.com/ee/user/ssh.html) (en anglais) de
   GitLab à ce sujet. Vous pouvez toutefois si nécessaire nous demander de
   l'aide en écrivant à la [liste dédiée à la
   FAQ](mailto:faq@gutenberg-asso.fr).
   :::
2. la plus simple immédiatement consiste à cloner avec
   HTTPS en utilisant l'URL `https://gitlab.gutenberg-asso.fr/gutenberg/faq-gut.git`.
   Mais il faut par la suite fournir
   vos nom d’utilisateur et mot de passe GitLab chaque fois que vous envoyez
   vos modifications de la FAQ.  *Sauf* si vous pouvez configurer le
   [`credential.helper`](https://git-scm.com/book/sv/v2/Git-Tools-Credential-Storage)
   de `git` sur votre système.  Par exemple sur macOS la commande suivante :
   ```bash
   git config --global credential.helper 'osxkeychain'
   ```
   a pour conséquence que le nom d'utilisateur et le mot de passe utilisés
   pour GitLab ne sont demandés qu’une unique fois, à l'occasion
   de votre tout premier `git push` contribuant des modifications à la FAQ.

Ensuite, procédez de façon habituelle en éditant les fichiers sources, en
effectuant des *commits* puis des `git push`.

:::{note}
Si vous envisagez de contribuer en clonant le dépôt, vous pourrez être intéressé
par la possibilité de [compiler la FAQ localement sur votre
machine](/8_contribuer/methodes/compilation_de_la_faq_en_local.md) et ainsi
pouvoir contrôler vos modifications avant de les publier sur le site.
:::

<!-- :::{note} Plutôt que cloner le dépôt de la FAQ lui-même et d'y intervenir du -->
<!-- coup directement, vous pouvez plutôt en créer une "bifurcation" (un *fork*) en -->
<!-- visitant la page https://gitlab.gutenberg-asso.fr/gutenberg/faq-gut/-/forks/new. Comme il -->
<!-- s'agit là aussi d'un sujet dépassant le cadre de cette page, nous renvoyons -->
<!-- également vers la -->
<!-- [documentation](https://docs.gitlab.com/ee/user/project/repository/forking_workflow.html) -->
<!-- (en anglais) de GitLab à ce sujet. -->
<!-- ::: -->

### Par où commencer ?

Si vous ne savez pas par quelle page commencer, vous pouvez en consulter <span id="random-page"><script
id="random_page_js" card_link="" link_text="une sélectionnée aléatoirement"
relative_path=".."  src="../_static/js/random_page.js"></script></span>.

## Association GUTenberg

Enfin, une autre façon de contribuer à cette FAQ est [d'adhérer à l'association
GUTenberg](https://www.gutenberg-asso.fr/Adherer-a-l-association), qui l'héberge
et la maintient.
