
#include "outputFileHandle.h"

/**************************************************************************
 **SA Network Connection Profiler [sancp] - A TCP/IP statistical/collection tool
 * ************************************************************************
 * * Copyright (C) 2003 John Curry <john.curry@metre.net>
 * *
 * * This program is distributed under the terms of version 1.0 of the
 * * Q Public License.  See LICENSE.QPL for further details.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * *
 * ***********************************************************************/

outputFileHandle::outputFileHandle() : fmt(0),fmtlen(0),delimiter(0)
{ 

}

outputFileHandle::outputFileHandle(FILE *OFH, int mode = APPEND_MODE,char *ifmt=0, int len=0) :fmt(0),fmtlen(0),delimiter('|'),eor('\n')
{ 
	::fileHandle(OFH,mode);
	setFormat(ifmt,len);
}

outputFileHandle::outputFileHandle(const char *newfilename,char *ifmt=0, int len=0, int mode=APPEND_MODE ) : fmt(0),fmtlen(0),delimiter('|'),eor('\n')
{
	setMode(mode);
	setFormat(ifmt,len);
	setFileName(newfilename);
}

char * outputFileHandle::getFormat() 
{
	return fmt;
}

char * outputFileHandle::setFormat(char *ifmt, int len) 
{
	if(fmt) { free(fmt); fmt=0; }
	fmtlen=len;
	if((fmt=(char *) calloc(len,1))!=0)
		memcpy(fmt,ifmt,len);
	return fmt;
}

int outputFileHandle::getFormatLen() 
{
	return fmtlen;
}

char outputFileHandle::getEor() 
{
	return eor;
}

void outputFileHandle::setEor(char c) 
{
	eor=c;
}

char outputFileHandle::getDelimiter() 
{
	return delimiter;
}

void outputFileHandle::setDelimiter(char c) 
{
	delimiter=c;
}

outputFileHandle * outputFileHandle::attach() 
{
	fileHandle::attach();
	return this;
}

outputFileHandle::~outputFileHandle() 
{ 
	if(fmt) { free(fmt); fmt=0; }
}
