
#include "pcapFileHandle.h"

/**************************************************************************
 **SA Network Connection Profiler [sancp] - A TCP/IP statistical/collection tool
 * ************************************************************************
 * * Copyright (C) 2003 John Curry <john.curry@metre.net>
 * *
 * * This program is distributed under the terms of version 1.0 of the
 * * Q Public License.  See LICENSE.QPL for further details.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * *
 * ***********************************************************************/

pcapFileHandle::pcapFileHandle() { }
 
pcapFileHandle::pcapFileHandle(const char *newfilename) 
{
	setFileName(newfilename);
}

int pcapFileHandle::stat()
{
	struct stat buffer;
	if(::stat(getFileName(),&buffer)||(buffer.st_size < 24))
	{
		return 0;
	}
	return 1;
}

int pcapFileHandle::open()
{ 
	if(isOpen()){ return 1; }
	if(getFileName()==0){ 
		//No filename set!
		return 0; 
	}
	// Check if file is present and that it has a minimum header size
	if(!stat())
	{ 
		// Open file in write mode
		fileHandle::setMode(WRITE_MODE);
		fileHandle::open();
		fileHandle::write( pcap_header ,PCAP_HEADER_SIZE);
	}else{
		// Open file in append mode
		fileHandle::setMode(APPEND_MODE);
		fileHandle::open();
	}
	return 1;
}


ssize_t pcapFileHandle::write(const char *data, int len, struct timeval *timeptr)
{
	char tmp[5];
	ssize_t bytes=0;
	tmp[4]=0;
	u_int32_t num;

 	if(open())
	{
		num = ((timeptr->tv_sec));
		bytes=fileHandle::write((const char *)&num,4);
		num = ((timeptr->tv_usec));
		bytes+=fileHandle::write((const char *)&num,4);
		num = 0x00000000;
		num = len;
		bytes+=fileHandle::write((const char *)&num,4);
		bytes+=fileHandle::write((const char *)&num,4);
		bytes+=fileHandle::write(data,len);
	}else{
		//Unable to print to file
		return -1;
	}
	return bytes;
}

pcapFileHandle * pcapFileHandle::attach() 
{
	fileHandle::attach();
	return this;
}

pcapFileHandle::~pcapFileHandle() { }
