[vset PACKAGE_VERSION 1.3.1]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctools::toc n [vset PACKAGE_VERSION]]
[see_also doctoc_intro]
[see_also doctoc_lang_cmdref]
[see_also doctoc_lang_intro]
[see_also doctoc_lang_syntax]
[see_also doctoc_plugin_apiref]
[keywords conversion]
[keywords doctoc]
[keywords documentation]
[keywords HTML]
[keywords latex]
[keywords manpage]
[keywords markup]
[keywords nroff]
[keywords {table of contents}]
[keywords markdown]
[keywords TMML]
[keywords toc]
[keywords wiki]
[copyright {2003-2019 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {doctoc - Processing tables of contents}]
[category  {Documentation tools}]
[require Tcl "8.5 9"]
[require doctools::toc [opt [vset PACKAGE_VERSION]]]
[description]

This package provides a class for the creation of objects able to
process and convert text written in the [term doctoc] markup language
into any output format X for which a [term {formatting engine}] is
available.

[para]

A reader interested in the markup language itself should start with
the [term {doctoc language introduction}] and proceed from there to
the formal specifications, i.e. the [term {doctoc language syntax}]
and the [term {doctoc language command reference}].

[para]

If on the other hand the reader wishes to write her own formatting
engine for some format, i.e. is a [term {plugin writer}] then reading
and understanding the [term {doctoc plugin API reference}] is an
absolute necessity, as that document specifies the interaction between
this package and its plugins, i.e. the formatting engines, in detail.

[section {PUBLIC API}]
[subsection {PACKAGE COMMANDS}]

[list_begin definitions]

[call [cmd ::doctools::toc::new] [arg objectName] [opt "[option -option] [arg value] ..."]]

This command creates a new doctoc object with an associated Tcl
command whose name is [arg objectName]. This [term object] command is
explained in full detail in the sections [sectref {OBJECT COMMAND}]
and [sectref {OBJECT METHODS}]. The object command will be created
under the current namespace if the [arg objectName] is not fully
qualified, and in the specified namespace otherwise.

[para]

The options and their values coming after the name of the object are
used to set the initial configuration of the object.

[call [cmd ::doctools::toc::help]]

This is a convenience command for applications wishing to provide
their user with a short description of the available formatting
commands and their meanings. It returns a string containing a standard
help text.

[call [cmd ::doctools::toc::search] [arg path]]

Whenever an object created by this the package has to map the name of
a format to the file containing the code for its formatting engine it
will search for the file in a number of directories stored in a
list. See section [sectref {FORMAT MAPPING}] for more explanations.

[para]

This list not only contains three default directories which are
declared by the package itself, but is also extensible user of the
package.

This command is the means to do so. When given a [arg path] to an
existing and readable directory it will prepend that directory to the
list of directories to search. This means that the [arg path] added
last is later searched through first.

[para]

An error will be thrown if the [arg path] either does not exist, is
not a directory, or is not readable.

[list_end]

[subsection {OBJECT COMMAND}]

All commands created by [cmd ::doctools::toc::new] have the following
general form and may be used to invoke various operations on their
doctoc converter object.

[list_begin definitions]

[call [cmd objectName] [method method] [opt [arg "arg arg ..."]]]

The method [method method] and its [arg arg]'uments determine the exact
behavior of the command. See section [sectref {OBJECT METHODS}] for
the detailed specifications.

[list_end]

[subsection {OBJECT METHODS}]

[list_begin definitions]

[call [arg objectName] [method configure]]

The method returns a list of all known options and their current
values when called without any arguments.

[call [arg objectName] [method configure] [arg option]]

The method behaves like the method [method cget] when called with a
single argument and returns the value of the option specified by said
argument.

[call [arg objectName] [method configure] [option -option] [arg value]...]

The method reconfigures the specified [option option]s of the object,
setting them to the associated [arg value]s, when called with an even
number of arguments, at least two.

[para]

The legal options are described in the section
[sectref {OBJECT CONFIGURATION}].

[call [arg objectName] [method cget] [option -option]]

This method expects a legal configuration option as argument and will
return the current value of that option for the object the method was
invoked for.

[para]

The legal configuration options are described in section
[sectref {OBJECT CONFIGURATION}].

[call [arg objectName] [method destroy]]

This method destroys the object it is invoked for.

[call [arg objectName] [method format] [arg text]]

This method runs the [arg text] through the configured formatting
engine and returns the generated string as its result. An error will
be thrown if no [option -format] was configured for the object.

[para]

The method assumes that the [arg text] is in [term doctoc] format as
specified in the companion document [term doctoc_fmt]. Errors will be
thrown otherwise.

[call [arg objectName] [method map] [arg symbolic] [arg actual]]

This methods add one entry to the per-object mapping from
[arg symbolic] filenames to the [arg actual] uris.

The object just stores this mapping and makes it available to the
configured formatting engine through the command [cmd dt_fmap].

This command is described in more detail in the
[term {doctoc plugin API reference}] which specifies the interaction
between the objects created by this package and toc formatting
engines.

[call [arg objectName] [method parameters]]

This method returns a list containing the names of all engine
parameters provided by the configured formatting engine. It will
return an empty list if the object is not yet configured for a
specific format.

[call [arg objectName] [method search] [arg path]]

This method extends the per-object list of paths searched for toc
formatting engines. See also the command [cmd ::doctools::toc::search]
on how to extend the per-package list of paths. Note that the path
entered last will be searched first.

For more details see section [sectref {FORMAT MAPPING}].

[call [arg objectName] [method setparam] [arg name] [arg value]]

This method sets the [arg name]d engine parameter to the specified
[arg value].

It will throw an error if the object is either not yet configured for
a specific format, or if the formatting engine for the configured
format does not provide a parameter with the given [arg name].

The list of parameters provided by the configured formatting engine
can be retrieved through the method [method parameters].

[call [arg objectName] [method warnings]]

This method returns a list containing all the warnings which were
generated by the configured formatting engine during the last
invocation of the method [method format].

[list_end]

[subsection {OBJECT CONFIGURATION}]

All doctoc objects understand the following configuration options:

[list_begin options]

[opt_def -file [arg file]]

The argument of this option is stored in the object and made available
to the configured formatting engine through the command [cmd dt_file].

This command is described in more detail in the companion document
[term doctoc_api] which specifies the API between the object and
formatting engines.

[para]

The default value of this option is the empty string.

[para]

The configured formatting engine should interpret the value as the
name of the file containing the document which is currently processed.

[opt_def -format [arg text]]

The argument of this option specifies the format to generate and by
implication the formatting engine to use when converting text via the
method [method format]. Its default value is the empty string. The
method [method format] cannot be used if this option is not set to a
valid value at least once.

[para]

The package will immediately try to map the given name to a file
containing the code for a formatting engine generating that format. An
error will be thrown if this mapping fails. In that case a previously
configured format is left untouched.

[para]

The section [sectref {FORMAT MAPPING}] explains in detail how the
package and object will look for engine implementations.

[list_end]

[subsection {FORMAT MAPPING}]

The package and object will perform the following algorithm when
trying to map a format name [term foo] to a file containing an
implementation of a formatting engine for [term foo]:

[list_begin enumerated]
[enum]

If [term foo] is the name of an existing file then this file is
directly taken as the implementation.

[enum]

If not, the list of per-object search paths is searched. For each
directory in the list the package checks if that directory contains a
file [file toc.[term foo]]. If yes, then that file is taken as the
implementation.

[para]

Note that this list of paths is initially empty and can be extended
through the object method [method search].

[enum]

If not, the list of package paths is searched.

For each directory in the list the package checks if that directory
contains a file [file toc.[term foo]]. If yes, then that file is taken
as the implementation.

[para]

This list of paths can be extended
through the command [cmd ::doctools::toc::search].

It contains initially one path, the subdirectory [file mpformats] of
the directory the package itself is located in. In other words, if the
package implementation [file doctoc.tcl] is installed in the directory
[file /usr/local/lib/tcllib/doctools] then it will by default search
the directory [file /usr/local/lib/tcllib/doctools/mpformats] for
format implementations.

[enum]

The mapping fails.

[list_end]

[section {PREDEFINED ENGINES}]

The package provides predefined formatting engines for the following
formats. Some of the formatting engines support engine
parameters. These will be explicitly highlighted.

[list_begin definitions]
[def html]

This engine generates HTML markup, for processing by web browsers and
the like. This engine supports three parameters:

[list_begin definitions]
[def footer]

The value for this parameter has to be valid selfcontained HTML markup
for the body section of a HTML document. The default value is the
empty string. The value is inserted into the generated output just
before the [const </body>] tag, closing the body of the generated
HTML.

[para]

This can be used to insert boilerplate footer markup into the
generated document.

[def header]

The value for this parameter has to be valid selfcontained HTML markup
for the body section of a HTML document. The default value is the
empty string. The value is inserted into the generated output just
after the [const <body>] tag, starting the body of the generated HTML.

[para]

This can be used to insert boilerplate header markup into the
generated document.

[def meta]

The value for this parameter has to be valid selfcontained HTML markup
for the header section of a HTML document. The default value is the
empty string. The value is inserted into the generated output just
after the [const <head>] tag, starting the header section of the
generated HTML.

[para]

This can be used to insert boilerplate meta data markup into the
generated document, like references to a stylesheet, standard meta
keywords, etc.

[list_end]
[para]

[def latex]

This engine generates output suitable for the [syscmd latex] text
processor coming out of the TeX world.

[def list]

This engine retrieves version, section and title of the manpage from
the document. As such it can be used to generate a directory listing
for a set of manpages.

[def markdown]

This engine generates [term Markdown] markup.

[def nroff]

This engine generates nroff output, for processing by [syscmd nroff],
or [syscmd groff]. The result will be standard man pages as they are
known in the unix world.

[def null]

This engine generates no outout at all. This can be used if one just
wants to validate some input.

[def tmml]

This engine generates TMML markup as specified by Joe English. The Tcl
Manpage Markup Language is a derivate of XML.

[def wiki]

This engine generates Wiki markup as understood by Jean Claude
Wippler's [syscmd wikit] application.

[list_end]

[vset CATEGORY doctools]
[include ../common-text/feedback.inc]
[manpage_end]
