/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.data;

import com.jgoodies.app.data.SimpleCSVReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class SampleDataConverter {
    private SampleDataConverter() {
    }

    public static <T> void convert(String description, InputStream in, URL outURL, Function<String[], T> converter) {
        System.out.println("Reading " + description + "...");
        List<T> elements = SampleDataConverter.readFromCSVFile(in, converter);
        System.out.println("Writing to: " + outURL.getPath());
        System.out.print("Writing " + description + "...");
        SampleDataConverter.writeObjectOutput(new File(outURL.getPath()), elements);
        System.out.println("done");
    }

    public static <T> List<T> readFromCSVFile(InputStream in, Function<String[], T> converter) {
        ArrayList<T> elements = new ArrayList<T>();
        try (InputStreamReader inReader = new InputStreamReader(in, StandardCharsets.ISO_8859_1);){
            String[] line;
            SimpleCSVReader reader = new SimpleCSVReader(inReader, ';');
            reader.readNext();
            while ((line = reader.readNext()) != null) {
                elements.add(converter.apply(line));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return elements;
    }

    private static <T> void writeObjectOutput(File outFile, List<T> elements) {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outFile));){
            out.writeObject(elements);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

