/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.action;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.action.ActionGroup;
import com.jgoodies.common.jsdl.action.SplitAction;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.JGToolBarMenuButton;
import com.jgoodies.components.JGToolBarSplitButton;
import com.jgoodies.components.util.ComponentUtils;
import com.jgoodies.framework.action.DefaultPopupMenuBuilder;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public final class DefaultToolBarBuilder
implements ActionGroup.ActionGroupBuilder {
    private final JToolBar toolBar;
    private final JGComponentFactory factory;

    public DefaultToolBarBuilder() {
        this(new JToolBar(), JGComponentFactory.getCurrent());
    }

    public DefaultToolBarBuilder(JToolBar toolBar) {
        this(toolBar, JGComponentFactory.getCurrent());
    }

    public DefaultToolBarBuilder(JToolBar toolBar, JGComponentFactory factory) {
        Preconditions.checkNotNull(toolBar, "The %s must not be null.", "tool bar");
        Preconditions.checkNotNull(factory, "The %s must not be null.", "component factory");
        this.toolBar = toolBar;
        this.factory = factory;
    }

    public static JToolBar toolBarFor(ActionGroup group) {
        if (group == null) {
            return null;
        }
        DefaultToolBarBuilder builder = new DefaultToolBarBuilder();
        group.build(builder);
        return builder.build();
    }

    @Override
    public void setLabelAction(Action labelAction) {
        if (labelAction == null) {
            return;
        }
        this.toolBar.setName((String)labelAction.getValue("Name"));
    }

    @Override
    public void add(Action action) {
        JButton button = this.factory.createButton(action);
        ComponentUtils.registerKeyboardAction((JComponent)button, action, 2);
        this.toolBar.add(button);
    }

    @Override
    public void add(ActionGroup group) {
        DefaultPopupMenuBuilder menuBuilder = new DefaultPopupMenuBuilder();
        group.build(menuBuilder);
        JPopupMenu popupMenu = menuBuilder.build();
        JGToolBarMenuButton button = new JGToolBarMenuButton(group.getLabelAction(), popupMenu);
        this.toolBar.add(button);
    }

    @Override
    public void add(SplitAction splitAction) {
        Action action = splitAction.getAction();
        DefaultPopupMenuBuilder menuBuilder = new DefaultPopupMenuBuilder();
        splitAction.getGroup().build(menuBuilder);
        JPopupMenu popupMenu = menuBuilder.build();
        JGToolBarSplitButton button = new JGToolBarSplitButton(action, popupMenu);
        ComponentUtils.registerKeyboardAction((JComponent)button, action, 2);
        this.toolBar.add(button);
    }

    @Override
    public void addSeparator() {
        this.toolBar.addSeparator();
    }

    public JToolBar build() {
        return this.toolBar;
    }
}

