# Formatting Documentation

Most of Cantera's HTML documentation, with the exception of the C++ API documentation,
is generated by [Sphinx](https://sphinx-doc.org). The C++ API documentation is generated
using Doxygen. The content used to generate these pages comes from several sources:

- [reStructuredText](https://www.sphinx-doc.org/en/master/usage/restructuredtext/basics.html)
  documents (with the `.rst` extension), organized under the `doc/sphinx` subdirectory
  of the Cantera Git repository.
- [MyST Markdown](https://myst-parser.readthedocs.io/en/latest/index.html)
  documents (with the `.md` extension), organized under the `doc/sphinx` subdirectory of
  the Cantera Git repository.
- Docstrings extracted from the Python source code, which are used to generate the
  Python API docs. These docstrings are parsed as reStructuredText.
- Docstrings extracted from the C++ source code, which are parsed by
  [Doxygen](https://www.doxygen.nl/manual/docblocks.html). These docstrings are
  formatted using Doxygen's syntax, which includes support for its own flavor of
  Markdown.
- Markdown files, organized under the `doc/doxygen` subdirectory of the
  Cantera Git repository, processed using Doxygen's Markdown parser.

This page provides some notes on useful syntax for writing in these various formats.

## Useful MyST syntax
- Linking to a Python class: `[](#ThermoPhase)`
  - This only works if there isn't a Matlab class with the same name!
- Linking to a Python class: ``` {py:class}`~cantera.Wall` ```
  - The `~` removes the `cantera` prefix from the rendered link.
- Linking to a C++ class: ``` {ct}`ThermoPhase`  ```
- Linking to a Doxygen page: `<a href="../cxx/d0/de3/citelist.html">link text</a>`
  - The number of `../` required depends on how deep the source page is in the hierarchy
- Linking to a Sphinx page:
  - `[](/absolute-subdir/docname)` (automatically get the text from `docname`'s title)
  - `[link text](relative-subdir/docname)` (explicitly specified link text)
  - source file extension is optional
- Linking to examples:
  - ``` [`example_name.py`](/examples/python/subdir/example_name) ```
- Linking to a labeled section:
  - `[Build Commands](sec-build-commands)`
- Labeling a section: Above the heading, write:
  - `(sec-label-name)=`
- To cite as "according to Smith et al \[1999]": ``` according to {cite:t}`smith1999` ```
- To cite as "blah blah \[Smith et al 1999]": ``` blah blah {cite:p}`smith1999` ```
- Including code from a file (here, drawing directly from the Cantera source tree; the path is relative to the temporary build directory `build/doc/sphinx/develop/reactor-integration.md`; the number of `../` will vary for files that are at depths within the `sphinx` directory):
   ```
   :::{literalinclude} ../../../../src/zeroD/ReactorNet.cpp
   :start-at: "void ReactorNet::updateState"
   :end-before: " ReactorNet::"
   :language: c++
   :::
   ```

## Useful reST syntax
reStructuredText is used in the docstrings for the Python package and in the comment
blocks in the examples that are parsed by Sphinx Gallery.

- Linking to a Sphinx label:
  - `` :ref:`sec-label-name` `` (automatic name)
  - `` :ref:`link text <sec-label-name>` `` (specified link text)
- Linking to a Sphinx page:
  - `` :doc:`/absolute/path` `` (automatic name)
- Linking to examples:
  - `` :doc:`example_name.py </examples/python/subdir/example_name>` ``
- Caution on usage of single backticks versus double backticks -- the former are only
  for linking to things using the default role (that is, Python objects)

## Useful Doxygen syntax
- Linking to a Sphinx page: `[link text](../reference/thermo/species-thermo.html)`
- Citations: `@cite authorYYYY` will generate a numbered citation like `[8]`, assuming
  `authorYYYY` is a key in `doc/doxygen/cantera.bib`.
- Equations can be added using LaTeX input bracketed by `@f[` and `@f]`.
- In-line math expressions are enclosed by a pair of `@f$` directives, for example
  `@f$ \sin(x) @f$`.
