// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emrserverless

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelJobRun = "CancelJobRun"

// CancelJobRunRequest generates a "aws/request.Request" representing the
// client's request for the CancelJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJobRun for more information on using the CancelJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelJobRunRequest method.
//	req, resp := client.CancelJobRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/CancelJobRun
func (c *EMRServerless) CancelJobRunRequest(input *CancelJobRunInput) (req *request.Request, output *CancelJobRunOutput) {
	op := &request.Operation{
		Name:       opCancelJobRun,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}/jobruns/{jobRunId}",
	}

	if input == nil {
		input = &CancelJobRunInput{}
	}

	output = &CancelJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelJobRun API operation for EMR Serverless.
//
// Cancels a job run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation CancelJobRun for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/CancelJobRun
func (c *EMRServerless) CancelJobRun(input *CancelJobRunInput) (*CancelJobRunOutput, error) {
	req, out := c.CancelJobRunRequest(input)
	return out, req.Send()
}

// CancelJobRunWithContext is the same as CancelJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) CancelJobRunWithContext(ctx aws.Context, input *CancelJobRunInput, opts ...request.Option) (*CancelJobRunOutput, error) {
	req, out := c.CancelJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateApplicationRequest method.
//	req, resp := client.CreateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/CreateApplication
func (c *EMRServerless) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for EMR Serverless.
//
// Creates an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/CreateApplication
func (c *EMRServerless) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteApplicationRequest method.
//	req, resp := client.DeleteApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/DeleteApplication
func (c *EMRServerless) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for EMR Serverless.
//
// Deletes an application. An application has to be in a stopped or created
// state in order to be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/DeleteApplication
func (c *EMRServerless) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplication for more information on using the GetApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationRequest method.
//	req, resp := client.GetApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/GetApplication
func (c *EMRServerless) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	output = &GetApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplication API operation for EMR Serverless.
//
// Displays detailed information about a specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation GetApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/GetApplication
func (c *EMRServerless) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	return out, req.Send()
}

// GetApplicationWithContext is the same as GetApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) GetApplicationWithContext(ctx aws.Context, input *GetApplicationInput, opts ...request.Option) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDashboardForJobRun = "GetDashboardForJobRun"

// GetDashboardForJobRunRequest generates a "aws/request.Request" representing the
// client's request for the GetDashboardForJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDashboardForJobRun for more information on using the GetDashboardForJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDashboardForJobRunRequest method.
//	req, resp := client.GetDashboardForJobRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/GetDashboardForJobRun
func (c *EMRServerless) GetDashboardForJobRunRequest(input *GetDashboardForJobRunInput) (req *request.Request, output *GetDashboardForJobRunOutput) {
	op := &request.Operation{
		Name:       opGetDashboardForJobRun,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/jobruns/{jobRunId}/dashboard",
	}

	if input == nil {
		input = &GetDashboardForJobRunInput{}
	}

	output = &GetDashboardForJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDashboardForJobRun API operation for EMR Serverless.
//
// Returns a URL to access the job run dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation GetDashboardForJobRun for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/GetDashboardForJobRun
func (c *EMRServerless) GetDashboardForJobRun(input *GetDashboardForJobRunInput) (*GetDashboardForJobRunOutput, error) {
	req, out := c.GetDashboardForJobRunRequest(input)
	return out, req.Send()
}

// GetDashboardForJobRunWithContext is the same as GetDashboardForJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetDashboardForJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) GetDashboardForJobRunWithContext(ctx aws.Context, input *GetDashboardForJobRunInput, opts ...request.Option) (*GetDashboardForJobRunOutput, error) {
	req, out := c.GetDashboardForJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobRun = "GetJobRun"

// GetJobRunRequest generates a "aws/request.Request" representing the
// client's request for the GetJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobRun for more information on using the GetJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetJobRunRequest method.
//	req, resp := client.GetJobRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/GetJobRun
func (c *EMRServerless) GetJobRunRequest(input *GetJobRunInput) (req *request.Request, output *GetJobRunOutput) {
	op := &request.Operation{
		Name:       opGetJobRun,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/jobruns/{jobRunId}",
	}

	if input == nil {
		input = &GetJobRunInput{}
	}

	output = &GetJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobRun API operation for EMR Serverless.
//
// Displays detailed information about a job run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation GetJobRun for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/GetJobRun
func (c *EMRServerless) GetJobRun(input *GetJobRunInput) (*GetJobRunOutput, error) {
	req, out := c.GetJobRunRequest(input)
	return out, req.Send()
}

// GetJobRunWithContext is the same as GetJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) GetJobRunWithContext(ctx aws.Context, input *GetJobRunInput, opts ...request.Option) (*GetJobRunOutput, error) {
	req, out := c.GetJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationsRequest method.
//	req, resp := client.ListApplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/ListApplications
func (c *EMRServerless) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "GET",
		HTTPPath:   "/applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for EMR Serverless.
//
// Lists applications based on a set of parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/ListApplications
func (c *EMRServerless) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplications operation.
//	pageNum := 0
//	err := client.ListApplicationsPages(params,
//	    func(page *emrserverless.ListApplicationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EMRServerless) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJobRuns = "ListJobRuns"

// ListJobRunsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobRuns for more information on using the ListJobRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListJobRunsRequest method.
//	req, resp := client.ListJobRunsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/ListJobRuns
func (c *EMRServerless) ListJobRunsRequest(input *ListJobRunsInput) (req *request.Request, output *ListJobRunsOutput) {
	op := &request.Operation{
		Name:       opListJobRuns,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/jobruns",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobRunsInput{}
	}

	output = &ListJobRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobRuns API operation for EMR Serverless.
//
// Lists job runs based on a set of parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation ListJobRuns for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/ListJobRuns
func (c *EMRServerless) ListJobRuns(input *ListJobRunsInput) (*ListJobRunsOutput, error) {
	req, out := c.ListJobRunsRequest(input)
	return out, req.Send()
}

// ListJobRunsWithContext is the same as ListJobRuns with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) ListJobRunsWithContext(ctx aws.Context, input *ListJobRunsInput, opts ...request.Option) (*ListJobRunsOutput, error) {
	req, out := c.ListJobRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobRunsPages iterates over the pages of a ListJobRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListJobRuns operation.
//	pageNum := 0
//	err := client.ListJobRunsPages(params,
//	    func(page *emrserverless.ListJobRunsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EMRServerless) ListJobRunsPages(input *ListJobRunsInput, fn func(*ListJobRunsOutput, bool) bool) error {
	return c.ListJobRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobRunsPagesWithContext same as ListJobRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) ListJobRunsPagesWithContext(ctx aws.Context, input *ListJobRunsInput, fn func(*ListJobRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/ListTagsForResource
func (c *EMRServerless) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for EMR Serverless.
//
// Lists the tags assigned to the resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/ListTagsForResource
func (c *EMRServerless) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartApplication = "StartApplication"

// StartApplicationRequest generates a "aws/request.Request" representing the
// client's request for the StartApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartApplication for more information on using the StartApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartApplicationRequest method.
//	req, resp := client.StartApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/StartApplication
func (c *EMRServerless) StartApplicationRequest(input *StartApplicationInput) (req *request.Request, output *StartApplicationOutput) {
	op := &request.Operation{
		Name:       opStartApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/start",
	}

	if input == nil {
		input = &StartApplicationInput{}
	}

	output = &StartApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartApplication API operation for EMR Serverless.
//
// Starts a specified application and initializes initial capacity if configured.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation StartApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ServiceQuotaExceededException
//     The maximum number of resources per account has been reached.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/StartApplication
func (c *EMRServerless) StartApplication(input *StartApplicationInput) (*StartApplicationOutput, error) {
	req, out := c.StartApplicationRequest(input)
	return out, req.Send()
}

// StartApplicationWithContext is the same as StartApplication with the addition of
// the ability to pass a context and additional request options.
//
// See StartApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) StartApplicationWithContext(ctx aws.Context, input *StartApplicationInput, opts ...request.Option) (*StartApplicationOutput, error) {
	req, out := c.StartApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartJobRun = "StartJobRun"

// StartJobRunRequest generates a "aws/request.Request" representing the
// client's request for the StartJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartJobRun for more information on using the StartJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartJobRunRequest method.
//	req, resp := client.StartJobRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/StartJobRun
func (c *EMRServerless) StartJobRunRequest(input *StartJobRunInput) (req *request.Request, output *StartJobRunOutput) {
	op := &request.Operation{
		Name:       opStartJobRun,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/jobruns",
	}

	if input == nil {
		input = &StartJobRunInput{}
	}

	output = &StartJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartJobRun API operation for EMR Serverless.
//
// Starts a job run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation StartJobRun for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/StartJobRun
func (c *EMRServerless) StartJobRun(input *StartJobRunInput) (*StartJobRunOutput, error) {
	req, out := c.StartJobRunRequest(input)
	return out, req.Send()
}

// StartJobRunWithContext is the same as StartJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) StartJobRunWithContext(ctx aws.Context, input *StartJobRunInput, opts ...request.Option) (*StartJobRunOutput, error) {
	req, out := c.StartJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopApplication = "StopApplication"

// StopApplicationRequest generates a "aws/request.Request" representing the
// client's request for the StopApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopApplication for more information on using the StopApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopApplicationRequest method.
//	req, resp := client.StopApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/StopApplication
func (c *EMRServerless) StopApplicationRequest(input *StopApplicationInput) (req *request.Request, output *StopApplicationOutput) {
	op := &request.Operation{
		Name:       opStopApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/stop",
	}

	if input == nil {
		input = &StopApplicationInput{}
	}

	output = &StopApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopApplication API operation for EMR Serverless.
//
// Stops a specified application and releases initial capacity if configured.
// All scheduled and running jobs must be completed or cancelled before stopping
// an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation StopApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/StopApplication
func (c *EMRServerless) StopApplication(input *StopApplicationInput) (*StopApplicationOutput, error) {
	req, out := c.StopApplicationRequest(input)
	return out, req.Send()
}

// StopApplicationWithContext is the same as StopApplication with the addition of
// the ability to pass a context and additional request options.
//
// See StopApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) StopApplicationWithContext(ctx aws.Context, input *StopApplicationInput, opts ...request.Option) (*StopApplicationOutput, error) {
	req, out := c.StopApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/TagResource
func (c *EMRServerless) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for EMR Serverless.
//
// Assigns tags to resources. A tag is a label that you assign to an AWS resource.
// Each tag consists of a key and an optional value, both of which you define.
// Tags enable you to categorize your AWS resources by attributes such as purpose,
// owner, or environment. When you have many resources of the same type, you
// can quickly identify a specific resource based on the tags you've assigned
// to it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/TagResource
func (c *EMRServerless) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/UntagResource
func (c *EMRServerless) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for EMR Serverless.
//
// Removes tags from resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/UntagResource
func (c *EMRServerless) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateApplicationRequest method.
//	req, resp := client.UpdateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/UpdateApplication
func (c *EMRServerless) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "PATCH",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplication API operation for EMR Serverless.
//
// Updates a specified application. An application has to be in a stopped or
// created state in order to be updated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EMR Serverless's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/emr-serverless-2021-07-13/UpdateApplication
func (c *EMRServerless) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMRServerless) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Information about an application. EMR Serverless uses applications to run
// jobs.
type Application struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The CPU architecture of an application.
	Architecture *string `locationName:"architecture" type:"string" enum:"Architecture"`

	// The ARN of the application.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"60" type:"string" required:"true"`

	// The configuration for an application to automatically start on job submission.
	AutoStartConfiguration *AutoStartConfig `locationName:"autoStartConfiguration" type:"structure"`

	// The configuration for an application to automatically stop after a certain
	// amount of time being idle.
	AutoStopConfiguration *AutoStopConfig `locationName:"autoStopConfiguration" type:"structure"`

	// The date and time when the application run was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The initial capacity of the application.
	InitialCapacity map[string]*InitialCapacityConfig `locationName:"initialCapacity" type:"map"`

	// The maximum capacity of the application. This is cumulative across all workers
	// at any given point in time during the lifespan of the application is created.
	// No new resources will be created once any one of the defined limits is hit.
	MaximumCapacity *MaximumAllowedResources `locationName:"maximumCapacity" type:"structure"`

	// The name of the application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The network configuration for customer VPC connectivity for the application.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The EMR release version associated with the application.
	//
	// ReleaseLabel is a required field
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string" required:"true"`

	// The state of the application.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"ApplicationState"`

	// The state details of the application.
	StateDetails *string `locationName:"stateDetails" min:"1" type:"string"`

	// The tags assigned to the application.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of application, such as Spark or Hive.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`

	// The date and time when the application run was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *Application) SetApplicationId(v string) *Application {
	s.ApplicationId = &v
	return s
}

// SetArchitecture sets the Architecture field's value.
func (s *Application) SetArchitecture(v string) *Application {
	s.Architecture = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Application) SetArn(v string) *Application {
	s.Arn = &v
	return s
}

// SetAutoStartConfiguration sets the AutoStartConfiguration field's value.
func (s *Application) SetAutoStartConfiguration(v *AutoStartConfig) *Application {
	s.AutoStartConfiguration = v
	return s
}

// SetAutoStopConfiguration sets the AutoStopConfiguration field's value.
func (s *Application) SetAutoStopConfiguration(v *AutoStopConfig) *Application {
	s.AutoStopConfiguration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Application) SetCreatedAt(v time.Time) *Application {
	s.CreatedAt = &v
	return s
}

// SetInitialCapacity sets the InitialCapacity field's value.
func (s *Application) SetInitialCapacity(v map[string]*InitialCapacityConfig) *Application {
	s.InitialCapacity = v
	return s
}

// SetMaximumCapacity sets the MaximumCapacity field's value.
func (s *Application) SetMaximumCapacity(v *MaximumAllowedResources) *Application {
	s.MaximumCapacity = v
	return s
}

// SetName sets the Name field's value.
func (s *Application) SetName(v string) *Application {
	s.Name = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *Application) SetNetworkConfiguration(v *NetworkConfiguration) *Application {
	s.NetworkConfiguration = v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *Application) SetReleaseLabel(v string) *Application {
	s.ReleaseLabel = &v
	return s
}

// SetState sets the State field's value.
func (s *Application) SetState(v string) *Application {
	s.State = &v
	return s
}

// SetStateDetails sets the StateDetails field's value.
func (s *Application) SetStateDetails(v string) *Application {
	s.StateDetails = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Application) SetTags(v map[string]*string) *Application {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Application) SetType(v string) *Application {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Application) SetUpdatedAt(v time.Time) *Application {
	s.UpdatedAt = &v
	return s
}

// The summary of attributes associated with an application.
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The CPU architecture of an application.
	Architecture *string `locationName:"architecture" type:"string" enum:"Architecture"`

	// The ARN of the application.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"60" type:"string" required:"true"`

	// The date and time when the application was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The ID of the application.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The name of the application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The EMR release version associated with the application.
	//
	// ReleaseLabel is a required field
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string" required:"true"`

	// The state of the application.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"ApplicationState"`

	// The state details of the application.
	StateDetails *string `locationName:"stateDetails" min:"1" type:"string"`

	// The type of application, such as Spark or Hive.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`

	// The date and time when the application was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *ApplicationSummary) SetArchitecture(v string) *ApplicationSummary {
	s.Architecture = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ApplicationSummary) SetArn(v string) *ApplicationSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ApplicationSummary) SetCreatedAt(v time.Time) *ApplicationSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *ApplicationSummary) SetId(v string) *ApplicationSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApplicationSummary) SetName(v string) *ApplicationSummary {
	s.Name = &v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *ApplicationSummary) SetReleaseLabel(v string) *ApplicationSummary {
	s.ReleaseLabel = &v
	return s
}

// SetState sets the State field's value.
func (s *ApplicationSummary) SetState(v string) *ApplicationSummary {
	s.State = &v
	return s
}

// SetStateDetails sets the StateDetails field's value.
func (s *ApplicationSummary) SetStateDetails(v string) *ApplicationSummary {
	s.StateDetails = &v
	return s
}

// SetType sets the Type field's value.
func (s *ApplicationSummary) SetType(v string) *ApplicationSummary {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ApplicationSummary) SetUpdatedAt(v time.Time) *ApplicationSummary {
	s.UpdatedAt = &v
	return s
}

// The configuration for an application to automatically start on job submission.
type AutoStartConfig struct {
	_ struct{} `type:"structure"`

	// Enables the application to automatically start on job submission. Defaults
	// to true.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoStartConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoStartConfig) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AutoStartConfig) SetEnabled(v bool) *AutoStartConfig {
	s.Enabled = &v
	return s
}

// The configuration for an application to automatically stop after a certain
// amount of time being idle.
type AutoStopConfig struct {
	_ struct{} `type:"structure"`

	// Enables the application to automatically stop after a certain amount of time
	// being idle. Defaults to true.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The amount of idle time in minutes after which your application will automatically
	// stop. Defaults to 15 minutes.
	IdleTimeoutMinutes *int64 `locationName:"idleTimeoutMinutes" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoStopConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoStopConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoStopConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoStopConfig"}
	if s.IdleTimeoutMinutes != nil && *s.IdleTimeoutMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("IdleTimeoutMinutes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *AutoStopConfig) SetEnabled(v bool) *AutoStopConfig {
	s.Enabled = &v
	return s
}

// SetIdleTimeoutMinutes sets the IdleTimeoutMinutes field's value.
func (s *AutoStopConfig) SetIdleTimeoutMinutes(v int64) *AutoStopConfig {
	s.IdleTimeoutMinutes = &v
	return s
}

type CancelJobRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application on which the job run will be canceled.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The ID of the job run to cancel.
	//
	// JobRunId is a required field
	JobRunId *string `location:"uri" locationName:"jobRunId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobRunInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JobRunId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobRunId"))
	}
	if s.JobRunId != nil && len(*s.JobRunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobRunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CancelJobRunInput) SetApplicationId(v string) *CancelJobRunInput {
	s.ApplicationId = &v
	return s
}

// SetJobRunId sets the JobRunId field's value.
func (s *CancelJobRunInput) SetJobRunId(v string) *CancelJobRunInput {
	s.JobRunId = &v
	return s
}

type CancelJobRunOutput struct {
	_ struct{} `type:"structure"`

	// The output contains the application ID on which the job run is cancelled.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The output contains the ID of the cancelled job run.
	//
	// JobRunId is a required field
	JobRunId *string `locationName:"jobRunId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJobRunOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CancelJobRunOutput) SetApplicationId(v string) *CancelJobRunOutput {
	s.ApplicationId = &v
	return s
}

// SetJobRunId sets the JobRunId field's value.
func (s *CancelJobRunOutput) SetJobRunId(v string) *CancelJobRunOutput {
	s.JobRunId = &v
	return s
}

// A configuration specification to be used when provisioning an application.
// A configuration consists of a classification, properties, and optional nested
// configurations. A classification refers to an application-specific configuration
// file. Properties are the settings you want to change in that file.
type Configuration struct {
	_ struct{} `type:"structure"`

	// The classification within a configuration.
	//
	// Classification is a required field
	Classification *string `locationName:"classification" min:"1" type:"string" required:"true"`

	// A list of additional configurations to apply within a configuration object.
	Configurations []*Configuration `locationName:"configurations" type:"list"`

	// A set of properties specified within a configuration classification.
	//
	// Properties is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Configuration's
	// String and GoString methods.
	Properties map[string]*string `locationName:"properties" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Configuration"}
	if s.Classification == nil {
		invalidParams.Add(request.NewErrParamRequired("Classification"))
	}
	if s.Classification != nil && len(*s.Classification) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Classification", 1))
	}
	if s.Configurations != nil {
		for i, v := range s.Configurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Configurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassification sets the Classification field's value.
func (s *Configuration) SetClassification(v string) *Configuration {
	s.Classification = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *Configuration) SetConfigurations(v []*Configuration) *Configuration {
	s.Configurations = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *Configuration) SetProperties(v map[string]*string) *Configuration {
	s.Properties = v
	return s
}

// A configuration specification to be used to override existing configurations.
type ConfigurationOverrides struct {
	_ struct{} `type:"structure"`

	// The override configurations for the application.
	ApplicationConfiguration []*Configuration `locationName:"applicationConfiguration" type:"list"`

	// The override configurations for monitoring.
	MonitoringConfiguration *MonitoringConfiguration `locationName:"monitoringConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationOverrides) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationOverrides) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationOverrides"}
	if s.ApplicationConfiguration != nil {
		for i, v := range s.ApplicationConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ApplicationConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MonitoringConfiguration != nil {
		if err := s.MonitoringConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MonitoringConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationConfiguration sets the ApplicationConfiguration field's value.
func (s *ConfigurationOverrides) SetApplicationConfiguration(v []*Configuration) *ConfigurationOverrides {
	s.ApplicationConfiguration = v
	return s
}

// SetMonitoringConfiguration sets the MonitoringConfiguration field's value.
func (s *ConfigurationOverrides) SetMonitoringConfiguration(v *MonitoringConfiguration) *ConfigurationOverrides {
	s.MonitoringConfiguration = v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The CPU architecture of an application.
	Architecture *string `locationName:"architecture" type:"string" enum:"Architecture"`

	// The configuration for an application to automatically start on job submission.
	AutoStartConfiguration *AutoStartConfig `locationName:"autoStartConfiguration" type:"structure"`

	// The configuration for an application to automatically stop after a certain
	// amount of time being idle.
	AutoStopConfiguration *AutoStopConfig `locationName:"autoStopConfiguration" type:"structure"`

	// The client idempotency token of the application to create. Its value must
	// be unique for each request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The capacity to initialize when the application is created.
	InitialCapacity map[string]*InitialCapacityConfig `locationName:"initialCapacity" type:"map"`

	// The maximum capacity to allocate when the application is created. This is
	// cumulative across all workers at any given point in time, not just when an
	// application is created. No new resources will be created once any one of
	// the defined limits is hit.
	MaximumCapacity *MaximumAllowedResources `locationName:"maximumCapacity" type:"structure"`

	// The name of the application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The network configuration for customer VPC connectivity.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The EMR release version associated with the application.
	//
	// ReleaseLabel is a required field
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string" required:"true"`

	// The tags assigned to the application.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of application you want to start, such as Spark or Hive.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ReleaseLabel == nil {
		invalidParams.Add(request.NewErrParamRequired("ReleaseLabel"))
	}
	if s.ReleaseLabel != nil && len(*s.ReleaseLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReleaseLabel", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}
	if s.AutoStopConfiguration != nil {
		if err := s.AutoStopConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AutoStopConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.InitialCapacity != nil {
		for i, v := range s.InitialCapacity {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InitialCapacity", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MaximumCapacity != nil {
		if err := s.MaximumCapacity.Validate(); err != nil {
			invalidParams.AddNested("MaximumCapacity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchitecture sets the Architecture field's value.
func (s *CreateApplicationInput) SetArchitecture(v string) *CreateApplicationInput {
	s.Architecture = &v
	return s
}

// SetAutoStartConfiguration sets the AutoStartConfiguration field's value.
func (s *CreateApplicationInput) SetAutoStartConfiguration(v *AutoStartConfig) *CreateApplicationInput {
	s.AutoStartConfiguration = v
	return s
}

// SetAutoStopConfiguration sets the AutoStopConfiguration field's value.
func (s *CreateApplicationInput) SetAutoStopConfiguration(v *AutoStopConfig) *CreateApplicationInput {
	s.AutoStopConfiguration = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateApplicationInput) SetClientToken(v string) *CreateApplicationInput {
	s.ClientToken = &v
	return s
}

// SetInitialCapacity sets the InitialCapacity field's value.
func (s *CreateApplicationInput) SetInitialCapacity(v map[string]*InitialCapacityConfig) *CreateApplicationInput {
	s.InitialCapacity = v
	return s
}

// SetMaximumCapacity sets the MaximumCapacity field's value.
func (s *CreateApplicationInput) SetMaximumCapacity(v *MaximumAllowedResources) *CreateApplicationInput {
	s.MaximumCapacity = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationInput) SetName(v string) *CreateApplicationInput {
	s.Name = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *CreateApplicationInput) SetNetworkConfiguration(v *NetworkConfiguration) *CreateApplicationInput {
	s.NetworkConfiguration = v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *CreateApplicationInput) SetReleaseLabel(v string) *CreateApplicationInput {
	s.ReleaseLabel = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v map[string]*string) *CreateApplicationInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateApplicationInput) SetType(v string) *CreateApplicationInput {
	s.Type = &v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The output contains the application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The output contains the ARN of the application.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"60" type:"string" required:"true"`

	// The output contains the name of the application.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateApplicationOutput) SetApplicationId(v string) *CreateApplicationOutput {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateApplicationOutput) SetArn(v string) *CreateApplicationOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationOutput) SetName(v string) *CreateApplicationOutput {
	s.Name = &v
	return s
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application that will be deleted.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApplicationInput) SetApplicationId(v string) *DeleteApplicationInput {
	s.ApplicationId = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type GetApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application that will be described.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationInput) SetApplicationId(v string) *GetApplicationInput {
	s.ApplicationId = &v
	return s
}

type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The output displays information about the specified application.
	//
	// Application is a required field
	Application *Application `locationName:"application" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// SetApplication sets the Application field's value.
func (s *GetApplicationOutput) SetApplication(v *Application) *GetApplicationOutput {
	s.Application = v
	return s
}

type GetDashboardForJobRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The ID of the job run.
	//
	// JobRunId is a required field
	JobRunId *string `location:"uri" locationName:"jobRunId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardForJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardForJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDashboardForJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDashboardForJobRunInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JobRunId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobRunId"))
	}
	if s.JobRunId != nil && len(*s.JobRunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobRunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetDashboardForJobRunInput) SetApplicationId(v string) *GetDashboardForJobRunInput {
	s.ApplicationId = &v
	return s
}

// SetJobRunId sets the JobRunId field's value.
func (s *GetDashboardForJobRunInput) SetJobRunId(v string) *GetDashboardForJobRunInput {
	s.JobRunId = &v
	return s
}

type GetDashboardForJobRunOutput struct {
	_ struct{} `type:"structure"`

	// The URL to view job run's dashboard.
	Url *string `locationName:"url" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardForJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardForJobRunOutput) GoString() string {
	return s.String()
}

// SetUrl sets the Url field's value.
func (s *GetDashboardForJobRunOutput) SetUrl(v string) *GetDashboardForJobRunOutput {
	s.Url = &v
	return s
}

type GetJobRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application on which the job run is submitted.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The ID of the job run.
	//
	// JobRunId is a required field
	JobRunId *string `location:"uri" locationName:"jobRunId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobRunInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JobRunId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobRunId"))
	}
	if s.JobRunId != nil && len(*s.JobRunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobRunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetJobRunInput) SetApplicationId(v string) *GetJobRunInput {
	s.ApplicationId = &v
	return s
}

// SetJobRunId sets the JobRunId field's value.
func (s *GetJobRunInput) SetJobRunId(v string) *GetJobRunInput {
	s.JobRunId = &v
	return s
}

type GetJobRunOutput struct {
	_ struct{} `type:"structure"`

	// The output displays information about the job run.
	//
	// JobRun is a required field
	JobRun *JobRun `locationName:"jobRun" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobRunOutput) GoString() string {
	return s.String()
}

// SetJobRun sets the JobRun field's value.
func (s *GetJobRunOutput) SetJobRun(v *JobRun) *GetJobRunOutput {
	s.JobRun = v
	return s
}

// The configurations for the Hive job driver.
type Hive struct {
	_ struct{} `type:"structure"`

	// The query file for the Hive job run.
	//
	// InitQueryFile is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Hive's
	// String and GoString methods.
	InitQueryFile *string `locationName:"initQueryFile" min:"1" type:"string" sensitive:"true"`

	// The parameters for the Hive job run.
	//
	// Parameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Hive's
	// String and GoString methods.
	Parameters *string `locationName:"parameters" min:"1" type:"string" sensitive:"true"`

	// The query for the Hive job run.
	//
	// Query is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Hive's
	// String and GoString methods.
	//
	// Query is a required field
	Query *string `locationName:"query" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Hive) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Hive) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Hive) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Hive"}
	if s.InitQueryFile != nil && len(*s.InitQueryFile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitQueryFile", 1))
	}
	if s.Parameters != nil && len(*s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}
	if s.Query == nil {
		invalidParams.Add(request.NewErrParamRequired("Query"))
	}
	if s.Query != nil && len(*s.Query) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Query", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitQueryFile sets the InitQueryFile field's value.
func (s *Hive) SetInitQueryFile(v string) *Hive {
	s.InitQueryFile = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Hive) SetParameters(v string) *Hive {
	s.Parameters = &v
	return s
}

// SetQuery sets the Query field's value.
func (s *Hive) SetQuery(v string) *Hive {
	s.Query = &v
	return s
}

// The initial capacity configuration per worker.
type InitialCapacityConfig struct {
	_ struct{} `type:"structure"`

	// The resource configuration of the initial capacity configuration.
	WorkerConfiguration *WorkerResourceConfig `locationName:"workerConfiguration" type:"structure"`

	// The number of workers in the initial capacity configuration.
	//
	// WorkerCount is a required field
	WorkerCount *int64 `locationName:"workerCount" min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitialCapacityConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitialCapacityConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitialCapacityConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitialCapacityConfig"}
	if s.WorkerCount == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerCount"))
	}
	if s.WorkerCount != nil && *s.WorkerCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("WorkerCount", 1))
	}
	if s.WorkerConfiguration != nil {
		if err := s.WorkerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WorkerConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkerConfiguration sets the WorkerConfiguration field's value.
func (s *InitialCapacityConfig) SetWorkerConfiguration(v *WorkerResourceConfig) *InitialCapacityConfig {
	s.WorkerConfiguration = v
	return s
}

// SetWorkerCount sets the WorkerCount field's value.
func (s *InitialCapacityConfig) SetWorkerCount(v int64) *InitialCapacityConfig {
	s.WorkerCount = &v
	return s
}

// Request processing failed because of an error or failure with the service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The driver that the job runs on.
type JobDriver struct {
	_ struct{} `type:"structure"`

	// The job driver parameters specified for Hive.
	Hive *Hive `locationName:"hive" type:"structure"`

	// The job driver parameters specified for Spark.
	SparkSubmit *SparkSubmit `locationName:"sparkSubmit" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDriver) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDriver) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobDriver) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobDriver"}
	if s.Hive != nil {
		if err := s.Hive.Validate(); err != nil {
			invalidParams.AddNested("Hive", err.(request.ErrInvalidParams))
		}
	}
	if s.SparkSubmit != nil {
		if err := s.SparkSubmit.Validate(); err != nil {
			invalidParams.AddNested("SparkSubmit", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHive sets the Hive field's value.
func (s *JobDriver) SetHive(v *Hive) *JobDriver {
	s.Hive = v
	return s
}

// SetSparkSubmit sets the SparkSubmit field's value.
func (s *JobDriver) SetSparkSubmit(v *SparkSubmit) *JobDriver {
	s.SparkSubmit = v
	return s
}

// Information about a job run. A job run is a unit of work, such as a Spark
// JAR, Hive query, or SparkSQL query, that you submit to an EMR Serverless
// application.
type JobRun struct {
	_ struct{} `type:"structure"`

	// The ID of the application the job is running on.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The execution role ARN of the job run.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"60" type:"string" required:"true"`

	// The configuration settings that are used to override default configuration.
	ConfigurationOverrides *ConfigurationOverrides `locationName:"configurationOverrides" type:"structure"`

	// The date and time when the job run was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The user who created the job run.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" min:"20" type:"string" required:"true"`

	// The execution role ARN of the job run.
	//
	// ExecutionRole is a required field
	ExecutionRole *string `locationName:"executionRole" min:"20" type:"string" required:"true"`

	// The job driver for the job run.
	//
	// JobDriver is a required field
	JobDriver *JobDriver `locationName:"jobDriver" type:"structure" required:"true"`

	// The ID of the job run.
	//
	// JobRunId is a required field
	JobRunId *string `locationName:"jobRunId" min:"1" type:"string" required:"true"`

	// The optional job run name. This doesn't have to be unique.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The network configuration for customer VPC connectivity.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`

	// The EMR release version associated with the application your job is running
	// on.
	//
	// ReleaseLabel is a required field
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string" required:"true"`

	// The state of the job run.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"JobRunState"`

	// The state details of the job run.
	//
	// StateDetails is a required field
	StateDetails *string `locationName:"stateDetails" min:"1" type:"string" required:"true"`

	// The tags assigned to the job run.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The job run total execution duration in seconds. This field is only available
	// for job runs in a COMPLETED, FAILED, or CANCELLED state.
	TotalExecutionDurationSeconds *int64 `locationName:"totalExecutionDurationSeconds" type:"integer"`

	// The aggregate vCPU, memory, and storage resources used from the time job
	// start executing till the time job is terminated, rounded up to the nearest
	// second.
	TotalResourceUtilization *TotalResourceUtilization `locationName:"totalResourceUtilization" type:"structure"`

	// The date and time when the job run was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobRun) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *JobRun) SetApplicationId(v string) *JobRun {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *JobRun) SetArn(v string) *JobRun {
	s.Arn = &v
	return s
}

// SetConfigurationOverrides sets the ConfigurationOverrides field's value.
func (s *JobRun) SetConfigurationOverrides(v *ConfigurationOverrides) *JobRun {
	s.ConfigurationOverrides = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *JobRun) SetCreatedAt(v time.Time) *JobRun {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *JobRun) SetCreatedBy(v string) *JobRun {
	s.CreatedBy = &v
	return s
}

// SetExecutionRole sets the ExecutionRole field's value.
func (s *JobRun) SetExecutionRole(v string) *JobRun {
	s.ExecutionRole = &v
	return s
}

// SetJobDriver sets the JobDriver field's value.
func (s *JobRun) SetJobDriver(v *JobDriver) *JobRun {
	s.JobDriver = v
	return s
}

// SetJobRunId sets the JobRunId field's value.
func (s *JobRun) SetJobRunId(v string) *JobRun {
	s.JobRunId = &v
	return s
}

// SetName sets the Name field's value.
func (s *JobRun) SetName(v string) *JobRun {
	s.Name = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *JobRun) SetNetworkConfiguration(v *NetworkConfiguration) *JobRun {
	s.NetworkConfiguration = v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *JobRun) SetReleaseLabel(v string) *JobRun {
	s.ReleaseLabel = &v
	return s
}

// SetState sets the State field's value.
func (s *JobRun) SetState(v string) *JobRun {
	s.State = &v
	return s
}

// SetStateDetails sets the StateDetails field's value.
func (s *JobRun) SetStateDetails(v string) *JobRun {
	s.StateDetails = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *JobRun) SetTags(v map[string]*string) *JobRun {
	s.Tags = v
	return s
}

// SetTotalExecutionDurationSeconds sets the TotalExecutionDurationSeconds field's value.
func (s *JobRun) SetTotalExecutionDurationSeconds(v int64) *JobRun {
	s.TotalExecutionDurationSeconds = &v
	return s
}

// SetTotalResourceUtilization sets the TotalResourceUtilization field's value.
func (s *JobRun) SetTotalResourceUtilization(v *TotalResourceUtilization) *JobRun {
	s.TotalResourceUtilization = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *JobRun) SetUpdatedAt(v time.Time) *JobRun {
	s.UpdatedAt = &v
	return s
}

// The summary of attributes associated with a job run.
type JobRunSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the application the job is running on.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The ARN of the job run.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"60" type:"string" required:"true"`

	// The date and time when the job run was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The user who created the job run.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" min:"20" type:"string" required:"true"`

	// The execution role ARN of the job run.
	//
	// ExecutionRole is a required field
	ExecutionRole *string `locationName:"executionRole" min:"20" type:"string" required:"true"`

	// The ID of the job run.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The optional job run name. This doesn't have to be unique.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The EMR release version associated with the application your job is running
	// on.
	//
	// ReleaseLabel is a required field
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string" required:"true"`

	// The state of the job run.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"JobRunState"`

	// The state details of the job run.
	//
	// StateDetails is a required field
	StateDetails *string `locationName:"stateDetails" min:"1" type:"string" required:"true"`

	// The type of job run, such as Spark or Hive.
	Type *string `locationName:"type" type:"string"`

	// The date and time when the job run was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobRunSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobRunSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *JobRunSummary) SetApplicationId(v string) *JobRunSummary {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *JobRunSummary) SetArn(v string) *JobRunSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *JobRunSummary) SetCreatedAt(v time.Time) *JobRunSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *JobRunSummary) SetCreatedBy(v string) *JobRunSummary {
	s.CreatedBy = &v
	return s
}

// SetExecutionRole sets the ExecutionRole field's value.
func (s *JobRunSummary) SetExecutionRole(v string) *JobRunSummary {
	s.ExecutionRole = &v
	return s
}

// SetId sets the Id field's value.
func (s *JobRunSummary) SetId(v string) *JobRunSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *JobRunSummary) SetName(v string) *JobRunSummary {
	s.Name = &v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *JobRunSummary) SetReleaseLabel(v string) *JobRunSummary {
	s.ReleaseLabel = &v
	return s
}

// SetState sets the State field's value.
func (s *JobRunSummary) SetState(v string) *JobRunSummary {
	s.State = &v
	return s
}

// SetStateDetails sets the StateDetails field's value.
func (s *JobRunSummary) SetStateDetails(v string) *JobRunSummary {
	s.StateDetails = &v
	return s
}

// SetType sets the Type field's value.
func (s *JobRunSummary) SetType(v string) *JobRunSummary {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *JobRunSummary) SetUpdatedAt(v time.Time) *JobRunSummary {
	s.UpdatedAt = &v
	return s
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of applications that can be listed.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of application results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// An optional filter for application states. Note that if this filter contains
	// multiple states, the resulting list will be grouped by the state.
	States []*string `location:"querystring" locationName:"states" min:"1" type:"list" enum:"ApplicationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.States != nil && len(s.States) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("States", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int64) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

// SetStates sets the States field's value.
func (s *ListApplicationsInput) SetStates(v []*string) *ListApplicationsInput {
	s.States = v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// The output lists the specified applications.
	//
	// Applications is a required field
	Applications []*ApplicationSummary `locationName:"applications" type:"list" required:"true"`

	// The output displays the token for the next set of application results. This
	// is required for pagination and is available as a response of the previous
	// request.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *ListApplicationsOutput) SetApplications(v []*ApplicationSummary) *ListApplicationsOutput {
	s.Applications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListJobRunsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application for which to list the job run.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The lower bound of the option to filter by creation date and time.
	CreatedAtAfter *time.Time `location:"querystring" locationName:"createdAtAfter" type:"timestamp"`

	// The upper bound of the option to filter by creation date and time.
	CreatedAtBefore *time.Time `location:"querystring" locationName:"createdAtBefore" type:"timestamp"`

	// The maximum number of job runs that can be listed.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of job run results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// An optional filter for job run states. Note that if this filter contains
	// multiple states, the resulting list will be grouped by the state.
	States []*string `location:"querystring" locationName:"states" type:"list" enum:"JobRunState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobRunsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListJobRunsInput) SetApplicationId(v string) *ListJobRunsInput {
	s.ApplicationId = &v
	return s
}

// SetCreatedAtAfter sets the CreatedAtAfter field's value.
func (s *ListJobRunsInput) SetCreatedAtAfter(v time.Time) *ListJobRunsInput {
	s.CreatedAtAfter = &v
	return s
}

// SetCreatedAtBefore sets the CreatedAtBefore field's value.
func (s *ListJobRunsInput) SetCreatedAtBefore(v time.Time) *ListJobRunsInput {
	s.CreatedAtBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobRunsInput) SetMaxResults(v int64) *ListJobRunsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobRunsInput) SetNextToken(v string) *ListJobRunsInput {
	s.NextToken = &v
	return s
}

// SetStates sets the States field's value.
func (s *ListJobRunsInput) SetStates(v []*string) *ListJobRunsInput {
	s.States = v
	return s
}

type ListJobRunsOutput struct {
	_ struct{} `type:"structure"`

	// The output lists information about the specified job runs.
	//
	// JobRuns is a required field
	JobRuns []*JobRunSummary `locationName:"jobRuns" type:"list" required:"true"`

	// The output displays the token for the next set of job run results. This is
	// required for pagination and is available as a response of the previous request.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsOutput) GoString() string {
	return s.String()
}

// SetJobRuns sets the JobRuns field's value.
func (s *ListJobRunsOutput) SetJobRuns(v []*JobRunSummary) *ListJobRunsOutput {
	s.JobRuns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobRunsOutput) SetNextToken(v string) *ListJobRunsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that identifies the resource to list the tags
	// for. Currently, the supported resources are Amazon EMR Serverless applications
	// and job runs.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"60" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 60 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 60))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The managed log persistence configuration for a job run.
type ManagedPersistenceMonitoringConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables managed logging and defaults to true. If set to false, managed logging
	// will be turned off.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The KMS key ARN to encrypt the logs stored in managed log persistence.
	EncryptionKeyArn *string `locationName:"encryptionKeyArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedPersistenceMonitoringConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedPersistenceMonitoringConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManagedPersistenceMonitoringConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ManagedPersistenceMonitoringConfiguration"}
	if s.EncryptionKeyArn != nil && len(*s.EncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKeyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ManagedPersistenceMonitoringConfiguration) SetEnabled(v bool) *ManagedPersistenceMonitoringConfiguration {
	s.Enabled = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *ManagedPersistenceMonitoringConfiguration) SetEncryptionKeyArn(v string) *ManagedPersistenceMonitoringConfiguration {
	s.EncryptionKeyArn = &v
	return s
}

// The maximum allowed cumulative resources for an application. No new resources
// will be created once the limit is hit.
type MaximumAllowedResources struct {
	_ struct{} `type:"structure"`

	// The maximum allowed CPU for an application.
	//
	// Cpu is a required field
	Cpu *string `locationName:"cpu" min:"1" type:"string" required:"true"`

	// The maximum allowed disk for an application.
	Disk *string `locationName:"disk" min:"1" type:"string"`

	// The maximum allowed resources for an application.
	//
	// Memory is a required field
	Memory *string `locationName:"memory" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaximumAllowedResources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaximumAllowedResources) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaximumAllowedResources) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MaximumAllowedResources"}
	if s.Cpu == nil {
		invalidParams.Add(request.NewErrParamRequired("Cpu"))
	}
	if s.Cpu != nil && len(*s.Cpu) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Cpu", 1))
	}
	if s.Disk != nil && len(*s.Disk) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Disk", 1))
	}
	if s.Memory == nil {
		invalidParams.Add(request.NewErrParamRequired("Memory"))
	}
	if s.Memory != nil && len(*s.Memory) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Memory", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCpu sets the Cpu field's value.
func (s *MaximumAllowedResources) SetCpu(v string) *MaximumAllowedResources {
	s.Cpu = &v
	return s
}

// SetDisk sets the Disk field's value.
func (s *MaximumAllowedResources) SetDisk(v string) *MaximumAllowedResources {
	s.Disk = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *MaximumAllowedResources) SetMemory(v string) *MaximumAllowedResources {
	s.Memory = &v
	return s
}

// The configuration setting for monitoring.
type MonitoringConfiguration struct {
	_ struct{} `type:"structure"`

	// The managed log persistence configuration for a job run.
	ManagedPersistenceMonitoringConfiguration *ManagedPersistenceMonitoringConfiguration `locationName:"managedPersistenceMonitoringConfiguration" type:"structure"`

	// The Amazon S3 configuration for monitoring log publishing.
	S3MonitoringConfiguration *S3MonitoringConfiguration `locationName:"s3MonitoringConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoringConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoringConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MonitoringConfiguration"}
	if s.ManagedPersistenceMonitoringConfiguration != nil {
		if err := s.ManagedPersistenceMonitoringConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ManagedPersistenceMonitoringConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3MonitoringConfiguration != nil {
		if err := s.S3MonitoringConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3MonitoringConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagedPersistenceMonitoringConfiguration sets the ManagedPersistenceMonitoringConfiguration field's value.
func (s *MonitoringConfiguration) SetManagedPersistenceMonitoringConfiguration(v *ManagedPersistenceMonitoringConfiguration) *MonitoringConfiguration {
	s.ManagedPersistenceMonitoringConfiguration = v
	return s
}

// SetS3MonitoringConfiguration sets the S3MonitoringConfiguration field's value.
func (s *MonitoringConfiguration) SetS3MonitoringConfiguration(v *S3MonitoringConfiguration) *MonitoringConfiguration {
	s.S3MonitoringConfiguration = v
	return s
}

// The network configuration for customer VPC connectivity.
type NetworkConfiguration struct {
	_ struct{} `type:"structure"`

	// The array of security group Ids for customer VPC connectivity.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The array of subnet Ids for customer VPC connectivity.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *NetworkConfiguration) SetSecurityGroupIds(v []*string) *NetworkConfiguration {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *NetworkConfiguration) SetSubnetIds(v []*string) *NetworkConfiguration {
	s.SubnetIds = v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon S3 configuration for monitoring log publishing. You can configure
// your jobs to send log information to Amazon S3.
type S3MonitoringConfiguration struct {
	_ struct{} `type:"structure"`

	// The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
	EncryptionKeyArn *string `locationName:"encryptionKeyArn" min:"20" type:"string"`

	// The Amazon S3 destination URI for log publishing.
	LogUri *string `locationName:"logUri" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3MonitoringConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3MonitoringConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3MonitoringConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3MonitoringConfiguration"}
	if s.EncryptionKeyArn != nil && len(*s.EncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKeyArn", 20))
	}
	if s.LogUri != nil && len(*s.LogUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogUri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *S3MonitoringConfiguration) SetEncryptionKeyArn(v string) *S3MonitoringConfiguration {
	s.EncryptionKeyArn = &v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *S3MonitoringConfiguration) SetLogUri(v string) *S3MonitoringConfiguration {
	s.LogUri = &v
	return s
}

// The maximum number of resources per account has been reached.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configurations for the Spark submit job driver.
type SparkSubmit struct {
	_ struct{} `type:"structure"`

	// The entry point for the Spark submit job run.
	//
	// EntryPoint is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SparkSubmit's
	// String and GoString methods.
	//
	// EntryPoint is a required field
	EntryPoint *string `locationName:"entryPoint" min:"1" type:"string" required:"true" sensitive:"true"`

	// The arguments for the Spark submit job run.
	EntryPointArguments []*string `locationName:"entryPointArguments" type:"list"`

	// The parameters for the Spark submit job run.
	//
	// SparkSubmitParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SparkSubmit's
	// String and GoString methods.
	SparkSubmitParameters *string `locationName:"sparkSubmitParameters" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SparkSubmit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SparkSubmit) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SparkSubmit) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SparkSubmit"}
	if s.EntryPoint == nil {
		invalidParams.Add(request.NewErrParamRequired("EntryPoint"))
	}
	if s.EntryPoint != nil && len(*s.EntryPoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntryPoint", 1))
	}
	if s.SparkSubmitParameters != nil && len(*s.SparkSubmitParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SparkSubmitParameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntryPoint sets the EntryPoint field's value.
func (s *SparkSubmit) SetEntryPoint(v string) *SparkSubmit {
	s.EntryPoint = &v
	return s
}

// SetEntryPointArguments sets the EntryPointArguments field's value.
func (s *SparkSubmit) SetEntryPointArguments(v []*string) *SparkSubmit {
	s.EntryPointArguments = v
	return s
}

// SetSparkSubmitParameters sets the SparkSubmitParameters field's value.
func (s *SparkSubmit) SetSparkSubmitParameters(v string) *SparkSubmit {
	s.SparkSubmitParameters = &v
	return s
}

type StartApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application to start.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StartApplicationInput) SetApplicationId(v string) *StartApplicationInput {
	s.ApplicationId = &v
	return s
}

type StartApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationOutput) GoString() string {
	return s.String()
}

type StartJobRunInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application on which to run the job.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The client idempotency token of the job run to start. Its value must be unique
	// for each request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The configuration overrides for the job run.
	ConfigurationOverrides *ConfigurationOverrides `locationName:"configurationOverrides" type:"structure"`

	// The execution role ARN for the job run.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" min:"20" type:"string" required:"true"`

	// The maximum duration for the job run to run. If the job run runs beyond this
	// duration, it will be automatically cancelled.
	ExecutionTimeoutMinutes *int64 `locationName:"executionTimeoutMinutes" type:"long"`

	// The job driver for the job run.
	JobDriver *JobDriver `locationName:"jobDriver" type:"structure"`

	// The optional job run name. This doesn't have to be unique.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The tags assigned to the job run.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartJobRunInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ConfigurationOverrides != nil {
		if err := s.ConfigurationOverrides.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationOverrides", err.(request.ErrInvalidParams))
		}
	}
	if s.JobDriver != nil {
		if err := s.JobDriver.Validate(); err != nil {
			invalidParams.AddNested("JobDriver", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StartJobRunInput) SetApplicationId(v string) *StartJobRunInput {
	s.ApplicationId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *StartJobRunInput) SetClientToken(v string) *StartJobRunInput {
	s.ClientToken = &v
	return s
}

// SetConfigurationOverrides sets the ConfigurationOverrides field's value.
func (s *StartJobRunInput) SetConfigurationOverrides(v *ConfigurationOverrides) *StartJobRunInput {
	s.ConfigurationOverrides = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *StartJobRunInput) SetExecutionRoleArn(v string) *StartJobRunInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetExecutionTimeoutMinutes sets the ExecutionTimeoutMinutes field's value.
func (s *StartJobRunInput) SetExecutionTimeoutMinutes(v int64) *StartJobRunInput {
	s.ExecutionTimeoutMinutes = &v
	return s
}

// SetJobDriver sets the JobDriver field's value.
func (s *StartJobRunInput) SetJobDriver(v *JobDriver) *StartJobRunInput {
	s.JobDriver = v
	return s
}

// SetName sets the Name field's value.
func (s *StartJobRunInput) SetName(v string) *StartJobRunInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartJobRunInput) SetTags(v map[string]*string) *StartJobRunInput {
	s.Tags = v
	return s
}

type StartJobRunOutput struct {
	_ struct{} `type:"structure"`

	// This output displays the application ID on which the job run was submitted.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The output lists the execution role ARN of the job run.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"60" type:"string" required:"true"`

	// The output contains the ID of the started job run.
	//
	// JobRunId is a required field
	JobRunId *string `locationName:"jobRunId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StartJobRunOutput) SetApplicationId(v string) *StartJobRunOutput {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *StartJobRunOutput) SetArn(v string) *StartJobRunOutput {
	s.Arn = &v
	return s
}

// SetJobRunId sets the JobRunId field's value.
func (s *StartJobRunOutput) SetJobRunId(v string) *StartJobRunOutput {
	s.JobRunId = &v
	return s
}

type StopApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application to stop.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StopApplicationInput) SetApplicationId(v string) *StopApplicationInput {
	s.ApplicationId = &v
	return s
}

type StopApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the resource to list the tags
	// for. Currently, the supported resources are Amazon EMR Serverless applications
	// and job runs.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"60" type:"string" required:"true"`

	// The tags to add to the resource. A tag is an array of key-value pairs.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 60 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 60))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The aggregate vCPU, memory, and storage resources used from the time job
// start executing till the time job is terminated, rounded up to the nearest
// second.
type TotalResourceUtilization struct {
	_ struct{} `type:"structure"`

	// The aggregated memory used per hour from the time job start executing till
	// the time job is terminated.
	MemoryGBHour *float64 `locationName:"memoryGBHour" type:"double"`

	// The aggregated storage used per hour from the time job start executing till
	// the time job is terminated.
	StorageGBHour *float64 `locationName:"storageGBHour" type:"double"`

	// The aggregated vCPU used per hour from the time job start executing till
	// the time job is terminated.
	VCPUHour *float64 `locationName:"vCPUHour" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TotalResourceUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TotalResourceUtilization) GoString() string {
	return s.String()
}

// SetMemoryGBHour sets the MemoryGBHour field's value.
func (s *TotalResourceUtilization) SetMemoryGBHour(v float64) *TotalResourceUtilization {
	s.MemoryGBHour = &v
	return s
}

// SetStorageGBHour sets the StorageGBHour field's value.
func (s *TotalResourceUtilization) SetStorageGBHour(v float64) *TotalResourceUtilization {
	s.StorageGBHour = &v
	return s
}

// SetVCPUHour sets the VCPUHour field's value.
func (s *TotalResourceUtilization) SetVCPUHour(v float64) *TotalResourceUtilization {
	s.VCPUHour = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that identifies the resource to list the tags
	// for. Currently, the supported resources are Amazon EMR Serverless applications
	// and job runs.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"60" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 60 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 60))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application to update.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"1" type:"string" required:"true"`

	// The CPU architecture of an application.
	Architecture *string `locationName:"architecture" type:"string" enum:"Architecture"`

	// The configuration for an application to automatically start on job submission.
	AutoStartConfiguration *AutoStartConfig `locationName:"autoStartConfiguration" type:"structure"`

	// The configuration for an application to automatically stop after a certain
	// amount of time being idle.
	AutoStopConfiguration *AutoStopConfig `locationName:"autoStopConfiguration" type:"structure"`

	// The client idempotency token of the application to update. Its value must
	// be unique for each request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The capacity to initialize when the application is updated.
	InitialCapacity map[string]*InitialCapacityConfig `locationName:"initialCapacity" type:"map"`

	// The maximum capacity to allocate when the application is updated. This is
	// cumulative across all workers at any given point in time during the lifespan
	// of the application. No new resources will be created once any one of the
	// defined limits is hit.
	MaximumCapacity *MaximumAllowedResources `locationName:"maximumCapacity" type:"structure"`

	// The network configuration for customer VPC connectivity.
	NetworkConfiguration *NetworkConfiguration `locationName:"networkConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.AutoStopConfiguration != nil {
		if err := s.AutoStopConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AutoStopConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.InitialCapacity != nil {
		for i, v := range s.InitialCapacity {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InitialCapacity", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MaximumCapacity != nil {
		if err := s.MaximumCapacity.Validate(); err != nil {
			invalidParams.AddNested("MaximumCapacity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApplicationInput) SetApplicationId(v string) *UpdateApplicationInput {
	s.ApplicationId = &v
	return s
}

// SetArchitecture sets the Architecture field's value.
func (s *UpdateApplicationInput) SetArchitecture(v string) *UpdateApplicationInput {
	s.Architecture = &v
	return s
}

// SetAutoStartConfiguration sets the AutoStartConfiguration field's value.
func (s *UpdateApplicationInput) SetAutoStartConfiguration(v *AutoStartConfig) *UpdateApplicationInput {
	s.AutoStartConfiguration = v
	return s
}

// SetAutoStopConfiguration sets the AutoStopConfiguration field's value.
func (s *UpdateApplicationInput) SetAutoStopConfiguration(v *AutoStopConfig) *UpdateApplicationInput {
	s.AutoStopConfiguration = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateApplicationInput) SetClientToken(v string) *UpdateApplicationInput {
	s.ClientToken = &v
	return s
}

// SetInitialCapacity sets the InitialCapacity field's value.
func (s *UpdateApplicationInput) SetInitialCapacity(v map[string]*InitialCapacityConfig) *UpdateApplicationInput {
	s.InitialCapacity = v
	return s
}

// SetMaximumCapacity sets the MaximumCapacity field's value.
func (s *UpdateApplicationInput) SetMaximumCapacity(v *MaximumAllowedResources) *UpdateApplicationInput {
	s.MaximumCapacity = v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *UpdateApplicationInput) SetNetworkConfiguration(v *NetworkConfiguration) *UpdateApplicationInput {
	s.NetworkConfiguration = v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the updated application.
	//
	// Application is a required field
	Application *Application `locationName:"application" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplication sets the Application field's value.
func (s *UpdateApplicationOutput) SetApplication(v *Application) *UpdateApplicationOutput {
	s.Application = v
	return s
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The cumulative configuration requirements for every worker instance of the
// worker type.
type WorkerResourceConfig struct {
	_ struct{} `type:"structure"`

	// The CPU requirements for every worker instance of the worker type.
	//
	// Cpu is a required field
	Cpu *string `locationName:"cpu" min:"1" type:"string" required:"true"`

	// The disk requirements for every worker instance of the worker type.
	Disk *string `locationName:"disk" min:"1" type:"string"`

	// The memory requirements for every worker instance of the worker type.
	//
	// Memory is a required field
	Memory *string `locationName:"memory" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkerResourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkerResourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkerResourceConfig"}
	if s.Cpu == nil {
		invalidParams.Add(request.NewErrParamRequired("Cpu"))
	}
	if s.Cpu != nil && len(*s.Cpu) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Cpu", 1))
	}
	if s.Disk != nil && len(*s.Disk) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Disk", 1))
	}
	if s.Memory == nil {
		invalidParams.Add(request.NewErrParamRequired("Memory"))
	}
	if s.Memory != nil && len(*s.Memory) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Memory", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCpu sets the Cpu field's value.
func (s *WorkerResourceConfig) SetCpu(v string) *WorkerResourceConfig {
	s.Cpu = &v
	return s
}

// SetDisk sets the Disk field's value.
func (s *WorkerResourceConfig) SetDisk(v string) *WorkerResourceConfig {
	s.Disk = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *WorkerResourceConfig) SetMemory(v string) *WorkerResourceConfig {
	s.Memory = &v
	return s
}

const (
	// ApplicationStateCreating is a ApplicationState enum value
	ApplicationStateCreating = "CREATING"

	// ApplicationStateCreated is a ApplicationState enum value
	ApplicationStateCreated = "CREATED"

	// ApplicationStateStarting is a ApplicationState enum value
	ApplicationStateStarting = "STARTING"

	// ApplicationStateStarted is a ApplicationState enum value
	ApplicationStateStarted = "STARTED"

	// ApplicationStateStopping is a ApplicationState enum value
	ApplicationStateStopping = "STOPPING"

	// ApplicationStateStopped is a ApplicationState enum value
	ApplicationStateStopped = "STOPPED"

	// ApplicationStateTerminated is a ApplicationState enum value
	ApplicationStateTerminated = "TERMINATED"
)

// ApplicationState_Values returns all elements of the ApplicationState enum
func ApplicationState_Values() []string {
	return []string{
		ApplicationStateCreating,
		ApplicationStateCreated,
		ApplicationStateStarting,
		ApplicationStateStarted,
		ApplicationStateStopping,
		ApplicationStateStopped,
		ApplicationStateTerminated,
	}
}

const (
	// ArchitectureArm64 is a Architecture enum value
	ArchitectureArm64 = "ARM64"

	// ArchitectureX8664 is a Architecture enum value
	ArchitectureX8664 = "X86_64"
)

// Architecture_Values returns all elements of the Architecture enum
func Architecture_Values() []string {
	return []string{
		ArchitectureArm64,
		ArchitectureX8664,
	}
}

const (
	// JobRunStateSubmitted is a JobRunState enum value
	JobRunStateSubmitted = "SUBMITTED"

	// JobRunStatePending is a JobRunState enum value
	JobRunStatePending = "PENDING"

	// JobRunStateScheduled is a JobRunState enum value
	JobRunStateScheduled = "SCHEDULED"

	// JobRunStateRunning is a JobRunState enum value
	JobRunStateRunning = "RUNNING"

	// JobRunStateSuccess is a JobRunState enum value
	JobRunStateSuccess = "SUCCESS"

	// JobRunStateFailed is a JobRunState enum value
	JobRunStateFailed = "FAILED"

	// JobRunStateCancelling is a JobRunState enum value
	JobRunStateCancelling = "CANCELLING"

	// JobRunStateCancelled is a JobRunState enum value
	JobRunStateCancelled = "CANCELLED"
)

// JobRunState_Values returns all elements of the JobRunState enum
func JobRunState_Values() []string {
	return []string{
		JobRunStateSubmitted,
		JobRunStatePending,
		JobRunStateScheduled,
		JobRunStateRunning,
		JobRunStateSuccess,
		JobRunStateFailed,
		JobRunStateCancelling,
		JobRunStateCancelled,
	}
}
