// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief e+e- -> J/psi or psi(2S) + X
  class BESIII_2024_I2854046 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESIII_2024_I2854046);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      declare(UnstableParticles(Cuts::pid==443 || Cuts::pid==100443), "UFS");
      // book hists
      for(unsigned int ix=0;ix<2;++ix)
        for(unsigned int iy=0;iy<2;++iy)
          book(_h[ix][iy],1,1,2*ix+iy+1);
      // energies
      for (const string& en : _h[0][0].binning().edges<0>()) {
        string en2 = en.back()=='a' || en.back()=='b' ? en.substr(0,en.size()-1) : en;
        const double end = std::stod(en2)*GeV;
        if (isCompatibleWithSqrtS(end)) {
          _ecms.push_back(en);
          break;
        }
      }
      if (_ecms.empty())
        MSG_ERROR("Beam energy incompatible with analysis.");
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& ufs = apply<FinalState>(event, "UFS");
      for( const Particle & psi : ufs.particles() ) {
        bool dup=false;
        for(const Particle & child : psi.children()) {
          dup |= psi.pid()==child.pid();
        }
        if(dup) continue;
        int ipsi=psi.pid()/100000;
        for(unsigned int iy=0;iy<2;++iy) {
          for(const string & en : _ecms)
            _h[ipsi][iy]->fill(en);
        }
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_h, crossSection()/ sumOfWeights() /picobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _h[2][2];
    vector<string> _ecms;
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESIII_2024_I2854046);

}
