/*
 * Decompiled with CFR 0.152.
 */
package io.spring.githubchangeloggenerator;

import io.spring.githubchangeloggenerator.ApplicationProperties;
import io.spring.githubchangeloggenerator.github.payload.Issue;
import io.spring.githubchangeloggenerator.github.payload.Label;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class ChangelogSection {
    private final String title;
    private final String group;
    private final ApplicationProperties.IssueSort sort;
    private final Set<String> labels;

    ChangelogSection(String title, String group, ApplicationProperties.IssueSort sort, String ... labels) {
        this(title, group, sort, new LinkedHashSet<String>(Arrays.asList(labels)));
    }

    ChangelogSection(String title, String group, ApplicationProperties.IssueSort sort, Set<String> labels) {
        Assert.hasText((String)title, (String)"Title must not be empty");
        Assert.isTrue((!CollectionUtils.isEmpty(labels) ? 1 : 0) != 0, (String)"Labels must not be empty");
        this.title = title;
        this.group = group;
        this.sort = sort;
        this.labels = labels;
    }

    String getGroup() {
        return this.group;
    }

    ApplicationProperties.IssueSort getSort() {
        return this.sort;
    }

    boolean isMatchFor(Issue issue) {
        return this.isMatchFor(issue, false);
    }

    boolean isMatchFor(Issue issue, boolean allowWildcard) {
        for (String candidate : this.labels) {
            for (Label label : issue.getLabels()) {
                if (!label.getName().contains(candidate)) continue;
                return true;
            }
        }
        return allowWildcard && this.labels.size() == 1 && this.labels.contains("*");
    }

    public String toString() {
        return this.title;
    }
}

