/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithJavaDoc;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class FieldDeclaration
extends BodyDeclaration<FieldDeclaration>
implements NodeWithJavaDoc<FieldDeclaration>,
NodeWithType<FieldDeclaration>,
NodeWithModifiers<FieldDeclaration> {
    private EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    private Type type;
    private List<VariableDeclarator> variables;

    public FieldDeclaration() {
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, Type type, VariableDeclarator variable) {
        this.setModifiers((EnumSet)modifiers);
        this.setType(type);
        ArrayList<VariableDeclarator> aux = new ArrayList<VariableDeclarator>();
        aux.add(variable);
        this.setVariables(aux);
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, Type type, List<VariableDeclarator> variables) {
        this.setModifiers((EnumSet)modifiers);
        this.setType(type);
        this.setVariables(variables);
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, Type type, List<VariableDeclarator> variables) {
        super(annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setType(type);
        this.setVariables(variables);
    }

    public FieldDeclaration(Range range, EnumSet<Modifier> modifiers, List<AnnotationExpr> annotations, Type type, List<VariableDeclarator> variables) {
        super(range, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setType(type);
        this.setVariables(variables);
    }

    public static FieldDeclaration create(EnumSet<Modifier> modifiers, Type type, VariableDeclarator variable) {
        ArrayList<VariableDeclarator> variables = new ArrayList<VariableDeclarator>();
        variables.add(variable);
        return new FieldDeclaration(modifiers, type, variables);
    }

    public static FieldDeclaration create(EnumSet<Modifier> modifiers, Type type, String name) {
        VariableDeclaratorId id = new VariableDeclaratorId(name);
        VariableDeclarator variable = new VariableDeclarator(id);
        return FieldDeclaration.create(modifiers, type, variable);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public List<VariableDeclarator> getVariables() {
        this.variables = Utils.ensureNotNull(this.variables);
        return this.variables;
    }

    @Override
    public FieldDeclaration setModifiers(EnumSet<Modifier> modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    @Override
    public FieldDeclaration setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(this.type);
        return this;
    }

    public void setVariables(List<VariableDeclarator> variables) {
        this.variables = variables;
        this.setAsParentNodeOf(this.variables);
    }

    @Override
    public JavadocComment getJavaDoc() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }

    public MethodDeclaration createGetter() {
        if (this.getVariables().size() != 1) {
            throw new IllegalStateException("You can use this only when the field declares only 1 variable name");
        }
        ClassOrInterfaceDeclaration parentClass = this.getParentNodeOfType(ClassOrInterfaceDeclaration.class);
        EnumDeclaration parentEnum = this.getParentNodeOfType(EnumDeclaration.class);
        if (parentClass == null && parentEnum == null || parentClass != null && parentClass.isInterface()) {
            throw new IllegalStateException("You can use this only when the field is attached to a class or an enum");
        }
        String fieldName = this.getVariables().get(0).getId().getName();
        String fieldNameUpper = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        MethodDeclaration getter = parentClass != null ? parentClass.addMethod("get" + fieldNameUpper, Modifier.PUBLIC) : parentEnum.addMethod("get" + fieldNameUpper, Modifier.PUBLIC);
        getter.setType(this.getType());
        BlockStmt blockStmt = new BlockStmt();
        getter.setBody(blockStmt);
        blockStmt.addStatement(new ReturnStmt(NameExpr.create(fieldName)));
        return getter;
    }

    public MethodDeclaration createSetter() {
        if (this.getVariables().size() != 1) {
            throw new IllegalStateException("You can use this only when the field declares only 1 variable name");
        }
        ClassOrInterfaceDeclaration parentClass = this.getParentNodeOfType(ClassOrInterfaceDeclaration.class);
        EnumDeclaration parentEnum = this.getParentNodeOfType(EnumDeclaration.class);
        if (parentClass == null && parentEnum == null || parentClass != null && parentClass.isInterface()) {
            throw new IllegalStateException("You can use this only when the field is attached to a class or an enum");
        }
        String fieldName = this.getVariables().get(0).getId().getName();
        String fieldNameUpper = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        MethodDeclaration setter = parentClass != null ? parentClass.addMethod("set" + fieldNameUpper, Modifier.PUBLIC) : parentEnum.addMethod("set" + fieldNameUpper, Modifier.PUBLIC);
        setter.setType(VoidType.VOID_TYPE);
        setter.getParameters().add(new Parameter(this.getType(), new VariableDeclaratorId(fieldName)));
        BlockStmt blockStmt2 = new BlockStmt();
        setter.setBody(blockStmt2);
        blockStmt2.addStatement(new AssignExpr(new NameExpr("this." + fieldName), new NameExpr(fieldName), AssignExpr.Operator.assign));
        return setter;
    }
}

