<!--
Fill in the relevant information below to help triage your issue.

Pick the target branch based on the following criteria:
  * Documentation improvement: master branch
  * Bugfix: master branch
  * QA improvement (additional tests, CS fixes, etc.) that does not change code
    behavior: master branch
  * New feature, or refactor of existing code: master/develop branch
-->

|    Q          |   A
|-------------- | ------
| Documentation | yes/no
| Bugfix         | yes/no
| BC Break      | yes/no
| New Feature   | yes/no
| RFC           | yes/no
| QA            | yes/no

### Description

<!--
Tell us about why this change is necessary:
- Are you fixing a bug or providing a failing unit test to demonstrate a bug?
  - How do you reproduce it?
  - What did you expect to happen?
  - What actually happened?
  - TARGET THE master BRANCH

- Are you adding documentation?
  - TARGET THE master BRANCH

- Are you providing a QA improvement (additional tests, CS fixes, etc.) that
  does not change behavior?
  - Explain why the changes are necessary
  - TARGET THE master BRANCH

- Are you fixing a BC Break?
  - How do you reproduce it?
  - What was the previous behavior?
  - What is the current behavior?
  - TARGET THE master BRANCH

- Are you adding something the library currently does not support?
  - Why should it be added?
  - What will it enable?
  - How will the code be used?
  - TARGET THE develop BRANCH

- Are you refactoring code?
  - Why do you feel the refactor is necessary?
  - What types of refactoring are you doing?
  - TARGET THE develop BRANCH
-->
