/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.pantsbuild.jarjar.EmptyClassVisitor;
import org.pantsbuild.jarjar.Keep;
import org.pantsbuild.jarjar.PackageRemapper;
import org.pantsbuild.jarjar.PatternElement;
import org.pantsbuild.jarjar.Wildcard;
import org.pantsbuild.jarjar.util.EntryStruct;
import org.pantsbuild.jarjar.util.JarProcessor;

class KeepProcessor
extends Remapper
implements JarProcessor {
    private final ClassVisitor cv = new ClassRemapper(new EmptyClassVisitor(), this);
    private final List<Wildcard> wildcards;
    private final List<String> roots = new ArrayList<String>();
    private final Map<String, Set<String>> depend = new HashMap<String, Set<String>>();
    private Set<String> curSet;
    private byte[] buf = new byte[8192];

    public KeepProcessor(List<Keep> list) {
        this.wildcards = PatternElement.createWildcards(list);
    }

    public boolean isEnabled() {
        return !this.wildcards.isEmpty();
    }

    public Set<String> getExcludes() {
        HashSet<String> hashSet = new HashSet<String>();
        this.closureHelper(hashSet, this.roots);
        HashSet<String> hashSet2 = new HashSet<String>(this.depend.keySet());
        hashSet2.removeAll(hashSet);
        return hashSet2;
    }

    private void closureHelper(Set<String> set, Collection<String> collection) {
        if (collection == null) {
            return;
        }
        for (String string : collection) {
            if (!set.add(string)) continue;
            this.closureHelper(set, (Collection<String>)this.depend.get(string));
        }
    }

    @Override
    public boolean process(EntryStruct entryStruct) throws IOException {
        try {
            if (entryStruct.name.endsWith(".class")) {
                String string = entryStruct.name.substring(0, entryStruct.name.length() - 6);
                for (Wildcard wildcard : this.wildcards) {
                    if (!wildcard.matches(string)) continue;
                    this.roots.add(string);
                }
                this.curSet = new HashSet<String>();
                this.depend.put(string, this.curSet);
                new ClassReader(new ByteArrayInputStream(entryStruct.data)).accept(this.cv, 8);
                this.curSet.remove(string);
            }
        }
        catch (Exception exception) {
            System.err.println("Error reading " + entryStruct.name + ": " + exception.getMessage());
        }
        return true;
    }

    @Override
    public String map(String string) {
        if (string.startsWith("java/") || string.startsWith("javax/")) {
            return null;
        }
        this.curSet.add(string);
        return null;
    }

    @Override
    public Object mapValue(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (PackageRemapper.isArrayForName(string)) {
                this.mapDesc(string.replace('.', '/'));
            } else if (KeepProcessor.isForName(string)) {
                this.map(string.replace('.', '/'));
            }
            return object;
        }
        return super.mapValue(object);
    }

    private static boolean isForName(String string) {
        if (string.equals("")) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }
}

