/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.CacheWrapper;
import org.cachebench.config.Configuration;
import org.cachebench.config.TestCase;
import org.cachebench.utils.Instantiator;

public class CacheBenchmarkSlave {
    private Configuration conf;
    private Log logger = LogFactory.getLog((String)"org.cachebench.CacheBenchmarkRunner");
    private Log errorLogger = LogFactory.getLog((String)"CacheException");

    public static void main(String[] args) {
        String conf = null;
        if (args.length == 1) {
            conf = args[0];
        }
        if (conf != null && conf.toLowerCase().endsWith(".xml")) {
            new CacheBenchmarkSlave(conf);
        } else {
            new CacheBenchmarkSlave();
        }
    }

    private CacheBenchmarkSlave() {
        this("cachebench.xml");
    }

    private CacheBenchmarkSlave(String s) {
        URL confFile = this.findOnFS(s);
        Object o = new Object();
        if (confFile == null) {
            confFile = this.findInClasspath(s);
        }
        if (confFile == null) {
            this.logger.warn((Object)"Unable to locate a configuration file; Application terminated");
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using configuration " + confFile));
            }
            this.logger.debug((Object)"Parsing configuration");
            try {
                this.conf = this.parseConfiguration(confFile);
                this.logger.info((Object)"Starting Slave....");
                List<TestCase> cases = this.conf.getTestCases();
                if (cases.size() == 0) {
                    throw new RuntimeException("Unable to proceed; no tests configured!");
                }
                if (cases.size() != 1) {
                    this.logger.warn((Object)("Slaves only support running one test case at a time.  You have " + cases.size() + " cases configured.  Will only attempt the first one."));
                }
                CacheWrapper c = this.getCacheWrapperInstance(cases.get(0));
                c.init(cases.get(0).getParams());
                c.setUp();
                this.logger.info((Object)"Slave is listening.  CTRL-C to kill.");
                boolean debug = Boolean.getBoolean("org.cachebench.debug");
                if (debug) {
                    System.out.println("DEBUG mode is true.  Will dump cache contents periodically");
                }
                System.out.println("Slave listening... ");
                while (true) {
                    Thread.sleep(debug ? 5000L : 240000L);
                    System.out.println(c.getInfo());
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)("Unable to parse configuration file " + confFile + ". Application terminated."), (Throwable)e);
                this.errorLogger.fatal((Object)("Unable to parse configuration file " + confFile), (Throwable)e);
            }
        }
    }

    private Configuration parseConfiguration(URL url) throws Exception {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("cachebench", "org.cachebench.config.Configuration");
        digester.addSetProperties("cachebench");
        digester.addObjectCreate("cachebench/testcase", "org.cachebench.config.TestCase");
        digester.addSetProperties("cachebench/testcase");
        digester.addObjectCreate("cachebench/testcase/test", "org.cachebench.config.TestConfig");
        digester.addSetProperties("cachebench/testcase/test");
        digester.addSetNext("cachebench/testcase/test", "addTest", "org.cachebench.config.TestConfig");
        digester.addObjectCreate("cachebench/testcase/param", "org.cachebench.config.NVPair");
        digester.addSetProperties("cachebench/testcase/param");
        digester.addSetNext("cachebench/testcase/param", "addParam", "org.cachebench.config.NVPair");
        digester.addSetNext("cachebench/testcase", "addTestCase", "org.cachebench.config.TestCase");
        digester.addObjectCreate("cachebench/report", "org.cachebench.config.Report");
        digester.addSetProperties("cachebench/report");
        digester.addSetNext("cachebench/report", "addReport", "org.cachebench.config.Report");
        return (Configuration)digester.parse(url.openStream());
    }

    private URL findOnFS(String filename) {
        File f = new File(filename);
        try {
            if (f.exists()) {
                return f.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private URL findInClasspath(String filename) {
        return this.getClass().getClassLoader().getResource(filename);
    }

    private CacheWrapper getCacheWrapperInstance(TestCase testCaseClass) {
        CacheWrapper cache = null;
        try {
            cache = (CacheWrapper)Instantiator.getInstance().createClass(testCaseClass.getCacheWrapper());
        }
        catch (Exception e) {
            this.logger.warn((Object)("Unable to instantiate CacheWrapper class: " + testCaseClass.getCacheWrapper() + " - Not Running any tests"));
            this.errorLogger.error((Object)("Unable to instantiate CacheWrapper class: " + testCaseClass.getCacheWrapper()), (Throwable)e);
            this.errorLogger.error((Object)"Skipping this test");
        }
        return cache;
    }
}

