/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.config;

import java.util.ArrayList;
import java.util.List;
import org.cachebench.config.CacheWarmupConfig;
import org.cachebench.config.GenericParamsConfig;
import org.cachebench.config.TestConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCase
extends GenericParamsConfig {
    private String name;
    private String cacheWrapper;
    private boolean stopOnFailure = true;
    private List<TestConfig> tests = new ArrayList<TestConfig>();
    private CacheWarmupConfig cacheWarmupConfig;

    public CacheWarmupConfig getCacheWarmupConfig() {
        return this.cacheWarmupConfig;
    }

    public void setCacheWarmupConfig(CacheWarmupConfig cacheWarmupConfig) {
        this.cacheWarmupConfig = cacheWarmupConfig;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCacheWrapper() {
        if (this.cacheWrapper == null) {
            this.cacheWrapper = System.getProperty("cacheBenchFwk.cacheWrapperClassName");
        }
        if (this.cacheWrapper == null) {
            throw new IllegalStateException("Null cache wrapper, it was not specified in neither in 'cachebench.xml'  nor as sys prop 'cacheBenchFwk.cacheWrapperClassName'");
        }
        return this.cacheWrapper;
    }

    public void setCacheWrapper(String cacheWrapper) {
        this.cacheWrapper = cacheWrapper;
    }

    public List<TestConfig> getTests() {
        return this.tests;
    }

    public void addTest(TestConfig test) {
        this.tests.add(test);
    }

    public boolean isStopOnFailure() {
        return this.stopOnFailure;
    }

    public void setStopOnFailure(boolean stopOnFailure) {
        this.stopOnFailure = stopOnFailure;
    }

    public TestConfig getTest(String testName) {
        for (TestConfig config : this.getTests()) {
            if (!testName.equals(config.getName())) continue;
            return config;
        }
        return null;
    }
}

