/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.reportgenerators;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.cluster.ClusterBarrier;
import org.cachebench.reportgenerators.AbstractReportGenerator;
import org.cachebench.reportgenerators.ClusterAwareReportGenerator;
import org.cachebench.tests.results.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterReportGenerator
extends AbstractReportGenerator
implements ClusterAwareReportGenerator {
    private static Log log = LogFactory.getLog(ClusterReportGenerator.class);
    private String reportGeneratorClassName;

    @Override
    public void setConfigParams(Map<String, String> configParams) {
        super.setConfigParams(configParams);
        log.trace((Object)("Received config params: " + configParams));
        this.reportGeneratorClassName = configParams.get("generatorClassName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate() throws Exception {
        try {
            ClusterBarrier barrier = new ClusterBarrier();
            barrier.setConfig(this.clusterConfig);
            barrier.setAcknowledge(false);
            barrier.barrier(this.results);
            log.trace((Object)(" Starting generating. Is master? " + this.clusterConfig.isMaster()));
            if (this.clusterConfig.isMaster()) {
                log.info((Object)"Master node, generating report");
                log.trace((Object)("Received following results: " + this.results));
                this.generateReport(barrier.getReceivedMessages());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while generating report!", (Throwable)e);
        }
        finally {
            this.barrierUntilReportIsGenerated();
        }
    }

    private void barrierUntilReportIsGenerated() throws Exception {
        ClusterBarrier barrier = new ClusterBarrier();
        barrier.setConfig(this.clusterConfig);
        barrier.setAcknowledge(true);
        barrier.barrier("AFTER_REPORT_GENERATED_BARRIER");
    }

    private void generateReport(Map<SocketAddress, Object> receivedMessages) throws Exception {
        log.trace((Object)("Received " + receivedMessages.size() + " results!"));
        ArrayList<List<TestResult>> results = new ArrayList<List<TestResult>>();
        for (SocketAddress socketAddress : receivedMessages.keySet()) {
            Object obj = receivedMessages.get(socketAddress);
            if (!(obj instanceof List)) {
                log.error((Object)("Expected a List of results, but received '" + obj + "'"));
                throw new IllegalStateException("Expected a List of results, but received '" + obj + "'");
            }
            List testResults = (List)obj;
            log.trace((Object)("From " + socketAddress + " received " + testResults));
            results.add(testResults);
        }
        List<TestResult> mergedResults = this.mergerTestResultsAndGenerateReport(results);
        this.generateReportFile(mergedResults);
    }

    private void generateReportFile(List<TestResult> mergedResults) throws Exception {
        if (mergedResults.isEmpty()) {
            log.warn((Object)"Result list is emty, not generating any report");
            return;
        }
        String genClassName = mergedResults.get(0).getReportGeneratorClassName();
        AbstractReportGenerator generator = this.instantiateReportGenerator(genClassName);
        generator.setResults(mergedResults);
        log.debug((Object)("Generating reports to file: " + this.output));
        generator.output = this.output;
        generator.generate();
    }

    private AbstractReportGenerator instantiateReportGenerator(String genClassName) {
        try {
            log.debug((Object)("Using generator class: " + genClassName));
            return (AbstractReportGenerator)Class.forName(genClassName).newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate report generators", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private List<TestResult> mergerTestResultsAndGenerateReport(List<List<TestResult>> results) {
        ArrayList<TestResult> mergedResults = new ArrayList<TestResult>();
        for (int i = 0; i < results.get(0).size(); ++i) {
            for (int j = 0; j < results.size(); ++j) {
                if (j > 0 && results.get(j).size() != results.get(j - 1).size()) {
                    throw new RuntimeException("Not all servers send the same number of responses. I.e. not all severs run the same number of tests!!!");
                }
                mergedResults.add(results.get(j).get(i));
            }
        }
        log.trace((Object)("Merged tests are: " + mergedResults));
        return mergedResults;
    }
}

