/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.tests;

import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.CacheWrapper;
import org.cachebench.cluster.ClusterBarrier;
import org.cachebench.config.Configuration;
import org.cachebench.config.TestCase;
import org.cachebench.config.TestConfig;
import org.cachebench.tests.ClusteredCacheTest;
import org.cachebench.tests.results.StatisticTestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationOccursTest
implements ClusteredCacheTest {
    public static final Log log = LogFactory.getLog(ReplicationOccursTest.class);
    private Configuration conf;
    private static final String PREFIX = "_ReplicationOccursTest_";
    private static final int REPLICATION_TRY_COUNT = 17;
    private static final int REPLICATION_TRY_SLEEP = 2000;

    @Override
    public void setConfiguration(Configuration configuration) {
        this.conf = configuration;
    }

    @Override
    public StatisticTestResult doTest(String testName, CacheWrapper cache, String testCaseName, int sampleSize, int numThreads) throws Exception {
        log.trace((Object)("TestCase = '" + testCaseName + "', TestName = " + testName));
        this.barrier("BEFORE_REPLICATION_OCCURS_BARRIER");
        Integer currentNodeIndex = this.conf.getClusterConfig().getCurrentNodeIndex();
        this.tryToPut(cache, currentNodeIndex);
        this.barrier("AFTER_ADDING_LOCAL_ELEMENTS_BARRIER");
        Thread.sleep(2000L);
        if (this.conf.getClusterConfig().getClusterSize() == 1) {
            log.info((Object)"Cluster size is one, no replication expected");
            StatisticTestResult result = new StatisticTestResult();
            result.setTestPassed(true);
            result.setSkipReport(true);
            return result;
        }
        boolean allNodesReplicated = this.checkReplicationSeveralTimes(testName, cache, testCaseName);
        Map<SocketAddress, Object> receivedValues = this.broadcastReplicationResult(allNodesReplicated);
        try {
            cache.empty();
        }
        catch (Throwable e) {
            log.warn((Object)"Fail to cleanup cache after replication test", e);
        }
        return this.allReplicatedFine(receivedValues);
    }

    private void tryToPut(CacheWrapper cache, Integer currentNodeIndex) throws Exception {
        for (int tryCount = 0; tryCount < 5; ++tryCount) {
            try {
                cache.put(Arrays.asList(PREFIX, "" + currentNodeIndex), PREFIX + currentNodeIndex, "true");
                return;
            }
            catch (Throwable e) {
                log.warn((Object)"Error while trying to put data: ", e);
                continue;
            }
        }
        throw new Exception("Couldn't accomplish additiona before replication!");
    }

    private boolean checkReplicationSeveralTimes(String testName, CacheWrapper cache, String testCaseName) throws Exception {
        for (int i = 0; i < 17; ++i) {
            if (this.nodesReplicated(cache, testCaseName, testName)) {
                return true;
            }
            log.info((Object)("Replication test failed, " + (i + 1) + " tries so far. Sleeping for  " + 2000 + " millis then try again"));
            Thread.sleep(2000L);
        }
        return false;
    }

    private Map<SocketAddress, Object> broadcastReplicationResult(boolean allNodesReplicated) throws Exception {
        ClusterBarrier barrier = new ClusterBarrier();
        barrier.setConfig(this.conf.getClusterConfig());
        barrier.barrier(String.valueOf(allNodesReplicated));
        Map<SocketAddress, Object> receivedValues = barrier.getReceivedMessages();
        log.info((Object)("Recieved following responses from barrier:" + receivedValues));
        return receivedValues;
    }

    private void barrier(String res) throws Exception {
        ClusterBarrier barrier = new ClusterBarrier();
        barrier.setAcknowledge(true);
        barrier.setConfig(this.conf.getClusterConfig());
        barrier.barrier(res);
    }

    private StatisticTestResult allReplicatedFine(Map<SocketAddress, Object> receivedValues) {
        StatisticTestResult result = new StatisticTestResult();
        result.setSkipReport(true);
        for (Object value : receivedValues.values()) {
            if ("true".equals(value)) continue;
            log.info((Object)"Replication was not successful on the entire cluster!");
            result.setTestPassed(false);
            return result;
        }
        result.setTestPassed(true);
        log.info((Object)"Replication test successfully passed.");
        return result;
    }

    private boolean isPartialReplication(String testCaseName, String testName) {
        TestCase testCase = this.conf.getTestCase(testCaseName);
        TestConfig thisConfig = testCase.getTest(testName);
        return thisConfig.existsParam("partialReplication") && "true".equalsIgnoreCase(thisConfig.getParamValue("partialReplication"));
    }

    private boolean nodesReplicated(CacheWrapper cache, String testCaseName, String testName) throws Exception {
        int clusterSize = this.conf.getClusterConfig().getClusterSize();
        int replicaCount = 0;
        for (int i = 0; i < clusterSize; ++i) {
            int currentNodeIndex = this.conf.getClusterConfig().getCurrentNodeIndex();
            if (i == currentNodeIndex) continue;
            Object data = this.tryGet(cache, i);
            if (data == null || !"true".equals(data)) {
                log.trace((Object)("Cache with index " + i + " did *NOT* replicate"));
                continue;
            }
            log.trace((Object)("Cache with index " + i + " replicated here "));
            ++replicaCount;
        }
        log.info((Object)("Number of caches that replicated here is " + replicaCount));
        if (this.isPartialReplication(testCaseName, testName)) {
            return this.verifyClusterReplication(replicaCount);
        }
        return replicaCount == this.conf.getClusterConfig().getClusterSize() - 1;
    }

    private Object tryGet(CacheWrapper cache, int i) throws Exception {
        for (int tryCont = 0; tryCont < 5; ++tryCont) {
            try {
                return cache.getReplicatedData(Arrays.asList(PREFIX, "" + i), PREFIX + i);
            }
            catch (Throwable e) {
                continue;
            }
        }
        return null;
    }

    private boolean verifyClusterReplication(int replicaCount) throws Exception {
        ClusterBarrier barrier = new ClusterBarrier();
        barrier.setConfig(this.conf.getClusterConfig());
        barrier.barrier(replicaCount);
        Collection<Object> recievedValues = barrier.getReceivedMessages().values();
        log.trace((Object)("Recieved the following repilcation counts: " + recievedValues));
        int totalValue = 0;
        for (Object val : recievedValues) {
            totalValue += Integer.valueOf(val.toString()).intValue();
        }
        log.info((Object)("Overall replication count is: " + totalValue));
        if (totalValue < this.conf.getClusterConfig().getClusterSize() && totalValue != 0) {
            log.warn((Object)"The replication was not total, but partial!!");
        }
        boolean isReplicationSuccess = totalValue > 0;
        return isReplicationSuccess;
    }
}

